/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class KeyCall
implements AnalysisKey<Map<String, Object>> {
    public static KeyCall INSTANCE = new KeyCall();

    private KeyCall() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, 0, 4));
        int flag = data[4] & 0xFF;
        int time = data[5] & 0xFF | (data[6] & 0xFF) << 8;
        int retCode = data[7] & 0xFF;
        byte[] numberBytes = Arrays.copyOfRange(data, 8, data.length);
        String number = BytesHexStrUtil.bytes2StringByASCII(numberBytes);
        HashMap<String, Object> map_call = new HashMap<String, Object>(8);
        map_call.put("dateTime", new Timestamp(dateTime.getTime()));
        map_call.put("number", number);
        map_call.put("time", time);
        map_call.put("retCode", retCode);
        map_call.put("flag", flag);
        map_call.put("callInOut", ProtocolUtil.getbit(flag, 0, 1));
        map_call.put("callStatus", ProtocolUtil.getbit(flag, 1, 4));
        map_call.put("callType", ProtocolUtil.getbit(flag, 4, 8));
        return map_call;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        String number = Convert.toStr(data.get("number"), "");
        long time = Convert.toLong(data.get("time"), 0L);
        byte retCode = Convert.toByte(data.get("retCode"), (byte)0);
        byte callInOut = Convert.toByte(data.get("callInOut"), (byte)0);
        byte callStatus = Convert.toByte(data.get("callStatus"), (byte)0);
        byte callType = Convert.toByte(data.get("callType"), (byte)0);
        int flag = callInOut | callStatus << 1 | callType << 4;
        byte[] dateTime = ProtocolUtil.dateTime2Bytes(data.get("dateTime"));
        byte[] data_call = ArrayUtils.add(dateTime, (byte)flag);
        data_call = ArrayUtils.addAll(data_call, ProtocolUtil.long2Bytes(time, 2));
        data_call = ArrayUtils.addAll(data_call, retCode);
        data_call = ArrayUtils.addAll(data_call, BytesHexStrUtil.string2BytesByASCII(number));
        return data_call;
    }
}

