/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class KeyBle2
implements AnalysisKey<Map<String, Object>> {
    public static KeyBle2 INSTANCE = new KeyBle2();

    private KeyBle2() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> map_ble = new HashMap<String, Object>(5);
        String mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(data, 0, 6), false);
        double lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 6, 10));
        double lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 10, 14));
        int radius = data[14] & 0xFF | (data[15] & 0xFF) << 8;
        long height = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 16, 18), true);
        map_ble.put("mac", mac);
        map_ble.put("lat", lat);
        map_ble.put("lng", lng);
        map_ble.put("radius", (double)radius / 10.0);
        map_ble.put("height", Double.valueOf(height));
        return map_ble;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        String mac = Convert.toStr(data.get("mac"), "00:00:00:00:00:00");
        double lat = Convert.toDouble(data.get("lat"), 0.0);
        double lng = Convert.toDouble(data.get("lng"), 0.0);
        long radius = Convert.toLong(data.get("radius"), 0L);
        long height = Convert.toLong(data.get("height"), 0L);
        byte[] data_ble2 = ProtocolUtil.mac2Bytes(mac, false);
        data_ble2 = ArrayUtils.addAll(data_ble2, ProtocolUtil.latlng2Bytes(lat, lng));
        data_ble2 = ArrayUtils.addAll(data_ble2, ProtocolUtil.long2Bytes(radius * 10L, 2));
        data_ble2 = ArrayUtils.addAll(data_ble2, ProtocolUtil.long2Bytes(height, 2));
        return data_ble2;
    }
}

