/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class KeyBle
implements AnalysisKey<Map<String, Object>> {
    public static KeyBle INSTANCE = new KeyBle();

    private KeyBle() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        if (data.length > 1) {
            HashMap<String, Object> map_ble = new HashMap<String, Object>(4);
            String mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(data, 0, 6), false);
            double lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 6, 10));
            double lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 10, 14));
            map_ble.put("mac", mac);
            map_ble.put("lat", lat);
            map_ble.put("lng", lng);
            if (data.length > 14) {
                String description = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(data, 14, data.length));
                map_ble.put("describe", description);
            }
            return map_ble;
        }
        return null;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        String mac = Convert.toStr(data.get("mac"), "00:00:00:00:00:00");
        double lat = Convert.toDouble(data.get("lat"), 0.0);
        double lng = Convert.toDouble(data.get("lng"), 0.0);
        byte[] data_ble = ProtocolUtil.mac2Bytes(mac, false);
        data_ble = ArrayUtils.addAll(data_ble, ProtocolUtil.latlng2Bytes(lat, lng));
        String describe = Convert.toStr(data.get("describe"));
        if (describe != null) {
            data_ble = ArrayUtils.addAll(data_ble, BytesHexStrUtil.string2BytesByUTF_8(describe));
        }
        return data_ble;
    }
}

