/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class KeyBeacon2
implements AnalysisKey<Map<String, Object>> {
    public static KeyBeacon2 INSTANCE = new KeyBeacon2();

    private KeyBeacon2() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        int descriptionStatus;
        HashMap<String, Object> map_beacon = new HashMap<String, Object>(9);
        int flag = data[0] & 0xFF;
        int beacon_index = ProtocolUtil.getbit(flag, 0, 4);
        String mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(data, 1, 7), false);
        int rssi = ProtocolUtil.bytes2Int(data[7], true);
        int rssi_1m = ProtocolUtil.bytes2Int(data[8], true);
        int battery = data[9] & 0xFF;
        map_beacon.put("index", beacon_index);
        map_beacon.put("mac", mac);
        map_beacon.put("rssi", rssi);
        map_beacon.put("rssi_1m", rssi_1m);
        map_beacon.put("battery", battery);
        int index = 10;
        int latlngStatus = ProtocolUtil.getbit(flag, 7, 8);
        if (latlngStatus == 1) {
            double lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, index, index + 4));
            double lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, index + 4, index + 8));
            map_beacon.put("lat", lat);
            map_beacon.put("lng", lng);
            index += 8;
        }
        if ((descriptionStatus = ProtocolUtil.getbit(flag, 6, 7)) == 1) {
            int descriptionLength = data[index] & 0xFF;
            String description = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(data, index + 1, index + descriptionLength + 1));
            map_beacon.put("describe", description);
            index += descriptionLength + 1;
        }
        long temperature = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, index, index + 2), true);
        map_beacon.put("temperature", Double.valueOf(temperature) / 10.0);
        return map_beacon;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        int index = Convert.toInt(data.get("index"), 0);
        String mac = Convert.toStr(data.get("mac"), "00:00:00:00:00:00");
        byte rssi = Convert.toByte(data.get("rssi"), (byte)0);
        byte rssi_1m = Convert.toByte(data.get("rssi_1m"), (byte)0);
        int isLanLng = Convert.toInt(data.get("isLanLng"), 0);
        double lat = Convert.toDouble(data.get("lat"), 0.0);
        double lng = Convert.toDouble(data.get("lng"), 0.0);
        int isDescribe = Convert.toInt(data.get("isDescribe"), 0);
        String describe = Convert.utf8Str(data.get("describe"));
        double temperature = Convert.toDouble(data.get("temperature"), 0.0);
        int flag = index | isDescribe << 6 | isLanLng << 7;
        byte[] data_beacon = new byte[]{(byte)flag};
        data_beacon = ArrayUtils.addAll(data_beacon, ProtocolUtil.mac2Bytes(mac, false));
        data_beacon = ArrayUtils.addAll(data_beacon, rssi, rssi_1m);
        byte battery = Convert.toByte(data.get("battery"), (byte)0);
        data_beacon = ArrayUtils.addAll(data_beacon, battery);
        if (isLanLng == 1) {
            data_beacon = ArrayUtils.addAll(data_beacon, ProtocolUtil.latlng2Bytes(lat, lng));
        }
        if (isDescribe == 1) {
            byte[] describeBytes = BytesHexStrUtil.string2BytesByUTF_8(describe);
            data_beacon = ArrayUtils.addAll(data_beacon, (byte)describeBytes.length);
            data_beacon = ArrayUtils.addAll(data_beacon, describeBytes);
        }
        data_beacon = ArrayUtils.addAll(data_beacon, ProtocolUtil.long2Bytes((int)(temperature * 10.0), 2));
        return data_beacon;
    }
}

