/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class KeyBeacon
implements AnalysisKey<Map<String, Object>> {
    public static KeyBeacon INSTANCE = new KeyBeacon();

    private KeyBeacon() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        int descriptionStatus;
        HashMap<String, Object> map_beacon = new HashMap<String, Object>(7);
        int flag = data[0] & 0xFF;
        int beacon_index = ProtocolUtil.getbit(flag, 0, 4);
        String mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(data, 1, 7), false);
        int rssi = ProtocolUtil.bytes2Int(data[7], true);
        int rssi_1m = ProtocolUtil.bytes2Int(data[8], true);
        map_beacon.put("index", beacon_index);
        map_beacon.put("mac", mac);
        map_beacon.put("rssi", rssi);
        map_beacon.put("rssi_1m", rssi_1m);
        int index = 9;
        int latlngStatus = ProtocolUtil.getbit(flag, 7, 8);
        if (latlngStatus == 1) {
            double lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 9, 13));
            double lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 13, 17));
            map_beacon.put("lat", lat);
            map_beacon.put("lng", lng);
            index += 8;
        }
        if ((descriptionStatus = ProtocolUtil.getbit(flag, 6, 7)) == 1) {
            String description = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(data, index, data.length));
            map_beacon.put("describe", description);
        }
        return map_beacon;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        int index = Convert.toInt(data.get("index"), 0);
        String mac = Convert.toStr(data.get("mac"), "00:00:00:00:00:00");
        byte rssi = Convert.toByte(data.get("rssi"), (byte)0);
        byte rssi_1m = Convert.toByte(data.get("rssi_1m"), (byte)0);
        int isLanLng = Convert.toInt(data.get("isLanLng"), 0);
        double lat = Convert.toDouble(data.get("lat"), 0.0);
        double lng = Convert.toDouble(data.get("lng"), 0.0);
        int isDescribe = Convert.toInt(data.get("isDescribe"), 0);
        String describe = Convert.utf8Str(data.get("describe"));
        int flag = index | isDescribe << 6 | isLanLng << 7;
        byte[] data_beacon = new byte[]{(byte)flag};
        data_beacon = ArrayUtils.addAll(data_beacon, ProtocolUtil.mac2Bytes(mac, false));
        data_beacon = ArrayUtils.addAll(data_beacon, rssi, rssi_1m);
        if (isLanLng == 1) {
            data_beacon = ArrayUtils.addAll(data_beacon, ProtocolUtil.latlng2Bytes(lat, lng));
        }
        if (isDescribe == 1) {
            byte[] describeBytes = BytesHexStrUtil.string2BytesByUTF_8(describe);
            data_beacon = ArrayUtils.addAll(data_beacon, describeBytes);
        }
        return data_beacon;
    }
}

