/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class KeyAlarmCode
implements AnalysisKey<Map<String, Object>> {
    public static KeyAlarmCode INSTANCE = new KeyAlarmCode();

    private KeyAlarmCode() {
    }

    public Map<String, Object> getAlarmStatus(long alarmFlag) {
        HashMap<String, Object> alarmStatus = new HashMap<String, Object>(32);
        alarmStatus.put("flagValue", alarmFlag);
        alarmStatus.put("batteryLow", ProtocolUtil.getbit(alarmFlag, 0, 1));
        alarmStatus.put("overSpeed", ProtocolUtil.getbit(alarmFlag, 1, 2));
        alarmStatus.put("fallDown", ProtocolUtil.getbit(alarmFlag, 2, 3));
        alarmStatus.put("tilt", ProtocolUtil.getbit(alarmFlag, 3, 4));
        alarmStatus.put("geo1", ProtocolUtil.getbit(alarmFlag, 4, 5));
        alarmStatus.put("geo2", ProtocolUtil.getbit(alarmFlag, 5, 6));
        alarmStatus.put("geo3", ProtocolUtil.getbit(alarmFlag, 6, 7));
        alarmStatus.put("geo4", ProtocolUtil.getbit(alarmFlag, 7, 8));
        alarmStatus.put("powerOff", ProtocolUtil.getbit(alarmFlag, 8, 9));
        alarmStatus.put("powerOn", ProtocolUtil.getbit(alarmFlag, 9, 10));
        alarmStatus.put("motion", ProtocolUtil.getbit(alarmFlag, 10, 11));
        alarmStatus.put("noMotion", ProtocolUtil.getbit(alarmFlag, 11, 12));
        alarmStatus.put("sosKey", ProtocolUtil.getbit(alarmFlag, 12, 13));
        alarmStatus.put("side1key", ProtocolUtil.getbit(alarmFlag, 13, 14));
        alarmStatus.put("side2key", ProtocolUtil.getbit(alarmFlag, 14, 15));
        alarmStatus.put("batteryCharging", ProtocolUtil.getbit(alarmFlag, 15, 16));
        alarmStatus.put("batteryNoCharging", ProtocolUtil.getbit(alarmFlag, 16, 17));
        alarmStatus.put("alarmEnd", ProtocolUtil.getbit(alarmFlag, 17, 18));
        alarmStatus.put("amber", ProtocolUtil.getbit(alarmFlag, 18, 19));
        alarmStatus.put("welfareCheckin", ProtocolUtil.getbit(alarmFlag, 19, 20));
        alarmStatus.put("amberEnd", ProtocolUtil.getbit(alarmFlag, 20, 21));
        alarmStatus.put("fallDownEnd", ProtocolUtil.getbit(alarmFlag, 21, 22));
        alarmStatus.put("welfare", ProtocolUtil.getbit(alarmFlag, 22, 23));
        alarmStatus.put("sosCancel", ProtocolUtil.getbit(alarmFlag, 23, 24));
        alarmStatus.put("homeFenceOut", ProtocolUtil.getbit(alarmFlag, 24, 25));
        alarmStatus.put("homeFenceIn", ProtocolUtil.getbit(alarmFlag, 25, 26));
        alarmStatus.put("geo1_in", ProtocolUtil.getbit(alarmFlag, 26, 27));
        alarmStatus.put("geo2_in", ProtocolUtil.getbit(alarmFlag, 27, 28));
        alarmStatus.put("geo3_in", ProtocolUtil.getbit(alarmFlag, 28, 29));
        alarmStatus.put("geo4_in", ProtocolUtil.getbit(alarmFlag, 29, 30));
        alarmStatus.put("bleDisConnected", ProtocolUtil.getbit(alarmFlag, 30, 31));
        alarmStatus.put("barkDetection", ProtocolUtil.getbit(alarmFlag, 31, 32));
        return alarmStatus;
    }

    public Map<String, Object> getAlarmStatusExtend(long alarmFlag) {
        HashMap<String, Object> alarmExtendStatus = new HashMap<String, Object>();
        alarmExtendStatus.put("flagValue", alarmFlag);
        alarmExtendStatus.put("fallOff", ProtocolUtil.getbit(alarmFlag, 0, 1));
        alarmExtendStatus.put("welfareCheckout", ProtocolUtil.getbit(alarmFlag, 1, 2));
        alarmExtendStatus.put("geo5", ProtocolUtil.getbit(alarmFlag, 2, 3));
        alarmExtendStatus.put("geo6", ProtocolUtil.getbit(alarmFlag, 3, 4));
        alarmExtendStatus.put("geo5_in", ProtocolUtil.getbit(alarmFlag, 4, 5));
        alarmExtendStatus.put("geo6_in", ProtocolUtil.getbit(alarmFlag, 5, 6));
        alarmExtendStatus.put("runStep", ProtocolUtil.getbit(alarmFlag, 6, 7));
        alarmExtendStatus.put("callingState", ProtocolUtil.getbit(alarmFlag, 7, 8));
        alarmExtendStatus.put("geo_in_valid", ProtocolUtil.getbit(alarmFlag, 16, 17));
        alarmExtendStatus.put("welfareCheckSuccess", ProtocolUtil.getbit(alarmFlag, 17, 18));
        alarmExtendStatus.put("welfareCheckFailure", ProtocolUtil.getbit(alarmFlag, 18, 19));
        return alarmExtendStatus;
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> map_alarm = new HashMap<String, Object>();
        long alarmFlag = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 0, 4));
        Map<String, Object> alarmStatus = this.getAlarmStatus(alarmFlag);
        map_alarm.put("alarmStatus", alarmStatus);
        if (data.length >= 8) {
            Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, 4, 8));
            map_alarm.put("dateTime", dateTime);
        }
        if (data.length >= 12) {
            long alarmFlagExtend = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 8, 12));
            Map<String, Object> alarmExtendStatus = this.getAlarmStatusExtend(alarmFlagExtend);
            map_alarm.put("alarmStatusExtend", alarmExtendStatus);
        }
        return map_alarm;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        Map status = (Map)data.get("alarmStatus");
        long statusCode = Convert.toInt(status.get("batteryLow"), 0).intValue();
        statusCode |= (long)(Convert.toInt(status.get("overSpeed"), 0) << 1);
        statusCode |= (long)(Convert.toInt(status.get("fallDown"), 0) << 2);
        statusCode |= (long)(Convert.toInt(status.get("tilt"), 0) << 3);
        statusCode |= (long)(Convert.toInt(status.get("geo1"), 0) << 4);
        statusCode |= (long)(Convert.toInt(status.get("geo2"), 0) << 5);
        statusCode |= (long)(Convert.toInt(status.get("geo3"), 0) << 6);
        statusCode |= (long)(Convert.toInt(status.get("geo4"), 0) << 7);
        statusCode |= (long)(Convert.toInt(status.get("powerOff"), 0) << 8);
        statusCode |= (long)(Convert.toInt(status.get("powerOn"), 0) << 9);
        statusCode |= (long)(Convert.toInt(status.get("motion"), 0) << 10);
        statusCode |= (long)(Convert.toInt(status.get("noMotion"), 0) << 11);
        statusCode |= (long)(Convert.toInt(status.get("sosKey"), 0) << 12);
        statusCode |= (long)(Convert.toInt(status.get("side1key"), 0) << 13);
        statusCode |= (long)(Convert.toInt(status.get("side2key"), 0) << 14);
        statusCode |= (long)(Convert.toInt(status.get("batteryCharging"), 0) << 15);
        statusCode |= (long)(Convert.toInt(status.get("batteryNoCharging"), 0) << 16);
        statusCode |= (long)(Convert.toInt(status.get("alarmEnd"), 0) << 17);
        statusCode |= (long)(Convert.toInt(status.get("amber"), 0) << 18);
        statusCode |= (long)(Convert.toInt(status.get("welfareCheckin"), 0) << 19);
        statusCode |= (long)(Convert.toInt(status.get("amberEnd"), 0) << 20);
        statusCode |= (long)(Convert.toInt(status.get("fallDownEnd"), 0) << 21);
        statusCode |= (long)(Convert.toInt(status.get("welfare"), 0) << 22);
        statusCode |= (long)(Convert.toInt(status.get("sosCancel"), 0) << 23);
        statusCode |= (long)(Convert.toInt(status.get("homeFenceOut"), 0) << 24);
        statusCode |= (long)(Convert.toInt(status.get("homeFenceIn"), 0) << 25);
        statusCode |= (long)(Convert.toInt(status.get("geo1_in"), 0) << 26);
        statusCode |= (long)(Convert.toInt(status.get("geo2_in"), 0) << 27);
        statusCode |= (long)(Convert.toInt(status.get("geo3_in"), 0) << 28);
        statusCode |= (long)(Convert.toInt(status.get("geo4_in"), 0) << 29);
        statusCode |= (long)(Convert.toInt(status.get("bleDisConnected"), 0) << 30);
        statusCode |= (long)(Convert.toInt(status.get("barkDetection"), 0) << 31);
        Map statusExtend = (Map)data.get("alarmStatusExtend");
        long statusCodeExtend = Convert.toInt(statusExtend.get("fallOff"), 0).intValue();
        statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("welfareCheckout"), 0) << 1);
        statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("geo5"), 0) << 2);
        statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("geo6"), 0) << 3);
        statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("geo5_in"), 0) << 4);
        statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("geo6_in"), 0) << 5);
        statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("runStep"), 0) << 6);
        statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("callingState"), 0) << 7);
        statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("geo_in_valid"), 0) << 16);
        statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("welfareCheckSuccess"), 0) << 17);
        byte[] data_alarmCode = ProtocolUtil.dateTime2Bytes(data.get("dateTime"));
        data_alarmCode = ArrayUtils.addAll(ProtocolUtil.long2Bytes(statusCode, 4), data_alarmCode);
        data_alarmCode = ArrayUtils.addAll(data_alarmCode, ProtocolUtil.long2Bytes(statusCodeExtend |= (long)(Convert.toInt(statusExtend.get("welfareCheckFailure"), 0) << 18), 4));
        return data_alarmCode;
    }
}

