/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyActive
implements AnalysisKey<List<Map>> {
    public static KeyActive INSTANCE = new KeyActive();

    private KeyActive() {
    }

    @Override
    public List<Map> encode(byte[] data) {
        ArrayList<Map> activeList = new ArrayList<Map>();
        for (int i = 0; i < data.length; i += 8) {
            HashMap<String, Comparable<Date>> ev07b_active = new HashMap<String, Comparable<Date>>(2);
            Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, i, i + 4));
            int active = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, i + 4, i + 8));
            ev07b_active.put("dateTime", new Timestamp(dateTime.getTime()));
            ev07b_active.put("active", Integer.valueOf(active));
            activeList.add(ev07b_active);
        }
        return activeList;
    }

    @Override
    public byte[] decode(List<Map> dataList) {
        byte[] data_active = null;
        for (Map active : dataList) {
            int activeNo = Convert.toInt(active.get("active"), 0);
            byte[] activeBytes = ProtocolUtil.dateTime2Bytes(active.get("dateTime"));
            data_active = ArrayUtils.addAll(data_active, activeBytes);
            data_active = ArrayUtils.addAll(data_active, ProtocolUtil.long2Bytes(activeNo, 4));
        }
        return data_active;
    }
}

