/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.command;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.service.command.AnalysisCommand;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandUpdate
implements AnalysisCommand {
    public static CommandUpdate INSTANCE = new CommandUpdate();

    private CommandUpdate() {
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel) {
        return this.encode(cmdModel, true);
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel, boolean isReq) {
        HashMap<String, Object> updateData = new HashMap<String, Object>();
        List<CmdBody.CMD> cmdDataList = cmdModel.getBodyData().getCmdData();
        int cmdKey = cmdDataList.get(0).getCmdKey();
        byte[] cmdValue = cmdDataList.get(0).getCmdValue();
        switch (cmdKey) {
            case 16: {
                break;
            }
            case 17: {
                updateData.put("returnStatus", "ok");
                int address = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                updateData.put("updateAddress", address);
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                updateData.put("updateStateKey", cmdValue[0]);
                if (cmdValue[0] != 17) break;
                int updateAddress = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 1, 5));
                updateData.put("updateAddress", updateAddress);
                break;
            }
            case 21: {
                int packSize = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8;
                updateData.put("updatePackSize", packSize);
                break;
            }
            case 22: {
                HashMap<String, Serializable> requestData = new HashMap<String, Serializable>();
                ArrayList list = new ArrayList();
                for (int i = 0; i < cmdValue.length / 6; ++i) {
                    HashMap<String, Integer> data = new HashMap<String, Integer>();
                    int offset = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, i * 6 + 0, i * 6 + 4));
                    int length = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, i * 6 + 4, i * 6 + 6));
                    data.put("offset", offset);
                    data.put("length", length);
                    list.add(data);
                }
                requestData.put("percent", Integer.valueOf(cmdValue[0] & 0xFF));
                requestData.put("list", list);
                updateData.put("RequestData", requestData);
            }
        }
        return updateData;
    }

    @Override
    public CmdBody decode(Map<String, Object> data) {
        return this.decode(data, true);
    }

    @Override
    public CmdBody decode(Map<String, Object> data, boolean isReq) {
        CmdBody cmd_bodyData = new CmdBody();
        cmd_bodyData.setCmdType(126);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            switch (entry.getKey()) {
                case "InitialData": {
                    int cmdKey = 16;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "FirmwareData": {
                    int cmdKey = 17;
                    Map update_0x11 = (Map)entry.getValue();
                    int offset = Convert.toInt(update_0x11.get("offset"), 0);
                    byte[] cmdValue = new byte[]{(byte)offset};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "Validate": {
                    int cmdKey = 18;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "State": {
                    int cmdKey = 17;
                    Map update_0x13 = (Map)entry.getValue();
                    int state = Convert.toInt(update_0x13.get("updateStateKey"), 0);
                    byte[] cmdValue = new byte[]{(byte)state};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "PackSize": {
                    int cmdKey = 17;
                    Map update_0x15 = (Map)entry.getValue();
                    int packSize = Convert.toInt(update_0x15.get("updatePackSize"), 0);
                    byte[] cmdValue = new byte[]{(byte)packSize};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "RequestData": {
                    int cmdKey = 22;
                    String hexData = Convert.toStr(entry.getValue());
                    byte[] cmdValue = BytesHexStrUtil.hexStringToBytes(hexData);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                }
            }
        }
        return cmd_bodyData;
    }
}

