/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.command;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.model.KeyValue;
import com.tracker.ev07b.service.command.AnalysisCommand;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandSystem
implements AnalysisCommand {
    public static CommandSystem INSTANCE = new CommandSystem();
    private List<String> toListKeys = new ArrayList<String>(2);

    private CommandSystem() {
        this.toListKeys.add("UnsupportedKeys");
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel) {
        return this.encode(cmdModel, true);
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel, boolean isReq) {
        HashMap<String, Object> systemData = new HashMap<String, Object>();
        List<CmdBody.CMD> cmdDataList = cmdModel.getBodyData().getCmdData();
        for (CmdBody.CMD cmd : cmdDataList) {
            systemData.put("cmdKey", cmd.getCmdKey());
            KeyValue keyValue = this.encode(cmd);
            if (this.toListKeys.contains(keyValue.getKey())) {
                ProtocolUtil.saveNewToList(systemData, keyValue.getKey(), keyValue.getValue());
                continue;
            }
            if (keyValue.getKey().equals("scanWifi")) {
                if (((Map)keyValue.getValue()).get("index") == null) continue;
                ProtocolUtil.saveNewToList(systemData, keyValue.getKey(), keyValue.getValue());
                continue;
            }
            systemData.put(keyValue.getKey(), keyValue.getValue());
        }
        return systemData;
    }

    public KeyValue encode(CmdBody.CMD cmd) {
        KeyValue keyValue = null;
        byte[] cmdValue = cmd.getCmdValue();
        switch (cmd.getCmdKey()) {
            case 1: {
                keyValue = new KeyValue("imei", BytesHexStrUtil.bytes2StringByASCII(cmdValue));
                break;
            }
            case 16: {
                keyValue = new KeyValue("resetRecord", "null");
                break;
            }
            case 17: {
                keyValue = new KeyValue("reFactory", "null");
                break;
            }
            case 18: {
                keyValue = new KeyValue("reboot", "null");
                break;
            }
            case 19: {
                keyValue = new KeyValue("findMe", "null");
                break;
            }
            case 20: {
                keyValue = new KeyValue("shutdown", "null");
                break;
            }
            case 21: {
                byte led_state = cmdValue[0];
                keyValue = new KeyValue("led", led_state);
                break;
            }
            case 22: {
                if (cmdValue.length == 0) {
                    keyValue = new KeyValue("scanBLE", "null");
                    break;
                }
                ArrayList scanBleList = new ArrayList();
                for (int i = 0; i < cmdValue.length; i += 7) {
                    HashMap<String, Object> ble = new HashMap<String, Object>(2);
                    byte[] macArr = Arrays.copyOfRange(cmdValue, i, i + 6);
                    String MAC = ProtocolUtil.bytes2Mac(macArr, false);
                    int rssi = ProtocolUtil.bytes2Int(cmdValue[i + 6], true);
                    ble.put("mac", MAC);
                    ble.put("rssi", rssi);
                    scanBleList.add(ble);
                }
                keyValue = new KeyValue("scanBLE", scanBleList);
                break;
            }
            case 23: {
                keyValue = new KeyValue("firmwareRecovery", "null");
                break;
            }
            case 25: {
                double beacon_lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 0, 4));
                double beacon_lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 4, 8));
                String beacon_describe = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 8, cmdValue.length));
                HashMap<String, Object> scanBeacon = new HashMap<String, Object>(3);
                scanBeacon.put("lat", beacon_lat);
                scanBeacon.put("lng", beacon_lng);
                scanBeacon.put("describe", beacon_describe);
                keyValue = new KeyValue("scanBeaconAuto", scanBeacon);
                break;
            }
            case 26: {
                double scanWifi_lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 0, 4));
                double scanWifi_lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 4, 8));
                String scanWifi_describe = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 8, cmdValue.length));
                HashMap<String, Object> scanWifiAuto = new HashMap<String, Object>(3);
                scanWifiAuto.put("lat", scanWifi_lat);
                scanWifiAuto.put("lng", scanWifi_lng);
                scanWifiAuto.put("describe", scanWifi_describe);
                keyValue = new KeyValue("scanWifiAuto", scanWifiAuto);
                break;
            }
            case 27: {
                if (cmdValue.length == 2) {
                    int rssi = ProtocolUtil.bytes2Int(cmdValue[0], true);
                    byte interval = cmdValue[1];
                    HashMap<String, Integer> wifi = new HashMap<String, Integer>(2);
                    wifi.put("rssi", rssi);
                    wifi.put("interval", Integer.valueOf(interval));
                    keyValue = new KeyValue("scanWifi", wifi);
                    break;
                }
                HashMap<String, Object> wifi = new HashMap<String, Object>(4);
                int flag_wifi = cmdValue[0] & 0xFF;
                int wifi_index = ProtocolUtil.getbit(flag_wifi, 0, 7);
                int network = ProtocolUtil.getbit(flag_wifi, 7, 8);
                String mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(cmdValue, 1, 7), false);
                int rssi = ProtocolUtil.bytes2Int(cmdValue[7], true);
                String name = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 8, cmdValue.length));
                wifi.put("index", wifi_index);
                wifi.put("mac", mac);
                wifi.put("rssi", rssi);
                wifi.put("name", name);
                wifi.put("network", network);
                keyValue = new KeyValue("scanWifi", wifi);
                break;
            }
            case 28: {
                int flag_light = cmdValue[0] & 0xFF;
                int light_status = ProtocolUtil.getbit(flag_light, 7, 8);
                int light_value = ProtocolUtil.getbit(flag_light, 0, 7);
                HashMap<String, Integer> light = new HashMap<String, Integer>(2);
                light.put("status", light_status);
                light.put("value", light_value);
                keyValue = new KeyValue("light", light);
                break;
            }
            case 30: {
                int motor = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("motor", motor);
                break;
            }
            case 31: {
                int type = cmdValue[0] & 0xFF;
                byte[] contentArr = Arrays.copyOfRange(cmdValue, 1, cmdValue.length);
                HashMap<String, Object> alarmTTS = new HashMap<String, Object>(2);
                alarmTTS.put("type", type);
                alarmTTS.put("content", BytesHexStrUtil.bytes2StringByUTF_8(contentArr));
                keyValue = new KeyValue("alarmTTS", alarmTTS);
                break;
            }
            case 33: {
                ArrayList bleList = new ArrayList();
                int i = 0;
                while (i + 7 <= cmdValue.length) {
                    String mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(cmdValue, i, i + 6), false);
                    int rssi = ProtocolUtil.bytes2Int(cmdValue[i + 6], true);
                    HashMap<String, Object> uploadingBLE = new HashMap<String, Object>(2);
                    uploadingBLE.put("mac", mac);
                    uploadingBLE.put("rssi", rssi);
                    bleList.add(uploadingBLE);
                    i += 7;
                }
                keyValue = new KeyValue("uploadingBLE", bleList);
                break;
            }
            case 48: {
                String ota_url = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 0, cmdValue.length));
                HashMap<String, String> ota = new HashMap<String, String>(1);
                ota.put("url", ota_url);
                keyValue = new KeyValue("ota", ota);
                break;
            }
            case 49: {
                keyValue = new KeyValue("heart", "null");
                break;
            }
            case 64: {
                byte alarm_state = cmdValue[0];
                keyValue = new KeyValue("alarmControl", alarm_state);
                break;
            }
            case 65: {
                keyValue = new KeyValue("cancelSOS", "null");
                break;
            }
            case 66: {
                if (cmdValue.length == 0) {
                    keyValue = new KeyValue("scanBeacon", "null");
                    break;
                }
                ArrayList scanBeaconList = new ArrayList();
                for (int i = 0; i < cmdValue.length; i += 7) {
                    HashMap<String, Object> beacon = new HashMap<String, Object>(2);
                    byte[] macArr = Arrays.copyOfRange(cmdValue, i, i + 6);
                    String MAC = ProtocolUtil.bytes2Mac(macArr, false);
                    int rssi = ProtocolUtil.bytes2Int(cmdValue[i + 6], true);
                    beacon.put("mac", MAC);
                    beacon.put("rssi", rssi);
                    scanBeaconList.add(beacon);
                }
                keyValue = new KeyValue("scanBeacon", scanBeaconList);
                break;
            }
            case 68: {
                keyValue = new KeyValue("SimCardUnLock", "null");
                break;
            }
            default: {
                HashMap<String, String> other = new HashMap<String, String>(1);
                other.put("key:0x" + Integer.toHexString(cmd.getCmdKey()), "Value:" + BytesHexStrUtil.bytesToHexString(cmdValue));
                keyValue = new KeyValue("UnsupportedKeys", other);
            }
        }
        return keyValue;
    }

    @Override
    public CmdBody decode(Map<String, Object> data) {
        return this.decode(data, true);
    }

    @Override
    public CmdBody decode(Map<String, Object> data, boolean isReq) {
        CmdBody cmd_bodyData = new CmdBody();
        cmd_bodyData.setCmdType(4);
        block48: for (Map.Entry<String, Object> entry : data.entrySet()) {
            switch (entry.getKey()) {
                case "imei": {
                    int cmdKey = 1;
                    String imei = Convert.toStr(entry.getValue(), "000000000000000");
                    byte[] cmdValue = BytesHexStrUtil.string2BytesByASCII(imei);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "resetRecord": {
                    int cmdKey = 16;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "reFactory": {
                    int cmdKey = 17;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "reboot": {
                    int cmdKey = 18;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "findMe": {
                    int cmdKey = 19;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "shutdown": {
                    int cmdKey = 20;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "led": {
                    int cmdKey = 21;
                    int led_state = Convert.toInt(entry.getValue());
                    byte[] cmdValue = new byte[]{(byte)led_state};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "scanBLE": {
                    int cmdKey = 22;
                    if (entry.getValue() == null || entry.getValue() instanceof String) {
                        cmd_bodyData.addCmdData(1, cmdKey, null);
                        break;
                    }
                    if (!(entry.getValue() instanceof List)) break;
                    List list = (List)entry.getValue();
                    byte[] cmdValue = new byte[]{};
                    for (Map scanBLE : list) {
                        String scanBLE_mac = Convert.toStr(scanBLE.get("mac"));
                        byte scanBLE_rssi = Convert.toByte(scanBLE.get("rssi"), (byte)0);
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.mac2Bytes(scanBLE_mac, false));
                        cmdValue = ArrayUtils.add(cmdValue, scanBLE_rssi);
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "firmwareRecovery": {
                    int cmdKey = 23;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "scanBeaconAuto": {
                    int cmdKey = 25;
                    Map scanBeaconAuto = (Map)entry.getValue();
                    double lat_beacon = Convert.toDouble(scanBeaconAuto.get("lat"), 0.0);
                    double lng_beacon = Convert.toDouble(scanBeaconAuto.get("lng"), 0.0);
                    String describe_beacon = Convert.toStr(scanBeaconAuto.get("describe"), "");
                    byte[] cmdValue = ProtocolUtil.latlng2Bytes(lat_beacon, lng_beacon);
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8(describe_beacon));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "scanWifiAuto": {
                    int cmdKey = 26;
                    Map scanWifiAuto = (Map)entry.getValue();
                    double lat_wifiAuto = Convert.toDouble(scanWifiAuto.get("lat"), 0.0);
                    double lng_wifiAuto = Convert.toDouble(scanWifiAuto.get("lng"), 0.0);
                    String describe_wifiAuto = Convert.toStr(scanWifiAuto.get("describe"), "");
                    byte[] cmdValue = ProtocolUtil.latlng2Bytes(lat_wifiAuto, lng_wifiAuto);
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8(describe_wifiAuto));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "scanWifi": {
                    byte[] cmdValue;
                    int cmdKey = 27;
                    if (entry.getValue() instanceof Map) {
                        Map scanWifi = (Map)entry.getValue();
                        int rssi = Convert.toInt(scanWifi.get("rssi"), 0);
                        int interval = Convert.toInt(scanWifi.get("interval"), 0);
                        cmdValue = new byte[]{(byte)rssi, (byte)interval};
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                        break;
                    }
                    if (!(entry.getValue() instanceof List)) break;
                    List scanWifiList = (List)entry.getValue();
                    for (Map scanWifi : scanWifiList) {
                        int index = Convert.toInt(scanWifi.get("index"), 0);
                        String mac = Convert.toStr(scanWifi.get("mac"), "00:00:00:00:00:00");
                        byte rssi = Convert.toByte(scanWifi.get("rssi"), (byte)0);
                        String name = Convert.toStr(scanWifi.get("name"), "");
                        int network = Convert.toInt(scanWifi.get("network"), 0);
                        int flag = index | network << 7;
                        cmdValue = new byte[]{(byte)flag};
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.mac2Bytes(mac, false));
                        cmdValue = ArrayUtils.add(cmdValue, rssi);
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8(name));
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    continue block48;
                }
                case "light": {
                    int cmdKey = 28;
                    Map light = (Map)entry.getValue();
                    int light_status = Convert.toInt(light.get("status"), 0);
                    int light_value = Convert.toInt(light.get("value"), 0);
                    byte[] cmdValue = new byte[]{(byte)(light_value |= light_status << 7)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "motor": {
                    int cmdKey = 30;
                    int motor = Convert.toInt(entry.getValue());
                    byte[] cmdValue = new byte[]{(byte)motor};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "alarmTTS": {
                    int cmdKey = 31;
                    Map alarmTTS = (Map)entry.getValue();
                    int type = Convert.toInt(alarmTTS.get("type"), 0);
                    String content = Convert.toStr(alarmTTS.get("content"), "");
                    byte[] cmdValue = new byte[]{(byte)type};
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8(content));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "uploadingBLE": {
                    int cmdKey = 33;
                    byte[] cmdValue = new byte[]{};
                    List bleList = (List)entry.getValue();
                    for (Map ble : bleList) {
                        String mac = Convert.toStr(ble.get("mac"), "00:00:00:00:00:00");
                        byte rssi = Convert.toByte(ble.get("rssi"), (byte)0);
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.mac2Bytes(mac, false));
                        cmdValue = ArrayUtils.add(cmdValue, rssi);
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "ota": {
                    int cmdKey = 48;
                    Map ota = (Map)entry.getValue();
                    byte[] cmdValue = BytesHexStrUtil.string2BytesByUTF_8(Convert.toStr(ota.get("url"), ""));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "heart": {
                    int cmdKey = 49;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "alarmControl": {
                    int cmdKey = 64;
                    int alarm_state = Convert.toInt(entry.getValue());
                    byte[] cmdValue = new byte[]{(byte)alarm_state};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "cancelSOS": {
                    int cmdKey = 65;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "scanBeacon": {
                    int cmdKey = 66;
                    if (entry.getValue() == null || entry.getValue() instanceof String) {
                        cmd_bodyData.addCmdData(1, cmdKey, null);
                        break;
                    }
                    if (!(entry.getValue() instanceof List)) break;
                    List scanBeaconList = (List)entry.getValue();
                    byte[] cmdValue = new byte[]{};
                    for (Map scanBeacon : scanBeaconList) {
                        String scanBLE_mac = Convert.toStr(scanBeacon.get("mac"));
                        byte scanBLE_rssi = Convert.toByte(scanBeacon.get("rssi"), (byte)0);
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.mac2Bytes(scanBLE_mac, false));
                        cmdValue = ArrayUtils.add(cmdValue, scanBLE_rssi);
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "SimCardUnLock": {
                    int cmdKey = 68;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                }
            }
        }
        return cmd_bodyData;
    }
}

