/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.command;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.model.KeyValue;
import com.tracker.ev07b.service.command.AnalysisCommand;
import com.tracker.ev07b.service.key.KeyGMS;
import com.tracker.ev07b.service.key.KeyStatus;
import com.tracker.ev07b.service.key.KeyWifi;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandService
implements AnalysisCommand {
    public static CommandService INSTANCE = new CommandService();
    private List<String> toListKeys = new ArrayList<String>(2);

    private CommandService() {
        this.toListKeys.add("weather2");
        this.toListKeys.add("UnsupportedKeys");
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel) {
        return this.encode(cmdModel, true);
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel, boolean isReq) {
        HashMap<String, Object> servicesData = new HashMap<String, Object>();
        List<CmdBody.CMD> cmdDataList = cmdModel.getBodyData().getCmdData();
        for (CmdBody.CMD cmd : cmdDataList) {
            KeyValue keyValue = this.encode(cmd);
            if (this.toListKeys.contains(keyValue.getKey())) {
                ProtocolUtil.saveNewToList(servicesData, keyValue.getKey(), keyValue.getValue());
                continue;
            }
            servicesData.put(keyValue.getKey(), keyValue.getValue());
        }
        return servicesData;
    }

    public KeyValue encode(CmdBody.CMD cmd) {
        KeyValue keyValue = null;
        byte[] cmdValue = cmd.getCmdValue();
        switch (cmd.getCmdKey()) {
            case 1: {
                String imei = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("imei", imei);
                break;
            }
            case 16: {
                Integer heartBeat = null;
                if (cmdValue.length > 0) {
                    heartBeat = cmdValue[0] & 0xFF;
                }
                keyValue = new KeyValue("heartBeat", heartBeat);
                break;
            }
            case 17: {
                double lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 0, 4));
                double lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 4, 8));
                HashMap<String, Object> ev07b_addresses = new HashMap<String, Object>();
                ev07b_addresses.put("lat", lat);
                ev07b_addresses.put("lng", lng);
                if (cmdValue.length > 8) {
                    String address = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 8, cmdValue.length));
                    ev07b_addresses.put("address", address);
                }
                keyValue = new KeyValue("addresses", ev07b_addresses);
                break;
            }
            case 18: {
                if (cmdValue.length == 0) {
                    keyValue = new KeyValue("systemTime", "null");
                    break;
                }
                Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(cmdValue, 0, 4));
                keyValue = new KeyValue("systemTime", dateTime);
                break;
            }
            case 19: {
                HashMap<String, Object> weather = new HashMap<String, Object>();
                if (cmdValue.length < 8) {
                    byte[] langBytes = Arrays.copyOfRange(cmdValue, 0, cmdValue.length);
                    String lang = BytesHexStrUtil.bytes2StringByASCII(langBytes);
                    weather.put("lang", lang.replaceAll(" ", "").replace("\u0000", ""));
                } else if (cmdValue.length == 8 || cmdValue.length == 16) {
                    byte[] langBytes = Arrays.copyOfRange(cmdValue, 0, 8);
                    String lang = BytesHexStrUtil.bytes2StringByASCII(langBytes);
                    weather.put("lang", lang.replaceAll(" ", "").replace("\u0000", ""));
                    if (cmdValue.length == 16) {
                        double lat_weather = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 8, 12));
                        double lng_weather = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 12, 16));
                        weather.put("lat", lat_weather);
                        weather.put("lng", lng_weather);
                    }
                } else {
                    Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(cmdValue, 0, 4));
                    double lat_weather = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 4, 8));
                    double lng_weather = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 8, 12));
                    String city = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 12, cmdValue.length));
                    weather.put("dateTime", dateTime);
                    weather.put("lat", lat_weather);
                    weather.put("lng", lng_weather);
                    weather.put("city", city);
                }
                keyValue = new KeyValue("weather", weather);
                break;
            }
            case 20: {
                Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(cmdValue, 0, 4));
                long codeDay = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 4, 6));
                long codeNight = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 6, 8));
                double temp_max = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 8, 10), true);
                double temp_min = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 10, 12), true);
                byte hum = cmdValue[12];
                byte uv_index = cmdValue[13];
                byte wind_spd = cmdValue[14];
                long wind_deg = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 15, 17));
                HashMap<String, Comparable<Date>> weather2 = new HashMap<String, Comparable<Date>>(9);
                weather2.put("dateTime", dateTime);
                weather2.put("codeDay", Long.valueOf(codeDay));
                weather2.put("codeNight", Long.valueOf(codeNight));
                weather2.put("tempMax", Double.valueOf(temp_max / 10.0));
                weather2.put("tempMin", Double.valueOf(temp_min / 10.0));
                weather2.put("hum", Integer.valueOf(hum));
                weather2.put("uvIndex", Integer.valueOf(uv_index));
                weather2.put("windSpd", Integer.valueOf(wind_spd));
                weather2.put("windDeg", Long.valueOf(wind_deg));
                ArrayList<HashMap<String, Comparable<Date>>> weatherList = new ArrayList<HashMap<String, Comparable<Date>>>(1);
                weatherList.add(weather2);
                keyValue = new KeyValue("weather2", weatherList);
                break;
            }
            case 33: {
                Object ev07b_gsm = KeyGMS.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("location_gsm", ev07b_gsm);
                break;
            }
            case 34: {
                Object ev07b_wifi = KeyWifi.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("location_wifi", ev07b_wifi);
                break;
            }
            case 36: {
                Object ev07b_status = KeyStatus.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("status", ev07b_status);
                break;
            }
            default: {
                HashMap<String, String> other = new HashMap<String, String>(1);
                other.put("key:0x" + Integer.toHexString(cmd.getCmdKey()), "Value:" + BytesHexStrUtil.bytesToHexString(cmdValue));
                keyValue = new KeyValue("UnsupportedKeys", other);
            }
        }
        return keyValue;
    }

    @Override
    public CmdBody decode(Map<String, Object> data) {
        return this.decode(data, true);
    }

    @Override
    public CmdBody decode(Map<String, Object> data, boolean isReq) {
        CmdBody cmd_bodyData = new CmdBody();
        cmd_bodyData.setCmdType(3);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            switch (entry.getKey()) {
                case "imei": {
                    int cmdKey = 1;
                    String imei = Convert.toStr(entry.getValue(), "000000000000000");
                    byte[] cmdValue = BytesHexStrUtil.string2BytesByASCII(imei);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "heartBeat": {
                    int cmdKey = 16;
                    byte[] cmdValue = new byte[]{Convert.toByte(entry.getValue(), (byte)0)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "addresses": {
                    int cmdKey = 17;
                    Map addresses = (Map)entry.getValue();
                    double lat_addr = Convert.toDouble(addresses.get("lat"), 0.0);
                    double lng_addr = Convert.toDouble(addresses.get("lng"), 0.0);
                    byte[] cmdValue = ProtocolUtil.latlng2Bytes(lat_addr, lng_addr);
                    String address = Convert.toStr(addresses.get("address"));
                    if (address != null) {
                        byte[] addressBytes = BytesHexStrUtil.string2BytesByUTF_8(address);
                        addressBytes = ArrayUtils.add(addressBytes, (byte)0);
                        cmdValue = ArrayUtils.addAll(cmdValue, addressBytes);
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "systemTime": {
                    int cmdKey = 18;
                    byte[] cmdValue = null;
                    if (entry.getValue() instanceof String && !entry.getValue().equals("null")) {
                        cmdValue = ProtocolUtil.dateTime2Bytes(entry.getValue());
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "weather": {
                    byte[] cmdValue;
                    int cmdKey = 19;
                    Map weather = (Map)entry.getValue();
                    if (weather.get("lang") != null) {
                        String lang = Convert.toStr(weather.get("lang"), "");
                        lang = String.format("%-8s", lang);
                        cmdValue = BytesHexStrUtil.string2BytesByASCII(lang);
                        if (weather.get("lat") != null && weather.get("lng") != null) {
                            double lat_weather = Convert.toDouble(weather.get("lat"), 0.0);
                            double lng_weather = Convert.toDouble(weather.get("lng"), 0.0);
                            cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.latlng2Bytes(lat_weather, lng_weather));
                        }
                    } else {
                        cmdValue = ProtocolUtil.dateTime2Bytes(weather.get("dateTime"));
                        double lat_weather = Convert.toDouble(weather.get("lat"), 0.0);
                        double lng_weather = Convert.toDouble(weather.get("lng"), 0.0);
                        String city = Convert.toStr(weather.get("lang"), "");
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.latlng2Bytes(lat_weather, lng_weather));
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8(city));
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "weather2": {
                    int cmdKey = 20;
                    Map weather2 = (Map)entry.getValue();
                    byte[] data_status = ProtocolUtil.dateTime2Bytes(weather2.get("dateTime"));
                    int codeDay = Convert.toInt(weather2.get("codeDay"));
                    int codeNight = Convert.toInt(weather2.get("codeNight"));
                    int tempMax = Convert.toInt(weather2.get("tempMax"));
                    int tempMin = Convert.toInt(weather2.get("tempMin"));
                    int hum = Convert.toInt(weather2.get("hum"));
                    int uvIndex = Convert.toInt(weather2.get("uvIndex"));
                    int windSpd = Convert.toInt(weather2.get("windSpd"));
                    int windDeg = Convert.toInt(weather2.get("windDeg"));
                    byte[] cmdValue = ArrayUtils.addAll(data_status, ProtocolUtil.long2Bytes(codeDay, 2));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(codeNight, 2));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(tempMax, 2));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(tempMin, 2));
                    cmdValue = ArrayUtils.add(cmdValue, (byte)hum);
                    cmdValue = ArrayUtils.add(cmdValue, (byte)uvIndex);
                    cmdValue = ArrayUtils.add(cmdValue, (byte)windSpd);
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(windDeg, 2));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "location_gsm": {
                    int cmdKey = 33;
                    Map location_gsm = (Map)entry.getValue();
                    byte[] cmdValue = KeyGMS.INSTANCE.decode(location_gsm);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "location_wifi": {
                    int cmdKey = 34;
                    Map location_wifi = (Map)entry.getValue();
                    byte[] cmdValue = KeyWifi.INSTANCE.decode(location_wifi);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "status": {
                    int cmdKey = 36;
                    Map generalData = (Map)entry.getValue();
                    byte[] cmdValue = KeyStatus.INSTANCE.decode(generalData);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                }
            }
        }
        return cmd_bodyData;
    }
}

