/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.command;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.model.KeyValue;
import com.tracker.ev07b.service.command.AnalysisCommand;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandResponse
implements AnalysisCommand {
    public static CommandResponse INSTANCE = new CommandResponse();

    private CommandResponse() {
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel) {
        return this.encode(cmdModel, true);
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel, boolean isReq) {
        HashMap<String, Object> responseData = new HashMap<String, Object>(3);
        List<CmdBody.CMD> cmdDataList = cmdModel.getBodyData().getCmdData();
        int cmdKey = cmdDataList.get(0).getCmdKey();
        responseData.put("code", cmdKey);
        responseData.put("returnStatus", "error");
        KeyValue keyValue = this.encode(cmdDataList.get(0));
        if (keyValue.getKey().equals("UnsupportedKeys")) {
            ProtocolUtil.saveNewToList(responseData, keyValue.getKey(), keyValue.getValue());
        } else {
            responseData.put(keyValue.getKey(), keyValue.getValue());
        }
        return responseData;
    }

    public KeyValue encode(CmdBody.CMD cmd) {
        KeyValue keyValue = null;
        byte[] cmdValue = cmd.getCmdValue();
        switch (cmd.getCmdKey()) {
            case 0: {
                keyValue = new KeyValue("returnStatus", "ok");
                break;
            }
            case 17: {
                keyValue = new KeyValue("msg", "Version Invalid");
                break;
            }
            case 18: {
                keyValue = new KeyValue("msg", "Encryption Invalid");
                break;
            }
            case 19: {
                keyValue = new KeyValue("msg", "Length error");
                break;
            }
            case 20: {
                keyValue = new KeyValue("msg", "Check CRC error");
                break;
            }
            case 21: {
                keyValue = new KeyValue("msg", "Command Invalid");
                break;
            }
            case 22: {
                keyValue = new KeyValue("msg", "Key Invalid");
                break;
            }
            case 23: {
                keyValue = new KeyValue("msg", "Key length error");
                break;
            }
            case 33: {
                keyValue = new KeyValue("msg", "Data Format Invalid");
                break;
            }
            case 34: {
                keyValue = new KeyValue("msg", "Data Size Error");
                break;
            }
            case 35: {
                keyValue = new KeyValue("msg", "Invalid State");
                break;
            }
            case 36: {
                keyValue = new KeyValue("msg", "Invalid Parameter");
                break;
            }
            case 37: {
                keyValue = new KeyValue("msg", "No Memory");
                break;
            }
            case 38: {
                keyValue = new KeyValue("msg", "Function not supported");
                break;
            }
            case 39: {
                keyValue = new KeyValue("msg", "GPS not Location");
                break;
            }
            case 40: {
                keyValue = new KeyValue("msg", "Address resolution Error");
                break;
            }
            case 64: {
                keyValue = new KeyValue("msg", "No Password Verify");
                break;
            }
            case 240: {
                keyValue = new KeyValue("msg", "Battery Power Low");
                break;
            }
            default: {
                HashMap<String, String> other = new HashMap<String, String>(1);
                other.put("key:0x" + Integer.toHexString(cmd.getCmdKey()), "Value:" + BytesHexStrUtil.bytesToHexString(cmdValue));
                keyValue = new KeyValue("UnsupportedKeys", other);
            }
        }
        return keyValue;
    }

    @Override
    public CmdBody decode(Map<String, Object> data) {
        return this.decode(data, true);
    }

    @Override
    public CmdBody decode(Map<String, Object> data, boolean isReq) {
        CmdBody cmd_bodyData = new CmdBody();
        cmd_bodyData.setCmdType(127);
        int cmdKey = Convert.toInt(data.get("cmdKey"));
        cmd_bodyData.addCmdData(1, cmdKey, null);
        return cmd_bodyData;
    }
}

