/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.command;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.model.KeyValue;
import com.tracker.ev07b.service.command.AnalysisCommand;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandDebug
implements AnalysisCommand {
    public static CommandDebug INSTANCE = new CommandDebug();

    private CommandDebug() {
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel) {
        return this.encode(cmdModel, true);
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel, boolean isReq) {
        HashMap<String, Object> debugData = new HashMap<String, Object>();
        List<CmdBody.CMD> cmdDataList = cmdModel.getBodyData().getCmdData();
        for (CmdBody.CMD cmd : cmdDataList) {
            debugData.put("cmdKey", cmd.getCmdKey());
            KeyValue keyValue = this.encode(cmd, isReq);
            if (keyValue.getKey().equals("UnsupportedKeys")) {
                ProtocolUtil.saveNewToList(debugData, keyValue.getKey(), keyValue.getValue());
                continue;
            }
            debugData.put(keyValue.getKey(), keyValue.getValue());
        }
        return debugData;
    }

    public KeyValue encode(CmdBody.CMD cmd) {
        return this.encode(cmd, true);
    }

    public KeyValue encode(CmdBody.CMD cmd, boolean isReq) {
        KeyValue keyValue = null;
        byte[] cmdValue = cmd.getCmdValue();
        switch (cmd.getCmdKey()) {
            case 112: {
                if (isReq) {
                    long flag = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                    String fileName = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 4, cmdValue.length));
                    HashMap<String, Object> open = new HashMap<String, Object>(3);
                    open.put("flag", flag);
                    open.put("fileName", fileName);
                    keyValue = new KeyValue("open", open);
                    break;
                }
                keyValue = new KeyValue("open", this.fileSystemReturnCode(cmdValue));
                break;
            }
            case 113: {
                if (isReq) {
                    keyValue = new KeyValue("close", "null");
                    break;
                }
                keyValue = new KeyValue("close", this.fileSystemReturnCode(cmdValue));
                break;
            }
            case 114: {
                if (isReq) {
                    keyValue = new KeyValue("write", cmdValue);
                    break;
                }
                long writeSize = ProtocolUtil.bytes2Long(cmdValue, true);
                keyValue = new KeyValue("write", writeSize);
                break;
            }
            case 118: {
                if (isReq) {
                    String remove_path = BytesHexStrUtil.bytes2StringByUTF_8(cmdValue);
                    keyValue = new KeyValue("remove", remove_path);
                    break;
                }
                keyValue = new KeyValue("remove", this.fileSystemReturnCode(cmdValue));
                break;
            }
            case 120: {
                if (isReq) {
                    String readDir_path = BytesHexStrUtil.bytes2StringByUTF_8(cmdValue);
                    keyValue = new KeyValue("readDir", readDir_path);
                    break;
                }
                String readDir_type = "";
                if (cmdValue[0] == 17) {
                    readDir_type = "file";
                } else if (cmdValue[0] == 34) {
                    readDir_type = "dir";
                } else if (cmdValue[0] == 46) {
                    readDir_type = "super block";
                }
                long readDir_size = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 1, 5));
                String readDir_name = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 5, cmdValue.length));
                HashMap<String, Object> readDir = new HashMap<String, Object>(3);
                readDir.put("type", readDir_type);
                readDir.put("size", readDir_size);
                readDir.put("name", readDir_name);
                keyValue = new KeyValue("readDir", readDir);
                break;
            }
            case 122: {
                if (isReq) {
                    keyValue = new KeyValue("traverse", "null");
                    break;
                }
                long blockSize = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                long blockCount = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 4, 8));
                long blockUsed = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 8, 12));
                HashMap<String, Long> traverse = new HashMap<String, Long>(3);
                traverse.put("blockSize", blockSize);
                traverse.put("blockCount", blockCount);
                traverse.put("blockUsed", blockUsed);
                keyValue = new KeyValue("traverse", traverse);
                break;
            }
            case 123: {
                if (isReq) {
                    keyValue = new KeyValue("format", "null");
                    break;
                }
                keyValue = new KeyValue("format", this.fileSystemReturnCode(cmdValue));
                break;
            }
            default: {
                HashMap<String, String> other = new HashMap<String, String>(1);
                other.put("key:0x" + Integer.toHexString(cmd.getCmdKey()), "Value:" + BytesHexStrUtil.bytesToHexString(cmdValue));
                keyValue = new KeyValue("UnsupportedKeys", other);
            }
        }
        return keyValue;
    }

    @Override
    public CmdBody decode(Map<String, Object> data) {
        return this.decode(data, true);
    }

    @Override
    public CmdBody decode(Map<String, Object> data, boolean isReq) {
        CmdBody cmd_bodyData = new CmdBody();
        cmd_bodyData.setCmdType(6);
        byte[] cmdValue = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            switch (entry.getKey()) {
                case "open": {
                    int cmdKey = 112;
                    if (isReq) {
                        Map open = (Map)entry.getValue();
                        long flag = Convert.toLong(open.get("flag"), 0L);
                        String fileName = Convert.toStr(open.get("fileName"), "");
                        cmdValue = ProtocolUtil.long2Bytes(flag, 4);
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8(fileName));
                    } else {
                        long returnCode = Convert.toLong(entry.getValue(), 0L);
                        cmdValue = ProtocolUtil.long2Bytes(returnCode, 4);
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "close": {
                    int cmdKey = 113;
                    if (isReq) {
                        cmd_bodyData.addCmdData(1, cmdKey, null);
                        break;
                    }
                    long returnCode = Convert.toLong(entry.getValue(), 0L);
                    cmdValue = ProtocolUtil.long2Bytes(returnCode, 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "write": {
                    int cmdKey = 114;
                    if (isReq) {
                        if (entry.getValue() instanceof String) {
                            cmdValue = BytesHexStrUtil.hexStringToBytes((String)entry.getValue());
                        } else if (entry.getValue() instanceof byte[]) {
                            cmdValue = (byte[])entry.getValue();
                        }
                    } else {
                        cmdValue = ProtocolUtil.long2Bytes(Convert.toLong(entry.getValue(), 0L), 4);
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "remove": {
                    int cmdKey = 118;
                    if (isReq) {
                        cmdValue = BytesHexStrUtil.string2BytesByUTF_8(Convert.toStr(entry.getValue(), ""));
                    } else {
                        long returnCode = Convert.toLong(entry.getValue(), 0L);
                        cmdValue = ProtocolUtil.long2Bytes(returnCode, 4);
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "readDir": {
                    int cmdKey = 120;
                    if (isReq) {
                        cmdValue = BytesHexStrUtil.string2BytesByUTF_8(Convert.toStr(entry.getValue(), ""));
                    } else {
                        Map readDir = (Map)entry.getValue();
                        String type = Convert.toStr(readDir.get("type"), "");
                        if (type.equals("file")) {
                            cmdValue = new byte[]{17};
                        } else if (type.equals("dir")) {
                            cmdValue = new byte[]{34};
                        } else if (type.equals("super block")) {
                            cmdValue = new byte[]{46};
                        }
                        long size = Convert.toLong(readDir.get("size"), 0L);
                        String name = Convert.toStr(readDir.get("name"));
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(size, 4));
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8(name));
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "traverse": {
                    int cmdKey = 122;
                    if (isReq) {
                        cmd_bodyData.addCmdData(1, cmdKey, null);
                        break;
                    }
                    Map traverse = (Map)entry.getValue();
                    long blockSize = Convert.toLong(traverse.get("blockSize"), 0L);
                    long blockCount = Convert.toLong(traverse.get("blockCount"), 0L);
                    long blockUsed = Convert.toLong(traverse.get("blockUsed"), 0L);
                    cmdValue = ProtocolUtil.long2Bytes(blockSize, 4);
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(blockCount, 4));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(blockUsed, 4));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "format": {
                    int cmdKey = 123;
                    if (isReq) {
                        cmd_bodyData.addCmdData(1, cmdKey, null);
                        break;
                    }
                    long returnCode = Convert.toLong(entry.getValue(), 0L);
                    cmdValue = ProtocolUtil.long2Bytes(returnCode, 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
            }
        }
        return cmd_bodyData;
    }

    private String fileSystemReturnCode(byte[] data) {
        long flag = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 0, 4));
        String code = "ERROR";
        if (flag == 0L) {
            code = "OK";
        } else if (flag == -5L) {
            code = "ERR_IO";
        } else if (flag == -52L) {
            code = "ERR_CORRUPT";
        } else if (flag == -2L) {
            code = "ERR_NOENT";
        } else if (flag == -17L) {
            code = "ERR_EXIST";
        } else if (flag == -20L) {
            code = "ERR_NOTDIR";
        } else if (flag == -21L) {
            code = "ERR_ISDIR";
        } else if (flag == -39L) {
            code = "ERR_NOTEMPTY";
        } else if (flag == -9L) {
            code = "ERR_BADF";
        } else if (flag == -27L) {
            code = "ERR_FBIG";
        } else if (flag == -22L) {
            code = "ERR_INVAL";
        } else if (flag == -28L) {
            code = "ERR_NOSPC";
        } else if (flag == -12L) {
            code = "ERR_NOMEM";
        }
        return code;
    }
}

