/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.command;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.model.KeyValue;
import com.tracker.ev07b.service.command.AnalysisCommand;
import com.tracker.ev07b.service.key.KeyActive;
import com.tracker.ev07b.service.key.KeyAlarmCode;
import com.tracker.ev07b.service.key.KeyBeacon;
import com.tracker.ev07b.service.key.KeyBeacon2;
import com.tracker.ev07b.service.key.KeyBle;
import com.tracker.ev07b.service.key.KeyBle2;
import com.tracker.ev07b.service.key.KeyCall;
import com.tracker.ev07b.service.key.KeyEddystone;
import com.tracker.ev07b.service.key.KeyGMS;
import com.tracker.ev07b.service.key.KeyGMS2;
import com.tracker.ev07b.service.key.KeyGMS3;
import com.tracker.ev07b.service.key.KeyGPS;
import com.tracker.ev07b.service.key.KeyHealthData;
import com.tracker.ev07b.service.key.KeyHeartRate;
import com.tracker.ev07b.service.key.KeyHomeWifi;
import com.tracker.ev07b.service.key.KeyIBeacon;
import com.tracker.ev07b.service.key.KeyIBeacon2;
import com.tracker.ev07b.service.key.KeySPO2List;
import com.tracker.ev07b.service.key.KeySmart;
import com.tracker.ev07b.service.key.KeyStatus;
import com.tracker.ev07b.service.key.KeyStep;
import com.tracker.ev07b.service.key.KeyStepData;
import com.tracker.ev07b.service.key.KeyWifi;
import com.tracker.ev07b.service.key.KeyWifi2;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CommandData
implements AnalysisCommand {
    private final Logger log = Logger.getLogger(CommandData.class.getName());
    public static CommandData INSTANCE = new CommandData();
    private List<String> toListKeys = new ArrayList<String>(10);
    private List<String> locationDataKeys = new ArrayList<String>(16);

    private CommandData() {
        this.locationDataKeys.add("status");
        this.locationDataKeys.add("gps");
        this.locationDataKeys.add("gsm");
        this.locationDataKeys.add("gsm2");
        this.locationDataKeys.add("gsm3");
        this.locationDataKeys.add("wifi");
        this.locationDataKeys.add("wifi2");
        this.locationDataKeys.add("ble");
        this.locationDataKeys.add("ble2");
        this.locationDataKeys.add("smart");
        this.locationDataKeys.add("beacon");
        this.locationDataKeys.add("beacon2");
        this.locationDataKeys.add("homeWifi");
        this.locationDataKeys.add("iBeacon");
        this.locationDataKeys.add("iBeacon2");
        this.locationDataKeys.add("eddystone");
        this.locationDataKeys.add("alarm");
        this.toListKeys.add("callList");
        this.toListKeys.add("stepList");
        this.toListKeys.add("activeList");
        this.toListKeys.add("heartList");
        this.toListKeys.add("spo2List");
        this.toListKeys.add("healthData");
        this.toListKeys.add("logList");
        this.toListKeys.add("beacon");
        this.toListKeys.add("beacon2");
        this.toListKeys.add("homeWifi");
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel) {
        return this.encode(cmdModel, true);
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel, boolean isReq) {
        HashMap<String, Object> locationData = new HashMap<String, Object>();
        List<CmdBody.CMD> cmdDataList = cmdModel.getBodyData().getCmdData();
        for (CmdBody.CMD cmd : cmdDataList) {
            KeyValue keyValue = this.encode(cmd);
            if (this.locationDataKeys.contains(keyValue.getKey())) {
                boolean isSaveList = this.toListKeys.contains(keyValue.getKey());
                ProtocolUtil.saveLocationData(locationData, keyValue.getKey(), keyValue.getValue(), isSaveList);
                continue;
            }
            if (this.toListKeys.contains(keyValue.getKey())) {
                ProtocolUtil.saveNewToList(locationData, keyValue.getKey(), keyValue.getValue());
                continue;
            }
            locationData.put(keyValue.getKey(), keyValue.getValue());
        }
        return locationData;
    }

    public KeyValue encode(CmdBody.CMD cmd) {
        KeyValue keyValue = null;
        byte[] cmdValue = cmd.getCmdValue();
        switch (cmd.getCmdKey()) {
            case 1: {
                keyValue = new KeyValue("imei", BytesHexStrUtil.bytes2StringByASCII(cmdValue));
                break;
            }
            case 3: {
                keyValue = new KeyValue("customizedID", BytesHexStrUtil.bytes2StringByUTF_8(cmdValue));
                break;
            }
            case 4: {
                keyValue = new KeyValue("iccid", BytesHexStrUtil.bytes2StringByASCII(cmdValue));
                break;
            }
            case 36: {
                Object ev07b_status = KeyStatus.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("status", ev07b_status);
                break;
            }
            case 32: {
                Object ev07b_gps = KeyGPS.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("gps", ev07b_gps);
                break;
            }
            case 33: {
                Object ev07b_gsm = KeyGMS.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("gsm", ev07b_gsm);
                break;
            }
            case 41: {
                Object ev07b_gsm2 = KeyGMS2.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("gsm2", ev07b_gsm2);
                break;
            }
            case 43: {
                Object ev07b_gsm3 = KeyGMS3.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("gsm3", ev07b_gsm3);
                break;
            }
            case 34: {
                Object ev07b_wifi = KeyWifi.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("wifi", ev07b_wifi);
                break;
            }
            case 25: {
                Object ev07b_wifi2 = KeyWifi2.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("wifi2", ev07b_wifi2);
                break;
            }
            case 35: {
                Object ev07b_ble = KeyBle.INSTANCE.encode(cmdValue);
                if (ev07b_ble == null) break;
                keyValue = new KeyValue("ble", ev07b_ble);
                break;
            }
            case 38: {
                Object ev07b_ble2 = KeyBle2.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("ble2", ev07b_ble2);
                break;
            }
            case 39: {
                Object ev07b_smart = KeySmart.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("smart", ev07b_smart);
                break;
            }
            case 40: {
                Object ev07b_beacon = KeyBeacon.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("beacon", ev07b_beacon);
                break;
            }
            case 44: {
                Object ev07b_beacon2 = KeyBeacon2.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("beacon2", ev07b_beacon2);
                break;
            }
            case 42: {
                Object ev07b_homeWifi = KeyHomeWifi.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("homeWifi", ev07b_homeWifi);
                break;
            }
            case 2: {
                Object map_alarm = KeyAlarmCode.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("alarm", map_alarm);
                break;
            }
            case 18: {
                keyValue = new KeyValue("singleLocating", "null");
                break;
            }
            case 19: {
                keyValue = new KeyValue("continueLocating", "null");
                break;
            }
            case 20: {
                Date startTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(cmdValue, 0, 4));
                Date stopTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(cmdValue, 4, 8));
                HashMap<String, Date> map_walkPet = new HashMap<String, Date>();
                map_walkPet.put("startTime", startTime);
                map_walkPet.put("stopTime", stopTime);
                keyValue = new KeyValue("petWalking", map_walkPet);
                break;
            }
            case 37: {
                Object ev07b_call = KeyCall.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("callList", ev07b_call);
                break;
            }
            case 48: {
                Object ev07b_step_list = KeyStep.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("stepList", ev07b_step_list);
                break;
            }
            case 49: {
                Object ev07b_active_list = KeyActive.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("activeList", ev07b_active_list);
                break;
            }
            case 64: {
                Object ev07b_heart_list = KeyHeartRate.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("heartList", ev07b_heart_list);
                break;
            }
            case 65: {
                Object ev07b_spo2_list = KeySPO2List.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("spo2List", ev07b_spo2_list);
                break;
            }
            case 51: {
                Object beaconList = KeyIBeacon.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("iBeacon", beaconList);
                break;
            }
            case 52: {
                Object beaconList2 = KeyIBeacon2.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("iBeacon2", beaconList2);
                break;
            }
            case 53: {
                Object eddystone = KeyEddystone.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("eddystone", eddystone);
                break;
            }
            case 55: {
                Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(cmdValue, 0, 4));
                long status = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 4, 8));
                HashMap<String, Comparable<Date>> dogBarking = new HashMap<String, Comparable<Date>>(3);
                dogBarking.put("time", dateTime);
                dogBarking.put("count", Integer.valueOf(ProtocolUtil.getbit(status, 0, 31)));
                dogBarking.put("status", Integer.valueOf(ProtocolUtil.getbit(status, 31, 32)));
                keyValue = new KeyValue("dogBarking", dogBarking);
                break;
            }
            case 56: {
                Date lastTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(cmdValue, 0, 4));
                Date thisTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(cmdValue, 4, 8));
                byte value = cmdValue[8];
                HashMap<String, Comparable<Date>> gpsWork = new HashMap<String, Comparable<Date>>(3);
                gpsWork.put("lastTime", lastTime);
                gpsWork.put("thisTime", thisTime);
                gpsWork.put("value", Integer.valueOf(value));
                keyValue = new KeyValue("GpsWork", gpsWork);
                break;
            }
            case 57: {
                Object ev07b_step = KeyStepData.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("stepData", ev07b_step);
                break;
            }
            case 100: {
                Object healthData = KeyHealthData.INSTANCE.encode(cmdValue);
                keyValue = new KeyValue("healthData", healthData);
                break;
            }
            case 240: {
                HashMap<String, Object> ev07b_log = new HashMap<String, Object>(2);
                ev07b_log.put("codeData", cmdValue);
                ev07b_log.put("logData", BytesHexStrUtil.bytes2StringByUTF_8(cmdValue));
                keyValue = new KeyValue("logList", ev07b_log);
                break;
            }
            default: {
                HashMap<String, String> other = new HashMap<String, String>(1);
                other.put("key:0x" + Integer.toHexString(cmd.getCmdKey()), "Value:" + BytesHexStrUtil.bytesToHexString(cmdValue));
                keyValue = new KeyValue("UnsupportedKeys", other);
            }
        }
        return keyValue;
    }

    @Override
    public CmdBody decode(Map<String, Object> data) {
        return this.decode(data, true);
    }

    @Override
    public CmdBody decode(Map<String, Object> data, boolean isReq) {
        CmdBody cmd_bodyData = new CmdBody();
        cmd_bodyData.setCmdType(1);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            byte[] cmdValue = new byte[]{};
            switch (entry.getKey()) {
                case "imei": {
                    int cmdKey = 1;
                    String imei = Convert.toStr(entry.getValue(), "000000000000000");
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(imei);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "iccid": {
                    int cmdKey = 4;
                    String iccid = Convert.toStr(entry.getValue(), "00000000000000000000");
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(iccid);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "alarm": {
                    int cmdKey = 2;
                    Map alarmCode = (Map)entry.getValue();
                    cmdValue = KeyAlarmCode.INSTANCE.decode(alarmCode);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "customizedID": {
                    int cmdKey = 3;
                    String customizedID = Convert.toStr(entry.getValue(), "");
                    cmdValue = BytesHexStrUtil.string2BytesByUTF_8(customizedID);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "singleLocating": {
                    int cmdKey = 18;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "continueLocating": {
                    int cmdKey = 19;
                    cmd_bodyData.addCmdData(1, cmdKey, null);
                    break;
                }
                case "petWalking": {
                    int cmdKey = 20;
                    Map walkPet = (Map)entry.getValue();
                    byte[] startByte = ProtocolUtil.dateTime2Bytes(walkPet.get("startTime"));
                    byte[] stopByte = ProtocolUtil.dateTime2Bytes(walkPet.get("stopTime"));
                    cmdValue = ArrayUtils.addAll(startByte, stopByte);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "gps": {
                    int cmdKey = 32;
                    Map data_gps = (Map)entry.getValue();
                    cmdValue = KeyGPS.INSTANCE.decode(data_gps);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "gsm": {
                    int cmdKey = 33;
                    Map data_gsm = (Map)entry.getValue();
                    cmdValue = KeyGMS.INSTANCE.decode(data_gsm);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "gsm2": {
                    int cmdKey = 41;
                    Map data_gsm2 = (Map)entry.getValue();
                    cmdValue = KeyGMS2.INSTANCE.decode(data_gsm2);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "gsm3": {
                    int cmdKey = 43;
                    Map data_gsm3 = (Map)entry.getValue();
                    cmdValue = KeyGMS3.INSTANCE.decode(data_gsm3);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "wifi": {
                    int cmdKey = 34;
                    Map data_wifi = (Map)entry.getValue();
                    cmdValue = KeyWifi.INSTANCE.decode(data_wifi);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "wifi2": {
                    int cmdKey = 25;
                    Map data_wifi2 = (Map)entry.getValue();
                    cmdValue = KeyWifi2.INSTANCE.decode(data_wifi2);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "ble": {
                    int cmdKey = 35;
                    Map data_ble = (Map)entry.getValue();
                    cmdValue = KeyBle.INSTANCE.decode(data_ble);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "ble2": {
                    int cmdKey = 38;
                    Map data_ble2 = (Map)entry.getValue();
                    cmdValue = KeyBle2.INSTANCE.decode(data_ble2);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "status": {
                    int cmdKey = 36;
                    Map data_status = (Map)entry.getValue();
                    cmdValue = KeyStatus.INSTANCE.decode(data_status);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "callList": {
                    int cmdKey = 37;
                    List callList = (List)entry.getValue();
                    for (Map call : callList) {
                        cmdValue = ArrayUtils.addAll(cmdValue, KeyCall.INSTANCE.decode(call));
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "smart": {
                    int cmdKey = 39;
                    Map data_smart = (Map)entry.getValue();
                    cmdValue = KeySmart.INSTANCE.decode(data_smart);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "beacon": {
                    int cmdKey = 40;
                    Map data_beacon = (Map)entry.getValue();
                    cmdValue = KeyBeacon.INSTANCE.decode(data_beacon);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "beacon2": {
                    int cmdKey = 44;
                    Map data_beacon2 = (Map)entry.getValue();
                    cmdValue = KeyBeacon2.INSTANCE.decode(data_beacon2);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "homeWifi": {
                    int cmdKey = 42;
                    Map data_homeWifi = (Map)entry.getValue();
                    cmdValue = KeyHomeWifi.INSTANCE.decode(data_homeWifi);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "stepList": {
                    int cmdKey = 48;
                    List data_step = (List)entry.getValue();
                    cmdValue = KeyStep.INSTANCE.decode(data_step);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "activeList": {
                    int cmdKey = 49;
                    List data_active = (List)entry.getValue();
                    cmdValue = KeyActive.INSTANCE.decode(data_active);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "iBeacon": {
                    int cmdKey = 51;
                    Map data_beaconList = (Map)entry.getValue();
                    cmdValue = KeyIBeacon.INSTANCE.decode(data_beaconList);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "iBeacon2": {
                    int cmdKey = 52;
                    Map data_beaconList2 = (Map)entry.getValue();
                    cmdValue = KeyIBeacon2.INSTANCE.decode(data_beaconList2);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "eddystone": {
                    int cmdKey = 53;
                    Map eddystone = (Map)entry.getValue();
                    cmdValue = KeyEddystone.INSTANCE.decode(eddystone);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "dogBarking": {
                    int cmdKey = 55;
                    Map dogBarking = (Map)entry.getValue();
                    cmdValue = ProtocolUtil.dateTime2Bytes(dogBarking.get("time"));
                    int count = Convert.toInt(dogBarking.get("count"));
                    int dogBarking_status = Convert.toInt(dogBarking.get("status"));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(count += dogBarking_status << 31, 4));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "GpsWork": {
                    int cmdKey = 56;
                    Map gpsWork = (Map)entry.getValue();
                    byte[] lastTime = ProtocolUtil.dateTime2Bytes(gpsWork.get("lastTime"));
                    byte[] thisTime = ProtocolUtil.dateTime2Bytes(gpsWork.get("thisTime"));
                    int value = Convert.toInt(gpsWork.get("value"));
                    cmdValue = ArrayUtils.addAll(lastTime, thisTime);
                    cmdValue = ArrayUtils.add(cmdValue, (byte)value);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "stepData": {
                    int cmdKey = 57;
                    Map stepData = (Map)entry.getValue();
                    cmdValue = KeyStepData.INSTANCE.decode(stepData);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "heartList": {
                    int cmdKey = 64;
                    List data_heartRate = (List)entry.getValue();
                    cmdValue = KeyHeartRate.INSTANCE.decode(data_heartRate);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "spo2List": {
                    int cmdKey = 65;
                    List data_spo2Rate = (List)entry.getValue();
                    cmdValue = KeySPO2List.INSTANCE.decode(data_spo2Rate);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "healthData": {
                    int cmdKey = 100;
                    Map healthData = (Map)entry.getValue();
                    cmdValue = KeyHealthData.INSTANCE.decode(healthData);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                }
            }
        }
        return cmd_bodyData;
    }
}

