/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.command;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.model.KeyValue;
import com.tracker.ev07b.service.command.AnalysisCommand;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandConfig
implements AnalysisCommand {
    public static CommandConfig INSTANCE = new CommandConfig();
    private final List<String> toListKeys = new ArrayList<String>(15);

    private CommandConfig() {
        this.toListKeys.add("alarmClock");
        this.toListKeys.add("alarmClockExt");
        this.toListKeys.add("bleWhiteList");
        this.toListKeys.add("number");
        this.toListKeys.add("numberNamePhoto");
        this.toListKeys.add("wifiList");
        this.toListKeys.add("apnList");
        this.toListKeys.add("geoAlert");
        this.toListKeys.add("wifiWhiteList");
        this.toListKeys.add("beaconList");
        this.toListKeys.add("sub1GWhiteList");
        this.toListKeys.add("loraWhiteList");
        this.toListKeys.add("voipList");
        this.toListKeys.add("UnsupportedKeys");
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel) {
        return this.encode(cmdModel, true);
    }

    @Override
    public Map<String, Object> encode(CmdModel cmdModel, boolean isReq) {
        HashMap<String, Object> configData = new HashMap<String, Object>();
        List<CmdBody.CMD> cmdDataList = cmdModel.getBodyData().getCmdData();
        for (CmdBody.CMD cmd : cmdDataList) {
            KeyValue keyValue = this.encode(cmd);
            if (this.toListKeys.contains(keyValue.getKey())) {
                ProtocolUtil.saveNewToList(configData, keyValue.getKey(), keyValue.getValue());
                continue;
            }
            configData.put(keyValue.getKey(), keyValue.getValue());
        }
        return configData;
    }

    /*
     * WARNING - void declaration
     */
    public KeyValue encode(CmdBody.CMD cmd) {
        KeyValue keyValue = null;
        int cmdLength = cmd.getCmdLength();
        byte[] cmdValue = cmd.getCmdValue();
        switch (cmd.getCmdKey()) {
            case 1: {
                String module = BytesHexStrUtil.bytesToHexString(cmdValue, false);
                module = module.replaceAll(" ", "");
                keyValue = new KeyValue("module", module);
                break;
            }
            case 2: {
                StringBuilder version = new StringBuilder();
                version.append("v").append(cmdValue[3] & 0xFF);
                version.append(".").append(cmdValue[2] & 0xFF);
                version.append(".").append(cmdValue[1] & 0xFF);
                version.append(".").append(cmdValue[0] & 0xFF);
                keyValue = new KeyValue("version", version.toString());
                break;
            }
            case 3: {
                String IMEI = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("IMEI", IMEI);
                break;
            }
            case 4: {
                String ICCID = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("ICCID", ICCID);
                break;
            }
            case 5: {
                String MAC = ProtocolUtil.bytes2Mac(cmdValue, false);
                keyValue = new KeyValue("MAC", MAC);
                break;
            }
            case 6: {
                Date dateTime = ProtocolUtil.bytes2DateTime(cmdValue);
                keyValue = new KeyValue("dateTime", dateTime);
                break;
            }
            case 7: {
                int runTime = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                keyValue = new KeyValue("runTime", runTime);
                break;
            }
            case 8: {
                StringBuilder firmwareVersion = new StringBuilder();
                firmwareVersion.append("v").append(cmdValue[3] & 0xFF).append(".").append(cmdValue[2] & 0xFF);
                firmwareVersion.append(".").append(cmdValue[1] & 0xFF).append(".").append(cmdValue[0] & 0xFF);
                StringBuilder hardwareVersion = new StringBuilder();
                hardwareVersion.append("v").append(cmdValue[11] & 0xFF).append(".").append(cmdValue[10] & 0xFF);
                hardwareVersion.append(".").append(cmdValue[9] & 0xFF).append(".").append(cmdValue[8] & 0xFF);
                int msdv = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 12, 16));
                StringBuilder softDeviceVersion = new StringBuilder();
                softDeviceVersion.append("v").append(msdv / 1000000).append(".").append(msdv % 1000000 / 1000).append(".").append(msdv % 1000);
                byte[] complier_dt = Arrays.copyOfRange(cmdValue, 20, 40);
                String complierDateTime = BytesHexStrUtil.bytes2StringByASCII(complier_dt).replace("\u0000", " ");
                HashMap<String, Object> firmware = new HashMap<String, Object>();
                firmware.put("firmwareVersion", firmwareVersion.toString());
                firmware.put("firmwareSize", ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 4, 8)));
                firmware.put("hardwareVersion", hardwareVersion.toString());
                firmware.put("softDeviceVersion", softDeviceVersion.toString());
                firmware.put("softDeviceFWID", (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 16, 20)));
                firmware.put("complierDateTime", complierDateTime);
                keyValue = new KeyValue("firmware", firmware);
                break;
            }
            case 9: {
                keyValue = new KeyValue("mileage", (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4)));
                break;
            }
            case 10: {
                int mode = cmdValue[3] & 0xFF;
                HashMap<String, Integer> workMode = new HashMap<String, Integer>();
                workMode.put("time", (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 3)));
                workMode.put("mode", mode);
                keyValue = new KeyValue("workMode", workMode);
                break;
            }
            case 11: {
                int index = ProtocolUtil.getbit(cmdValue[0], 0, 6);
                int medicine = ProtocolUtil.getbit(cmdValue[0], 6, 7);
                int status = ProtocolUtil.getbit(cmdValue[0], 7, 8);
                String alarmTime = String.format("%02d", cmdValue[1] & 0xFF) + ":" + String.format("%02d", cmdValue[2] & 0xFF);
                int week = cmdValue[3] & 0xFF;
                int ringTime = cmdValue[4] & 0xFF;
                int ringType = cmdValue[5] & 0xFF;
                HashMap<String, Object> alarmClock = new HashMap<String, Object>();
                alarmClock.put("index", index);
                alarmClock.put("medicine", medicine);
                alarmClock.put("status", status);
                alarmClock.put("time", alarmTime);
                alarmClock.put("ringTime", ringTime);
                alarmClock.put("ringType", ringType);
                alarmClock.put("mon", ProtocolUtil.getbit(week, 0, 1));
                alarmClock.put("tus", ProtocolUtil.getbit(week, 1, 2));
                alarmClock.put("wed", ProtocolUtil.getbit(week, 2, 3));
                alarmClock.put("thu", ProtocolUtil.getbit(week, 3, 4));
                alarmClock.put("fri", ProtocolUtil.getbit(week, 4, 5));
                alarmClock.put("sat", ProtocolUtil.getbit(week, 5, 6));
                alarmClock.put("sun", ProtocolUtil.getbit(week, 6, 7));
                if (cmdValue.length > 6) {
                    String describe = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 6, cmdValue.length));
                    alarmClock.put("describe", describe);
                }
                keyValue = new KeyValue("alarmClock", alarmClock);
                break;
            }
            case 123: {
                int status_7B = ProtocolUtil.getbit(cmdValue[0], 7, 8);
                int alarmType_7B = cmdValue[1] & 0xFF;
                int index_7B = cmdValue[2] & 0xFF;
                String alarmTime_7B = String.format("%02d", cmdValue[3] & 0xFF) + ":" + String.format("%02d", cmdValue[4] & 0xFF);
                int week_7B = cmdValue[5] & 0xFF;
                int ringTime_7B = cmdValue[6] & 0xFF;
                int ringType_7B = cmdValue[7] & 0xFF;
                String describe_7B = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 8, cmdValue.length));
                HashMap<String, Object> alarmClock_7B = new HashMap<String, Object>(15);
                alarmClock_7B.put("index", index_7B);
                alarmClock_7B.put("status", status_7B);
                alarmClock_7B.put("alarmType", alarmType_7B);
                alarmClock_7B.put("time", alarmTime_7B);
                alarmClock_7B.put("ringTime", ringTime_7B);
                alarmClock_7B.put("ringType", ringType_7B);
                alarmClock_7B.put("mon", ProtocolUtil.getbit(week_7B, 0, 1));
                alarmClock_7B.put("tus", ProtocolUtil.getbit(week_7B, 1, 2));
                alarmClock_7B.put("wed", ProtocolUtil.getbit(week_7B, 2, 3));
                alarmClock_7B.put("thu", ProtocolUtil.getbit(week_7B, 3, 4));
                alarmClock_7B.put("fri", ProtocolUtil.getbit(week_7B, 4, 5));
                alarmClock_7B.put("sat", ProtocolUtil.getbit(week_7B, 5, 6));
                alarmClock_7B.put("sun", ProtocolUtil.getbit(week_7B, 6, 7));
                alarmClock_7B.put("describe", describe_7B);
                keyValue = new KeyValue("alarmClockExt", alarmClock_7B);
                break;
            }
            case 12: {
                int noDisturbStatus = ProtocolUtil.getbit(cmdValue[0], 7, 8);
                String from = String.format("%02d", cmdValue[1] & 0xFF) + ":" + String.format("%02d", cmdValue[2] & 0xFF);
                String to = String.format("%02d", cmdValue[3] & 0xFF) + ":" + String.format("%02d", cmdValue[4] & 0xFF);
                HashMap<String, Object> noDisturb = new HashMap<String, Object>();
                noDisturb.put("status", noDisturbStatus);
                noDisturb.put("from", from);
                noDisturb.put("to", to);
                keyValue = new KeyValue("noDisturb", noDisturb);
                break;
            }
            case 13: {
                int password = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8 | (cmdValue[2] & 0xFF) << 16 | (cmdValue[3] & 0x7F) << 23;
                int passwordStatus = ProtocolUtil.getbit(cmdValue[3], 7, 8);
                HashMap<String, Integer> sim_password = new HashMap<String, Integer>();
                sim_password.put("password", password);
                sim_password.put("status", passwordStatus);
                keyValue = new KeyValue("password", sim_password);
                break;
            }
            case 14: {
                float timeZone = (float)((byte)(cmdValue[0] & 0xFF)) * 15.0f / 60.0f;
                keyValue = new KeyValue("timeZone", Float.valueOf(timeZone));
                break;
            }
            case 15: {
                long en_data = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                HashMap<String, Number> enableControl = new HashMap<String, Number>();
                enableControl.put("flagValue", en_data);
                enableControl.put("led", ProtocolUtil.getbit(en_data, 0, 1));
                enableControl.put("beep", ProtocolUtil.getbit(en_data, 1, 2));
                enableControl.put("motor", ProtocolUtil.getbit(en_data, 2, 3));
                enableControl.put("gsmLoc", ProtocolUtil.getbit(en_data, 3, 4));
                enableControl.put("wifiLoc", ProtocolUtil.getbit(en_data, 4, 5));
                enableControl.put("sosSpeaker", ProtocolUtil.getbit(en_data, 5, 6));
                enableControl.put("xSpeaker", ProtocolUtil.getbit(en_data, 6, 7));
                enableControl.put("bleLongConnect", ProtocolUtil.getbit(en_data, 7, 8));
                enableControl.put("bleLoc", ProtocolUtil.getbit(en_data, 8, 9));
                enableControl.put("sosCallNumberVoice", ProtocolUtil.getbit(en_data, 9, 10));
                enableControl.put("bleAdvAlways", ProtocolUtil.getbit(en_data, 10, 11));
                enableControl.put("gpsLoc", ProtocolUtil.getbit(en_data, 11, 12));
                enableControl.put("tcpFast", ProtocolUtil.getbit(en_data, 12, 13));
                enableControl.put("homeBeacon", ProtocolUtil.getbit(en_data, 14, 15));
                enableControl.put("activity", ProtocolUtil.getbit(en_data, 15, 16));
                enableControl.put("step", ProtocolUtil.getbit(en_data, 16, 17));
                enableControl.put("homeWifi", ProtocolUtil.getbit(en_data, 17, 18));
                enableControl.put("dataSaver", ProtocolUtil.getbit(en_data, 18, 19));
                enableControl.put("networkLoc", ProtocolUtil.getbit(en_data, 19, 20));
                enableControl.put("powerControl", ProtocolUtil.getbit(en_data, 20, 21));
                enableControl.put("sosCannel", ProtocolUtil.getbit(en_data, 21, 22));
                enableControl.put("longSMS", ProtocolUtil.getbit(en_data, 22, 23));
                enableControl.put("autoUpdate", ProtocolUtil.getbit(en_data, 30, 31));
                enableControl.put("agps", ProtocolUtil.getbit(en_data, 31, 32));
                keyValue = new KeyValue("enableControl", enableControl);
                break;
            }
            case 117: {
                long ex_data = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                HashMap<String, Number> extraControl = new HashMap<String, Number>();
                extraControl.put("flagValue", ex_data);
                for (int i = 0; i < 32; ++i) {
                    extraControl.put("bit" + i, ProtocolUtil.getbit(ex_data, i, i + 1));
                }
                keyValue = new KeyValue("extraControl", extraControl);
                break;
            }
            case 16: {
                int ringToneVolume = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("ringToneVolume", ringToneVolume);
                break;
            }
            case 17: {
                int micVolume = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("micVolume", micVolume);
                break;
            }
            case 18: {
                int speakerVolume = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("speakerVolume", speakerVolume);
                break;
            }
            case 28: {
                int promptVolume = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("promptVolume", promptVolume);
                break;
            }
            case 29: {
                int agpsStatus = ProtocolUtil.getbit(cmdValue[0], 7, 8);
                double agps_lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 1, 5));
                double agps_lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 5, 9));
                HashMap<String, Number> agpsLocMap = new HashMap<String, Number>();
                agpsLocMap.put("status", agpsStatus);
                agpsLocMap.put("lat", agps_lat);
                agpsLocMap.put("lng", agps_lng);
                keyValue = new KeyValue("agpsLoc", agpsLocMap);
                break;
            }
            case 19: {
                String deviceName = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("deviceName", deviceName);
                break;
            }
            case 20: {
                int battery = cmdValue[0] & 0xFF;
                int voltage = cmdValue[1] & 0xFF | (cmdValue[2] & 0xFF) << 8;
                HashMap<String, Integer> batteryMap = new HashMap<String, Integer>();
                batteryMap.put("battery", battery);
                batteryMap.put("voltage", voltage);
                keyValue = new KeyValue("battery", batteryMap);
                break;
            }
            case 21: {
                double ble_lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 0, 4));
                double ble_lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 4, 8));
                cmdValue = Arrays.copyOfRange(cmdValue, 8, cmdValue.length);
                String describe = BytesHexStrUtil.bytes2StringByUTF_8(cmdValue);
                describe = describe.replace("\u0000", "");
                HashMap<String, Object> bleLocMap = new HashMap<String, Object>();
                bleLocMap.put("lat", ble_lat);
                bleLocMap.put("lng", ble_lng);
                bleLocMap.put("describe", describe);
                keyValue = new KeyValue("bleLoc", bleLocMap);
                break;
            }
            case 22: {
                int bwl_flag = cmdValue[0] & 0xFF;
                int bwl_enable = ProtocolUtil.getbit(bwl_flag, 7, 8);
                int bwl_index = ProtocolUtil.getbit(bwl_flag, 0, 7);
                cmdValue = Arrays.copyOfRange(cmdValue, 1, cmdValue.length);
                String bwl_mac = ProtocolUtil.bytes2Mac(cmdValue, false);
                HashMap<String, Object> bleWhiteList = new HashMap<String, Object>();
                bleWhiteList.put("index", bwl_index);
                bleWhiteList.put("enable", bwl_enable);
                bleWhiteList.put("mac", bwl_mac);
                keyValue = new KeyValue("bleWhiteList", bleWhiteList);
                break;
            }
            case 23: {
                String sms_gpsurl = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("smsgpsurl", sms_gpsurl);
                break;
            }
            case 24: {
                String sms_wifiUrl = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("smswifiurl", sms_wifiUrl);
                break;
            }
            case 25: {
                long musicValue = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                HashMap<String, Number> musicMap = new HashMap<String, Number>(34);
                musicMap.put("flagValue", musicValue);
                for (int i = 0; i < 32; ++i) {
                    musicMap.put("bit" + i, ProtocolUtil.getbit(musicValue, i, i + 1));
                }
                keyValue = new KeyValue("music", musicMap);
                break;
            }
            case 118: {
                long musicValueExtend = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                HashMap<String, Number> musicExtendMap = new HashMap<String, Number>();
                musicExtendMap.put("flagValue", musicValueExtend);
                for (int i = 0; i < 32; ++i) {
                    musicExtendMap.put("bit" + i, ProtocolUtil.getbit(musicValueExtend, i, i + 1));
                }
                keyValue = new KeyValue("musicExtend", musicExtendMap);
                break;
            }
            case 26: {
                String fwVersion = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("fwVersion", fwVersion);
                break;
            }
            case 27: {
                String gsmModule = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("gsmModule", gsmModule);
                break;
            }
            case 31: {
                String locale = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("locale", locale);
                break;
            }
            case 32: {
                int sosButtonData = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8;
                HashMap<String, Integer> sosButton = new HashMap<String, Integer>();
                sosButton.put("status", ProtocolUtil.getbit(sosButtonData, 15, 16));
                sosButton.put("mode", ProtocolUtil.getbit(sosButtonData, 13, 14));
                sosButton.put("task", ProtocolUtil.getbit(sosButtonData, 9, 13));
                sosButton.put("time", ProtocolUtil.getbit(sosButtonData, 2, 9));
                sosButton.put("feedBack", ProtocolUtil.getbit(sosButtonData, 0, 2));
                keyValue = new KeyValue("sosButton", sosButton);
                break;
            }
            case 33: {
                int call1ButtonData = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8;
                HashMap<String, Integer> call1Button = new HashMap<String, Integer>();
                call1Button.put("status", ProtocolUtil.getbit(call1ButtonData, 15, 16));
                call1Button.put("mode", ProtocolUtil.getbit(call1ButtonData, 13, 14));
                call1Button.put("task", ProtocolUtil.getbit(call1ButtonData, 9, 13));
                call1Button.put("time", ProtocolUtil.getbit(call1ButtonData, 2, 9));
                call1Button.put("feedBack", ProtocolUtil.getbit(call1ButtonData, 0, 2));
                keyValue = new KeyValue("call1Button", call1Button);
                break;
            }
            case 34: {
                int call2ButtonData = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8;
                HashMap<String, Integer> call2Button = new HashMap<String, Integer>();
                call2Button.put("status", ProtocolUtil.getbit(call2ButtonData, 15, 16));
                call2Button.put("mode", ProtocolUtil.getbit(call2ButtonData, 13, 14));
                call2Button.put("task", ProtocolUtil.getbit(call2ButtonData, 9, 13));
                call2Button.put("time", ProtocolUtil.getbit(call2ButtonData, 2, 9));
                call2Button.put("feedBack", ProtocolUtil.getbit(call2ButtonData, 0, 2));
                keyValue = new KeyValue("call2Button", call2Button);
                break;
            }
            case 35: {
                int funButtonData = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8;
                HashMap<String, Integer> funButton = new HashMap<String, Integer>(4);
                funButton.put("status", ProtocolUtil.getbit(funButtonData, 15, 16));
                funButton.put("mode", ProtocolUtil.getbit(funButtonData, 13, 14));
                funButton.put("task", ProtocolUtil.getbit(funButtonData, 9, 13));
                funButton.put("time", ProtocolUtil.getbit(funButtonData, 2, 9));
                keyValue = new KeyValue("funButton", funButton);
                break;
            }
            case 48: {
                int n_flag = cmdValue[0] & 0xFF;
                int number_index = ProtocolUtil.getbit(n_flag, 0, 4);
                byte[] numberBytes = Arrays.copyOfRange(cmdValue, 1, cmdValue.length);
                String number = BytesHexStrUtil.bytes2StringByASCII(numberBytes);
                HashMap<String, Object> number_data = new HashMap<String, Object>();
                number_data.put("index", number_index);
                number_data.put("enable", ProtocolUtil.getbit(n_flag, 7, 8));
                number_data.put("sms", ProtocolUtil.getbit(n_flag, 6, 7));
                number_data.put("call", ProtocolUtil.getbit(n_flag, 5, 6));
                number_data.put("noCard", ProtocolUtil.getbit(n_flag, 4, 5));
                number_data.put("number", number);
                keyValue = new KeyValue("number", number_data);
                break;
            }
            case 49: {
                int SMSPrefixStatus = ProtocolUtil.getbit(cmdValue[0], 7, 8);
                cmdValue = Arrays.copyOfRange(cmdValue, 1, cmdValue.length);
                String SMSPrefixText = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                HashMap<String, Object> smsOption = new HashMap<String, Object>();
                smsOption.put("status", SMSPrefixStatus);
                smsOption.put("prefix", SMSPrefixText);
                keyValue = new KeyValue("smsOption", smsOption);
                break;
            }
            case 50: {
                int holdTime = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8;
                int ringsTime = cmdValue[2] & 0xFF;
                int loops = cmdValue[3] & 0xFF;
                HashMap<String, Integer> sosOption = new HashMap<String, Integer>();
                sosOption.put("holdTime", holdTime);
                sosOption.put("ringsTime", ringsTime);
                sosOption.put("loops", loops);
                keyValue = new KeyValue("sosOption", sosOption);
                break;
            }
            case 51: {
                long phoneOptionValue = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8 | (cmdValue[2] & 0xFF) << 16 | (cmdValue[3] & 0xFF) << 24;
                HashMap<String, Number> phoneOption = new HashMap<String, Number>();
                phoneOption.put("flag_value", phoneOptionValue);
                phoneOption.put("rings", ProtocolUtil.getbit(phoneOptionValue, 0, 7));
                phoneOption.put("s1", ProtocolUtil.getbit(phoneOptionValue, 7, 8));
                phoneOption.put("s2", ProtocolUtil.getbit(phoneOptionValue, 8, 9));
                phoneOption.put("s3", ProtocolUtil.getbit(phoneOptionValue, 9, 10));
                phoneOption.put("s4", ProtocolUtil.getbit(phoneOptionValue, 10, 11));
                phoneOption.put("s5", ProtocolUtil.getbit(phoneOptionValue, 11, 12));
                phoneOption.put("s6", ProtocolUtil.getbit(phoneOptionValue, 14, 15));
                phoneOption.put("s7", ProtocolUtil.getbit(phoneOptionValue, 15, 16));
                phoneOption.put("callIncoming", ProtocolUtil.getbit(phoneOptionValue, 16, 18));
                phoneOption.put("toneID", ProtocolUtil.getbit(phoneOptionValue, 28, 32));
                keyValue = new KeyValue("phoneOption", phoneOption);
                break;
            }
            case 52: {
                int numberNamePhoto_flag = cmdValue[0] & 0xFF;
                int l_number = cmdValue[1] & 0xFF;
                byte[] number2Bytes = Arrays.copyOfRange(cmdValue, 2, l_number + 2);
                String number2 = BytesHexStrUtil.bytes2StringByASCII(number2Bytes);
                int l_name = cmdValue[l_number + 2] & 0xFF;
                byte[] nameBytes = Arrays.copyOfRange(cmdValue, l_number + 3, l_number + l_name + 3);
                String numberName = BytesHexStrUtil.bytes2StringByUTF_8(nameBytes);
                int l_photo = cmdValue[l_number + l_name + 3] & 0xFF;
                byte[] photoBytes = Arrays.copyOfRange(cmdValue, l_number + l_name + 4, l_number + l_name + l_photo + 4);
                String photoURL = BytesHexStrUtil.bytes2StringByASCII(photoBytes);
                int numberPhoto_index = ProtocolUtil.getbit(numberNamePhoto_flag, 0, 4);
                HashMap<String, Object> number2_data = new HashMap<String, Object>();
                number2_data.put("index", numberPhoto_index);
                number2_data.put("enable", ProtocolUtil.getbit(numberNamePhoto_flag, 7, 8));
                number2_data.put("sms", ProtocolUtil.getbit(numberNamePhoto_flag, 6, 7));
                number2_data.put("call", ProtocolUtil.getbit(numberNamePhoto_flag, 5, 6));
                number2_data.put("noCard", ProtocolUtil.getbit(numberNamePhoto_flag, 4, 5));
                number2_data.put("number", number2);
                number2_data.put("name", numberName);
                number2_data.put("headURL", photoURL);
                keyValue = new KeyValue("numberNamePhoto", number2_data);
                break;
            }
            case 53: {
                int nameLength = cmdValue[0] & 0xFF;
                int urlLength = cmdValue[1] & 0xFF;
                int headURLLength = cmdValue[2] & 0xFF;
                int height = cmdValue[3] & 0xFF;
                int weight = cmdValue[4] & 0xFF;
                int sex = ProtocolUtil.getbit(cmdValue[5] & 0xFF, 6, 8);
                int bloodType = ProtocolUtil.getbit(cmdValue[5] & 0xFF, 0, 5);
                Date birthday = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(cmdValue, 6, 10), true);
                String name = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 10, 10 + nameLength));
                String url = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 10 + nameLength, 10 + nameLength + urlLength));
                String headURL = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 10 + nameLength + urlLength, 10 + nameLength + urlLength + headURLLength));
                HashMap<String, Object> personalInfo = new HashMap<String, Object>();
                personalInfo.put("height", height);
                personalInfo.put("weight", weight);
                personalInfo.put("sex", sex);
                personalInfo.put("bloodType", bloodType);
                personalInfo.put("birthday", birthday);
                personalInfo.put("name", name);
                personalInfo.put("url", url);
                personalInfo.put("headURL", headURL);
                keyValue = new KeyValue("personalInfo", personalInfo);
                break;
            }
            case 54: {
                int i;
                int watchFaceId = cmdValue[0] & 0xFF;
                long watchStatus = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 1, 5));
                long watchMenu = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 5, 9));
                long watchAutoTime = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 9, 13));
                HashMap<String, Number> watch = new HashMap<String, Number>();
                watch.put("faceId", watchFaceId);
                watch.put("flagValue", watchStatus);
                watch.put("status0", ProtocolUtil.getbit(watchStatus, 0, 1));
                watch.put("status1", ProtocolUtil.getbit(watchStatus, 1, 2));
                watch.put("status2", ProtocolUtil.getbit(watchStatus, 2, 3));
                watch.put("status3", ProtocolUtil.getbit(watchStatus, 3, 4));
                for (i = 8; i < 18; ++i) {
                    watch.put("status" + i, ProtocolUtil.getbit(watchStatus, i, i + 1));
                }
                for (i = 0; i < 8; ++i) {
                    watch.put("menu" + (i + 1), ProtocolUtil.getbit(watchMenu, i + 1, i + 2));
                }
                watch.put("autoTime", watchAutoTime);
                keyValue = new KeyValue("watch", watch);
                if (cmdValue.length < 16) break;
                int bright_ness = cmdValue[13] & 0xFF;
                int bright_time = cmdValue[14] & 0xFF;
                int logo_index = cmdValue[15] & 0xFF;
                watch.put("brightNess", bright_ness);
                watch.put("brightTime", bright_time);
                watch.put("logoIndex", logo_index);
                break;
            }
            case 64: {
                String apn = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("apn", apn);
                break;
            }
            case 65: {
                String apnUserName = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("apnUserName", apnUserName);
                break;
            }
            case 66: {
                String apnPassword = BytesHexStrUtil.bytes2StringByASCII(cmdValue);
                keyValue = new KeyValue("apnPassword", apnPassword);
                break;
            }
            case 67: {
                int severPort = cmdValue[1] & 0xFF | (cmdValue[2] & 0xFF) << 8;
                byte[] ipBytes = Arrays.copyOfRange(cmdValue, 3, cmdValue.length);
                String severIP = BytesHexStrUtil.bytes2StringByASCII(ipBytes);
                HashMap<String, Object> sever = new HashMap<String, Object>();
                sever.put("status", ProtocolUtil.getbit(cmdValue[0], 7, 8));
                sever.put("type", ProtocolUtil.getbit(cmdValue[0], 0, 1));
                sever.put("port", severPort);
                sever.put("ip", severIP);
                keyValue = new KeyValue("sever", sever);
                break;
            }
            case 68: {
                int heartbeat = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8 | (cmdValue[2] & 0xFF) << 16 | (cmdValue[3] & 0x7F) << 23;
                int upload = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 4, 8));
                int uploadLazy = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 8, 12));
                HashMap<String, Integer> timeInterval = new HashMap<String, Integer>();
                timeInterval.put("heartBeatStatus", ProtocolUtil.getbit(cmdValue[3], 7, 8));
                timeInterval.put("heartBeat", heartbeat);
                timeInterval.put("upload", upload);
                timeInterval.put("uploadLazy", uploadLazy);
                keyValue = new KeyValue("timeInterval", timeInterval);
                break;
            }
            case 69: {
                int locate_interval = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8;
                int locate_time = cmdValue[2] & 0xFF | (cmdValue[3] & 0xFF) << 8;
                HashMap<String, Integer> continueLocate = new HashMap<String, Integer>();
                continueLocate.put("interval", locate_interval);
                continueLocate.put("time", locate_time);
                keyValue = new KeyValue("continueLocate", continueLocate);
                break;
            }
            case 70: {
                long heartRateInterval = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8 | (cmdValue[2] & 0xFF) << 16 | (cmdValue[3] & 0x7F) << 24;
                HashMap<String, Number> heartRate = new HashMap<String, Number>();
                heartRate.put("status", ProtocolUtil.getbit(cmdValue[3], 7, 8));
                heartRate.put("interval", heartRateInterval);
                keyValue = new KeyValue("heartRate", heartRate);
                break;
            }
            case 71: {
                String deviceID = BytesHexStrUtil.bytes2StringByUTF_8(cmdValue);
                keyValue = new KeyValue("customizedID", deviceID);
                break;
            }
            case 72: {
                long keyID = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                String aesKey = BytesHexStrUtil.bytesToHexString(Arrays.copyOfRange(cmdValue, 4, 20));
                String aesIV = BytesHexStrUtil.bytesToHexString(Arrays.copyOfRange(cmdValue, 20, 36));
                HashMap<String, Object> aesKeyObj = new HashMap<String, Object>(3);
                aesKeyObj.put("id", ProtocolUtil.getbit(keyID, 0, 24));
                aesKeyObj.put("type", ProtocolUtil.getbit(keyID, 24, 32));
                aesKeyObj.put("aesKey", aesKey);
                aesKeyObj.put("aesIV", aesIV);
                keyValue = new KeyValue("aesKey", aesKeyObj);
                break;
            }
            case 73: {
                long aesKeyID = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                String aesCRC = BytesHexStrUtil.bytesToHexString(Arrays.copyOfRange(cmdValue, 4, 8));
                HashMap<String, Object> aesCRCObj = new HashMap<String, Object>(2);
                aesCRCObj.put("id", ProtocolUtil.getbit(aesKeyID, 0, 24));
                aesCRCObj.put("type", ProtocolUtil.getbit(aesKeyID, 24, 32));
                aesCRCObj.put("aesCRC", aesCRC);
                keyValue = new KeyValue("aesCRC", aesCRCObj);
                break;
            }
            case 74: {
                int wifi_flag = cmdValue[0] & 0xFF;
                int name_len = cmdValue[1] & 0xFF;
                int password_len = cmdValue[2] & 0xFF;
                byte[] nameByte = Arrays.copyOfRange(cmdValue, 3, name_len + 3);
                byte[] passwordByte = Arrays.copyOfRange(cmdValue, name_len + 3, name_len + password_len + 3);
                String wifi_name = BytesHexStrUtil.bytes2StringByUTF_8(nameByte);
                String wifi_password = BytesHexStrUtil.bytes2StringByUTF_8(passwordByte);
                HashMap<String, Object> wifiList = new HashMap<String, Object>();
                int wifi_index = ProtocolUtil.getbit(wifi_flag, 0, 6);
                wifiList.put("index", wifi_index);
                wifiList.put("enable", ProtocolUtil.getbit(wifi_flag, 7, 8));
                wifiList.put("isConnected", ProtocolUtil.getbit(wifi_flag, 6, 7));
                wifiList.put("name", wifi_name);
                wifiList.put("password", wifi_password);
                keyValue = new KeyValue("wifiList", wifiList);
                break;
            }
            case 75: {
                int iotMode = cmdValue[0] & 0xFF;
                int eMTC = cmdValue[1] & 0xFF;
                int eMTC_value = cmdValue[2] & 0xFF;
                int NBIOT = cmdValue[3] & 0xFF;
                int NBIOT_value = cmdValue[4] & 0xFF;
                HashMap<String, Number> catm = new HashMap<String, Number>();
                catm.put("iotMode", iotMode);
                catm.put("emtc", eMTC);
                catm.put("emtcValue", eMTC_value);
                catm.put("nbiot", NBIOT);
                catm.put("nbiotValue", NBIOT_value);
                if (cmdValue.length >= 28) {
                    long GSM = cmdValue[5] & 0xFF;
                    byte[] catm_eMTBand = Arrays.copyOfRange(cmdValue, 6, 18);
                    byte[] catm_NBBand = Arrays.copyOfRange(cmdValue, 18, 30);
                    catm.put("gsm", GSM);
                    catm.put("eMTBand", ProtocolUtil.bytes2Long(catm_eMTBand));
                    catm.put("nbBand", ProtocolUtil.bytes2Long(catm_NBBand));
                }
                keyValue = new KeyValue("catm", catm);
                break;
            }
            case 76: {
                long apnList_index = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 2));
                int apnList_plmn = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 2, 5));
                int apnLength = cmdValue[5] & 0xFF;
                int usernameLength = cmdValue[6] & 0xFF;
                int passwordLength = cmdValue[7] & 0xFF;
                String apnList_apn = BytesHexStrUtil.bytes2StringByASCII(Arrays.copyOfRange(cmdValue, 8, 8 + apnLength));
                String apnList_username = BytesHexStrUtil.bytes2StringByASCII(Arrays.copyOfRange(cmdValue, 8 + apnLength, 8 + apnLength + usernameLength));
                String apnList_password = BytesHexStrUtil.bytes2StringByASCII(Arrays.copyOfRange(cmdValue, 8 + apnLength + usernameLength, 8 + apnLength + usernameLength + passwordLength));
                HashMap<String, Object> apnList = new HashMap<String, Object>();
                apnList.put("index", apnList_index);
                apnList.put("apn", apnList_apn);
                apnList.put("username", apnList_username);
                apnList.put("password", apnList_password);
                apnList.put("plmn", apnList_plmn);
                keyValue = new KeyValue("apnList", apnList);
                break;
            }
            case 77: {
                int apnNow_plmn = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 3));
                int apnNowLength = cmdValue[3] & 0xFF;
                int apnNowusernameLength = cmdValue[4] & 0xFF;
                int apnNowpasswordLength = cmdValue[5] & 0xFF;
                String apnNow_apn = BytesHexStrUtil.bytes2StringByASCII(Arrays.copyOfRange(cmdValue, 6, 6 + apnNowLength));
                String apnNow_username = BytesHexStrUtil.bytes2StringByASCII(Arrays.copyOfRange(cmdValue, 6 + apnNowLength, 6 + apnNowLength + apnNowusernameLength));
                String apnNow_password = BytesHexStrUtil.bytes2StringByASCII(Arrays.copyOfRange(cmdValue, 6 + apnNowLength + apnNowusernameLength, 6 + apnNowLength + apnNowusernameLength + apnNowpasswordLength));
                HashMap<String, Object> apnNow = new HashMap<String, Object>();
                apnNow.put("apn", apnNow_apn);
                apnNow.put("username", apnNow_username);
                apnNow.put("password", apnNow_password);
                apnNow.put("plmn", apnNow_plmn);
                keyValue = new KeyValue("apnNow", apnNow);
                break;
            }
            case 78: {
                int gsmBand_value = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("gsmBand", gsmBand_value);
                break;
            }
            case 79: {
                int networkType_value = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("networkType", networkType_value);
                break;
            }
            case 80: {
                int powerLow = cmdValue[0] & 0xFF;
                int voiceLow = cmdValue[1] & 0xFF;
                HashMap<String, Integer> powerLowAlert = new HashMap<String, Integer>();
                powerLowAlert.put("powerOFF", ProtocolUtil.getbit(cmdValue[3], 7, 8));
                powerLowAlert.put("powerON", ProtocolUtil.getbit(cmdValue[3], 6, 7));
                powerLowAlert.put("status", ProtocolUtil.getbit(cmdValue[3], 5, 6));
                powerLowAlert.put("voiceStatus", ProtocolUtil.getbit(cmdValue[3], 4, 5));
                powerLowAlert.put("powerOFFSMS", ProtocolUtil.getbit(cmdValue[3], 3, 4));
                powerLowAlert.put("powerONSMS", ProtocolUtil.getbit(cmdValue[3], 2, 3));
                powerLowAlert.put("powerOFFLoc", ProtocolUtil.getbit(cmdValue[3], 1, 2));
                powerLowAlert.put("power", powerLow);
                powerLowAlert.put("voice", voiceLow);
                keyValue = new KeyValue("powerLowAlert", powerLowAlert);
                break;
            }
            case 81: {
                long geo_flag = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                ArrayList latlngs = new ArrayList();
                int readData = 4;
                while (readData + 8 < cmdLength) {
                    HashMap<String, Double> latlng = new HashMap<String, Double>();
                    double geo_lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, readData, readData + 4));
                    double geo_lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, readData + 4, readData + 8));
                    latlng.put("lat", geo_lat);
                    latlng.put("lng", geo_lng);
                    latlngs.add(latlng);
                    readData += 8;
                }
                HashMap<String, Serializable> geoAlert = new HashMap<String, Serializable>();
                int geo_index = ProtocolUtil.getbit(geo_flag, 0, 4);
                geoAlert.put("index", Integer.valueOf(geo_index));
                geoAlert.put("points", Integer.valueOf(ProtocolUtil.getbit(geo_flag, 4, 8)));
                geoAlert.put("status", Integer.valueOf(ProtocolUtil.getbit(geo_flag, 8, 9)));
                geoAlert.put("direction", Integer.valueOf(ProtocolUtil.getbit(geo_flag, 9, 10)));
                geoAlert.put("type", Integer.valueOf(ProtocolUtil.getbit(geo_flag, 10, 11)));
                geoAlert.put("radius", Integer.valueOf(ProtocolUtil.getbit(geo_flag, 16, 32)));
                geoAlert.put("latlng", latlngs);
                keyValue = new KeyValue("geoAlert", geoAlert);
                break;
            }
            case 82: {
                int staticTime = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8;
                int moveTime = cmdValue[2] & 0xFF | (cmdValue[3] & 0x3F) << 8;
                HashMap<String, Integer> motionAlert = new HashMap<String, Integer>();
                motionAlert.put("staticTime", staticTime);
                motionAlert.put("moveTime", moveTime);
                motionAlert.put("status", ProtocolUtil.getbit(cmdValue[3], 7, 8));
                motionAlert.put("dial", ProtocolUtil.getbit(cmdValue[3], 6, 7));
                keyValue = new KeyValue("motionAlert", motionAlert);
                break;
            }
            case 83: {
                int noMotionValue = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8 | (cmdValue[2] & 0xFF) << 16 | (cmdValue[3] & 0x3F) << 24;
                HashMap<String, Integer> noMotionAlert = new HashMap<String, Integer>();
                noMotionAlert.put("time", noMotionValue);
                noMotionAlert.put("status", ProtocolUtil.getbit(cmdValue[3], 7, 8));
                noMotionAlert.put("dial", ProtocolUtil.getbit(cmdValue[3], 6, 7));
                keyValue = new KeyValue("noMotionAlert", noMotionAlert);
                break;
            }
            case 84: {
                int overSpeedValue = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 2));
                HashMap<String, Integer> overSpeedAlert = new HashMap<String, Integer>();
                overSpeedAlert.put("speed", ProtocolUtil.getbit(overSpeedValue, 0, 15));
                overSpeedAlert.put("status", ProtocolUtil.getbit(overSpeedValue, 15, 16));
                keyValue = new KeyValue("overSpeedAlert", overSpeedAlert);
                break;
            }
            case 85: {
                int tiltTime = cmdValue[0] & 0xFF | (cmdValue[1] & 0xFF) << 8;
                int tiltAngle = cmdValue[2] & 0xFF;
                HashMap<String, Integer> tiltAlert = new HashMap<String, Integer>();
                tiltAlert.put("time", tiltTime);
                tiltAlert.put("angle", tiltAngle);
                tiltAlert.put("status", ProtocolUtil.getbit(cmdValue[3], 7, 8));
                tiltAlert.put("dial", ProtocolUtil.getbit(cmdValue[3], 6, 7));
                keyValue = new KeyValue("tiltAlert", tiltAlert);
                break;
            }
            case 86: {
                HashMap<String, Integer> fallDownAlert = new HashMap<String, Integer>();
                fallDownAlert.put("level", ProtocolUtil.getbit(cmdValue[0], 0, 4));
                fallDownAlert.put("allwayOn", ProtocolUtil.getbit(cmdValue[0], 5, 6));
                fallDownAlert.put("dial", ProtocolUtil.getbit(cmdValue[0], 6, 7));
                fallDownAlert.put("status", ProtocolUtil.getbit(cmdValue[0], 7, 8));
                keyValue = new KeyValue("fallDownAlert", fallDownAlert);
                break;
            }
            case 87: {
                long welfare = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                HashMap<String, Integer> welfareAlert = new HashMap<String, Integer>();
                welfareAlert.put("status", ProtocolUtil.getbit(welfare, 31, 32));
                welfareAlert.put("value", ProtocolUtil.getbit(welfare, 0, 31));
                if (cmdValue.length >= 8) {
                    long welfareTime = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 4, 8));
                    welfareAlert.put("time", ProtocolUtil.getbit(welfareTime, 0, 31));
                    welfareAlert.put("dial", ProtocolUtil.getbit(welfareTime, 31, 32));
                }
                keyValue = new KeyValue("welfareAlert", welfareAlert);
                break;
            }
            case 88: {
                long notification_customerID = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 1, 5));
                long notification_centreID = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 5, 9));
                String notification_url = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 9, cmdValue.length));
                HashMap<String, Object> alertNotification = new HashMap<String, Object>();
                alertNotification.put("customerID", (int)notification_customerID);
                alertNotification.put("centreID", (int)notification_centreID);
                alertNotification.put("url", notification_url);
                alertNotification.put("status", ProtocolUtil.getbit(cmdValue[0], 7, 8));
                keyValue = new KeyValue("notificationAlert", alertNotification);
                break;
            }
            case 89: {
                int motionLevel = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("motionLevel", motionLevel);
                break;
            }
            case 90: {
                long geoDetectValue = ProtocolUtil.bytes2Long(cmdValue);
                HashMap<String, Integer> geoDetect = new HashMap<String, Integer>();
                geoDetect.put("status", ProtocolUtil.getbit(geoDetectValue, 31, 32));
                geoDetect.put("time", ProtocolUtil.getbit(geoDetectValue, 0, 31));
                keyValue = new KeyValue("geoDetect", geoDetect);
                break;
            }
            case 91: {
                long stepCollectValue = ProtocolUtil.bytes2Long(cmdValue);
                HashMap<String, Integer> stepCollect = new HashMap<String, Integer>();
                stepCollect.put("status", ProtocolUtil.getbit(stepCollectValue, 31, 32));
                stepCollect.put("time", ProtocolUtil.getbit(stepCollectValue, 0, 31));
                keyValue = new KeyValue("stepCollect", stepCollect);
                break;
            }
            case 92: {
                int dogBarking_flag = cmdValue[0] & 0xFF;
                long barking_time = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 1, 5));
                HashMap<String, Number> barking = new HashMap<String, Number>(3);
                barking.put("status", ProtocolUtil.getbit(dogBarking_flag, 7, 8));
                barking.put("level", ProtocolUtil.getbit(dogBarking_flag, 0, 7));
                barking.put("time", barking_time);
                keyValue = new KeyValue("dogBarking", barking);
                break;
            }
            case 93: {
                int level_NoMotion = cmdValue[0] & 0xFF;
                HashMap<String, Integer> alertLevel = new HashMap<String, Integer>(1);
                alertLevel.put("noMotion", level_NoMotion);
                keyValue = new KeyValue("alertLevel", alertLevel);
                break;
            }
            case 94: {
                int sideButton_flag = cmdValue[0] & 0xFF;
                HashMap<String, Integer> sideButton = new HashMap<String, Integer>(3);
                sideButton.put("status", ProtocolUtil.getbit(sideButton_flag, 7, 8));
                sideButton.put("dial", ProtocolUtil.getbit(sideButton_flag, 6, 7));
                sideButton.put("sms", ProtocolUtil.getbit(sideButton_flag, 5, 6));
                keyValue = new KeyValue("sideButton", sideButton);
                break;
            }
            case 95: {
                long homeDetectValue = ProtocolUtil.bytes2Long(cmdValue);
                HashMap<String, Integer> homeDetect = new HashMap<String, Integer>();
                homeDetect.put("status", ProtocolUtil.getbit(homeDetectValue, 31, 32));
                homeDetect.put("time", ProtocolUtil.getbit(homeDetectValue, 0, 31));
                keyValue = new KeyValue("homeDetect", homeDetect);
                break;
            }
            case 98: {
                void wifiWhiteList;
                int wifiList_flag = cmdValue[0] & 0xFF;
                int wifiList_enable = ProtocolUtil.getbit(wifiList_flag, 7, 8);
                int wifiList_index = ProtocolUtil.getbit(wifiList_flag, 0, 7);
                String wifiList_mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(cmdValue, 1, 7), false);
                HashMap hashMap = new HashMap();
                wifiWhiteList.put("index", wifiList_index);
                wifiWhiteList.put("enable", wifiList_enable);
                wifiWhiteList.put("mac", wifiList_mac);
                if (cmdValue.length > 7) {
                    void wifiList_lng;
                    void wifiList_lat;
                    double d = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 7, 11));
                    double d2 = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 11, 15));
                    wifiWhiteList.put("lat", (double)wifiList_lat);
                    wifiWhiteList.put("lng", (double)wifiList_lng);
                }
                if (cmdValue.length > 15) {
                    void wifiList_describe;
                    String wifiList_lat = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 15, cmdValue.length));
                    wifiWhiteList.put("describe", wifiList_describe);
                }
                keyValue = new KeyValue("wifiWhiteList", wifiWhiteList);
                break;
            }
            case 99: {
                void nightMode_to;
                void nightMode_from;
                void nightMode;
                String wifiList_describe = String.format("%02d", cmdValue[1] & 0xFF) + ":" + String.format("%02d", cmdValue[2] & 0xFF);
                String string = String.format("%02d", cmdValue[3] & 0xFF) + ":" + String.format("%02d", cmdValue[4] & 0xFF);
                HashMap wifiList_lng = new HashMap();
                nightMode.put("status", ProtocolUtil.getbit(cmdValue[0], 7, 8));
                nightMode.put("from", nightMode_from);
                nightMode.put("to", nightMode_to);
                keyValue = new KeyValue("nightMode", nightMode);
                break;
            }
            case 100: {
                void networkName;
                void networkBand;
                void networkStrength;
                void network;
                int n = cmdValue[0] & 0xFF;
                long l = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 1, 5));
                String string = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 5, cmdValue.length));
                HashMap hashMap = new HashMap();
                network.put("strength", (int)networkStrength);
                network.put("band", (long)networkBand);
                network.put("name", networkName);
                keyValue = new KeyValue("network", network);
                break;
            }
            case 102: {
                void IMSI;
                String string = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 0, cmdValue.length));
                keyValue = new KeyValue("IMSI", IMSI);
                break;
            }
            case 103: {
                void matched;
                void homeWifiMatch;
                HashMap hashMap = new HashMap();
                int n = cmdValue[0] & 0xFF;
                homeWifiMatch.put("matched", (int)matched);
                if (cmdValue.length > 1) {
                    void noMatched;
                    int n2 = cmdValue[1] & 0xFF;
                    homeWifiMatch.put("noMatched", (int)noMatched);
                }
                keyValue = new KeyValue("homeWifiMatch", homeWifiMatch);
                break;
            }
            case 105: {
                void CLIR;
                int noMatched = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("CLIR", (int)CLIR);
                break;
            }
            case 106: {
                void weather;
                void weatherMap;
                long l = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                HashMap hashMap = new HashMap();
                weatherMap.put("status", ProtocolUtil.getbit((long)weather, 31, 32));
                weatherMap.put("time1", ProtocolUtil.getbit((long)weather, 0, 31));
                weatherMap.put("time2", ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 4, 8)));
                keyValue = new KeyValue("weather", weatherMap);
                break;
            }
            case 115: {
                void beacon_enable;
                void beacon_index;
                void beaconList;
                String beacon_describe;
                double beacon_lng;
                double beacon_lat;
                String beacon_mac;
                void beacon_flag;
                int n = cmdValue[0] & 0xFF;
                int n3 = ProtocolUtil.getbit((long)beacon_flag, 7, 8);
                int n4 = ProtocolUtil.getbit((long)beacon_flag, 0, 7);
                String string = "";
                if (cmdValue.length > 1) {
                    beacon_mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(cmdValue, 1, 7), false);
                }
                double d = 0.0;
                double d3 = 0.0;
                if (cmdValue.length > 7) {
                    beacon_lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 7, 11));
                    beacon_lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(cmdValue, 11, 15));
                }
                String string2 = "";
                if (cmdValue.length > 15) {
                    beacon_describe = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 15, cmdValue.length));
                }
                HashMap hashMap = new HashMap();
                beaconList.put("index", (int)beacon_index);
                beaconList.put("enable", (int)beacon_enable);
                beaconList.put("mac", beacon_mac);
                beaconList.put("lat", beacon_lat);
                beaconList.put("lng", beacon_lng);
                beaconList.put("describe", beacon_describe);
                keyValue = new KeyValue("beaconList", beaconList);
                break;
            }
            case 116: {
                void findMe_flag;
                void findMeMap;
                long l = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                HashMap hashMap = new HashMap(3);
                findMeMap.put("times", ProtocolUtil.getbit((long)findMe_flag, 0, 8));
                findMeMap.put("playIndex", ProtocolUtil.getbit((long)findMe_flag, 8, 16));
                findMeMap.put("sound", ProtocolUtil.getbit((long)findMe_flag, 16, 24));
                keyValue = new KeyValue("findMe", findMeMap);
                break;
            }
            case 119: {
                void runStep;
                void runStepMap;
                long l = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                HashMap hashMap = new HashMap(4);
                runStepMap.put("status", ProtocolUtil.getbit((long)runStep, 16, 17));
                runStepMap.put("time", ProtocolUtil.getbit((long)runStep, 0, 8));
                runStepMap.put("count", ProtocolUtil.getbit((long)runStep, 8, 16));
                runStepMap.put("call", ProtocolUtil.getbit((long)runStep, 17, 18));
                keyValue = new KeyValue("runStepAlert", runStepMap);
                break;
            }
            case 120: {
                void deviceState;
                byte by = cmdValue[0];
                keyValue = new KeyValue("deviceState", (int)deviceState);
                break;
            }
            case 121: {
                void fallDownTime;
                long l = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 2));
                keyValue = new KeyValue("fallDownTime", (long)fallDownTime);
                break;
            }
            case 122: {
                void spo2Interval;
                void spo2Detect;
                long l = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 4));
                HashMap hashMap = new HashMap();
                spo2Detect.put("status", ProtocolUtil.getbit((long)spo2Interval, 31, 32));
                spo2Detect.put("interval", ProtocolUtil.getbit((long)spo2Interval, 0, 31));
                keyValue = new KeyValue("spo2Interval", spo2Detect);
                break;
            }
            case 124: {
                void preAlertTime;
                void motionAlertExt;
                long l = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 0, 2));
                HashMap hashMap = new HashMap();
                motionAlertExt.put("preAlertTime", (long)preAlertTime);
                keyValue = new KeyValue("motionAlertExt", motionAlertExt);
                break;
            }
            case 125: {
                void voiceTime;
                int n = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("sosAlertExt", (int)voiceTime);
                break;
            }
            case 126: {
                void voiceInterval;
                int n = cmdValue[0] & 0xFF;
                keyValue = new KeyValue("voiceParam", (int)voiceInterval);
                break;
            }
            case 128: {
                void syncWord;
                void sub1G_band;
                void sub1G_flag;
                void sub1G;
                int n = cmdValue[0] & 0xFF;
                int n5 = cmdValue[1] & 0xFF;
                long l = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 2, 4));
                HashMap hashMap = new HashMap();
                sub1G.put("status", ProtocolUtil.getbit((long)sub1G_flag, 0, 1));
                sub1G.put("lowBattery", ProtocolUtil.getbit((long)sub1G_flag, 1, 2));
                sub1G.put("fallDown", ProtocolUtil.getbit((long)sub1G_flag, 2, 3));
                sub1G.put("band", (int)sub1G_band);
                sub1G.put("syncWord", (long)syncWord);
                keyValue = new KeyValue("sub1G", sub1G);
                break;
            }
            case 129: {
                void sub1GList_deviceID;
                void sub1GList_flag;
                void sub1GWhiteList;
                long l = cmdValue[0];
                long l2 = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 1, 5));
                HashMap hashMap = new HashMap();
                sub1GWhiteList.put("status", ProtocolUtil.getbit((long)sub1GList_flag, 7, 8));
                sub1GWhiteList.put("index", ProtocolUtil.getbit((long)sub1GList_flag, 0, 7));
                sub1GWhiteList.put("deviceID", Long.toHexString((long)sub1GList_deviceID));
                keyValue = new KeyValue("sub1GWhiteList", sub1GWhiteList);
                break;
            }
            case 130: {
                void tokenStr;
                String string = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 0, 64));
                keyValue = new KeyValue("token", tokenStr);
                break;
            }
            case 131: {
                void numberStr;
                String string = BytesHexStrUtil.bytes2StringByUTF_8(cmdValue);
                keyValue = new KeyValue("testAlert", numberStr);
                break;
            }
            case 132: {
                void nfcStr;
                void nfcMap;
                HashMap hashMap = new HashMap();
                String string = BytesHexStrUtil.bytes2StringByASCII(Arrays.copyOfRange(cmdValue, 1, cmdValue.length));
                nfcMap.put("status", ProtocolUtil.getbit(cmdValue[0], 0, 1));
                nfcMap.put("message", nfcStr);
                keyValue = new KeyValue("nfc", nfcMap);
                break;
            }
            case 133: {
                void lora_band;
                void lora_flag;
                void lora;
                int n = cmdValue[0] & 0xFF;
                int n6 = cmdValue[1] & 0xFF;
                HashMap hashMap = new HashMap(3);
                lora.put("status", ProtocolUtil.getbit((long)lora_flag, 0, 1));
                lora.put("lowBattery", ProtocolUtil.getbit((long)lora_flag, 1, 2));
                lora.put("band", (int)lora_band);
                keyValue = new KeyValue("lora", lora);
                break;
            }
            case 134: {
                void loraList_deviceID;
                void loraList_deviceType;
                void loraList_flag;
                void loraWhiteList;
                long l = cmdValue[0];
                long l3 = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 1, 3));
                long l4 = ProtocolUtil.bytes2Long(Arrays.copyOfRange(cmdValue, 3, 7));
                HashMap hashMap = new HashMap(4);
                loraWhiteList.put("status", ProtocolUtil.getbit((long)loraList_flag, 7, 8));
                loraWhiteList.put("index", ProtocolUtil.getbit((long)loraList_flag, 0, 7));
                loraWhiteList.put("deviceType", (long)loraList_deviceType);
                loraWhiteList.put("deviceID", Long.toHexString((long)loraList_deviceID));
                keyValue = new KeyValue("loraWhiteList", loraWhiteList);
                break;
            }
            case 144: {
                void accountInfo;
                void voip_flag;
                void voipSetting;
                long l = cmdValue[0];
                String string = BytesHexStrUtil.bytes2StringByASCII(Arrays.copyOfRange(cmdValue, 1, cmdValue.length));
                HashMap hashMap = new HashMap(2);
                voipSetting.put("status", ProtocolUtil.getbit((long)voip_flag, 7, 8));
                voipSetting.put("accountInfo", accountInfo);
                keyValue = new KeyValue("voip", voipSetting);
                break;
            }
            case 145: {
                void accountInfo2;
                void voipList_flag;
                void voipList;
                long l = cmdValue[0];
                String string = BytesHexStrUtil.bytes2StringByASCII(Arrays.copyOfRange(cmdValue, 1, cmdValue.length));
                HashMap hashMap = new HashMap(3);
                voipList.put("status", ProtocolUtil.getbit((long)voipList_flag, 7, 8));
                voipList.put("index", ProtocolUtil.getbit((long)voipList_flag, 0, 4));
                voipList.put("accountInfo", accountInfo2);
                keyValue = new KeyValue("voipList", voipList);
                break;
            }
            case 208: {
                void wifiHotspot_Name;
                void wifiHotspot_mac;
                void wiFiHotspot;
                void wifiHotspot_Len;
                String string = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(cmdValue, 0, 6), false);
                int n = cmdValue[6] & 0xFF;
                String string3 = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 7, 7 + wifiHotspot_Len));
                HashMap hashMap = new HashMap(2);
                wiFiHotspot.put("mac", wifiHotspot_mac);
                wiFiHotspot.put("name", wifiHotspot_Name);
                keyValue = new KeyValue("wifiHotspot", wiFiHotspot);
                break;
            }
            case 209: {
                void ethernet_DNS2;
                void ethernet_DNS1;
                void ethernet_gateway;
                void ethernet_netmask;
                void ethernet_ipv4;
                void ethernet_mac;
                void ipMode;
                void ethernet;
                int n = cmdValue[0] & 0xFF;
                String string = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(cmdValue, 1, 7), false);
                String string4 = ProtocolUtil.bytes2IpAddr(Arrays.copyOfRange(cmdValue, 7, 11));
                String string5 = ProtocolUtil.bytes2IpAddr(Arrays.copyOfRange(cmdValue, 11, 15));
                String string6 = ProtocolUtil.bytes2IpAddr(Arrays.copyOfRange(cmdValue, 15, 19));
                String string7 = ProtocolUtil.bytes2IpAddr(Arrays.copyOfRange(cmdValue, 19, 23));
                String string8 = ProtocolUtil.bytes2IpAddr(Arrays.copyOfRange(cmdValue, 23, 27));
                HashMap hashMap = new HashMap(7);
                ethernet.put("ipMode", (int)ipMode);
                ethernet.put("mac", ethernet_mac);
                ethernet.put("ipv4", ethernet_ipv4);
                ethernet.put("netmask", ethernet_netmask);
                ethernet.put("gateway", ethernet_gateway);
                ethernet.put("dns1", ethernet_DNS1);
                ethernet.put("dns2", ethernet_DNS2);
                keyValue = new KeyValue("ethernet", ethernet);
                break;
            }
            case 210: {
                void internetAccessMode3;
                void internetAccessMode2;
                void internetAccessMode1;
                void internetAccessMode;
                int n = cmdValue[0] & 0xFF;
                int n7 = cmdValue[1] & 0xFF;
                int n8 = cmdValue[2] & 0xFF;
                HashMap hashMap = new HashMap(3);
                internetAccessMode.put("mode1", (int)internetAccessMode1);
                internetAccessMode.put("mode2", (int)internetAccessMode2);
                internetAccessMode.put("mode3", (int)internetAccessMode3);
                keyValue = new KeyValue("internetAccessMode", internetAccessMode);
                break;
            }
            case 211: {
                void internetStatus;
                byte by = cmdValue[0];
                keyValue = new KeyValue("internetStatus", (int)internetStatus);
                break;
            }
            case 225: {
                void MBN_Name;
                void state;
                void MBNMap;
                void MBN_Len;
                byte by = cmdValue[0];
                byte by2 = cmdValue[1];
                String string = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(cmdValue, 2, 2 + MBN_Len));
                HashMap hashMap = new HashMap(2);
                MBNMap.put("state", (int)state);
                MBNMap.put("name", MBN_Name);
                keyValue = new KeyValue("MBN", MBNMap);
                break;
            }
            default: {
                void other;
                HashMap hashMap = new HashMap(1);
                other.put("key:0x" + Integer.toHexString(cmd.getCmdKey()), "Value:" + BytesHexStrUtil.bytesToHexString(cmdValue));
                keyValue = new KeyValue("UnsupportedKeys", other);
            }
        }
        return keyValue;
    }

    @Override
    public CmdBody decode(Map<String, Object> data) {
        return this.decode(data, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CmdBody decode(Map<String, Object> data, boolean isReq) {
        CmdBody cmd_bodyData = new CmdBody();
        cmd_bodyData.setCmdType(2);
        byte[] cmdValue = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            switch (entry.getKey()) {
                case "Read": {
                    int cmdKey = 240;
                    if (entry.getValue() != null) {
                        if (entry.getValue() instanceof byte[]) {
                            cmdValue = (byte[])entry.getValue();
                        } else if (entry.getValue() instanceof String) {
                            cmdValue = Convert.toByteArray(",", (String)entry.getValue());
                        }
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "module": {
                    int cmdKey = 1;
                    cmdValue = BytesHexStrUtil.hexStringToBytes(Convert.toStr(entry.getValue(), ""), false);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "version": {
                    int cmdKey = 2;
                    String version = Convert.toStr(entry.getValue(), "");
                    String[] versionArr = version.replace("v", "").split("\\.");
                    cmdValue = new byte[]{Convert.toByte(versionArr[3], (byte)0), Convert.toByte(versionArr[2], (byte)0), Convert.toByte(versionArr[1], (byte)0), Convert.toByte(versionArr[0], (byte)0)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "IMEI": {
                    int cmdKey = 3;
                    String imei = Convert.toStr(entry.getValue(), "000000000000000");
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(imei);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "ICCID": {
                    int cmdKey = 4;
                    String iccid = Convert.toStr(entry.getValue(), "");
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(iccid);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "MAC": {
                    int cmdKey = 5;
                    String mac = Convert.toStr(entry.getValue(), "00:00:00:00:00:00");
                    cmdValue = ProtocolUtil.mac2Bytes(mac, false);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "dateTime": {
                    int cmdKey = 6;
                    cmdValue = ProtocolUtil.dateTime2Bytes(entry.getValue());
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "runTime": {
                    int cmdKey = 7;
                    long runTime = Convert.toLong(entry.getValue(), 0L);
                    cmdValue = ProtocolUtil.long2Bytes(runTime, 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "firmware": {
                    int cmdKey = 8;
                    Map firmware = (Map)entry.getValue();
                    String firmwareVersion = Convert.toStr(firmware.get("firmwareVersion"), "");
                    String[] firmwareVersionArr = firmwareVersion.replace("v", "").split("\\.");
                    if (firmwareVersionArr.length < 3) break;
                    byte[] firmwareVersionByte = new byte[]{Convert.toByte(firmwareVersionArr[3], (byte)0), Convert.toByte(firmwareVersionArr[2], (byte)0), Convert.toByte(firmwareVersionArr[1], (byte)0), Convert.toByte(firmwareVersionArr[0], (byte)0)};
                    String hardwareVersion = Convert.toStr(firmware.get("hardwareVersion"), "");
                    String[] hardwareVersionArr = hardwareVersion.replace("v", "").split("\\.");
                    byte[] hardwareVersionByte = new byte[]{Convert.toByte(hardwareVersionArr[3], (byte)0), Convert.toByte(hardwareVersionArr[2], (byte)0), Convert.toByte(hardwareVersionArr[1], (byte)0), Convert.toByte(hardwareVersionArr[0], (byte)0)};
                    String softDeviceVersion = Convert.toStr(firmware.get("softDeviceVersion"), "");
                    String[] softDeviceVersionArr = softDeviceVersion.replace("v", "").split("\\.");
                    long msdv = Convert.toInt(softDeviceVersionArr[0], 0) * 1000000 + Convert.toInt(softDeviceVersionArr[1], 0) * 1000 + Convert.toInt(softDeviceVersionArr[2], 0);
                    byte[] softDeviceVersionByte = ProtocolUtil.long2Bytes(msdv, 4);
                    long firmwareSize = Convert.toLong(firmware.get("firmwareSize"), 0L);
                    byte[] firmwareSizeByte = ProtocolUtil.long2Bytes(firmwareSize, 4);
                    long softDeviceFWID = Convert.toLong(firmware.get("softDeviceFWID"), 0L);
                    byte[] softDeviceFWIDByte = ProtocolUtil.long2Bytes(softDeviceFWID, 4);
                    String complierDateTime = Convert.toStr(firmware.get("complierDateTime"), "");
                    byte[] complierDateTimeByte = BytesHexStrUtil.string2BytesByASCII(complierDateTime);
                    cmdValue = ArrayUtils.addAll(firmwareVersionByte, firmwareSizeByte);
                    cmdValue = ArrayUtils.addAll(cmdValue, hardwareVersionByte);
                    cmdValue = ArrayUtils.addAll(cmdValue, softDeviceVersionByte);
                    cmdValue = ArrayUtils.addAll(cmdValue, softDeviceFWIDByte);
                    cmdValue = ArrayUtils.addAll(cmdValue, complierDateTimeByte);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "mileage": {
                    int cmdKey = 9;
                    int mileage = Convert.toInt(entry.getValue(), 0);
                    cmdValue = new byte[]{(byte)(mileage & 0xFF), (byte)(mileage >> 8 & 0xFF), (byte)(mileage >> 16 & 0xFF), (byte)(mileage >> 24 & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "workMode": {
                    int cmdKey = 10;
                    Map workMode = (Map)entry.getValue();
                    int mode = Convert.toInt(workMode.get("mode"), 0);
                    int time = Convert.toInt(workMode.get("time"), 0);
                    cmdValue = new byte[]{(byte)(time & 0xFF), (byte)(time >> 8 & 0xFF), (byte)(time >> 16 & 0xFF), (byte)(mode & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "alarmClock": {
                    int cmdKey = 11;
                    List alarmClockList = (List)entry.getValue();
                    for (Object alarmClock : alarmClockList) {
                        int alarm_index = Convert.toInt(alarmClock.get("index"), 0);
                        alarm_index |= Convert.toInt(alarmClock.get("medicine"), 0) << 6;
                        alarm_index |= Convert.toInt(alarmClock.get("status"), 0) << 7;
                        String alarm_timeStr = Convert.toStr(alarmClock.get("time"), "00:00");
                        alarm_timeStr = alarm_timeStr.trim().length() > 0 ? alarm_timeStr : "00:00";
                        String[] alarm_time = alarm_timeStr.split(":");
                        int hours = Convert.toInt(alarm_time[0], 0);
                        int minutes = Convert.toInt(alarm_time[1], 0);
                        int alarm_ringTime = Convert.toInt(alarmClock.get("ringTime"), 0);
                        int alarm_ringType = Convert.toInt(alarmClock.get("ringType"), 0);
                        int week = Convert.toInt(alarmClock.get("mon"), 0);
                        week |= Convert.toInt(alarmClock.get("tus"), 0) << 1;
                        week |= Convert.toInt(alarmClock.get("wed"), 0) << 2;
                        week |= Convert.toInt(alarmClock.get("thu"), 0) << 3;
                        week |= Convert.toInt(alarmClock.get("fri"), 0) << 4;
                        week |= Convert.toInt(alarmClock.get("sat"), 0) << 5;
                        cmdValue = new byte[]{(byte)(alarm_index & 0xFF), (byte)(hours & 0xFF), (byte)(minutes & 0xFF), (byte)((week |= Convert.toInt(alarmClock.get("sun"), 0) << 6) & 0xFF), (byte)(alarm_ringTime & 0xFF), (byte)(alarm_ringType & 0xFF)};
                        if (alarmClock.get("describe") != null) {
                            String alarm_describe = Convert.toStr(alarmClock.get("describe"), "");
                            cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8(alarm_describe));
                        }
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "alarmClockExt": {
                    Object alarmClock;
                    int cmdKey = 123;
                    List alarmClockListExt = (List)entry.getValue();
                    alarmClock = alarmClockListExt.iterator();
                    while (alarmClock.hasNext()) {
                        Map alarmClock2 = (Map)alarmClock.next();
                        int status_7B = Convert.toInt(alarmClock2.get("status"), 0) << 7;
                        int alarmType = Convert.toInt(alarmClock2.get("alarmType"), 0);
                        int index_7B = Convert.toInt(alarmClock2.get("index"), 0);
                        String alarm_timeStr = Convert.toStr(alarmClock2.get("time"), "00:00");
                        alarm_timeStr = !alarm_timeStr.trim().isEmpty() ? alarm_timeStr : "00:00";
                        String[] alarm_time = alarm_timeStr.split(":");
                        int hours = Convert.toInt(alarm_time[0], 0);
                        int minutes = Convert.toInt(alarm_time[1], 0);
                        int alarm_ringTime = Convert.toInt(alarmClock2.get("ringTime"), 0);
                        int alarm_ringType = Convert.toInt(alarmClock2.get("ringType"), 0);
                        String alarm_describe = Convert.toStr(alarmClock2.get("describe"), "");
                        int week = Convert.toInt(alarmClock2.get("mon"), 0);
                        week |= Convert.toInt(alarmClock2.get("tus"), 0) << 1;
                        week |= Convert.toInt(alarmClock2.get("wed"), 0) << 2;
                        week |= Convert.toInt(alarmClock2.get("thu"), 0) << 3;
                        week |= Convert.toInt(alarmClock2.get("fri"), 0) << 4;
                        week |= Convert.toInt(alarmClock2.get("sat"), 0) << 5;
                        cmdValue = new byte[]{(byte)(status_7B & 0xFF), (byte)(alarmType & 0xFF)};
                        cmdValue = ArrayUtils.add(cmdValue, (byte)index_7B);
                        cmdValue = ArrayUtils.add(cmdValue, (byte)hours);
                        cmdValue = ArrayUtils.add(cmdValue, (byte)minutes);
                        cmdValue = ArrayUtils.add(cmdValue, (byte)(week |= Convert.toInt(alarmClock2.get("sun"), 0) << 6));
                        cmdValue = ArrayUtils.add(cmdValue, (byte)alarm_ringTime);
                        cmdValue = ArrayUtils.add(cmdValue, (byte)alarm_ringType);
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8(alarm_describe));
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "noDisturb": {
                    int cmdKey = 12;
                    Map noDisturb = (Map)entry.getValue();
                    int noDisturbStatus = Convert.toInt(noDisturb.get("status"), 0);
                    String fromStr = Convert.toStr(noDisturb.get("from"), "00:00");
                    fromStr = fromStr.trim().length() > 0 ? fromStr : "00:00";
                    String[] from = fromStr.split(":");
                    int from1 = Convert.toInt(from[0], 0);
                    int from2 = Convert.toInt(from[1], 0);
                    String toStr = Convert.toStr(noDisturb.get("to"), "00:00");
                    toStr = toStr.trim().length() > 0 ? toStr : "00:00";
                    String[] to = toStr.split(":");
                    int to1 = Convert.toInt(to[0], 0);
                    int to2 = Convert.toInt(to[1], 0);
                    cmdValue = new byte[]{(byte)(noDisturbStatus << 7), (byte)(from1 & 0xFF), (byte)(from2 & 0xFF), (byte)(to1 & 0xFF), (byte)(to2 & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "password": {
                    int cmdKey = 13;
                    Map passwordMap = (Map)entry.getValue();
                    int passwordStatus = Convert.toInt(passwordMap.get("status"), 0) << 7;
                    int password = Convert.toInt(passwordMap.get("password"), 0);
                    cmdValue = new byte[]{(byte)(password & 0xFF), (byte)(password >> 8 & 0xFF), (byte)(password >> 16 & 0xFF), (byte)(password >> 23 & 0xFF | passwordStatus)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "timeZone": {
                    int cmdKey = 14;
                    int timeZone = (int)(Convert.toFloat(entry.getValue(), Float.valueOf(0.0f)).floatValue() * 60.0f / 15.0f);
                    cmdValue = new byte[]{(byte)(timeZone & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "enableControl": {
                    int cmdKey = 15;
                    Map enableControl = (Map)entry.getValue();
                    long flag_value = Convert.toLong(enableControl.get("flagValue"), 0L);
                    long enable = Convert.toInt(enableControl.get("led"), ProtocolUtil.getbit(flag_value, 0, 1)).intValue();
                    enable |= (long)(Convert.toInt(enableControl.get("beep"), ProtocolUtil.getbit(flag_value, 1, 2)) << 1);
                    enable |= (long)(Convert.toInt(enableControl.get("motor"), ProtocolUtil.getbit(flag_value, 2, 3)) << 2);
                    enable |= (long)(Convert.toInt(enableControl.get("gsmLoc"), ProtocolUtil.getbit(flag_value, 3, 4)) << 3);
                    enable |= (long)(Convert.toInt(enableControl.get("wifiLoc"), ProtocolUtil.getbit(flag_value, 4, 5)) << 4);
                    enable |= (long)(Convert.toInt(enableControl.get("sosSpeaker"), ProtocolUtil.getbit(flag_value, 5, 6)) << 5);
                    enable |= (long)(Convert.toInt(enableControl.get("xSpeaker"), ProtocolUtil.getbit(flag_value, 6, 7)) << 6);
                    enable |= (long)(Convert.toInt(enableControl.get("bleLongConnect"), ProtocolUtil.getbit(flag_value, 7, 8)) << 7);
                    enable |= (long)(Convert.toInt(enableControl.get("bleLoc"), ProtocolUtil.getbit(flag_value, 8, 9)) << 8);
                    enable |= (long)(Convert.toInt(enableControl.get("sosCallNumberVoice"), ProtocolUtil.getbit(flag_value, 9, 10)) << 9);
                    enable |= (long)(Convert.toInt(enableControl.get("bleAdvAlways"), ProtocolUtil.getbit(flag_value, 10, 11)) << 10);
                    enable |= (long)(Convert.toInt(enableControl.get("gpsLoc"), ProtocolUtil.getbit(flag_value, 11, 12)) << 11);
                    enable |= (long)(Convert.toInt(enableControl.get("tcpFast"), ProtocolUtil.getbit(flag_value, 12, 13)) << 12);
                    enable |= (long)(Convert.toInt(enableControl.get("homeBeacon"), ProtocolUtil.getbit(flag_value, 14, 15)) << 14);
                    enable |= (long)(Convert.toInt(enableControl.get("activity"), ProtocolUtil.getbit(flag_value, 15, 16)) << 15);
                    enable |= (long)(Convert.toInt(enableControl.get("step"), ProtocolUtil.getbit(flag_value, 16, 17)) << 16);
                    enable |= (long)(Convert.toInt(enableControl.get("homeWifi"), ProtocolUtil.getbit(flag_value, 17, 18)) << 17);
                    enable |= (long)(Convert.toInt(enableControl.get("dataSaver"), ProtocolUtil.getbit(flag_value, 18, 19)) << 18);
                    enable |= (long)(Convert.toInt(enableControl.get("networkLoc"), ProtocolUtil.getbit(flag_value, 19, 20)) << 19);
                    enable |= (long)(Convert.toInt(enableControl.get("powerControl"), ProtocolUtil.getbit(flag_value, 20, 21)) << 20);
                    enable |= (long)(Convert.toInt(enableControl.get("sosCannel"), ProtocolUtil.getbit(flag_value, 21, 22)) << 21);
                    enable |= (long)(Convert.toInt(enableControl.get("longSMS"), ProtocolUtil.getbit(flag_value, 22, 23)) << 22);
                    enable |= (long)(Convert.toInt(enableControl.get("autoUpdate"), ProtocolUtil.getbit(flag_value, 30, 31)) << 30);
                    cmdValue = ProtocolUtil.long2Bytes(enable |= (long)(Convert.toInt(enableControl.get("agps"), ProtocolUtil.getbit(flag_value, 31, 32)) << 31), 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "ringToneVolume": {
                    int cmdKey = 16;
                    int ringtoneVolume = Convert.toInt(entry.getValue(), 0);
                    cmdValue = new byte[]{(byte)(ringtoneVolume & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "micVolume": {
                    int cmdKey = 17;
                    int micVolume = Convert.toInt(entry.getValue(), 0);
                    cmdValue = new byte[]{(byte)(micVolume & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "speakerVolume": {
                    int cmdKey = 18;
                    int speakerVolume = Convert.toInt(entry.getValue(), 0);
                    cmdValue = new byte[]{(byte)(speakerVolume & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "deviceName": {
                    int cmdKey = 19;
                    String deviceName = Convert.toStr(entry.getValue(), "");
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(deviceName);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "battery": {
                    int cmdKey = 20;
                    Map batteryMap = (Map)entry.getValue();
                    int battery = Convert.toInt(batteryMap.get("battery"), 0);
                    int voltage = Convert.toInt(batteryMap.get("voltage"), 0);
                    cmdValue = new byte[]{(byte)(battery & 0xFF)};
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(voltage, 2));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "fwVersion": {
                    int cmdKey = 26;
                    String fwVersion = Convert.toStr(entry.getValue(), "");
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(fwVersion);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "gsmModule": {
                    int cmdKey = 27;
                    String gsmModule = Convert.toStr(entry.getValue(), "");
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(gsmModule);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "promptVolume": {
                    int cmdKey = 28;
                    int promptVolume = Convert.toInt(entry.getValue(), 0);
                    cmdValue = new byte[]{(byte)(promptVolume & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "agpsLoc": {
                    int cmdKey = 29;
                    Map agpsLoc = (Map)entry.getValue();
                    int agps_status = Convert.toInt(agpsLoc.get("status"), 0) << 7;
                    double agpsLoc_lat = Convert.toDouble(agpsLoc.get("lat"), 0.0);
                    double agpsLoc_lng = Convert.toDouble(agpsLoc.get("lng"), 0.0);
                    cmdValue = new byte[]{(byte)(agps_status & 0xFF)};
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.latlng2Bytes(agpsLoc_lat, agpsLoc_lng));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "locale": {
                    int cmdKey = 31;
                    String locale = Convert.toStr(entry.getValue(), "");
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(locale);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "number": {
                    int cmdKey = 48;
                    List numberList = (List)entry.getValue();
                    for (Object number : numberList) {
                        int number_flag = Convert.toInt(number.get("index"), 0) & 0xF;
                        number_flag |= Convert.toInt(number.get("enable"), 0) << 7;
                        number_flag |= Convert.toInt(number.get("sms"), 0) << 6;
                        number_flag |= Convert.toInt(number.get("call"), 0) << 5;
                        byte[] numberValue = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(number.get("number"), ""));
                        cmdValue = new byte[]{(byte)((number_flag |= Convert.toInt(number.get("noCard"), 0) << 4) & 0xFF)};
                        cmdValue = ArrayUtils.addAll(cmdValue, numberValue);
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "numberNamePhoto": {
                    Object number;
                    int cmdKey = 52;
                    List numberPhotoList = (List)entry.getValue();
                    number = numberPhotoList.iterator();
                    while (number.hasNext()) {
                        Map numberPhoto = (Map)number.next();
                        byte[] numberValue_photo = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(numberPhoto.get("number"), ""));
                        byte[] nameValue = BytesHexStrUtil.string2BytesByUTF_8(Convert.toStr(numberPhoto.get("name"), ""));
                        byte[] photoValue = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(numberPhoto.get("headURL"), ""));
                        int flag_numberPhoto = Convert.toInt(numberPhoto.get("index"), 0) & 0xF;
                        flag_numberPhoto |= Convert.toInt(numberPhoto.get("enable"), 0) << 7;
                        flag_numberPhoto |= Convert.toInt(numberPhoto.get("sms"), 0) << 6;
                        flag_numberPhoto |= Convert.toInt(numberPhoto.get("call"), 0) << 5;
                        cmdValue = new byte[]{(byte)((flag_numberPhoto |= Convert.toInt(numberPhoto.get("noCard"), 0) << 4) & 0xFF), (byte)(numberValue_photo.length & 0xFF)};
                        cmdValue = ArrayUtils.addAll(cmdValue, numberValue_photo);
                        cmdValue = ArrayUtils.addAll(cmdValue, (byte)(nameValue.length & 0xFF));
                        cmdValue = ArrayUtils.addAll(cmdValue, nameValue);
                        cmdValue = ArrayUtils.addAll(cmdValue, (byte)(photoValue.length & 0xFF));
                        cmdValue = ArrayUtils.addAll(cmdValue, photoValue);
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "personalInfo": {
                    int cmdKey = 53;
                    Map personalInfo = (Map)entry.getValue();
                    int height = Convert.toInt(personalInfo.get("height"), 0);
                    int weight = Convert.toInt(personalInfo.get("weight"), 0);
                    int sex = Convert.toInt(personalInfo.get("sex"), 0);
                    int bloodType = Convert.toInt(personalInfo.get("bloodType"), 0);
                    byte[] birthdayByte = ProtocolUtil.dateTime2Bytes(personalInfo.get("birthday"));
                    String name = Convert.toStr(personalInfo.get("name"), "");
                    byte[] nameByte = BytesHexStrUtil.string2BytesByUTF_8(name);
                    String url = Convert.toStr(personalInfo.get("url"), "");
                    byte[] urlByte = BytesHexStrUtil.string2BytesByUTF_8(url);
                    String headURL = Convert.toStr(personalInfo.get("headURL"), "");
                    byte[] headURLByte = BytesHexStrUtil.string2BytesByUTF_8(headURL);
                    cmdValue = new byte[]{(byte)(nameByte.length & 0xFF), (byte)(urlByte.length & 0xFF), (byte)(headURLByte.length & 0xFF), (byte)(height & 0xFF), (byte)(weight & 0xFF), (byte)(sex << 6 | bloodType & 0x1F)};
                    cmdValue = ArrayUtils.addAll(cmdValue, birthdayByte);
                    cmdValue = ArrayUtils.addAll(cmdValue, nameByte);
                    cmdValue = ArrayUtils.addAll(cmdValue, urlByte);
                    cmdValue = ArrayUtils.addAll(cmdValue, headURLByte);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "watch": {
                    int cmdKey = 54;
                    Map watchSettings = (Map)entry.getValue();
                    int watch_faceId = Convert.toInt(watchSettings.get("faceId"), 0);
                    int watch_autoTime = Convert.toInt(watchSettings.get("autoTime"), 0);
                    long watch_flag = Convert.toLong(watchSettings.get("flagValue"), 0L);
                    int watch_status = Convert.toInt(watchSettings.get("status0"), ProtocolUtil.getbit(watch_flag, 0, 1));
                    watch_status |= Convert.toInt(watchSettings.get("status1"), ProtocolUtil.getbit(watch_flag, 1, 2)) << 1;
                    watch_status |= Convert.toInt(watchSettings.get("status2"), ProtocolUtil.getbit(watch_flag, 2, 3)) << 2;
                    watch_status |= Convert.toInt(watchSettings.get("status3"), ProtocolUtil.getbit(watch_flag, 3, 4)) << 3;
                    for (int i = 8; i < 18; ++i) {
                        watch_status |= Convert.toInt(watchSettings.get("status" + i), ProtocolUtil.getbit(watch_flag, i, i + 1)) << i;
                    }
                    int watch_menu = 0;
                    for (int i = 0; i < 8; ++i) {
                        watch_menu |= Convert.toInt(watchSettings.get("menu" + (i + 1)), 0) << i + 1;
                    }
                    cmdValue = new byte[]{(byte)(watch_faceId & 0xFF)};
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(watch_status, 4));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(watch_menu, 4));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(watch_autoTime, 4));
                    int bright_ness = Convert.toInt(watchSettings.get("brightNess"), 3);
                    int bright_time = Convert.toInt(watchSettings.get("brightTime"), 10);
                    int logo_index = Convert.toInt(watchSettings.get("logoIndex"), 1);
                    cmdValue = ArrayUtils.addAll(cmdValue, (byte)bright_ness, (byte)bright_time, (byte)logo_index);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "bleLoc": {
                    int cmdKey = 21;
                    Map bleLoc = (Map)entry.getValue();
                    Double bleLoc_lat = Convert.toDouble(bleLoc.get("lat"), 0.0);
                    Double bleLoc_lng = Convert.toDouble(bleLoc.get("lng"), 0.0);
                    cmdValue = ProtocolUtil.latlng2Bytes(bleLoc_lat, bleLoc_lng);
                    String describe = Convert.toStr(bleLoc.get("describe"), "");
                    byte[] ble_describe = BytesHexStrUtil.string2BytesByASCII(describe);
                    cmdValue = ArrayUtils.addAll(cmdValue, ble_describe);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "bleWhiteList": {
                    int cmdKey = 22;
                    List bleWhiteList = (List)entry.getValue();
                    for (Map bleWhite : bleWhiteList) {
                        int bwl_index = Convert.toInt(bleWhite.get("index"), 0);
                        int flag_bleWhite = Convert.toInt(bleWhite.get("enable"), 0);
                        String bwl_macStr = Convert.toStr(bleWhite.get("mac"), "00:00:00:00:00:00");
                        byte[] bwl_mac = ProtocolUtil.mac2Bytes(bwl_macStr, false);
                        cmdValue = new byte[]{(byte)(flag_bleWhite << 7 | bwl_index & 0x7F)};
                        cmdValue = ArrayUtils.addAll(cmdValue, bwl_mac);
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "smsgpsurl": {
                    int cmdKey = 23;
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(entry.getValue(), ""));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "smswifiurl": {
                    int cmdKey = 24;
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(entry.getValue(), ""));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "music": {
                    int cmdKey = 25;
                    Map music = (Map)entry.getValue();
                    long musicValue = Convert.toLong(music.get("flagValue"), 0L);
                    long flag = 0L;
                    for (int i = 0; i < 32; ++i) {
                        flag |= (long)(Convert.toInt(music.get("bit" + i), ProtocolUtil.getbit(musicValue, i, i + 1)) << i);
                    }
                    cmdValue = ProtocolUtil.long2Bytes(flag, 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "musicExtend": {
                    int cmdKey = 118;
                    Map musicExtend = (Map)entry.getValue();
                    long musicValueExtend = Convert.toLong(musicExtend.get("flagValue"), 0L);
                    long flagExtend = 0L;
                    for (int i = 0; i < 32; ++i) {
                        flagExtend |= (long)(Convert.toInt(musicExtend.get("bit" + i), ProtocolUtil.getbit(musicValueExtend, i, i + 1)) << i);
                    }
                    cmdValue = ProtocolUtil.long2Bytes(flagExtend, 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "sosButton": {
                    int cmdKey = 32;
                    Map sosButton = (Map)entry.getValue();
                    int sosButtonStatus = Convert.toInt(sosButton.get("status"), 0);
                    int sosButtonMode = Convert.toInt(sosButton.get("mode"), 0);
                    int sosButtonTask = Convert.toInt(sosButton.get("task"), 0);
                    int sosButtonTime = Convert.toInt(sosButton.get("time"), 0);
                    int sosButtonFeedBack = Convert.toInt(sosButton.get("feedBack"), 0);
                    int sosButtonData = sosButtonFeedBack | sosButtonTime << 2 | sosButtonTask << 9 | sosButtonMode << 13 | sosButtonStatus << 15;
                    cmdValue = new byte[]{(byte)(sosButtonData & 0xFF), (byte)((sosButtonData & 0xFF00) >> 8)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "call1Button": {
                    int cmdKey = 33;
                    Map call1Button = (Map)entry.getValue();
                    int call1ButtonStatus = Convert.toInt(call1Button.get("status"), 0);
                    int call1ButtonMode = Convert.toInt(call1Button.get("mode"), 0);
                    int call1ButtonTask = Convert.toInt(call1Button.get("task"), 0);
                    int call1ButtonTime = Convert.toInt(call1Button.get("time"), 0);
                    int call1ButtonFeedBack = Convert.toInt(call1Button.get("feedBack"), 0);
                    int call1ButtonData = call1ButtonFeedBack | call1ButtonTime << 2 | call1ButtonTask << 9 | call1ButtonMode << 13 | call1ButtonStatus << 15;
                    cmdValue = new byte[]{(byte)(call1ButtonData & 0xFF), (byte)((call1ButtonData & 0xFF00) >> 8)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "call2Button": {
                    int cmdKey = 34;
                    Map call2Button = (Map)entry.getValue();
                    int call2ButtonStatus = Convert.toInt(call2Button.get("status"), 0);
                    int call2ButtonMode = Convert.toInt(call2Button.get("mode"), 0);
                    int call2ButtonTask = Convert.toInt(call2Button.get("task"), 0);
                    int call2ButtonTime = Convert.toInt(call2Button.get("time"), 0);
                    int call2ButtonFeedBack = Convert.toInt(call2Button.get("feedBack"), 0);
                    int call2ButtonData = call2ButtonFeedBack | call2ButtonTime << 2 | call2ButtonTask << 9 | call2ButtonMode << 13 | call2ButtonStatus << 15;
                    cmdValue = new byte[]{(byte)(call2ButtonData & 0xFF), (byte)((call2ButtonData & 0xFF00) >> 8)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "funButton": {
                    int cmdKey = 35;
                    Map funButton = (Map)entry.getValue();
                    long funButtonData = Convert.toInt(funButton.get("status"), 0) << 15;
                    funButtonData |= (long)(Convert.toInt(funButton.get("mode"), 0) << 13);
                    funButtonData |= (long)(Convert.toInt(funButton.get("task"), 0) << 9);
                    cmdValue = ProtocolUtil.long2Bytes(funButtonData |= (long)(Convert.toInt(funButton.get("time"), 0) << 2), 2);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "smsOption": {
                    int cmdKey = 49;
                    Map smsOption = (Map)entry.getValue();
                    int smsStatus = Convert.toInt(smsOption.get("status"), 0);
                    byte[] smsPrefix = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(smsOption.get("prefix"), ""));
                    cmdValue = new byte[]{(byte)(smsStatus << 7 & 0xFF)};
                    cmdValue = ArrayUtils.addAll(cmdValue, smsPrefix);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "sosOption": {
                    int cmdKey = 50;
                    Map sosOption = (Map)entry.getValue();
                    int holdTime = Convert.toInt(sosOption.get("holdTime"), 0);
                    int ringsTime = Convert.toInt(sosOption.get("ringsTime"), 0);
                    int loops = Convert.toInt(sosOption.get("loops"), 0);
                    cmdValue = new byte[]{(byte)(holdTime & 0xFF), (byte)(holdTime >> 8 & 0xFF), (byte)(ringsTime & 0xFF), (byte)(loops & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "phoneOption": {
                    int cmdKey = 51;
                    Map phoneOption = (Map)entry.getValue();
                    long flag_phone = Convert.toLong(phoneOption.get("flagValue"), 0L);
                    long value_phone = Convert.toInt(phoneOption.get("rings"), ProtocolUtil.getbit(flag_phone, 0, 7)).intValue();
                    value_phone |= (long)(Convert.toInt(phoneOption.get("s1"), ProtocolUtil.getbit(flag_phone, 7, 8)) << 7);
                    value_phone |= (long)(Convert.toInt(phoneOption.get("s2"), ProtocolUtil.getbit(flag_phone, 8, 9)) << 8);
                    value_phone |= (long)(Convert.toInt(phoneOption.get("s3"), ProtocolUtil.getbit(flag_phone, 9, 10)) << 9);
                    value_phone |= (long)(Convert.toInt(phoneOption.get("s4"), ProtocolUtil.getbit(flag_phone, 10, 11)) << 10);
                    value_phone |= (long)(Convert.toInt(phoneOption.get("s5"), ProtocolUtil.getbit(flag_phone, 11, 12)) << 11);
                    value_phone |= (long)(Convert.toInt(phoneOption.get("s6"), ProtocolUtil.getbit(flag_phone, 14, 15)) << 14);
                    value_phone |= (long)(Convert.toInt(phoneOption.get("s7"), ProtocolUtil.getbit(flag_phone, 15, 16)) << 15);
                    value_phone |= (long)(Convert.toInt(phoneOption.get("callIncoming"), ProtocolUtil.getbit(flag_phone, 16, 18)) << 16);
                    cmdValue = ProtocolUtil.long2Bytes(value_phone |= (long)(Convert.toInt(phoneOption.get("toneID"), ProtocolUtil.getbit(flag_phone, 28, 32)) << 28), 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "apn": {
                    int cmdKey = 64;
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(entry.getValue(), ""));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "apnUserName": {
                    int cmdKey = 65;
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(entry.getValue(), ""));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "apnPassword": {
                    int cmdKey = 66;
                    cmdValue = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(entry.getValue(), ""));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "sever": {
                    int cmdKey = 67;
                    Map sever = (Map)entry.getValue();
                    int severStatus = Convert.toInt(sever.get("status"), 0);
                    byte[] severIP = BytesHexStrUtil.string2BytesByASCII(Convert.toStr(sever.get("ip"), ""));
                    int severType = Convert.toInt(sever.get("type"), 0);
                    int severPort = Convert.toInt(sever.get("port"), 0);
                    cmdValue = new byte[]{(byte)(severStatus << 7 | severType & 1), (byte)(severPort & 0xFF), (byte)(severPort >> 8 & 0xFF)};
                    cmdValue = ArrayUtils.addAll(cmdValue, severIP);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "timeInterval": {
                    int cmdKey = 68;
                    Map timeInterval = (Map)entry.getValue();
                    int heartBeatStatus = Convert.toInt(timeInterval.get("heartBeatStatus"), 0) << 7;
                    int heartBeat = Convert.toInt(timeInterval.get("heartBeat"), 0);
                    int upload = Convert.toInt(timeInterval.get("upload"), 0);
                    int uploadLazy = Convert.toInt(timeInterval.get("uploadLazy"), 0);
                    byte[] heartByte = new byte[]{(byte)(heartBeat & 0xFF), (byte)(heartBeat >> 8 & 0xFF), (byte)(heartBeat >> 16 & 0xFF), (byte)(heartBeat >> 23 & 0xFF | heartBeatStatus)};
                    byte[] uploadByte = new byte[]{(byte)(upload & 0xFF), (byte)(upload >> 8 & 0xFF), (byte)(upload >> 16 & 0xFF), (byte)(upload >> 24 & 0xFF)};
                    byte[] uploadLazyByte = new byte[]{(byte)(uploadLazy & 0xFF), (byte)(uploadLazy >> 8 & 0xFF), (byte)(uploadLazy >> 16 & 0xFF), (byte)(uploadLazy >> 24 & 0xFF)};
                    cmdValue = ArrayUtils.addAll(heartByte, uploadByte);
                    cmdValue = ArrayUtils.addAll(cmdValue, uploadLazyByte);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "continueLocate": {
                    int cmdKey = 69;
                    Map continueLocate = (Map)entry.getValue();
                    int locate_interval = Convert.toInt(continueLocate.get("interval"), 0);
                    int locate_time = Convert.toInt(continueLocate.get("time"), 0);
                    cmdValue = new byte[]{(byte)(locate_interval & 0xFF), (byte)(locate_interval >> 8 & 0xFF), (byte)(locate_time & 0xFF), (byte)(locate_time >> 8 & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "heartRate": {
                    int cmdKey = 70;
                    Map heartRateInterval = (Map)entry.getValue();
                    int status = Convert.toInt(heartRateInterval.get("status"), 0) << 7;
                    long interval = Convert.toLong(heartRateInterval.get("interval"), 0L);
                    cmdValue = new byte[]{(byte)(interval & 0xFFL), (byte)(interval >> 8 & 0xFFL), (byte)(interval >> 16 & 0xFFL), (byte)(interval >> 23 & 0x7FL | (long)status)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "customizedID": {
                    int cmdKey = 71;
                    String deviceID = Convert.toStr(entry.getValue());
                    cmdValue = BytesHexStrUtil.string2BytesByUTF_8(deviceID);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "aesKey": {
                    int cmdKey = 72;
                    Map aesKeyObj = (Map)entry.getValue();
                    int id = Convert.toInt(aesKeyObj.get("id"), 0);
                    int type = Convert.toInt(aesKeyObj.get("type"), 0);
                    String aesKey = Convert.toStr(aesKeyObj.get("aesKey"), "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
                    String aesIV = Convert.toStr(aesKeyObj.get("aesIV"), "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
                    cmdValue = ArrayUtils.addAll(ProtocolUtil.long2Bytes(id, 3), (byte)type);
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.hexStringToBytes(aesKey));
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.hexStringToBytes(aesIV));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "aesCRC": {
                    int cmdKey = 73;
                    Map aesCRCObj = (Map)entry.getValue();
                    int aesKeyID = Convert.toInt(aesCRCObj.get("id"), 0);
                    int aesKeyType = Convert.toInt(aesCRCObj.get("type"), 0);
                    String aesCRC = Convert.toStr(aesCRCObj.get("aesCRC"), "");
                    cmdValue = ArrayUtils.addAll(ProtocolUtil.long2Bytes(aesKeyID, 3), (byte)aesKeyType);
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.hexStringToBytes(aesCRC));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "wifiList": {
                    int cmdKey = 74;
                    List wifiList = (List)entry.getValue();
                    for (Map wifi : wifiList) {
                        int wifi_index = Convert.toInt(wifi.get("index"), 0);
                        int wifi_flag = Convert.toInt(wifi.get("enable"), 0);
                        int isConnected = Convert.toInt(wifi.get("isConnected"), 0);
                        String nameStr = Convert.toStr(wifi.get("name"), "");
                        String passwordStr = Convert.toStr(wifi.get("password"), "");
                        byte[] wifi_name = BytesHexStrUtil.string2BytesByUTF_8(nameStr);
                        byte[] wifi_password = BytesHexStrUtil.string2BytesByUTF_8(passwordStr);
                        cmdValue = new byte[]{(byte)(wifi_flag << 7 | isConnected << 6 | wifi_index & 0x3F), (byte)wifi_name.length, (byte)wifi_password.length};
                        cmdValue = ArrayUtils.addAll(cmdValue, wifi_name);
                        cmdValue = ArrayUtils.addAll(cmdValue, wifi_password);
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "catm": {
                    int cmdKey = 75;
                    Map catM = (Map)entry.getValue();
                    int iotMode = Convert.toInt(catM.get("iotMode"), 0);
                    int eMTC = Convert.toInt(catM.get("emtc"), 0);
                    int eMTC_value = Convert.toInt(catM.get("emtcValue"), 0);
                    int NBIOT = Convert.toInt(catM.get("nbiot"), 0);
                    int NBIOT_value = Convert.toInt(catM.get("nbiotValue"), 0);
                    long gsm = Convert.toInt(catM.get("gsm"), 0).intValue();
                    long eMTBand = Convert.toInt(catM.get("eMTBand"), 0).intValue();
                    long nbBand = Convert.toInt(catM.get("nbBand"), 0).intValue();
                    cmdValue = new byte[]{(byte)(iotMode & 0xFF), (byte)eMTC, (byte)eMTC_value, (byte)NBIOT, (byte)NBIOT_value};
                    cmdValue = ArrayUtils.addAll(cmdValue, (byte)gsm);
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(eMTBand, 12));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(nbBand, 12));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "apnList": {
                    int cmdKey = 76;
                    List apnList = (List)entry.getValue();
                    for (Map apn : apnList) {
                        int index = Convert.toInt(apn.get("index"), 0);
                        int apnList_plmn = Convert.toInt(apn.get("plmn"), 0);
                        String apnList_apn = Convert.toStr(apn.get("apn"), "");
                        String apnList_username = Convert.toStr(apn.get("username"), "");
                        String apnList_password = Convert.toStr(apn.get("password"), "");
                        cmdValue = ProtocolUtil.long2Bytes(index, 2);
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(apnList_plmn, 3));
                        cmdValue = ArrayUtils.addAll(cmdValue, (byte)apnList_apn.length(), (byte)apnList_username.length(), (byte)apnList_password.length());
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByASCII(apnList_apn));
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByASCII(apnList_username));
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByASCII(apnList_password));
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "apnNow": {
                    int cmdKey = 77;
                    Map apnNowList = (Map)entry.getValue();
                    int apnNow_plmn = Convert.toInt(apnNowList.get("plmn"), 0);
                    String apnNow_apn = Convert.toStr(apnNowList.get("apn"), "");
                    String apnNow_username = Convert.toStr(apnNowList.get("username"), "");
                    String apnNow_password = Convert.toStr(apnNowList.get("password"), "");
                    cmdValue = ProtocolUtil.long2Bytes(apnNow_plmn, 3);
                    cmdValue = ArrayUtils.addAll(cmdValue, (byte)apnNow_apn.length(), (byte)apnNow_username.length(), (byte)apnNow_password.length());
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByASCII(apnNow_apn));
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByASCII(apnNow_username));
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByASCII(apnNow_password));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "gsmBand": {
                    int cmdKey = 78;
                    cmdValue = new byte[]{Convert.toByte(entry.getValue(), (byte)0)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "networkType": {
                    int cmdKey = 79;
                    cmdValue = new byte[]{Convert.toByte(entry.getValue(), (byte)0)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "powerLowAlert": {
                    int cmdKey = 80;
                    Map powerAlert = (Map)entry.getValue();
                    int powerLow = Convert.toInt(powerAlert.get("power"), 0);
                    int voiceLow = Convert.toInt(powerAlert.get("voice"), 0);
                    int power_status = Convert.toInt(powerAlert.get("powerOFF"), 0) << 7;
                    power_status |= Convert.toInt(powerAlert.get("powerON"), 0) << 6;
                    power_status |= Convert.toInt(powerAlert.get("status"), 0) << 5;
                    power_status |= Convert.toInt(powerAlert.get("voiceStatus"), 0) << 4;
                    power_status |= Convert.toInt(powerAlert.get("powerOFFSMS"), 0) << 3;
                    power_status |= Convert.toInt(powerAlert.get("powerONSMS"), 0) << 2;
                    cmdValue = new byte[]{(byte)(powerLow & 0xFF), (byte)(voiceLow & 0xFF), 0, (byte)((power_status |= Convert.toInt(powerAlert.get("powerOFFLoc"), 0) << 1) & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "geoAlert": {
                    int cmdKey = 81;
                    List geoAlertList = (List)entry.getValue();
                    for (Map geoAlert : geoAlertList) {
                        int geoIndex = Convert.toInt(geoAlert.get("index"), 0);
                        int geoStatus = Convert.toInt(geoAlert.get("status"), 0);
                        int geoDirection = Convert.toInt(geoAlert.get("direction"), 0);
                        int geoType = Convert.toInt(geoAlert.get("type"), 0);
                        int geoRadius = Convert.toInt(geoAlert.get("radius"), 0);
                        List geoLatlng = (List)geoAlert.get("latlng");
                        if (geoLatlng == null || geoLatlng.size() == 0) continue;
                        int geoPoints = geoLatlng.size();
                        cmdValue = new byte[]{(byte)(geoIndex & 0xF | geoPoints << 4 & 0xF0), (byte)(geoStatus & 1 | (geoDirection & 1) << 1 | (geoType & 1) << 2), (byte)(geoRadius & 0xFF), (byte)(geoRadius >> 8 & 0xFF)};
                        for (Map latlng : geoLatlng) {
                            double geo_lat = Convert.toDouble(latlng.get("lat"), 0.0);
                            double geo_lng = Convert.toDouble(latlng.get("lng"), 0.0);
                            cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.latlng2Bytes(geo_lat, geo_lng));
                        }
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "motionAlert": {
                    int cmdKey = 82;
                    Map motionAlert = (Map)entry.getValue();
                    int motionStatus = Convert.toInt(motionAlert.get("status"), 0);
                    int motionDial = Convert.toInt(motionAlert.get("dial"), 0);
                    int staticTime = Convert.toInt(motionAlert.get("staticTime"), 0);
                    int moveTime = Convert.toInt(motionAlert.get("moveTime"), 0);
                    cmdValue = new byte[]{(byte)(staticTime & 0xFF), (byte)(staticTime >> 8 & 0xFF), (byte)(moveTime & 0xFF), (byte)(moveTime >> 8 & 0x3F | motionDial << 6 | motionStatus << 7)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "noMotionAlert": {
                    int cmdKey = 83;
                    Map noMotionAlert = (Map)entry.getValue();
                    int noMotionStatus = Convert.toInt(noMotionAlert.get("status"), 0);
                    int noMotionDial = Convert.toInt(noMotionAlert.get("dial"), 0);
                    int noMotionTime = Convert.toInt(noMotionAlert.get("time"), 0);
                    cmdValue = new byte[]{(byte)(noMotionTime & 0xFF), (byte)(noMotionTime >> 8 & 0xFF), (byte)(noMotionTime >> 16 & 0xFF), (byte)(noMotionTime >> 24 & 0x3F | noMotionDial << 6 | noMotionStatus << 7)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "overSpeedAlert": {
                    int cmdKey = 84;
                    Map overSpeedAlert = (Map)entry.getValue();
                    int overSpeed_status = Convert.toInt(overSpeedAlert.get("status"), 0);
                    int overSpeed_speed = Convert.toInt(overSpeedAlert.get("speed"), 0);
                    cmdValue = new byte[]{(byte)(overSpeed_speed & 0xFF), (byte)(overSpeed_speed >> 8 & 0xFF | overSpeed_status << 7)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "tiltAlert": {
                    int cmdKey = 85;
                    Map tiltAlert = (Map)entry.getValue();
                    int tiltStatus = Convert.toInt(tiltAlert.get("status"), 0);
                    int tiltDial = Convert.toInt(tiltAlert.get("dial"), 0);
                    int tiltAngle = Convert.toInt(tiltAlert.get("angle"), 0);
                    int tiltTime = Convert.toInt(tiltAlert.get("time"), 0);
                    cmdValue = new byte[]{(byte)(tiltTime & 0xFF), (byte)(tiltTime >> 8 & 0xFF), (byte)(tiltAngle & 0xFF), (byte)(tiltDial << 6 | tiltStatus << 7)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "fallDownAlert": {
                    int cmdKey = 86;
                    Map fallDownAlert = (Map)entry.getValue();
                    int fallDownStatus = Convert.toInt(fallDownAlert.get("status"), 0);
                    int fallDownDial = Convert.toInt(fallDownAlert.get("dial"), 0);
                    int fallDownAllway = Convert.toInt(fallDownAlert.get("allwayOn"), 0);
                    int fallDownLevel = Convert.toInt(fallDownAlert.get("level"), 0);
                    cmdValue = new byte[]{(byte)(fallDownLevel & 0xF | fallDownAllway << 5 | fallDownDial << 6 | fallDownStatus << 7)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "welfareAlert": {
                    int cmdKey = 87;
                    Map welfareAlert = (Map)entry.getValue();
                    int welfareValue = Convert.toInt(welfareAlert.get("value"), 0);
                    cmdValue = ProtocolUtil.long2Bytes(welfareValue |= Convert.toInt(welfareAlert.get("status"), 0) << 31, 4);
                    if (welfareAlert.get("time") != null) {
                        int welfareTime = Convert.toInt(welfareAlert.get("time"), 0);
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(welfareTime |= Convert.toInt(welfareAlert.get("dial"), 0) << 31, 4));
                    }
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "notificationAlert": {
                    int cmdKey = 88;
                    Map notificationAlert = (Map)entry.getValue();
                    int notification_Status = Convert.toInt(notificationAlert.get("status"), 0);
                    int notification_customerID = Convert.toInt(notificationAlert.get("customerID"), 0);
                    int notification_centreID = Convert.toInt(notificationAlert.get("centreID"), 0);
                    byte[] notification_url = BytesHexStrUtil.string2BytesByUTF_8(Convert.toStr(notificationAlert.get("url"), ""));
                    cmdValue = new byte[]{(byte)(notification_Status << 7)};
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(notification_customerID, 4));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(notification_centreID, 4));
                    cmdValue = ArrayUtils.addAll(cmdValue, notification_url);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "motionLevel": {
                    int cmdKey = 89;
                    int motionLevel = Convert.toInt(entry.getValue(), 7);
                    cmdValue = new byte[]{(byte)motionLevel};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "geoDetect": {
                    int cmdKey = 90;
                    Map geoDetect = (Map)entry.getValue();
                    long geoDetect_time = Convert.toLong(geoDetect.get("time"), 0L);
                    cmdValue = ProtocolUtil.long2Bytes(geoDetect_time |= (long)(Convert.toInt(geoDetect.get("status"), 0) << 31), 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "stepCollect": {
                    int cmdKey = 91;
                    Map stepCollect = (Map)entry.getValue();
                    long stepCollect_time = Convert.toLong(stepCollect.get("time"), 0L);
                    cmdValue = ProtocolUtil.long2Bytes(stepCollect_time |= (long)(Convert.toInt(stepCollect.get("status"), 0) << 31), 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "dogBarking": {
                    int cmdKey = 92;
                    Map dogBarking = (Map)entry.getValue();
                    int dogBarking_level = Convert.toInt(dogBarking.get("level"), 0);
                    long dogBarking_time = Convert.toLong(dogBarking.get("time"), 0L);
                    cmdValue = new byte[]{(byte)(dogBarking_level |= Convert.toInt(dogBarking.get("status"), 0) << 7)};
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(dogBarking_time, 4));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "alertLevel": {
                    int cmdKey = 93;
                    Map alertLevel = (Map)entry.getValue();
                    int level_noMotion = Convert.toInt(alertLevel.get("noMotion"), 7);
                    cmdValue = new byte[]{(byte)level_noMotion};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "sideButton": {
                    int cmdKey = 94;
                    Map sideButton = (Map)entry.getValue();
                    int sideButton_flag = Convert.toInt(sideButton.get("status"), 0) << 7;
                    sideButton_flag |= Convert.toInt(sideButton.get("dial"), 0) << 6;
                    cmdValue = new byte[]{(byte)(sideButton_flag |= Convert.toInt(sideButton.get("sms"), 0) << 5)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "homeDetect": {
                    int cmdKey = 95;
                    Map homeDetect = (Map)entry.getValue();
                    long homeDetect_time = Convert.toLong(homeDetect.get("time"), 0L);
                    cmdValue = ProtocolUtil.long2Bytes(homeDetect_time |= (long)(Convert.toInt(homeDetect.get("status"), 0) << 31), 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "wifiWhiteList": {
                    void wifiWhiteList;
                    int cmdKey = 98;
                    List list = (List)entry.getValue();
                    for (Map map : wifiWhiteList) {
                        void wifiWhite_describe;
                        void wifiWhite_lng;
                        void wifiWhite_lat;
                        void wifiWhite_mac;
                        void wifiWhite_index;
                        void wifiWhite_enable;
                        void wifiWhite;
                        int n = Convert.toInt(wifiWhite.get("index"), 0);
                        int n2 = Convert.toInt(wifiWhite.get("enable"), 0);
                        String string = Convert.toStr(wifiWhite.get("mac"), "00:00:00:00:00:00");
                        double d = Convert.toDouble(wifiWhite.get("lat"), 0.0);
                        double d2 = Convert.toDouble(wifiWhite.get("lng"), 0.0);
                        String string2 = Convert.toStr(wifiWhite.get("describe"), "");
                        cmdValue = new byte[]{(byte)(wifiWhite_enable << 7 | wifiWhite_index & 0x7F)};
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.mac2Bytes((String)wifiWhite_mac, false));
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.latlng2Bytes((double)wifiWhite_lat, (double)wifiWhite_lng));
                        if (wifiWhite_describe != null) {
                            cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8((String)wifiWhite_describe));
                        }
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "nightMode": {
                    void nm_to2;
                    void nm_to1;
                    void nm_from2;
                    void nm_from1;
                    void nightModeStatus;
                    void nm_to;
                    String nm_toStr;
                    void nm_from;
                    String nm_fromStr;
                    void nightMode;
                    int cmdKey = 99;
                    Map map = (Map)entry.getValue();
                    int wifiWhite = Convert.toInt(nightMode.get("status"), 0);
                    String wifiWhite_index = Convert.toStr(nightMode.get("from"), "00:00");
                    nm_fromStr = nm_fromStr.trim().length() > 0 ? nm_fromStr : "00:00";
                    String[] wifiWhite_enable = nm_fromStr.split(":");
                    int wifiWhite_mac = Convert.toInt(nm_from[0], 0);
                    int wifiWhite_lat = Convert.toInt(nm_from[1], 0);
                    String string = Convert.toStr(nightMode.get("to"), "00:00");
                    nm_toStr = nm_toStr.trim().length() > 0 ? nm_toStr : "00:00";
                    String[] wifiWhite_lng = nm_toStr.split(":");
                    int n = Convert.toInt(nm_to[0], 0);
                    int wifiWhite_describe = Convert.toInt(nm_to[1], 0);
                    cmdValue = new byte[]{(byte)(nightModeStatus << 7), (byte)(nm_from1 & 0xFF), (byte)(nm_from2 & 0xFF), (byte)(nm_to1 & 0xFF), (byte)(nm_to2 & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "network": {
                    void network_name;
                    void band;
                    void strength;
                    void network;
                    int cmdKey = 100;
                    Map map = (Map)entry.getValue();
                    int n = Convert.toInt(network.get("strength"), 0);
                    long l = Convert.toLong(network.get("band"), 0L);
                    String string = Convert.toStr(network.get("name"), "");
                    cmdValue = new byte[]{(byte)(strength & 0xFF)};
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes((long)band, 4));
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8((String)network_name));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "IMSI": {
                    void imsi;
                    int cmdKey = 102;
                    String string = Convert.toStr(entry.getValue(), "000000000000000");
                    cmdValue = BytesHexStrUtil.string2BytesByUTF_8((String)imsi);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "homeWifiMatch": {
                    void noMatched;
                    void matched;
                    void homeWifiMatch;
                    int cmdKey = 103;
                    Map map = (Map)entry.getValue();
                    int n = Convert.toInt(homeWifiMatch.get("matched"), 0);
                    int n3 = Convert.toInt(homeWifiMatch.get("noMatched"), 0);
                    cmdValue = new byte[]{(byte)(matched & 0xFF), (byte)(noMatched & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "CLIR": {
                    void CLIR;
                    int cmdKey = 105;
                    int n = Convert.toInt(entry.getValue(), 0);
                    cmdValue = new byte[]{(byte)(CLIR & 0xFF)};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "weather": {
                    void time2;
                    void weather;
                    int cmdKey = 106;
                    Map map = (Map)entry.getValue();
                    int n = Convert.toInt(weather.get("time1"), 21600);
                    int n4 = Convert.toInt(weather.get("time2"), 1200);
                    cmdValue = ProtocolUtil.long2Bytes(time1 |= Convert.toInt(weather.get("status"), 0) << 31, 4);
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes((long)time2, 4));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "beaconList": {
                    void beaconList;
                    int cmdKey = 115;
                    List list = (List)entry.getValue();
                    for (Map map : beaconList) {
                        void beacon_describe;
                        void beacon_lng;
                        void beacon_lat;
                        void beacon_mac;
                        void beacon_index;
                        void beacon_enable;
                        void beacon;
                        int n = Convert.toInt(beacon.get("index"), 0);
                        int n5 = Convert.toInt(beacon.get("enable"), 0);
                        String string = Convert.toStr(beacon.get("mac"), "00:00:00:00:00:00");
                        double d = Convert.toDouble(beacon.get("lat"), 0.0);
                        double d3 = Convert.toDouble(beacon.get("lng"), 0.0);
                        String string3 = Convert.toStr(beacon.get("describe"), "");
                        cmdValue = new byte[]{(byte)(beacon_enable << 7 | beacon_index & 0x7F)};
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.mac2Bytes((String)beacon_mac, false));
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.latlng2Bytes((double)beacon_lat, (double)beacon_lng));
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByUTF_8((String)beacon_describe));
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "findMe": {
                    void findMeMap;
                    int cmdKey = 116;
                    Map map = (Map)entry.getValue();
                    long beacon = Convert.toInt(findMeMap.get("times"), 0).intValue();
                    findMe_flag |= (long)(Convert.toInt(findMeMap.get("playIndex"), 0) << 8);
                    cmdValue = ProtocolUtil.long2Bytes((long)(findMe_flag |= (long)(Convert.toInt(findMeMap.get("sound"), 0) << 16)), 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "extraControl": {
                    void ex_byte;
                    void i;
                    void extraControl;
                    int cmdKey = 117;
                    Map beacon_enable = (Map)entry.getValue();
                    long beacon_mac = Convert.toLong(extraControl.get("flagValue"), 0L);
                    long l = 0L;
                    boolean bl = false;
                    while (i < 32) {
                        void ex_data;
                        ex_byte |= (long)(Convert.toInt(extraControl.get("bit" + (int)i), ProtocolUtil.getbit((long)ex_data, (int)i, (int)(i + true))) << i);
                        ++i;
                    }
                    cmdValue = ProtocolUtil.long2Bytes((long)ex_byte, 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "runStepAlert": {
                    void runStepAlert;
                    int cmdKey = 119;
                    Map i = (Map)entry.getValue();
                    long beacon_describe = Convert.toInt(runStepAlert.get("time"), 0).intValue();
                    runStep |= (long)(Convert.toInt(runStepAlert.get("count"), 0) << 8);
                    runStep |= (long)(Convert.toInt(runStepAlert.get("status"), 0) << 16);
                    cmdValue = ProtocolUtil.long2Bytes((long)(runStep |= (long)(Convert.toInt(runStepAlert.get("call"), 0) << 17)), 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "deviceState": {
                    void deviceState;
                    int cmdKey = 120;
                    int n = Convert.toInt(entry.getValue(), 0);
                    cmdValue = new byte[]{(byte)deviceState};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "fallDownTime": {
                    void fallDownTime;
                    int cmdKey = 121;
                    long l = Convert.toLong(entry.getValue(), 0L);
                    cmdValue = ProtocolUtil.long2Bytes((long)fallDownTime, 2);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "spo2Interval": {
                    void spo2Interval;
                    int cmdKey = 122;
                    Map map = (Map)entry.getValue();
                    long l = Convert.toInt(spo2Interval.get("status"), 0) << 31;
                    cmdValue = ProtocolUtil.long2Bytes((long)(spo2 |= (long)Convert.toInt(spo2Interval.get("interval"), 0).intValue()), 4);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "motionAlertExt": {
                    void preAlertTime;
                    void motionAlertExt;
                    int cmdKey = 124;
                    Map map = (Map)entry.getValue();
                    long l = Convert.toInt(motionAlertExt.get("preAlertTime"), 3).intValue();
                    cmdValue = ProtocolUtil.long2Bytes((long)preAlertTime, 2);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "sosAlertExt": {
                    void voiceTime;
                    int cmdKey = 125;
                    int n = Convert.toInt(entry.getValue(), 1);
                    cmdValue = new byte[]{(byte)voiceTime};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "voiceParam": {
                    void voiceInterval;
                    int cmdKey = 126;
                    int n = Convert.toInt(entry.getValue(), 1);
                    cmdValue = new byte[]{(byte)voiceInterval};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "sub1G": {
                    void syncWord;
                    void sub1G_band;
                    void sub1G;
                    int cmdKey = 128;
                    Map map = (Map)entry.getValue();
                    int n = Convert.toInt(sub1G.get("status"), 0);
                    sub1G_flag |= Convert.toInt(sub1G.get("lowBattery"), 0) << 1;
                    int n6 = Convert.toInt(sub1G.get("band"), 0);
                    long l = Convert.toLong(sub1G.get("syncWord"), 0L);
                    cmdValue = new byte[]{(byte)(sub1G_flag |= Convert.toInt(sub1G.get("fallDown"), 0) << 2), (byte)sub1G_band};
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes((long)syncWord, 2));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "sub1GWhiteList": {
                    String sub1GWhite;
                    void sub1GWhiteList;
                    int cmdKey = 129;
                    List list = (List)entry.getValue();
                    for (Map map : sub1GWhiteList) {
                        void sub1GList_flag;
                        long sub1GList_deviceID;
                        long l = Convert.toInt(sub1GWhite.get("index"), 0).intValue();
                        sub1GList_flag |= (long)(Convert.toInt(sub1GWhite.get("status"), 0) << 7);
                        long l2 = 0L;
                        if (sub1GWhite.get("deviceID") instanceof String) {
                            String sub1GList_deviceIDStr;
                            String string = Convert.toStr(sub1GWhite.get("deviceID"), "0");
                            if (sub1GList_deviceIDStr.isEmpty()) {
                                sub1GList_deviceIDStr = "0";
                            }
                            sub1GList_deviceID = Long.parseLong(sub1GList_deviceIDStr, 16);
                        } else if (sub1GWhite.get("deviceID") instanceof Long) {
                            sub1GList_deviceID = Convert.toLong(sub1GWhite.get("deviceID"), 0L);
                        }
                        cmdValue = new byte[]{(byte)sub1GList_flag};
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(sub1GList_deviceID, 4));
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "token": {
                    void tokenStr;
                    int cmdKey = 130;
                    String string = Convert.toStr(entry.getValue(), "");
                    cmdValue = BytesHexStrUtil.string2BytesByUTF_8((String)tokenStr);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "testAlert": {
                    void numberStr;
                    int cmdKey = 131;
                    String sub1GWhite = Convert.toStr(entry.getValue(), "");
                    cmdValue = BytesHexStrUtil.string2BytesByUTF_8((String)numberStr);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "nfc": {
                    void nfc_message;
                    void nfc_status;
                    void nfcMap;
                    int cmdKey = 132;
                    Map sub1GList_flag = (Map)entry.getValue();
                    int n = Convert.toInt(nfcMap.get("status"), 0);
                    String sub1GList_deviceID = Convert.toStr(nfcMap.get("message"), "");
                    cmdValue = new byte[]{(byte)nfc_status};
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByASCII((String)nfc_message));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "lora": {
                    void lora_band;
                    void lora;
                    int cmdKey = 133;
                    Map map = (Map)entry.getValue();
                    int sub1GList_deviceIDStr = Convert.toInt(lora.get("status"), 0);
                    int n = Convert.toInt(lora.get("band"), 0);
                    cmdValue = new byte[]{(byte)(lora_flag |= Convert.toInt(lora.get("lowBattery"), 0) << 1), (byte)lora_band};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "loraWhiteList": {
                    Object sub1GList_deviceIDStr;
                    void loraWhiteList;
                    int cmdKey = 134;
                    List list = (List)entry.getValue();
                    for (Map map : loraWhiteList) {
                        void loraList_deviceType;
                        void loraList_flag;
                        long loraList_deviceID;
                        void loraWhite;
                        long l = Convert.toInt(loraWhite.get("index"), 0).intValue();
                        loraList_flag |= (long)(Convert.toInt(loraWhite.get("status"), 0) << 7);
                        long l3 = Convert.toInt(loraWhite.get("deviceType"), 0).intValue();
                        long l4 = 0L;
                        if (loraWhite.get("deviceID") instanceof String) {
                            String string = Convert.toStr(loraWhite.get("deviceID"), "0");
                            if (sub1GList_deviceIDStr.isEmpty()) {
                                sub1GList_deviceIDStr = "0";
                            }
                            loraList_deviceID = Long.parseLong((String)sub1GList_deviceIDStr, 16);
                        } else if (loraWhite.get("deviceID") instanceof Long) {
                            loraList_deviceID = Convert.toLong(loraWhite.get("deviceID"), 0L);
                        }
                        cmdValue = new byte[]{(byte)loraList_flag};
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes((long)loraList_deviceType, 2));
                        cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.long2Bytes(loraList_deviceID, 4));
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "voip": {
                    void accountInfo;
                    void voip_flag;
                    void voip;
                    int cmdKey = 144;
                    Map map = (Map)entry.getValue();
                    long loraWhite = Convert.toInt(voip.get("status"), 0) << 7;
                    String string = Convert.toStr(voip.get("accountInfo"), "");
                    cmdValue = new byte[]{(byte)voip_flag};
                    cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByASCII((String)accountInfo));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "voipList": {
                    Map accountInfo2;
                    void voipList;
                    int cmdKey = 145;
                    List loraList_deviceType = (List)entry.getValue();
                    for (Map loraList_deviceID : voipList) {
                        void voipMap;
                        long l = Convert.toInt(voipMap.get("status"), 0) << 7;
                        String string = Convert.toStr(voipMap.get("accountInfo"), "");
                        cmdValue = new byte[]{(byte)(voipList_flag |= (long)Convert.toInt(voipMap.get("index"), 0).intValue())};
                        cmdValue = ArrayUtils.addAll(cmdValue, BytesHexStrUtil.string2BytesByASCII((String)((Object)accountInfo2)));
                        cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    }
                    break;
                }
                case "wifiHotspot": {
                    void wifiHotspotNameBytes;
                    void wifiHotspot_mac;
                    void wifiHotspot_name;
                    void wifiHotspot;
                    int cmdKey = 208;
                    Map map = (Map)entry.getValue();
                    String voipMap = Convert.toStrNoEmpty(wifiHotspot.get("mac"), "00:00:00:00:00:00");
                    String voipList_flag = Convert.toStrNoEmpty(wifiHotspot.get("name"), "00:00:00:00:00:00");
                    Object sub1GList_deviceIDStr = BytesHexStrUtil.string2BytesByUTF_8((String)wifiHotspot_name);
                    cmdValue = ProtocolUtil.mac2Bytes((String)wifiHotspot_mac, false);
                    cmdValue = ArrayUtils.add(cmdValue, (byte)((void)wifiHotspotNameBytes).length);
                    cmdValue = ArrayUtils.addAll(cmdValue, (byte[])wifiHotspotNameBytes);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "ethernet": {
                    void ethernet_dns2;
                    void ethernet_dns1;
                    void ethernet_gateway;
                    void ethernet_netmask;
                    void ethernet_ipv4;
                    void ethernet_mac;
                    void ipMode;
                    void ethernet;
                    int cmdKey = 209;
                    Map accountInfo2 = (Map)entry.getValue();
                    int n = Convert.toInt(ethernet.get("ipMode"), 0);
                    String string = Convert.toStrNoEmpty(ethernet.get("mac"), "00:00:00:00:00:00");
                    String string4 = Convert.toStrNoEmpty(ethernet.get("ipv4"), "0.0.0.0");
                    String string5 = Convert.toStrNoEmpty(ethernet.get("netmask"), "0.0.0.0");
                    String string6 = Convert.toStrNoEmpty(ethernet.get("gateway"), "0.0.0.0");
                    String string7 = Convert.toStrNoEmpty(ethernet.get("dns1"), "0.0.0.0");
                    String string8 = Convert.toStrNoEmpty(ethernet.get("dns2"), "0.0.0.0");
                    cmdValue = new byte[]{(byte)ipMode};
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.mac2Bytes((String)ethernet_mac, false));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.ipAddr2Bytes((String)ethernet_ipv4));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.ipAddr2Bytes((String)ethernet_netmask));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.ipAddr2Bytes((String)ethernet_gateway));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.ipAddr2Bytes((String)ethernet_dns1));
                    cmdValue = ArrayUtils.addAll(cmdValue, ProtocolUtil.ipAddr2Bytes((String)ethernet_dns2));
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "internetAccessMode": {
                    void internetAccessMode3;
                    void internetAccessMode2;
                    void internetAccessMode1;
                    void internetAccessMode;
                    int cmdKey = 210;
                    Map map = (Map)entry.getValue();
                    int n = Convert.toInt(internetAccessMode.get("mode1"), 0);
                    int n7 = Convert.toInt(internetAccessMode.get("mode2"), 0);
                    int n8 = Convert.toInt(internetAccessMode.get("mode3"), 0);
                    cmdValue = new byte[]{(byte)internetAccessMode1, (byte)internetAccessMode2, (byte)internetAccessMode3};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "internetStatus": {
                    void internetStatus;
                    int cmdKey = 211;
                    int n = Convert.toInt(entry.getValue(), 0);
                    cmdValue = new byte[]{(byte)internetStatus};
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                    break;
                }
                case "MBN": {
                    void mbnNameBytes;
                    void mbnState;
                    void mbnName;
                    void mbn;
                    int cmdKey = 225;
                    Map map = (Map)entry.getValue();
                    int n = Convert.toInt(mbn.get("state"), 0);
                    String string = Convert.toStr(mbn.get("name"), "");
                    byte[] byArray = BytesHexStrUtil.string2BytesByUTF_8((String)mbnName);
                    cmdValue = new byte[]{(byte)mbnState, (byte)((void)mbnNameBytes).length};
                    cmdValue = ArrayUtils.addAll(cmdValue, (byte[])mbnNameBytes);
                    cmd_bodyData.addCmdData(cmdKey, cmdValue);
                }
            }
        }
        return cmd_bodyData;
    }
}

