/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdHead;

public class HeadService {
    private int sequenceId = 0;
    public static HeadService INSTANCE = new HeadService();

    private HeadService() {
    }

    public int getSequenceId(boolean isAdd) {
        if (isAdd) {
            ++this.sequenceId;
            return this.sequenceId %= 65535;
        }
        return this.sequenceId;
    }

    public CmdHead analysisHeadData(byte[] headData) {
        CmdHead cmd_headData = new CmdHead();
        int header = headData[0] & 0xFF;
        int properties = headData[1] & 0xFF;
        int length = headData[2] & 0xFF | (headData[3] & 0xFF) << 8;
        int checkCRC = headData[4] & 0xFF | (headData[5] & 0xFF) << 8;
        int sequenceId = headData[6] & 0xFF | (headData[7] & 0xFF) << 8;
        cmd_headData.setHeader(header);
        CmdHead.Propertie propertie = this.analysisHeadPropertie((byte)properties);
        cmd_headData.setPropertie(propertie);
        cmd_headData.setLength(length);
        cmd_headData.setCheckCRC(checkCRC);
        cmd_headData.setSequenceId(sequenceId);
        return cmd_headData;
    }

    public CmdHead getCommandHead(int sequenceId, boolean ack) {
        CmdHead cmd_headData = new CmdHead();
        cmd_headData.getPropertie().setFlagACK(ack);
        cmd_headData.setSequenceId(sequenceId);
        return cmd_headData;
    }

    public CmdHead getCommandHead(int sequenceId, boolean ack, int version) {
        CmdHead cmd_headData = new CmdHead();
        cmd_headData.getPropertie().setFlagACK(ack);
        cmd_headData.getPropertie().setVersion(version);
        cmd_headData.setSequenceId(sequenceId);
        return cmd_headData;
    }

    public CmdHead.Propertie analysisHeadPropertie(byte properties) {
        int version = ProtocolUtil.getbit(properties, 0, 4);
        int flag_ACK = ProtocolUtil.getbit(properties, 4, 5);
        int flag_ERR = ProtocolUtil.getbit(properties, 5, 6);
        int encryption = ProtocolUtil.getbit(properties, 6, 8);
        CmdHead.Propertie propertie = new CmdHead.Propertie();
        propertie.setVersion(version);
        propertie.setFlagACK(flag_ACK == 1);
        propertie.setFlagERR(flag_ERR == 1);
        propertie.setEncryption(encryption);
        return propertie;
    }

    public byte analysisHeadPropertie(CmdHead.Propertie propertie) {
        int properties = propertie.getVersion();
        properties |= (propertie.isFlagACK() ? 1 : 0) << 4;
        properties |= (propertie.isFlagERR() ? 1 : 0) << 5;
        return (byte)(properties |= propertie.getEncryption() << 6);
    }
}

