/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service;

import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.model.KeyValue;
import com.tracker.ev07b.service.BodyService;
import com.tracker.ev07b.service.HeadService;
import com.tracker.ev07b.service.command.CommandConfig;
import com.tracker.ev07b.service.command.CommandData;
import com.tracker.ev07b.service.command.CommandDebug;
import com.tracker.ev07b.service.command.CommandResponse;
import com.tracker.ev07b.service.command.CommandService;
import com.tracker.ev07b.service.command.CommandSystem;
import com.tracker.ev07b.service.command.CommandUpdate;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.CheckCRC;
import com.tracker.util.Convert;
import com.tracker.util.RingBuffer;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class CmdService {
    public static CmdService INSTANCE = new CmdService();

    private CmdService() {
    }

    public String codeAnalysis(byte[] data) {
        StringBuilder analysisKeyData = new StringBuilder();
        int read = 0;
        int headCount = 0;
        while (read + 8 < data.length) {
            if ((data[read] & 0xFF) != 171) {
                if (read + 8 == data.length - 1 && headCount == 0) {
                    analysisKeyData.append("[Check head error]:");
                    analysisKeyData.append("------------------------------------------------------------");
                    analysisKeyData.append("\nNo protocol head[AB]");
                    analysisKeyData.append("\n------------------------------------------------------------");
                }
                ++read;
                continue;
            }
            ++headCount;
            byte[] headData = Arrays.copyOfRange(data, read, read + 8);
            byte[] bodyData = new byte[]{};
            CmdHead cmd_head = HeadService.INSTANCE.analysisHeadData(headData);
            if (data.length < read + cmd_head.getLength() + 8) {
                bodyData = Arrays.copyOfRange(data, read + 8, data.length);
            }
            if (bodyData.length == 0) {
                bodyData = Arrays.copyOfRange(data, read + 8, read + cmd_head.getLength() + 8);
            }
            int cmdType = bodyData[0] & 0xFF;
            int checkCRC = CheckCRC.crc16_bit(bodyData);
            byte[] originalData = ArrayUtils.addAll(headData, bodyData);
            if (analysisKeyData.length() > 0) {
                analysisKeyData.append("\n");
            }
            analysisKeyData.append("[OriginalData]:------------------------------------------------------------");
            analysisKeyData.append("\n");
            analysisKeyData.append(BytesHexStrUtil.bytesToHexString(originalData));
            analysisKeyData.append("\n[Checked]:------------------------------------------------------------");
            analysisKeyData.append("\n[Check Length]    :").append(BytesHexStrUtil.longToHexString(bodyData.length, 2)).append("  (").append(bodyData.length).append(")");
            analysisKeyData.append("\n[Check CRC]       :").append(BytesHexStrUtil.longToHexString(checkCRC, 2)).append("  (").append(checkCRC).append(")");
            CmdHead.Propertie property = cmd_head.getPropertie();
            analysisKeyData.append("\n[HeadData]:------------------------------------------------------------");
            analysisKeyData.append("\n[Header]              :").append(String.format("%02X", cmd_head.getHeader()));
            analysisKeyData.append("\n[Property]            :").append(String.format("%02X", cmd_head.getPropertieValue()));
            Map<String, Object> objectMap = Convert.objectToMap(property);
            analysisKeyData.append("  ").append(Convert.mapToJsonString(objectMap));
            analysisKeyData.append("\n[Length]              :").append(BytesHexStrUtil.longToHexString(cmd_head.getLength(), 2)).append("  (").append(cmd_head.getLength()).append(")");
            analysisKeyData.append("\n[CRC]                 :").append(BytesHexStrUtil.longToHexString(cmd_head.getCheckCRC(), 2)).append("  (").append(cmd_head.getCheckCRC()).append(")");
            analysisKeyData.append("\n[SequenceId]      :").append(BytesHexStrUtil.longToHexString(cmd_head.getSequenceId(), 2));
            analysisKeyData.append("\n[BodyData]:------------------------------------------------------------");
            analysisKeyData.append("\n[Command]         :");
            analysisKeyData.append(String.format("%02X", bodyData[0]));
            analysisKeyData.append("\n");
            int index = 1;
            while (index + 1 < bodyData.length) {
                int length = bodyData[index] & 0xFF;
                int cmdKey = bodyData[index + 1] & 0xFF;
                byte[] cmdValue = new byte[]{};
                if (length > 1) {
                    int lastLength = bodyData.length - index - 1;
                    cmdValue = length <= lastLength ? Arrays.copyOfRange(bodyData, index + 2, index + length + 1) : Arrays.copyOfRange(bodyData, index + 2, bodyData.length);
                }
                CmdBody.CMD cmdData = new CmdBody.CMD(length, cmdKey, cmdValue);
                index += length + 1;
                analysisKeyData.append("\n[Length]:").append(String.format("%02X", cmdData.getCmdLength()));
                analysisKeyData.append(" [Key]:").append(String.format("%02X", cmdData.getCmdKey()));
                analysisKeyData.append(" [Value]:").append(BytesHexStrUtil.bytesToHexString(cmdData.getCmdValue()));
                analysisKeyData.append("\n");
                try {
                    KeyValue encode = null;
                    if (cmdType == 1) {
                        encode = CommandData.INSTANCE.encode(cmdData);
                    } else if (cmdType == 2) {
                        encode = CommandConfig.INSTANCE.encode(cmdData);
                    } else if (cmdType == 3) {
                        encode = CommandService.INSTANCE.encode(cmdData);
                    } else if (cmdType == 4) {
                        encode = CommandSystem.INSTANCE.encode(cmdData);
                    } else if (cmdType == 6) {
                        encode = CommandDebug.INSTANCE.encode(cmdData);
                    } else if (cmdType == 127) {
                        encode = CommandResponse.INSTANCE.encode(cmdData);
                    }
                    Map<String, Object> map = Collections.singletonMap(encode.getKey(), encode.getValue());
                    String jsonString = Convert.mapToJsonString(map);
                    analysisKeyData.append(jsonString).append("\n");
                }
                catch (Exception e) {
                    System.err.println(e);
                    analysisKeyData.append("[Error]: this key encode error\n");
                }
            }
            read += cmd_head.getLength() + 8;
        }
        return analysisKeyData.toString();
    }

    public byte[] updateBodyData(byte[] bodyData, Map<String, Object> keyObj) {
        if ((bodyData[0] & 0xFF) == 171) {
            bodyData = Arrays.copyOfRange(bodyData, 8, bodyData.length);
        }
        int command = bodyData[0] & 0xFF;
        CmdBody cmdBody = null;
        switch (command) {
            case 1: {
                cmdBody = CommandData.INSTANCE.decode(keyObj);
                break;
            }
            case 2: {
                cmdBody = CommandConfig.INSTANCE.decode(keyObj);
                break;
            }
            case 3: {
                cmdBody = CommandService.INSTANCE.decode(keyObj);
                break;
            }
            case 4: {
                cmdBody = CommandSystem.INSTANCE.decode(keyObj);
                break;
            }
            case 6: {
                cmdBody = CommandDebug.INSTANCE.decode(keyObj);
                break;
            }
            case 126: {
                cmdBody = CommandUpdate.INSTANCE.decode(keyObj);
                break;
            }
            case 127: {
                cmdBody = CommandResponse.INSTANCE.decode(keyObj);
            }
        }
        if (cmdBody != null && cmdBody.getCmdData().size() > 0) {
            int length;
            for (int i = 1; i < bodyData.length && (length = bodyData[i] & 0xFF) <= bodyData.length - i; i += length + 1) {
                int bodyKey = bodyData[i + 1] & 0xFF;
                if (cmdBody.getCmdData().get(0).getCmdKey() != bodyKey) continue;
                byte[] newKey = BodyService.INSTANCE.getByteData_cmdList(cmdBody);
                byte[] newBodyData = Arrays.copyOfRange(bodyData, 0, i);
                newBodyData = ArrayUtils.addAll(newBodyData, newKey);
                if (i + length + 1 < bodyData.length) {
                    byte[] bodyData_after = Arrays.copyOfRange(bodyData, i + length + 1, bodyData.length);
                    newBodyData = ArrayUtils.addAll(newBodyData, bodyData_after);
                }
                return newBodyData;
            }
        }
        return null;
    }

    public CmdModel analysis2Model(byte[] cmdData) {
        byte[] headData = Arrays.copyOfRange(cmdData, 0, 8);
        byte[] bodyData = Arrays.copyOfRange(cmdData, 8, cmdData.length);
        CmdHead cmd_headData = HeadService.INSTANCE.analysisHeadData(headData);
        CmdBody cmd_bodyData = BodyService.INSTANCE.analysisBodyData(bodyData);
        return new CmdModel(cmd_headData, cmd_bodyData, cmdData);
    }

    public CmdModel analysis2Model(byte[] headData, byte[] bodyData) {
        CmdHead cmd_headData = HeadService.INSTANCE.analysisHeadData(headData);
        CmdBody cmd_bodyData = BodyService.INSTANCE.analysisBodyData(bodyData);
        byte[] originalData = ArrayUtils.addAll(headData, bodyData);
        return new CmdModel(cmd_headData, cmd_bodyData, originalData);
    }

    private List<CmdModel> analysis2ModelList(byte[] data) {
        ArrayList<CmdModel> cmdList = new ArrayList<CmdModel>();
        int read = 0;
        while (read + 8 < data.length) {
            if ((data[read] & 0xFF) != 171) {
                ++read;
                continue;
            }
            byte[] headData = Arrays.copyOfRange(data, read, read + 8);
            CmdHead cmd_headData = HeadService.INSTANCE.analysisHeadData(headData);
            if (data.length < read + cmd_headData.getLength() + 8) {
                ++read;
                continue;
            }
            byte[] bodyData = Arrays.copyOfRange(data, read + 8, read + cmd_headData.getLength() + 8);
            int checkCRC = CheckCRC.crc16_bit(bodyData);
            if (cmd_headData.getCheckCRC() != checkCRC) {
                ++read;
                continue;
            }
            CmdBody cmd_bodyData = BodyService.INSTANCE.analysisBodyData(bodyData);
            byte[] originalData = ArrayUtils.addAll(headData, bodyData);
            cmdList.add(new CmdModel(cmd_headData, cmd_bodyData, originalData));
            read += cmd_headData.getLength() + 8;
        }
        return cmdList;
    }

    public List<Map<String, Object>> protocolAnalysis(byte[] data) {
        return this.protocolAnalysis(data, false);
    }

    public List<Map<String, Object>> protocolAnalysis(byte[] data, boolean isReq) {
        ArrayList<Map<String, Object>> cmdDataList = new ArrayList<Map<String, Object>>();
        List<CmdModel> cmdModelList = this.analysis2ModelList(data);
        for (CmdModel cmdModel : cmdModelList) {
            Map<String, Object> cmdData = this.protocolAnalysis(cmdModel, isReq);
            cmdDataList.add(cmdData);
        }
        return cmdDataList;
    }

    private Map<String, Object> getCmdDataObject(CmdModel cmdModel) {
        HashMap<String, Constable> cmdHeadData = new HashMap<String, Constable>(5);
        cmdHeadData.put("sequenceId", Integer.valueOf(cmdModel.getHeadData().getSequenceId()));
        cmdHeadData.put("length", Integer.valueOf(cmdModel.getHeadData().getLength()));
        cmdHeadData.put("checkCRC", Integer.valueOf(cmdModel.getHeadData().getCheckCRC()));
        cmdHeadData.put("version", Integer.valueOf(cmdModel.getHeadData().getPropertie().getVersion()));
        cmdHeadData.put("flagACK", Boolean.valueOf(cmdModel.getHeadData().getPropertie().isFlagACK()));
        HashMap<String, Integer> cmdBodyData = new HashMap<String, Integer>();
        cmdBodyData.put("cmdType", cmdModel.getBodyData().getCmdType());
        HashMap<String, Object> cmdData = new HashMap<String, Object>(3);
        cmdData.put("cmdHeadData", cmdHeadData);
        cmdData.put("cmdBodyData", cmdBodyData);
        cmdData.put("originalData", cmdModel.getOriginalData());
        return cmdData;
    }

    public Map<String, Object> protocolAnalysis(CmdModel cmdModel) {
        return this.protocolAnalysis(cmdModel, true);
    }

    public Map<String, Object> protocolAnalysis(CmdModel cmdModel, boolean isReq) {
        try {
            Map<String, Object> cmdData = this.getCmdDataObject(cmdModel);
            if (cmdModel.getBodyData() != null) {
                Map cmdBodyData = (Map)cmdData.get("cmdBodyData");
                String errorMsg = cmdModel.getBodyData().getErrorMsg();
                if (errorMsg != null) {
                    cmdBodyData.put("errorData", errorMsg);
                }
                switch (cmdModel.getBodyData().getCmdType()) {
                    case 1: {
                        Map<String, Object> locationData = CommandData.INSTANCE.encode(cmdModel, isReq);
                        cmdBodyData.put("locationData", locationData);
                        break;
                    }
                    case 2: {
                        Map<String, Object> configData = CommandConfig.INSTANCE.encode(cmdModel, isReq);
                        cmdBodyData.put("configData", configData);
                        break;
                    }
                    case 3: {
                        Map<String, Object> servicesData = CommandService.INSTANCE.encode(cmdModel, isReq);
                        cmdBodyData.put("servicesData", servicesData);
                        break;
                    }
                    case 4: {
                        Map<String, Object> systemData = CommandSystem.INSTANCE.encode(cmdModel, isReq);
                        cmdBodyData.put("systemData", systemData);
                        break;
                    }
                    case 6: {
                        Map<String, Object> debugData = CommandDebug.INSTANCE.encode(cmdModel, isReq);
                        cmdBodyData.put("debugData", debugData);
                        break;
                    }
                    case 126: {
                        Map<String, Object> updateData = CommandUpdate.INSTANCE.encode(cmdModel, isReq);
                        cmdBodyData.put("updateData", updateData);
                        break;
                    }
                    case 127: {
                        Map<String, Object> responseData = CommandResponse.INSTANCE.encode(cmdModel, isReq);
                        cmdBodyData.put("responseData", responseData);
                    }
                }
                return cmdData;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public byte[] getByteData(CmdHead cmdHead, byte[] cmdBody) {
        byte[] headData = new byte[8];
        headData[0] = -85;
        CmdHead.Propertie propertie = cmdHead.getPropertie();
        int version = propertie.getVersion();
        int flag_ACK = propertie.isFlagACK() ? 1 : 0;
        int flag_ERR = propertie.isFlagERR() ? 1 : 0;
        int encryption = propertie.getEncryption();
        int properties = encryption << 6 | flag_ERR << 5 | flag_ACK << 4 | version;
        headData[1] = (byte)(properties & 0xFF);
        int length = cmdBody.length;
        headData[2] = (byte)(length & 0xFF);
        headData[3] = (byte)(length >> 8 & 0xFF);
        int checkCRC = CheckCRC.crc16_bit(cmdBody);
        headData[4] = (byte)(checkCRC & 0xFF);
        headData[5] = (byte)(checkCRC >> 8 & 0xFF);
        int sequenceId = cmdHead.getSequenceId();
        headData[6] = (byte)(sequenceId & 0xFF);
        headData[7] = (byte)(sequenceId >> 8 & 0xFF);
        return ArrayUtils.addAll(headData, cmdBody);
    }

    public byte[] getByteData(CmdHead cmdHead, CmdBody cmdBody) {
        byte[] cmdBodyBytes = BodyService.INSTANCE.getByteData_body(cmdBody);
        return this.getByteData(cmdHead, cmdBodyBytes);
    }

    public byte[] getByteData(CmdModel cmdModel) {
        byte[] cmdBodyBytes = BodyService.INSTANCE.getByteData_body(cmdModel.getBodyData());
        return this.getByteData(cmdModel.getHeadData(), cmdBodyBytes);
    }

    public void addBuffer(RingBuffer bufferData, Consumer<CmdModel> consumer) {
        int read = 0;
        while (read + 8 < bufferData.getSize()) {
            if ((bufferData.read(0) & 0xFF) != 171) {
                bufferData.del(1);
                continue;
            }
            if ((bufferData.read(read) & 0xFF) == 171) {
                byte[] headData = bufferData.read(read, read + 8);
                CmdHead cmd_headData = HeadService.INSTANCE.analysisHeadData(headData);
                int cmdData_length = cmd_headData.getLength() + 8;
                if (bufferData.getSize() >= read + cmdData_length) {
                    byte[] bodyData = bufferData.read(read + 8, read + cmdData_length);
                    int checkCRC = CheckCRC.crc16_bit(bodyData);
                    if (cmd_headData.getCheckCRC() == checkCRC) {
                        byte[] originalData = ArrayUtils.addAll(headData, bodyData);
                        CmdBody cmd_bodyData = BodyService.INSTANCE.analysisBodyData(bodyData);
                        CmdModel cmdModel = new CmdModel(cmd_headData, cmd_bodyData, originalData);
                        consumer.accept(cmdModel);
                        bufferData.del(read + cmdData_length);
                        read = 0;
                        continue;
                    }
                }
            }
            ++read;
        }
    }
}

