/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service;

import com.tracker.ev07b.model.CmdBody;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BodyService {
    public static BodyService INSTANCE = new BodyService();

    private BodyService() {
    }

    public CmdBody analysisBodyData(byte[] bodyData) {
        CmdBody cmd_bodyData = new CmdBody();
        int cmdType = bodyData[0] & 0xFF;
        cmd_bodyData.setCmdType(cmdType);
        int readData = 1;
        while (readData + 1 < bodyData.length) {
            int cmdLength = bodyData[readData] & 0xFF;
            int cmdKey = bodyData[readData + 1] & 0xFF;
            byte[] cmdValue = new byte[]{};
            if (cmdLength == 0) {
                if (cmd_bodyData.getCmdDataSize() > 0) {
                    byte[] cmdValue2 = Arrays.copyOfRange(bodyData, readData, bodyData.length);
                    cmd_bodyData.setErrorMsg(BytesHexStrUtil.bytesToHexString(cmdValue2));
                    break;
                }
                cmdValue = Arrays.copyOfRange(bodyData, readData + 2, bodyData.length);
                cmd_bodyData.addCmdData(cmdLength, cmdKey, cmdValue);
                break;
            }
            if (readData + 1 + cmdLength > bodyData.length) {
                byte[] cmdValue2 = Arrays.copyOfRange(bodyData, readData, bodyData.length);
                cmd_bodyData.setErrorMsg(BytesHexStrUtil.bytesToHexString(cmdValue2));
                break;
            }
            if (readData + 2 < bodyData.length) {
                cmdValue = Arrays.copyOfRange(bodyData, readData + 2, readData + 1 + cmdLength);
            }
            readData += cmdLength + 1;
            cmd_bodyData.addCmdData(cmdLength, cmdKey, cmdValue);
        }
        return cmd_bodyData;
    }

    public CmdBody getCommandBody(int cmdType, int cmdKey, byte[] cmdValue) {
        int cmdLength;
        CmdBody cmd_bodyData = new CmdBody();
        cmd_bodyData.setCmdType(cmdType);
        int n = cmdLength = cmdValue != null ? cmdValue.length + 1 : 1;
        if (cmdType > 255) {
            cmdLength = 0;
        }
        cmd_bodyData.addCmdData(cmdLength, cmdKey, cmdValue);
        return cmd_bodyData;
    }

    public byte[] getByteData_body(CmdBody cmd_bodyData) {
        int cmdType = cmd_bodyData.getCmdType();
        byte[] cmd_bodyByte = new byte[]{(byte)cmdType};
        byte[] cmdBytes = this.getByteData_cmdList(cmd_bodyData);
        cmd_bodyByte = ArrayUtils.addAll(cmd_bodyByte, cmdBytes);
        return cmd_bodyByte;
    }

    public byte[] getByteData_cmdList(CmdBody cmd_bodyData) {
        byte[] cmdBytes = null;
        List<CmdBody.CMD> cmdList = cmd_bodyData.getCmdData();
        for (CmdBody.CMD cmd : cmdList) {
            int cmdLength = cmd.getCmdLength();
            int cmdKey = cmd.getCmdKey();
            byte[] cmdValue = cmd.getCmdValue();
            cmdBytes = ArrayUtils.add(cmdBytes, (byte)cmdLength);
            cmdBytes = ArrayUtils.add(cmdBytes, (byte)cmdKey);
            cmdBytes = ArrayUtils.addAll(cmdBytes, cmdValue);
        }
        return cmdBytes;
    }

    public List<byte[]> getByteData_body(CmdBody cmd_bodyData, long maxBodySize) {
        if (maxBodySize < 3L) {
            return null;
        }
        ArrayList<byte[]> bodyGroups = new ArrayList<byte[]>();
        int cmdType = cmd_bodyData.getCmdType();
        byte[] cmd_bodyByte = new byte[]{(byte)cmdType};
        List<CmdBody.CMD> cmdList = cmd_bodyData.getCmdData();
        for (CmdBody.CMD cmd : cmdList) {
            int cmdLength = cmd.getCmdLength();
            int cmdKey = cmd.getCmdKey();
            byte[] cmdValue = cmd.getCmdValue();
            if ((long)(cmd_bodyByte.length + cmdValue.length + 2) > maxBodySize) {
                bodyGroups.add(cmd_bodyByte);
                cmd_bodyByte = new byte[]{(byte)cmdType};
            }
            cmd_bodyByte = ArrayUtils.add(cmd_bodyByte, (byte)cmdLength);
            cmd_bodyByte = ArrayUtils.add(cmd_bodyByte, (byte)cmdKey);
            cmd_bodyByte = ArrayUtils.addAll(cmd_bodyByte, cmdValue);
        }
        bodyGroups.add(cmd_bodyByte);
        return bodyGroups;
    }
}

