/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.encrypt;

import com.tracker.ev07b.service.CmdService;
import com.tracker.util.AESUtil;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.CheckCRC;
import com.tracker.util.Convert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AesEncrypt {
    private static final int CC = 200;
    public static AesEncrypt INSTANCE = new AesEncrypt();

    private AesEncrypt() {
    }

    public String decodeAnalysis(byte[] data, String aesKey, String aesIV) {
        StringBuilder analysisKeyData = new StringBuilder();
        analysisKeyData.append("[OriginalData]:------------------------------------------------------------");
        analysisKeyData.append("\n");
        analysisKeyData.append(BytesHexStrUtil.bytesToHexString(data));
        if (data != null && data.length > 0) {
            int read = 0;
            while (read + 16 < data.length) {
                if ((data[read] & 0xFF) == 165 && read + 16 < data.length) {
                    byte[] headData = Arrays.copyOfRange(data, read, read + 16);
                    int header = headData[read] & 0xFF;
                    int properties = headData[1] & 0xFF;
                    int length = headData[read + 2] & 0xFF | (headData[read + 3] & 0xFF) << 8;
                    int cmdData_length = length + 16;
                    int body_crc = headData[read + 4] & 0xFF | (headData[read + 5] & 0xFF) << 8;
                    int sequenceId = headData[read + 6] & 0xFF | (headData[read + 7] & 0xFF) << 8;
                    int encodeId = headData[read + 8] & 0xFF | (headData[read + 9] & 0xFF) << 8 | (headData[read + 10] & 0xFF) << 16;
                    int encodeType = headData[read + 11] & 0xFF;
                    int cc = headData[read + 12] & 0xFF | (headData[read + 13] & 0xFF) << 8;
                    int head_crc = headData[read + 14] & 0xFF | (headData[read + 15] & 0xFF) << 8;
                    int check_head_crc = CheckCRC.crc16_bit(Arrays.copyOfRange(headData, read, read + 14));
                    analysisKeyData.append("\n[HeadData]:------------------------------------------------------------");
                    analysisKeyData.append("\n[Header]\t:").append(String.format("%02X", header));
                    analysisKeyData.append("\n[Property]\t:").append(String.format("%02X", properties));
                    analysisKeyData.append("\n[BodyLength]\t:").append(BytesHexStrUtil.longToHexString(length, 2)).append("  (").append(length).append(")");
                    analysisKeyData.append("\n[BodyCRC]\t:").append(BytesHexStrUtil.longToHexString(body_crc, 2)).append("  (").append(body_crc).append(")");
                    analysisKeyData.append("\n[HeadCRC]\t:").append(BytesHexStrUtil.longToHexString(head_crc, 2)).append("  (").append(head_crc).append(")");
                    analysisKeyData.append("\n[SequenceId]\t:").append(BytesHexStrUtil.longToHexString(sequenceId, 2));
                    byte[] keyID = Arrays.copyOfRange(headData, read + 8, read + 12);
                    analysisKeyData.append("\n[KeyID]\t:").append(BytesHexStrUtil.bytesToHexString(keyID));
                    analysisKeyData.append("\n    [encodeType]:").append(BytesHexStrUtil.longToHexString(encodeType, 3)).append("  (").append(encodeType).append(")");
                    analysisKeyData.append("\n    [encodeId]\t:").append(String.format("%02X", encodeId)).append("  (").append(encodeId).append(")");
                    analysisKeyData.append("\n[Control Code]\t:").append(BytesHexStrUtil.longToHexString(cc, 2));
                    analysisKeyData.append("\n[Checked]:------------------------------------------------------------");
                    analysisKeyData.append("\n[HeadCRC]\t:").append(BytesHexStrUtil.longToHexString(check_head_crc, 2)).append("  (").append(check_head_crc).append(")");
                    if (head_crc == check_head_crc) {
                        analysisKeyData.append("\n[BodyLength]\t:").append(BytesHexStrUtil.longToHexString(cmdData_length - 16, 2)).append("  (").append(cmdData_length - 16).append(")");
                        if (data.length >= read + cmdData_length) {
                            byte[] bodyData = Arrays.copyOfRange(data, read + 16, read + cmdData_length);
                            int check_body_crc = CheckCRC.crc16_bit(bodyData);
                            analysisKeyData.append("\n[BodyCRC]\t:").append(BytesHexStrUtil.longToHexString(check_body_crc, 2)).append("  (").append(check_body_crc).append(")");
                            if (body_crc == check_body_crc) {
                                byte[] key = BytesHexStrUtil.hexStringToBytes(aesKey);
                                byte[] iv = BytesHexStrUtil.hexStringToBytes(aesIV);
                                byte[] decode = AESUtil.AESDecrypt(key, iv, bodyData);
                                analysisKeyData.append("\n[DecodeData]:------------------------------------------------------------");
                                analysisKeyData.append("\n" + BytesHexStrUtil.bytesToHexString(decode));
                                data = Arrays.copyOfRange(data, read + cmdData_length, data.length);
                                read += cmdData_length;
                                continue;
                            }
                        }
                    }
                }
                ++read;
            }
        }
        return analysisKeyData.toString();
    }

    public List<Map<String, ?>> decode(byte[] data, String aesKey, String aesIV) {
        ArrayList cmdList = new ArrayList();
        if (data != null && data.length > 0) {
            int read = 0;
            while (read + 16 < data.length) {
                HashMap<String, Object> cmd_encode = new HashMap<String, Object>();
                if ((data[read] & 0xFF) == 165 && read + 16 < data.length) {
                    byte[] bodyData;
                    int check_body_crc;
                    byte[] headData = Arrays.copyOfRange(data, read, read + 16);
                    int header = headData[read] & 0xFF;
                    int properties = headData[1] & 0xFF;
                    int length = headData[read + 2] & 0xFF | (headData[read + 3] & 0xFF) << 8;
                    int cmdData_length = length + 16;
                    int body_crc = headData[read + 4] & 0xFF | (headData[read + 5] & 0xFF) << 8;
                    int sequenceId = headData[read + 6] & 0xFF | (headData[read + 7] & 0xFF) << 8;
                    int encodeId = headData[read + 8] & 0xFF | (headData[read + 9] & 0xFF) << 8 | (headData[read + 10] & 0xFF) << 16;
                    int encodeType = headData[read + 11] & 0xFF;
                    int cc = headData[read + 12] & 0xFF | (headData[read + 13] & 0xFF) << 8;
                    int head_crc = headData[read + 14] & 0xFF | (headData[read + 15] & 0xFF) << 8;
                    int check_head_crc = CheckCRC.crc16_bit(Arrays.copyOfRange(headData, read, read + 14));
                    cmd_encode.put("head", header);
                    cmd_encode.put("properties", properties);
                    cmd_encode.put("length", length);
                    cmd_encode.put("bodyCRC", body_crc);
                    cmd_encode.put("headCRC", head_crc);
                    cmd_encode.put("sequenceId", sequenceId);
                    cmd_encode.put("encodeType", encodeType);
                    cmd_encode.put("encodeId", encodeId);
                    cmd_encode.put("cc", cc);
                    if (head_crc == check_head_crc && data.length >= read + cmdData_length && body_crc == (check_body_crc = CheckCRC.crc16_bit(bodyData = Arrays.copyOfRange(data, read + 16, read + cmdData_length)))) {
                        byte[] key = BytesHexStrUtil.hexStringToBytes(aesKey);
                        byte[] iv = BytesHexStrUtil.hexStringToBytes(aesIV);
                        byte[] decode = AESUtil.AESDecrypt(key, iv, bodyData);
                        byte[] originalData = ArrayUtils.addAll(headData, bodyData);
                        cmd_encode.put("decodeData", BytesHexStrUtil.bytesToHexString(decode));
                        cmd_encode.put("originalData", BytesHexStrUtil.bytesToHexString(originalData));
                        data = Arrays.copyOfRange(data, read + cmdData_length, data.length);
                        read += cmdData_length;
                        cmdList.add(cmd_encode);
                        continue;
                    }
                }
                ++read;
                cmdList.add(cmd_encode);
            }
        }
        return cmdList;
    }

    public byte[] encode(byte[] data, Map<String, Object> head) {
        int sequenceId = 0;
        List<Map<String, Object>> maps = CmdService.INSTANCE.protocolAnalysis(data);
        if (maps != null) {
            Map<String, Object> stringObjectMap = maps.get(0);
            Map headMap = (Map)stringObjectMap.get("cmdHeadData");
            sequenceId = Convert.toInt(headMap.get("sequenceId"), 0);
        }
        String aesKey = Convert.toStr(head.get("aesKey"));
        String aesIV = Convert.toStr(head.get("aesIV"));
        byte[] key = BytesHexStrUtil.hexStringToBytes(aesKey);
        byte[] iv = BytesHexStrUtil.hexStringToBytes(aesIV);
        byte[] bodyData = AESUtil.AESEncrypt(key, iv, data);
        byte[] headData = new byte[16];
        headData[0] = -91;
        int properties = 0;
        headData[1] = (byte)(properties & 0xFF);
        int length = bodyData.length;
        headData[2] = (byte)(length & 0xFF);
        headData[3] = (byte)(length >> 8 & 0xFF);
        int body_crc = CheckCRC.crc16_bit(bodyData);
        headData[4] = (byte)(body_crc & 0xFF);
        headData[5] = (byte)(body_crc >> 8 & 0xFF);
        headData[6] = (byte)(sequenceId & 0xFF);
        headData[7] = (byte)(sequenceId >> 8 & 0xFF);
        int encodeId = Convert.toInt(head.get("encodeId"), 0);
        headData[8] = (byte)(encodeId & 0xFF);
        headData[9] = (byte)(encodeId >> 8 & 0xFF);
        headData[10] = (byte)(encodeId >> 16 & 0xFF);
        int encodeType = Convert.toInt(head.get("encodeType"), 0);
        headData[11] = (byte)(encodeType & 0xFF);
        headData[12] = -56;
        headData[13] = 0;
        int head_crc = CheckCRC.crc16_bit(Arrays.copyOfRange(headData, 0, 14));
        headData[14] = (byte)(head_crc & 0xFF);
        headData[15] = (byte)(head_crc >> 8 & 0xFF);
        return ArrayUtils.addAll(headData, bodyData);
    }
}

