/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b;

import com.tracker.ev07b.Protocol;
import com.tracker.ev07b.ProtocolAnalysis;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.util.ArrayUtils;
import com.tracker.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Upgrade2
extends Thread {
    private Logger log = Logger.getLogger(Upgrade2.class.getName());
    private InputStream inputStream;
    private CallBack callBack;
    private volatile boolean isRuning;
    private int bufferSize = 1024;
    private int statekey = 0;
    private int sequenceId = 0;
    private Protocol protocol = ProtocolAnalysis.INSTANCE;
    private DecimalFormat df = new DecimalFormat(".00");
    private BlockingQueue<Map<String, Object>> queue = new ArrayBlockingQueue<Map<String, Object>>(10);

    public Upgrade2(InputStream inputStream, CallBack callBack) {
        this.inputStream = inputStream;
        this.callBack = callBack;
    }

    public int getSequenceId(boolean isAdd) {
        if (isAdd) {
            ++this.sequenceId;
            return this.sequenceId %= 65535;
        }
        return this.sequenceId;
    }

    public void exitThread() {
        this.isRuning = false;
    }

    public void addRequestData(Map<String, Object> data) {
        try {
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendRequestData(int cmdKey, byte[] cmdValue) {
        CmdHead cmd_headData = this.protocol.getCommandHead(this.getSequenceId(true), false);
        CmdBody cmd_bodyData = new CmdBody();
        cmd_bodyData.setCmdType(126);
        cmd_bodyData.addCmdData(0, cmdKey, cmdValue);
        byte[] byteData = this.protocol.getByteData(cmd_headData, cmd_bodyData);
        this.callBack.sendData(byteData);
    }

    public void sendData(int cmdKey, byte[] cmdValue) {
        for (int ERROR_COUNT = 1; ERROR_COUNT <= 3; ++ERROR_COUNT) {
            Map receiveData;
            CmdHead cmd_headData = this.protocol.getCommandHead(this.getSequenceId(true), true);
            CmdBody cmd_bodyData = this.protocol.getCommandBody(126, cmdKey, cmdValue);
            byte[] byteData = this.protocol.getByteData(cmd_headData, cmd_bodyData);
            this.callBack.sendData(byteData);
            Map<String, Object> cmdData = this.callBack.receiveData(this.getSequenceId(false));
            if (cmdData == null || (receiveData = (Map)cmdData.get("cmdBodyData")) == null) continue;
            Map updateData = (Map)receiveData.get("updateData");
            if (updateData == null) {
                updateData = (Map)receiveData.get("responseData");
            }
            if (updateData == null && ERROR_COUNT == 3) {
                this.callBack.message("error", "Update device timeout !");
                this.isRuning = false;
                break;
            }
            if (updateData == null) continue;
            if (cmdKey == 16 || cmdKey == 17 || cmdKey == 18) {
                String resultMsg = (String)updateData.get("returnStatus");
                if (resultMsg.contains("ok")) break;
                if (!resultMsg.contains("error") || ERROR_COUNT != 3) continue;
                this.callBack.message("error", "Update device failure !");
                this.isRuning = false;
                break;
            }
            if (cmdKey == 19) {
                this.statekey = ((Byte)updateData.get("updateStateKey")).byteValue();
                if (this.statekey != 16 && this.statekey != 17 && this.statekey != 18) continue;
                break;
            }
            if (cmdKey != 21) continue;
            this.bufferSize = (Integer)updateData.get("updatePackSize");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block34: {
            ZipEntry entry;
            ByteArrayOutputStream output = null;
            ZipInputStream zis = null;
            float percent = 0.0f;
            this.callBack.init();
            this.isRuning = true;
            this.callBack.setProgressbar(this.df.format(percent));
            this.sendData(21, new byte[0]);
            percent = 2.0f;
            this.callBack.setProgressbar(this.df.format(percent));
            this.sendData(19, new byte[0]);
            percent = 4.0f;
            this.callBack.setProgressbar(this.df.format(percent));
            zis = new ZipInputStream(this.inputStream);
            byte[] buffer = new byte[this.bufferSize];
            byte[] initialData = new byte[]{};
            byte[] firmwareData = new byte[]{};
            while (this.isRuning && (entry = zis.getNextEntry()) != null) {
                int read = 0;
                output = new ByteArrayOutputStream();
                if (entry.getName().contains(".dat")) {
                    while ((read = zis.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    initialData = output.toByteArray();
                } else if (entry.getName().contains(".encrypted")) {
                    while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    firmwareData = output.toByteArray();
                }
                zis.closeEntry();
            }
            int totalSize = initialData.length + firmwareData.length;
            switch (this.statekey) {
                case 16: {
                    this.sendData(16, initialData);
                    percent = 6.0f;
                    this.callBack.setProgressbar(this.df.format(percent));
                    this.callBack.message("info", initialData.length + " of " + totalSize + " total transferred");
                }
                case 17: {
                    int percent_data = 0;
                    while (this.isRuning && percent_data < 100) {
                        Map<String, Object> requestData = this.queue.poll(60L, TimeUnit.SECONDS);
                        if (requestData == null) {
                            this.isRuning = false;
                        }
                        percent_data = (Integer)requestData.get("percent");
                        percent = (float)((double)percent_data * 0.92) + 6.0f;
                        List list = (List)requestData.get("list");
                        block19: for (Map data : list) {
                            int offset = (Integer)data.get("offset");
                            int length = (Integer)data.get("length");
                            if (length > firmwareData.length - offset) {
                                length = firmwareData.length - offset;
                            }
                            int i = 0;
                            while ((double)i < Math.ceil((float)length / (float)this.bufferSize)) {
                                int address = offset + this.bufferSize * i;
                                byte[] addressByte = new byte[]{(byte)(address & 0xFF), (byte)(address >> 8 & 0xFF), (byte)(address >> 16 & 0xFF), (byte)(address >> 24 & 0xFF)};
                                if (length - this.bufferSize * i >= this.bufferSize) {
                                    buffer = Arrays.copyOfRange(firmwareData, address, address + this.bufferSize);
                                } else {
                                    int size = length - this.bufferSize * i;
                                    buffer = Arrays.copyOfRange(firmwareData, address, address + size);
                                }
                                this.sendRequestData(22, ArrayUtils.addAll(addressByte, buffer));
                                this.callBack.setProgressbar(this.df.format(percent += (float)buffer.length / (float)firmwareData.length * 100.0f));
                                this.callBack.message("info", initialData.length + offset + this.bufferSize * i + " of " + totalSize + " total transferred");
                                if (!this.isRuning || percent_data >= 100) continue block19;
                                ++i;
                            }
                        }
                    }
                    if (!this.isRuning) break;
                }
                case 18: {
                    this.sendData(18, new byte[0]);
                    percent = 100.0f;
                    this.callBack.setProgressbar(this.df.format(percent));
                    this.callBack.message("info", "Upgrade complete!");
                }
            }
            if (percent == 100.0f) {
                this.callBack.message("info", "Upgrade Complete!");
                this.log.info("Upgrade Over!");
            } else {
                this.callBack.message("error", "Upgrade Failure!");
                this.log.info("Upgrade Failure!");
            }
            this.callBack.destroyed();
            try {
                IOUtil.close(this.inputStream, output, zis);
            }
            catch (IOException e) {
                this.log.warning("Close inputStream error !" + e);
            }
            break block34;
            catch (Exception e) {
                try {
                    this.log.warning("Update device error !" + e);
                    if (percent == 100.0f) {
                        this.callBack.message("info", "Upgrade Complete!");
                        this.log.info("Upgrade Over!");
                    } else {
                        this.callBack.message("error", "Upgrade Failure!");
                        this.log.info("Upgrade Failure!");
                    }
                    this.callBack.destroyed();
                }
                catch (Throwable throwable) {
                    if (percent == 100.0f) {
                        this.callBack.message("info", "Upgrade Complete!");
                        this.log.info("Upgrade Over!");
                    } else {
                        this.callBack.message("error", "Upgrade Failure!");
                        this.log.info("Upgrade Failure!");
                    }
                    this.callBack.destroyed();
                    try {
                        IOUtil.close(this.inputStream, output, zis);
                    }
                    catch (IOException e2) {
                        this.log.warning("Close inputStream error !" + e2);
                    }
                    throw throwable;
                }
                try {
                    IOUtil.close(this.inputStream, output, zis);
                }
                catch (IOException e3) {
                    this.log.warning("Close inputStream error !" + e3);
                }
            }
        }
    }

    public static interface CallBack {
        public void sendData(byte[] var1);

        public Map<String, Object> receiveData(int var1);

        public void setProgressbar(String var1);

        public void message(String var1, String var2);

        public void init();

        public void destroyed();
    }
}

