/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b;

import com.tracker.ev07b.Protocol;
import com.tracker.ev07b.ProtocolAnalysis;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.util.ArrayUtils;
import com.tracker.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Upgrade
extends Thread {
    private Logger log = Logger.getLogger(Upgrade.class.getName());
    private InputStream inputStream;
    private CallBack callBack;
    private volatile boolean isRuning;
    private int bufferSize = 4096;
    private int address = 0;
    private int statekey = 0;
    private int sequenceId = 0;
    private Protocol protocol = ProtocolAnalysis.INSTANCE;

    public Upgrade(InputStream inputStream, CallBack callBack) {
        this.inputStream = inputStream;
        this.callBack = callBack;
    }

    public int getSequenceId(boolean isAdd) {
        if (isAdd) {
            ++this.sequenceId;
            return this.sequenceId %= 65535;
        }
        return this.sequenceId;
    }

    public void exitThread() {
        this.isRuning = false;
    }

    private void sendData(int cmdKey, byte[] cmdValue) {
        for (int errorCount = 1; errorCount <= 3; ++errorCount) {
            CmdHead headData = this.protocol.getCommandHead(this.getSequenceId(true), true);
            CmdBody bodyData = this.protocol.getCommandBody(126, cmdKey, cmdValue);
            byte[] byteData = this.protocol.getByteData(headData, bodyData);
            this.callBack.sendData(byteData);
            Map<String, Object> cmdData = this.callBack.receiveData(this.getSequenceId(false));
            if (cmdData == null) {
                if (errorCount != 3) continue;
                this.callBack.message("error", "Update device timeout !");
                this.isRuning = false;
                continue;
            }
            Map receiveData = (Map)cmdData.get("cmdBodyData");
            if (receiveData == null) continue;
            Map updateData = (Map)receiveData.get("updateData");
            if (updateData == null) {
                updateData = (Map)receiveData.get("responseData");
            }
            if (updateData == null && errorCount == 3) {
                this.callBack.message("error", "Update device timeout !");
                this.isRuning = false;
                break;
            }
            if (updateData == null) continue;
            if (cmdKey == 16 || cmdKey == 17 || cmdKey == 18) {
                String resultMsg = (String)updateData.get("returnStatus");
                if (resultMsg != null && resultMsg.contains("ok")) {
                    Object address2;
                    if (cmdKey != 17 || (address2 = updateData.get("updateAddress")) == null) break;
                    this.address = (Integer)address2;
                    break;
                }
                if (resultMsg == null || !resultMsg.contains("error") || errorCount != 3) continue;
                this.callBack.message("error", "Update device failure !");
                this.isRuning = false;
                break;
            }
            if (cmdKey == 19) {
                if (!updateData.containsKey("updateStateKey")) continue;
                this.statekey = ((Byte)updateData.get("updateStateKey")).byteValue();
                if (this.statekey == 16) break;
                if (this.statekey == 17) {
                    this.address = (Integer)updateData.get("updateAddress");
                    break;
                }
                if (this.statekey != 18) continue;
                break;
            }
            if (cmdKey != 21 || !updateData.containsKey("updatePackSize")) continue;
            this.bufferSize = (Integer)updateData.get("updatePackSize");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block38: {
            int percent;
            ZipInputStream zis;
            ByteArrayOutputStream output;
            long now;
            block37: {
                block34: {
                    ZipEntry entry;
                    now = System.currentTimeMillis();
                    output = null;
                    zis = null;
                    percent = 0;
                    this.callBack.setProgressbar(percent);
                    this.isRuning = true;
                    int totalSize = this.inputStream.available();
                    this.sendData(21, new byte[0]);
                    if (!this.isRuning) {
                        throw new IllegalStateException("Read packSize failure !");
                    }
                    percent = 2;
                    this.callBack.setProgressbar(percent);
                    this.sendData(19, new byte[0]);
                    if (!this.isRuning) {
                        throw new IllegalStateException("Read update state failure !");
                    }
                    percent = 4;
                    this.callBack.setProgressbar(percent);
                    zis = new ZipInputStream(this.inputStream);
                    byte[] buffer = new byte[this.bufferSize];
                    byte[] initialData = new byte[]{};
                    byte[] firmwareData = new byte[]{};
                    while ((entry = zis.getNextEntry()) != null) {
                        int read;
                        output = new ByteArrayOutputStream();
                        if (entry.getName().contains(".dat")) {
                            while ((read = zis.read(buffer)) != -1) {
                                output.write(buffer, 0, read);
                            }
                            initialData = output.toByteArray();
                        } else if (entry.getName().contains(".encrypted")) {
                            read = 0;
                            while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
                                output.write(buffer, 0, read);
                            }
                            firmwareData = output.toByteArray();
                        }
                        zis.closeEntry();
                    }
                    switch (this.statekey) {
                        case 16: {
                            this.sendData(16, initialData);
                            if (!this.isRuning) {
                                throw new IllegalStateException("Update InitialData");
                            }
                            percent = 10;
                            this.callBack.setProgressbar(percent);
                            this.callBack.message("info", initialData.length + " of " + totalSize + " total transferred");
                        }
                        case 17: {
                            while (this.isRuning && this.address < firmwareData.length) {
                                byte[] addressByte = new byte[]{(byte)(this.address & 0xFF), (byte)(this.address >> 8 & 0xFF), (byte)(this.address >> 16 & 0xFF), (byte)(this.address >> 24 & 0xFF)};
                                buffer = this.bufferSize > firmwareData.length - this.address ? Arrays.copyOfRange(firmwareData, this.address, firmwareData.length) : Arrays.copyOfRange(firmwareData, this.address, this.address + this.bufferSize);
                                this.address += buffer.length;
                                buffer = ArrayUtils.addAll(addressByte, buffer);
                                percent = Math.round((float)this.address / (float)firmwareData.length * 88.0f) + 10;
                                this.callBack.setProgressbar(percent);
                                this.sendData(17, buffer);
                                this.callBack.message("info", initialData.length + this.address + " of " + totalSize + " total transferred");
                            }
                            if (this.address != firmwareData.length) break;
                        }
                        case 18: {
                            this.sendData(18, new byte[0]);
                            if (!this.isRuning) {
                                throw new IllegalStateException("Update validate failure !");
                            }
                            percent = 100;
                            this.callBack.setProgressbar(percent);
                            this.callBack.message("info", "Validate success!");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: " + this.statekey);
                        }
                    }
                    if (percent != 100) break block34;
                    this.callBack.message("info", "Upgrade Complete!");
                    this.log.info("Upgrade Over!");
                    break block37;
                }
                this.callBack.message("error", "Upgrade Failure!");
                this.log.info("Upgrade Failure!");
            }
            try {
                IOUtil.close(this.inputStream, output, zis);
            }
            catch (IOException e) {
                this.log.warning("Close inputStream error !" + e);
            }
            this.log.info("Upgrade time:" + (System.currentTimeMillis() - now));
            break block38;
            catch (IllegalStateException ex) {
                block35: {
                    this.log.warning("Update failure:" + ex);
                    if (percent == 100) {
                        this.callBack.message("info", "Upgrade Complete!");
                        this.log.info("Upgrade Over!");
                        break block35;
                    }
                    this.callBack.message("error", "Upgrade Failure!");
                    this.log.info("Upgrade Failure!");
                }
                try {
                    IOUtil.close(this.inputStream, output, zis);
                }
                catch (IOException e) {
                    this.log.warning("Close inputStream error !" + e);
                }
                this.log.info("Upgrade time:" + (System.currentTimeMillis() - now));
            }
            catch (Exception e) {
                block36: {
                    this.log.warning("Update device error !" + e);
                    if (percent == 100) {
                        this.callBack.message("info", "Upgrade Complete!");
                        this.log.info("Upgrade Over!");
                        break block36;
                    }
                    this.callBack.message("error", "Upgrade Failure!");
                    this.log.info("Upgrade Failure!");
                    {
                        catch (Throwable throwable) {
                            if (percent == 100) {
                                this.callBack.message("info", "Upgrade Complete!");
                                this.log.info("Upgrade Over!");
                            } else {
                                this.callBack.message("error", "Upgrade Failure!");
                                this.log.info("Upgrade Failure!");
                            }
                            try {
                                IOUtil.close(this.inputStream, output, zis);
                            }
                            catch (IOException e2) {
                                this.log.warning("Close inputStream error !" + e2);
                            }
                            this.log.info("Upgrade time:" + (System.currentTimeMillis() - now));
                            throw throwable;
                        }
                    }
                }
                try {
                    IOUtil.close(this.inputStream, output, zis);
                }
                catch (IOException e3) {
                    this.log.warning("Close inputStream error !" + e3);
                }
                this.log.info("Upgrade time:" + (System.currentTimeMillis() - now));
            }
        }
    }

    public static interface CallBack {
        public void sendData(byte[] var1);

        public Map<String, Object> receiveData(int var1);

        public void setProgressbar(int var1);

        public void message(String var1, String var2);
    }
}

