/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SimulateData {
    public static final String[] types = new String[]{"0x01 LocationData", "0x02 Configuration", "0x03 Services", "0x04 System", "0x7E Firmware Update", "0x7F Response"};
    public static final String[] keys_data = new String[]{"0x01 Device ID", "0x02 Alarm Code", "0x03 Customized Device ID", "0x04 ICCID", "0x12 Single locating", "0x13 Continue locating", "0x14 Walk pet", "0x24 General data", "0x20 GPS location", "0x21 GSM location", "0x29 GSM location2", "0x2B GSM location3", "0x22 Wi-Fi location", "0x19 Wi-Fi location2", "0x23 BLE location", "0x26 BLE location2(EV04)", "0x25 Call Records", "0x27 Smart location(EV04)", "0x28 Beacon/HomeBeacon", "0x2C Beacon/HomeBeacon", "0x2A Home Wifi", "0x30 G-sensor data", "0x31 Activity", "0x33 IBeacon", "0x34 IBeacon2", "0x35 Eddystone", "0x37 Dog Barking", "0x38 GPS Work", "0x39 Step Data", "0x40 Heart rate data", "0x41 SPO2 rate data", "0x64 Health data"};
    public static final String[] keys_config = new String[]{"0x01 Module Number", "0x02 Firmware Version", "0x03 IMEI", "0x04 ICCID", "0x05 MAC", "0x06 Date Time", "0x07 Run Time", "0x08 Firmware Info", "0x09 Mileage", "0x0A WorkMode", "0x0B AlarmClock", "0x7B AlarmClockExt", "0x0C NoDisturb", "0x0D Password", "0x0E TimeZone", "0x0F EnableControl", "0x75 ExtraControl", "0x10 RingtoneVolume", "0x11 MicVolume", "0x12 SpeakerVolume", "0x1C PromptVolume", "0x13 DeviceName", "0x14 Battery", "0x15 BleLoc", "0x16 BleWhiteList", "0x17 SMSGPSURL", "0x18 SMSWIFIURL", "0x19 Music", "0x76 Music Extend", "0x1A FWVersion", "0x1B GSMModule", "0x1D AgpsLoc", "0x1F SystemLanguage", "0x20 SOSButton", "0x21 Call1Button", "0x22 Call2Button", "0x23 FunButton", "0x30 Number", "0x31 SMSOption", "0x32 SOSOption", "0x33 PhoneOption", "0x34 NumberNamePhoto", "0x35 PersonalInfo", "0x36 WatchSettings", "0x40 APN", "0x41 ApnUserName", "0x42 ApnPassword", "0x43 SeverIPPort", "0x44 TimeInterval", "0x45 ContinueLocate", "0x46 HeartRateInterval", "0x47 Customized Device ID", "0x48 Aes Key", "0x49 Aes CRC", "0x4A WifiList", "0x4B Cat-M Setting", "0x4C APN Settings", "0x4D APN Now", "0x4E GSM Feature band", "0x4F Preferred network type", "0x50 AlertPowerLow", "0x51 AlertGEO", "0x52 AlertMotion", "0x53 AlertNoMotion", "0x54 AlertOverSpeed", "0x55 AlertTilt", "0x56 AlertFallDown", "0x57 Welfare Check", "0x58 Alert Notification", "0x59 MotionLevel", "0x5A GEO Alert Detect", "0x5B Step Collect", "0x5C Dog Barking", "0x5D Alert Level", "0x5E Side Button Alert", "0x62 WifiWhiteList", "0x63 NightMode", "0x64 Mobile network", "0x66 IMSI", "0x67 HomeWifiMatch", "0x69 CLIR", "0x6A Weather", "0x73 Beacon list", "0x74 Find Me", "0x77 RunStep Alert", "0x78 Device State", "0x79 FallDown Time", "0x7A SPO2 Detect Interval", "0x7C AlertMotionExt", "0x7D AlertSOSExt", "0x7E Voice Param", "0x80 Sub1G", "0x81 Sub1G WhiteList", "0x82 Algorithm token", "0x83 Test Alert", "0x84 NFC Setting", "0x85 LoRA Setting", "0x86 LoRA WhiteList", "0x90 voip", "0x91 voipList", "0xD0 WifiHotspot", "0xD1 Ethernet", "0xD2 InternetAccessMode", "0xD3 InternetStatus", "0xE1 MBN", "0xF0 Read"};
    public static final String[] keys_service = new String[]{"0x01 Device ID", "0x10 Heart beat", "0x11 Req addresses", "0x11 Res addresses", "0x12 Req Get timestamp", "0x12 Res Get timestamp", "0x13 Req Weather", "0x13 Res Weather", "0x14 Res Weather", "0x21 GSM towers", "0x22 WIFI towers", "0x24 General Data"};
    public static final String[] keys_system = new String[]{"0x01 Device ID", "0x10 Reset All Record", "0x11 ReFactory", "0x12 Reboot", "0x13 Find Me", "0x14 Shutdown", "0x15 LED", "0x16 Req Scan BLE", "0x16 Res Scan BLE", "0x17 Firmware Recovery", "0x19 ScanBeaconAuto", "0x1A ScanWifiAuto", "0x1B Req scanWifi", "0x1B Res scanWifi", "0x1C Light", "0x1E Motor", "0x1F Alarm TTS", "0x21 Uploading BLE Base", "0x30 OTA", "0x31 Heart beat", "0x40 Alarm control", "0x41 Cancel SOS", "0x42 Req Scan Beacon", "0x42 Res Scan Beacon", "0x44 Sim card unlock"};
    public static final String[] keys_update = new String[]{"0x10 Initial Data", "0x11 Firmware Data", "0x12 Validate", "0x13 Update State", "0x15 Pack Size", "0x16 Request data"};
    public static final String[] keys_response = new String[]{"0x00 Success", "0x11 Version Error", "0x12 Encrypt Error", "0x13 Length Error", "0x14 CRC Error", "0x15 Command Error", "0x16 Key Error", "0x17 Key Length Error", "0x21 Data Format Error", "0x22 Data Size Error", "0x23 State Error", "0x24 Parameter Error", "0x25 No Memory Error", "0x26 Functiont Not Suported", "0x27 GPS not Location", "0x28 Address Error", "0x30 ServiceFeeError", "0x31 Service no register", "0xF0 LowBattery"};

    public static Map<String, Object> formatDataTemplate(int command, int key) {
        return SimulateData.formatDataTemplate(command, key, null);
    }

    public static Map<String, Object> formatDataTemplate(int command, int key, String dataType) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        block0 : switch (command) {
            case 1: {
                switch (key) {
                    case 1: {
                        data.put("imei", "123456789012345");
                        break block0;
                    }
                    case 3: {
                        data.put("customizedID", "");
                        break block0;
                    }
                    case 4: {
                        data.put("iccid", "12345678901234567890");
                        break block0;
                    }
                    case 2: {
                        HashMap<String, Integer> data_alarmCode = new HashMap<String, Integer>();
                        data_alarmCode.put("batteryLow", 0);
                        data_alarmCode.put("overSpeed", 0);
                        data_alarmCode.put("fallDown", 0);
                        data_alarmCode.put("tilt", 0);
                        data_alarmCode.put("geo1", 0);
                        data_alarmCode.put("geo2", 0);
                        data_alarmCode.put("geo3", 0);
                        data_alarmCode.put("geo4", 0);
                        data_alarmCode.put("powerOff", 0);
                        data_alarmCode.put("powerOn", 0);
                        data_alarmCode.put("motion", 0);
                        data_alarmCode.put("noMotion", 0);
                        data_alarmCode.put("sosKey", 0);
                        data_alarmCode.put("side1key", 0);
                        data_alarmCode.put("side2key", 0);
                        data_alarmCode.put("batteryCharging", 0);
                        data_alarmCode.put("batteryNoCharging", 0);
                        data_alarmCode.put("alarmEnd", 0);
                        data_alarmCode.put("amber", 0);
                        data_alarmCode.put("welfareCheckin", 0);
                        data_alarmCode.put("amberEnd", 0);
                        data_alarmCode.put("fallDownEnd", 0);
                        data_alarmCode.put("welfare", 0);
                        data_alarmCode.put("sosCancel", 0);
                        data_alarmCode.put("homeFenceOut", 0);
                        data_alarmCode.put("homeFenceIn", 0);
                        data_alarmCode.put("geo1_in", 0);
                        data_alarmCode.put("geo2_in", 0);
                        data_alarmCode.put("geo3_in", 0);
                        data_alarmCode.put("geo4_in", 0);
                        data_alarmCode.put("bleDisConnected", 0);
                        data_alarmCode.put("barkDetection", 0);
                        HashMap<String, Integer> data_alarmCodeExtend = new HashMap<String, Integer>();
                        data_alarmCodeExtend.put("fallOff", 0);
                        data_alarmCodeExtend.put("welfareCheckout", 0);
                        data_alarmCodeExtend.put("geo5", 0);
                        data_alarmCodeExtend.put("geo6", 0);
                        data_alarmCodeExtend.put("geo5_in", 0);
                        data_alarmCodeExtend.put("geo6_in", 0);
                        data_alarmCodeExtend.put("runStep", 0);
                        data_alarmCodeExtend.put("callingState", 0);
                        data_alarmCodeExtend.put("geo_in_valid", 0);
                        data_alarmCodeExtend.put("welfareCheckSuccess", 0);
                        data_alarmCodeExtend.put("welfareCheckFailure", 0);
                        HashMap<String, Object> alarmCode = new HashMap<String, Object>();
                        alarmCode.put("dateTime", now);
                        alarmCode.put("alarmStatus", data_alarmCode);
                        alarmCode.put("alarmStatusExtend", data_alarmCodeExtend);
                        data.put("alarm", alarmCode);
                        break block0;
                    }
                    case 17: {
                        break block0;
                    }
                    case 18: {
                        data.put("singleLocating", "null");
                        break block0;
                    }
                    case 19: {
                        data.put("continueLocating", "null");
                        break block0;
                    }
                    case 20: {
                        HashMap<String, String> walkPet = new HashMap<String, String>(2);
                        walkPet.put("startTime", "2021-01-01 01:00:00");
                        walkPet.put("stopTime", "2021-01-01 02:00:00");
                        data.put("petWalking", walkPet);
                        break block0;
                    }
                    case 32: {
                        HashMap<String, Number> data_gps = new HashMap<String, Number>(8);
                        data_gps.put("lat", 0.0);
                        data_gps.put("lng", 0.0);
                        data_gps.put("speed", 45);
                        data_gps.put("direction", 175);
                        data_gps.put("altitude", 6553);
                        data_gps.put("precision", 88);
                        data_gps.put("mileage", 2669);
                        data_gps.put("satellites", 11);
                        data.put("gps", data_gps);
                        break block0;
                    }
                    case 33: {
                        HashMap gsm = new HashMap();
                        ArrayList gsmList = new ArrayList();
                        HashMap<String, Integer> data_gsm = new HashMap<String, Integer>();
                        data_gsm.put("mcc", 460);
                        data_gsm.put("mnc", 0);
                        data_gsm.put("cellId", 3772);
                        data_gsm.put("lac", 9724);
                        data_gsm.put("signal", 26);
                        gsmList.add(data_gsm);
                        gsm.put("gsmList", gsmList);
                        data.put("gsm", gsm);
                        break block0;
                    }
                    case 41: {
                        HashMap gsm2 = new HashMap();
                        ArrayList gsmList2 = new ArrayList();
                        HashMap<String, Integer> data_gsm2 = new HashMap<String, Integer>();
                        data_gsm2.put("mcc", 460);
                        data_gsm2.put("mnc", 0);
                        data_gsm2.put("cellId", 3772);
                        data_gsm2.put("lac", 9724);
                        data_gsm2.put("signal", 26);
                        gsmList2.add(data_gsm2);
                        gsm2.put("gsmList", gsmList2);
                        data.put("gsm2", gsm2);
                        break block0;
                    }
                    case 43: {
                        HashMap gsm3 = new HashMap();
                        ArrayList gsmList3 = new ArrayList();
                        HashMap<String, Integer> data_gsm3 = new HashMap<String, Integer>();
                        data_gsm3.put("mcc", 460);
                        data_gsm3.put("mnc", 0);
                        data_gsm3.put("cellId", 3772);
                        data_gsm3.put("lac", 9724);
                        data_gsm3.put("signal", 26);
                        gsmList3.add(data_gsm3);
                        gsm3.put("gsmList", gsmList3);
                        data.put("gsm3", gsm3);
                        break block0;
                    }
                    case 34: {
                        HashMap wifi = new HashMap();
                        ArrayList wifiList = new ArrayList();
                        HashMap<String, Object> data_wifi = new HashMap<String, Object>();
                        data_wifi.put("mac", "AC:C6:62:E4:C9:B0");
                        data_wifi.put("signal", -90);
                        wifiList.add(data_wifi);
                        wifi.put("wifiList", wifiList);
                        data.put("wifi", wifi);
                        break block0;
                    }
                    case 25: {
                        HashMap wifi2 = new HashMap();
                        ArrayList wifiList2 = new ArrayList();
                        HashMap<String, Object> data_wifi2 = new HashMap<String, Object>();
                        data_wifi2.put("mac", "AC:C6:62:E4:C9:B0");
                        data_wifi2.put("signal", -90);
                        data_wifi2.put("name", "eview");
                        wifiList2.add(data_wifi2);
                        wifi2.put("wifiList", wifiList2);
                        data.put("wifi2", wifi2);
                        break block0;
                    }
                    case 35: {
                        HashMap<String, Object> data_ble = new HashMap<String, Object>();
                        data_ble.put("mac", "00:00:00:00:00:00");
                        data_ble.put("lat", 0.0);
                        data_ble.put("lng", 0.0);
                        data_ble.put("describe", "");
                        data.put("ble", data_ble);
                        break block0;
                    }
                    case 38: {
                        HashMap<String, Object> data_ble2 = new HashMap<String, Object>();
                        data_ble2.put("mac", "00:00:00:00:00:00");
                        data_ble2.put("lat", 0.0);
                        data_ble2.put("lng", 0.0);
                        data_ble2.put("radius", 100);
                        data_ble2.put("height", 0);
                        data.put("ble2", data_ble2);
                        break block0;
                    }
                    case 36: {
                        HashMap<String, Object> data_status = new HashMap<String, Object>();
                        data_status.put("dateTime", now);
                        HashMap<String, Integer> deviceStatus = new HashMap<String, Integer>();
                        deviceStatus.put("isGPS", 1);
                        deviceStatus.put("isWIFI", 0);
                        deviceStatus.put("isGSM", 0);
                        deviceStatus.put("isBLE", 0);
                        deviceStatus.put("isSmart", 0);
                        deviceStatus.put("isHomeBeacon", 0);
                        deviceStatus.put("isHomeWifi", 0);
                        deviceStatus.put("isCharging", 0);
                        deviceStatus.put("isChargingComplete", 0);
                        deviceStatus.put("isReboot", 0);
                        deviceStatus.put("isHistoricalData", 0);
                        deviceStatus.put("isAGPS", 1);
                        deviceStatus.put("isMotion", 0);
                        deviceStatus.put("workMode", 2);
                        deviceStatus.put("signalSize", 24);
                        deviceStatus.put("battery", 80);
                        deviceStatus.put("isHome", 0);
                        deviceStatus.put("bleConnected", 0);
                        deviceStatus.put("fallDownStatus", 0);
                        data_status.put("deviceStatus", deviceStatus);
                        HashMap<String, Integer> deviceStatus2 = new HashMap<String, Integer>();
                        deviceStatus2.put("network", 0);
                        deviceStatus2.put("wifiConnected", 0);
                        deviceStatus2.put("wifiUpload", 0);
                        deviceStatus2.put("volte", 0);
                        deviceStatus2.put("calling", 0);
                        deviceStatus2.put("isBeacon", 0);
                        data_status.put("deviceStatus2", deviceStatus2);
                        data.put("status", data_status);
                        break block0;
                    }
                    case 37: {
                        ArrayList call_list = new ArrayList();
                        HashMap<String, Object> data_call = new HashMap<String, Object>();
                        data_call.put("dateTime", now);
                        data_call.put("number", "123456789");
                        data_call.put("time", 25);
                        data_call.put("retCode", 0);
                        data_call.put("callInOut", 1);
                        data_call.put("callStatus", 1);
                        data_call.put("callType", 6);
                        call_list.add(data_call);
                        data.put("callList", call_list);
                        break block0;
                    }
                    case 39: {
                        HashMap<String, Number> data_smart = new HashMap<String, Number>();
                        data_smart.put("lat", 0.0);
                        data_smart.put("lng", 0.0);
                        data_smart.put("radius", 1000);
                        data_smart.put("height", 0.0);
                        data.put("smart", data_smart);
                        break block0;
                    }
                    case 40: {
                        HashMap<String, Object> data_beacon = new HashMap<String, Object>();
                        data_beacon.put("index", 0);
                        data_beacon.put("mac", "D7:0D:7A:71:0A:F1");
                        data_beacon.put("rssi", -47);
                        data_beacon.put("rssi_1m", -61);
                        data_beacon.put("isLanLng", 1);
                        data_beacon.put("lat", 0.0);
                        data_beacon.put("lng", 0.0);
                        data_beacon.put("isDescribe", 1);
                        data_beacon.put("describe", "office");
                        data.put("beacon", data_beacon);
                        break block0;
                    }
                    case 44: {
                        HashMap<String, Object> data_beacon2 = new HashMap<String, Object>();
                        data_beacon2.put("index", 0);
                        data_beacon2.put("mac", "D7:0D:7A:71:0A:F1");
                        data_beacon2.put("rssi", -47);
                        data_beacon2.put("rssi_1m", -61);
                        data_beacon2.put("battery", 80);
                        data_beacon2.put("isLanLng", 1);
                        data_beacon2.put("lat", 0.0);
                        data_beacon2.put("lng", 0.0);
                        data_beacon2.put("isDescribe", 1);
                        data_beacon2.put("describe", "office");
                        data_beacon2.put("temperature", 30);
                        data.put("beacon2", data_beacon2);
                        break block0;
                    }
                    case 42: {
                        HashMap<String, Object> data_homeWifi = new HashMap<String, Object>();
                        data_homeWifi.put("index", 0);
                        data_homeWifi.put("mac", "D7:0D:7A:71:0A:F1");
                        data_homeWifi.put("rssi", -47);
                        data_homeWifi.put("isLanLng", 1);
                        data_homeWifi.put("lat", 0.0);
                        data_homeWifi.put("lng", 0.0);
                        data_homeWifi.put("isDescribe", 1);
                        data_homeWifi.put("describe", "office");
                        data.put("homeWifi", data_homeWifi);
                        break block0;
                    }
                    case 48: {
                        ArrayList step_list = new ArrayList();
                        HashMap<String, Object> data_step = new HashMap<String, Object>();
                        data_step.put("dateTime", now);
                        data_step.put("step", 12);
                        step_list.add(data_step);
                        data.put("stepList", step_list);
                        break block0;
                    }
                    case 49: {
                        ArrayList active_list = new ArrayList();
                        HashMap<String, Object> data_active = new HashMap<String, Object>();
                        data_active.put("dateTime", now);
                        data_active.put("active", 10);
                        active_list.add(data_active);
                        data.put("activeList", active_list);
                        break block0;
                    }
                    case 57: {
                        HashMap<String, Object> stepData = new HashMap<String, Object>(4);
                        stepData.put("dateTime", now);
                        stepData.put("stepTotal", 100);
                        stepData.put("stepTime", 10);
                        stepData.put("stepCount", 10);
                        data.put("stepData", stepData);
                        break block0;
                    }
                    case 64: {
                        ArrayList heart_list = new ArrayList();
                        HashMap<String, Object> data_heart = new HashMap<String, Object>();
                        data_heart.put("dateTime", now);
                        data_heart.put("heartRate", 82);
                        data_heart.put("trustLevel", 66);
                        heart_list.add(data_heart);
                        data.put("heartList", heart_list);
                        break block0;
                    }
                    case 65: {
                        ArrayList spo2_list = new ArrayList();
                        HashMap<String, Object> spo2Rate = new HashMap<String, Object>();
                        spo2Rate.put("dateTime", now);
                        spo2Rate.put("spo2Rate", 82);
                        spo2Rate.put("trustLevel", 66);
                        spo2_list.add(spo2Rate);
                        data.put("spo2List", spo2_list);
                        break block0;
                    }
                    case 51: {
                        HashMap<String, Object> beaconList = new HashMap<String, Object>();
                        beaconList.put("dateTime", now);
                        beaconList.put("companyId", 100);
                        beaconList.put("uuid", "D70D7A710AF16B7C");
                        ArrayList beacon_list = new ArrayList();
                        HashMap<String, Integer> list = new HashMap<String, Integer>();
                        list.put("major", 63);
                        list.put("minor", 63);
                        list.put("rssi_m", 15);
                        list.put("rssi_r", 12);
                        beacon_list.add(list);
                        beaconList.put("list", beacon_list);
                        data.put("iBeacon", beaconList);
                        break block0;
                    }
                    case 52: {
                        HashMap<String, Object> beaconList2 = new HashMap<String, Object>();
                        beaconList2.put("dateTime", now);
                        beaconList2.put("companyId", 100);
                        ArrayList beacon_list2 = new ArrayList();
                        HashMap<String, Object> list2 = new HashMap<String, Object>();
                        list2.put("uuid", "D70D7A710AF16B7C");
                        list2.put("major", 63);
                        list2.put("minor", 63);
                        list2.put("rssi_m", 15);
                        list2.put("rssi_r", 12);
                        beacon_list2.add(list2);
                        beaconList2.put("list", beacon_list2);
                        data.put("iBeacon2", beaconList2);
                        break block0;
                    }
                    case 53: {
                        HashMap<String, Object> eddystone = new HashMap<String, Object>();
                        eddystone.put("dateTime", now);
                        eddystone.put("uuId", "10");
                        ArrayList eddystoneList = new ArrayList();
                        HashMap<String, Object> list3 = new HashMap<String, Object>();
                        list3.put("namespaceId", "D70D7A710AF16B7C");
                        list3.put("instanceId", "63");
                        list3.put("txPower", 63);
                        list3.put("rssi", 15);
                        eddystoneList.add(list3);
                        eddystone.put("list", eddystoneList);
                        data.put("eddystone", eddystone);
                        break block0;
                    }
                    case 55: {
                        HashMap<String, Object> dogBarking = new HashMap<String, Object>(3);
                        dogBarking.put("time", now);
                        dogBarking.put("count", 100);
                        dogBarking.put("status", 1);
                        data.put("dogBarking", dogBarking);
                        break block0;
                    }
                    case 56: {
                        HashMap<String, Object> gpsWork = new HashMap<String, Object>(3);
                        gpsWork.put("lastTime", now);
                        gpsWork.put("thisTime", now);
                        gpsWork.put("value", 1);
                        data.put("GpsWork", gpsWork);
                        break block0;
                    }
                    case 100: {
                        HashMap<String, Object> healthData = new HashMap<String, Object>(3);
                        healthData.put("manufacturerId", 1);
                        healthData.put("type", 1);
                        healthData.put("DateTime", now);
                        healthData.put("heartRate", 0);
                        healthData.put("spo2", 0);
                        healthData.put("pi", 0);
                        healthData.put("systolic", 0);
                        healthData.put("diastolic", 0);
                        healthData.put("pulse", 0);
                        data.put("healthData", healthData);
                        break block0;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + key);
            }
            case 2: {
                switch (key) {
                    case 1: {
                        data.put("module", "20180504");
                        break;
                    }
                    case 2: {
                        data.put("version", "v1.0.9.2");
                        break;
                    }
                    case 3: {
                        data.put("IMEI", "123456789012345");
                        break;
                    }
                    case 4: {
                        data.put("ICCID", "");
                        break;
                    }
                    case 5: {
                        data.put("MAC", "FF:F6:15:11:4D:D5");
                        break;
                    }
                    case 6: {
                        data.put("dateTime", now);
                        break;
                    }
                    case 7: {
                        data.put("runTime", 1109834);
                        break;
                    }
                    case 8: {
                        HashMap<String, Object> data_firmware = new HashMap<String, Object>(6);
                        data_firmware.put("complierDateTime", now);
                        data_firmware.put("firmwareSize", 335872);
                        data_firmware.put("softDeviceFWID", 174);
                        data_firmware.put("hardwareVersion", "v0.0.0.10");
                        data_firmware.put("softDeviceVersion", "v6.1.0");
                        data_firmware.put("firmwareVersion", "v1.0.9.2");
                        data.put("firmware", data_firmware);
                        break;
                    }
                    case 9: {
                        data.put("mileage", 0);
                        break;
                    }
                    case 10: {
                        HashMap<String, Integer> data_workMode = new HashMap<String, Integer>(2);
                        data_workMode.put("mode", 3);
                        data_workMode.put("time", 0);
                        data.put("workMode", data_workMode);
                        break;
                    }
                    case 11: {
                        ArrayList alarmClockList = new ArrayList();
                        HashMap<String, Object> data_alarmClock0 = new HashMap<String, Object>(14);
                        data_alarmClock0.put("mon", 0);
                        data_alarmClock0.put("thu", 0);
                        data_alarmClock0.put("tus", 0);
                        data_alarmClock0.put("wed", 0);
                        data_alarmClock0.put("fri", 0);
                        data_alarmClock0.put("sat", 0);
                        data_alarmClock0.put("sun", 0);
                        data_alarmClock0.put("describe", "");
                        data_alarmClock0.put("ringTime", 30);
                        data_alarmClock0.put("ringType", 1);
                        data_alarmClock0.put("time", "00:00");
                        data_alarmClock0.put("status", 0);
                        data_alarmClock0.put("medicine", 0);
                        data_alarmClock0.put("index", 0);
                        alarmClockList.add(data_alarmClock0);
                        data.put("alarmClock", alarmClockList);
                        break;
                    }
                    case 123: {
                        ArrayList alarmClockListExt = new ArrayList();
                        HashMap<String, Object> data_alarmClockExt = new HashMap<String, Object>(14);
                        data_alarmClockExt.put("mon", 0);
                        data_alarmClockExt.put("thu", 0);
                        data_alarmClockExt.put("tus", 0);
                        data_alarmClockExt.put("wed", 0);
                        data_alarmClockExt.put("fri", 0);
                        data_alarmClockExt.put("sat", 0);
                        data_alarmClockExt.put("sun", 0);
                        data_alarmClockExt.put("describe", "");
                        data_alarmClockExt.put("ringTime", 30);
                        data_alarmClockExt.put("ringType", 1);
                        data_alarmClockExt.put("time", "00:00");
                        data_alarmClockExt.put("status", 0);
                        data_alarmClockExt.put("alarmType", 0);
                        data_alarmClockExt.put("index", 0);
                        alarmClockListExt.add(data_alarmClockExt);
                        data.put("alarmClockExt", alarmClockListExt);
                        break;
                    }
                    case 12: {
                        HashMap<String, Object> data_noDisturb = new HashMap<String, Object>(3);
                        data_noDisturb.put("from", "00:00");
                        data_noDisturb.put("to", "00:00");
                        data_noDisturb.put("status", 0);
                        data.put("noDisturb", data_noDisturb);
                        break;
                    }
                    case 13: {
                        HashMap<String, Integer> data_password = new HashMap<String, Integer>(2);
                        data_password.put("password", 123456);
                        data_password.put("status", 0);
                        data.put("password", data_password);
                        break;
                    }
                    case 14: {
                        data.put("timeZone", 8.0);
                        break;
                    }
                    case 15: {
                        HashMap<String, Integer> enableControl = new HashMap<String, Integer>(32);
                        enableControl.put("led", 1);
                        enableControl.put("beep", 1);
                        enableControl.put("motor", 1);
                        enableControl.put("gsmLoc", 1);
                        enableControl.put("wifiLoc", 1);
                        enableControl.put("sosSpeaker", 1);
                        enableControl.put("xSpeaker", 1);
                        enableControl.put("bleLongConnect", 1);
                        enableControl.put("bleLoc", 1);
                        enableControl.put("sosCallNumberVoice", 0);
                        enableControl.put("bleAdvAlways", 0);
                        enableControl.put("gpsLoc", 0);
                        enableControl.put("tcpFast", 0);
                        enableControl.put("beacon", 0);
                        enableControl.put("activity", 0);
                        enableControl.put("step", 0);
                        enableControl.put("homeWifi", 0);
                        enableControl.put("dataSaver", 0);
                        enableControl.put("networkLoc", 0);
                        enableControl.put("powerControl", 0);
                        enableControl.put("sosCannel", 0);
                        enableControl.put("longSMS", 0);
                        enableControl.put("autoUpdate", 0);
                        enableControl.put("agps", 1);
                        data.put("enableControl", enableControl);
                        break;
                    }
                    case 117: {
                        HashMap<String, Integer> extraControl = new HashMap<String, Integer>(32);
                        for (int i = 0; i < 32; ++i) {
                            extraControl.put("bit" + i, 0);
                        }
                        data.put("extraControl", extraControl);
                        break;
                    }
                    case 16: {
                        data.put("ringToneVolume", 100);
                        break;
                    }
                    case 17: {
                        data.put("micVolume", 5);
                        break;
                    }
                    case 18: {
                        data.put("speakerVolume", 100);
                        break;
                    }
                    case 19: {
                        data.put("deviceName", "EV07B");
                        break;
                    }
                    case 20: {
                        HashMap<String, Integer> data_battery = new HashMap<String, Integer>(2);
                        data_battery.put("battery", 100);
                        data_battery.put("voltage", 4121);
                        data.put("battery", data_battery);
                        break;
                    }
                    case 21: {
                        HashMap<String, Object> bleLoc = new HashMap<String, Object>(3);
                        bleLoc.put("lat", 0.0);
                        bleLoc.put("lng", 0.0);
                        bleLoc.put("describe", "");
                        data.put("bleLoc", bleLoc);
                        break;
                    }
                    case 22: {
                        ArrayList bleWhiteList = new ArrayList();
                        HashMap<String, Object> bleWhite = new HashMap<String, Object>(3);
                        bleWhite.put("index", 0);
                        bleWhite.put("enable", 0);
                        bleWhite.put("mac", "00:00:00:00:00:00");
                        bleWhiteList.add(bleWhite);
                        data.put("bleWhiteList", bleWhiteList);
                        break;
                    }
                    case 23: {
                        data.put("smsgpsurl", "www.google.com/maps?q=%.7f,%.7fc");
                        break;
                    }
                    case 24: {
                        data.put("smswifiurl", "smart-locator.com/web/geolocation/%s/%s");
                        break;
                    }
                    case 25: {
                        HashMap<String, Integer> data_music = new HashMap<String, Integer>(32);
                        for (int i = 0; i < 32; ++i) {
                            data_music.put("bit" + i, 0);
                        }
                        data.put("music", data_music);
                        break;
                    }
                    case 118: {
                        HashMap<String, Integer> musicExtend = new HashMap<String, Integer>(32);
                        for (int i = 0; i < 32; ++i) {
                            musicExtend.put("bit" + i, 0);
                        }
                        data.put("musicExtend", musicExtend);
                        break;
                    }
                    case 26: {
                        data.put("fwVersion", "V07B.8601.2002");
                        break;
                    }
                    case 27: {
                        data.put("gsmModule", "SIM800 R14.18\r\n");
                        break;
                    }
                    case 28: {
                        data.put("promptVolume", 100);
                        break;
                    }
                    case 29: {
                        HashMap<String, Number> agpsLocMap = new HashMap<String, Number>(3);
                        agpsLocMap.put("status", 1);
                        agpsLocMap.put("lat", 22.6536815);
                        agpsLocMap.put("lng", 114.0005976);
                        data.put("agpsLoc", agpsLocMap);
                        break;
                    }
                    case 31: {
                        data.put("locale", "en-US");
                        break;
                    }
                    case 32: {
                        HashMap<String, Integer> sosButton = new HashMap<String, Integer>(5);
                        sosButton.put("mode", 0);
                        sosButton.put("feedBack", 3);
                        sosButton.put("task", 15);
                        sosButton.put("time", 20);
                        sosButton.put("status", 1);
                        data.put("sosButton", sosButton);
                        break;
                    }
                    case 33: {
                        HashMap<String, Integer> call1Button = new HashMap<String, Integer>(5);
                        call1Button.put("mode", 0);
                        call1Button.put("feedBack", 3);
                        call1Button.put("task", 2);
                        call1Button.put("time", 20);
                        call1Button.put("status", 1);
                        data.put("call1Button", call1Button);
                        break;
                    }
                    case 34: {
                        HashMap<String, Integer> call2Button = new HashMap<String, Integer>(5);
                        call2Button.put("mode", 0);
                        call2Button.put("feedBack", 3);
                        call2Button.put("task", 2);
                        call2Button.put("time", 20);
                        call2Button.put("status", 1);
                        data.put("call2Button", call2Button);
                        break;
                    }
                    case 35: {
                        HashMap<String, Integer> funButton = new HashMap<String, Integer>(4);
                        funButton.put("mode", 0);
                        funButton.put("task", 2);
                        funButton.put("time", 20);
                        funButton.put("status", 1);
                        data.put("funButton", funButton);
                        break;
                    }
                    case 48: {
                        ArrayList numberList = new ArrayList();
                        HashMap<String, Object> number = new HashMap<String, Object>(6);
                        number.put("call", 0);
                        number.put("noCard", 0);
                        number.put("number", "123456789");
                        number.put("enable", 1);
                        number.put("sms", 0);
                        number.put("index", 0);
                        numberList.add(number);
                        data.put("number", numberList);
                        break;
                    }
                    case 49: {
                        HashMap<String, Object> smsOption = new HashMap<String, Object>(2);
                        smsOption.put("prefix", "");
                        smsOption.put("status", 1);
                        data.put("smsOption", smsOption);
                        break;
                    }
                    case 50: {
                        HashMap<String, Integer> sosOption = new HashMap<String, Integer>(3);
                        sosOption.put("ringsTime", 20);
                        sosOption.put("loops", 1);
                        sosOption.put("holdTime", 600);
                        data.put("sosOption", sosOption);
                        break;
                    }
                    case 51: {
                        HashMap<String, Integer> phoneOption = new HashMap<String, Integer>(10);
                        phoneOption.put("s1", 1);
                        phoneOption.put("s2", 0);
                        phoneOption.put("s3", 0);
                        phoneOption.put("s4", 0);
                        phoneOption.put("s5", 0);
                        phoneOption.put("s6", 0);
                        phoneOption.put("s7", 0);
                        phoneOption.put("callIncoming", 0);
                        phoneOption.put("toneID", 0);
                        phoneOption.put("rings", 5);
                        data.put("phoneOption", phoneOption);
                        break;
                    }
                    case 52: {
                        ArrayList number2List = new ArrayList();
                        HashMap<String, Object> number2_data = new HashMap<String, Object>(8);
                        number2_data.put("index", 0);
                        number2_data.put("enable", 1);
                        number2_data.put("sms", 0);
                        number2_data.put("call", 0);
                        number2_data.put("noCard", 0);
                        number2_data.put("number", "123456789");
                        number2_data.put("name", "");
                        number2_data.put("headURL", "");
                        number2List.add(number2_data);
                        data.put("numberNamePhoto", number2List);
                        break;
                    }
                    case 53: {
                        HashMap<String, Object> personalInfo = new HashMap<String, Object>(8);
                        personalInfo.put("height", 170);
                        personalInfo.put("weight", 50);
                        personalInfo.put("sex", 0);
                        personalInfo.put("bloodType", 0);
                        personalInfo.put("birthday", now);
                        personalInfo.put("name", "name");
                        personalInfo.put("url", "url");
                        personalInfo.put("headURL", "");
                        data.put("personalInfo", personalInfo);
                        break;
                    }
                    case 54: {
                        int i;
                        HashMap<String, Integer> watch = new HashMap<String, Integer>(32);
                        watch.put("faceId", 0);
                        watch.put("status0", 0);
                        watch.put("status1", 0);
                        watch.put("status2", 0);
                        watch.put("status3", 0);
                        for (i = 8; i < 18; ++i) {
                            watch.put("status" + i, 0);
                        }
                        for (i = 0; i < 8; ++i) {
                            watch.put("menu" + (i + 1), 0);
                        }
                        watch.put("autoTime", 20);
                        watch.put("brightNess", 0);
                        watch.put("brightTime", 0);
                        watch.put("logoIndex", 0);
                        data.put("watch", watch);
                        break;
                    }
                    case 64: {
                        data.put("apn", "");
                        break;
                    }
                    case 65: {
                        data.put("apnUserName", "");
                        break;
                    }
                    case 66: {
                        data.put("apnPassword", "");
                        break;
                    }
                    case 67: {
                        HashMap<String, Object> sever = new HashMap<String, Object>(4);
                        sever.put("port", 5050);
                        sever.put("ip", "");
                        sever.put("type", 0);
                        sever.put("status", 0);
                        data.put("sever", sever);
                        break;
                    }
                    case 68: {
                        HashMap<String, Integer> timeInterval = new HashMap<String, Integer>(4);
                        timeInterval.put("heartBeatStatus", 1);
                        timeInterval.put("upload", 600);
                        timeInterval.put("heartBeat", 200);
                        timeInterval.put("uploadLazy", 3600);
                        data.put("timeInterval", timeInterval);
                        break;
                    }
                    case 69: {
                        HashMap<String, Integer> continueLocate = new HashMap<String, Integer>(2);
                        continueLocate.put("interval", 10);
                        continueLocate.put("time", 600);
                        data.put("continueLocate", continueLocate);
                        break;
                    }
                    case 70: {
                        HashMap<String, Integer> heartRate = new HashMap<String, Integer>(2);
                        heartRate.put("interval", 39321610);
                        heartRate.put("status", 0);
                        data.put("heartRate", heartRate);
                        break;
                    }
                    case 71: {
                        data.put("customizedID", "");
                        break;
                    }
                    case 72: {
                        HashMap<String, Object> aesKeyObj = new HashMap<String, Object>(4);
                        aesKeyObj.put("id", 1);
                        aesKeyObj.put("type", 2);
                        aesKeyObj.put("aesKey", "12345678901234567890123456789012");
                        aesKeyObj.put("aesIV", "12345678901234567890123456789012");
                        data.put("aesKey", aesKeyObj);
                        break;
                    }
                    case 73: {
                        HashMap<String, Object> aesCRCObj = new HashMap<String, Object>(3);
                        aesCRCObj.put("id", 1);
                        aesCRCObj.put("type", 2);
                        aesCRCObj.put("aesCRC", "1234");
                        data.put("aesCRC", aesCRCObj);
                        break;
                    }
                    case 74: {
                        ArrayList wifiList = new ArrayList();
                        HashMap<String, Object> wifi = new HashMap<String, Object>(5);
                        wifi.put("index", 0);
                        wifi.put("enable", 1);
                        wifi.put("isConnected", 0);
                        wifi.put("name", "wifi_name");
                        wifi.put("password", "wifi_password");
                        wifiList.add(wifi);
                        data.put("wifiList", wifiList);
                        break;
                    }
                    case 75: {
                        HashMap<String, Integer> catm = new HashMap<String, Integer>(8);
                        catm.put("iotMode", 2);
                        catm.put("emtc", 0);
                        catm.put("emtcValue", 2);
                        catm.put("nbiot", 0);
                        catm.put("nbiotValue", 2);
                        catm.put("gsm", 0);
                        catm.put("eMTBand", 0);
                        catm.put("nbBand", 128);
                        data.put("catm", catm);
                        break;
                    }
                    case 76: {
                        ArrayList apnList = new ArrayList();
                        HashMap<String, Object> apn = new HashMap<String, Object>(5);
                        apn.put("apn", "");
                        apn.put("username", "");
                        apn.put("password", "");
                        apn.put("plmn", 46001);
                        apn.put("index", 0);
                        apnList.add(apn);
                        data.put("apnList", apnList);
                        break;
                    }
                    case 77: {
                        HashMap<String, Object> apnNow = new HashMap<String, Object>(4);
                        apnNow.put("apn", "cmnet");
                        apnNow.put("username", "");
                        apnNow.put("password", "");
                        apnNow.put("plmn", 46007);
                        data.put("apnNow", apnNow);
                        break;
                    }
                    case 78: {
                        data.put("gsmBand", 0);
                        break;
                    }
                    case 79: {
                        data.put("networkType", 0);
                        break;
                    }
                    case 80: {
                        HashMap<String, Integer> powerLowAlert = new HashMap<String, Integer>(6);
                        powerLowAlert.put("voice", 20);
                        powerLowAlert.put("powerON", 1);
                        powerLowAlert.put("voiceStatus", 1);
                        powerLowAlert.put("powerOFF", 0);
                        powerLowAlert.put("power", 15);
                        powerLowAlert.put("status", 1);
                        data.put("powerLowAlert", powerLowAlert);
                        break;
                    }
                    case 81: {
                        ArrayList geoAlertList = new ArrayList();
                        HashMap<String, Serializable> geoAlert = new HashMap<String, Serializable>(6);
                        geoAlert.put("index", Integer.valueOf(0));
                        geoAlert.put("type", Integer.valueOf(0));
                        geoAlert.put("radius", Integer.valueOf(62464));
                        geoAlert.put("points", Integer.valueOf(1));
                        geoAlert.put("status", Integer.valueOf(0));
                        geoAlert.put("direction", Integer.valueOf(0));
                        ArrayList latlngList = new ArrayList();
                        HashMap<String, Double> latlng = new HashMap<String, Double>(2);
                        latlng.put("lng", 0.0);
                        latlng.put("lat", 0.0);
                        latlngList.add(latlng);
                        geoAlert.put("latlng", latlngList);
                        geoAlertList.add(geoAlert);
                        data.put("geoAlert", geoAlertList);
                        break;
                    }
                    case 82: {
                        HashMap<String, Integer> motionAlert = new HashMap<String, Integer>(4);
                        motionAlert.put("staticTime", 120);
                        motionAlert.put("moveTime", 3);
                        motionAlert.put("dial", 0);
                        motionAlert.put("status", 0);
                        data.put("motionAlert", motionAlert);
                        break;
                    }
                    case 83: {
                        HashMap<String, Integer> noMotionAlert = new HashMap<String, Integer>(3);
                        noMotionAlert.put("time", 300);
                        noMotionAlert.put("dial", 0);
                        noMotionAlert.put("status", 0);
                        data.put("noMotionAlert", noMotionAlert);
                        break;
                    }
                    case 84: {
                        HashMap<String, Integer> overSpeedAlert = new HashMap<String, Integer>(2);
                        overSpeedAlert.put("speed", 80);
                        overSpeedAlert.put("status", 0);
                        data.put("overSpeedAlert", overSpeedAlert);
                        break;
                    }
                    case 85: {
                        HashMap<String, Integer> tiltAlert = new HashMap<String, Integer>(4);
                        tiltAlert.put("angle", 45);
                        tiltAlert.put("time", 30);
                        tiltAlert.put("dial", 0);
                        tiltAlert.put("status", 0);
                        data.put("tiltAlert", tiltAlert);
                        break;
                    }
                    case 86: {
                        HashMap<String, Integer> fallDownAlert = new HashMap<String, Integer>(4);
                        fallDownAlert.put("level", 1);
                        fallDownAlert.put("dial", 1);
                        fallDownAlert.put("allwayOn", 1);
                        fallDownAlert.put("status", 1);
                        data.put("fallDownAlert", fallDownAlert);
                        break;
                    }
                    case 87: {
                        HashMap<String, Integer> welfareAlert = new HashMap<String, Integer>(4);
                        welfareAlert.put("status", 0);
                        welfareAlert.put("value", 60);
                        welfareAlert.put("dial", 0);
                        welfareAlert.put("time", 65);
                        data.put("welfareAlert", welfareAlert);
                        break;
                    }
                    case 88: {
                        HashMap<String, Object> alertNotification = new HashMap<String, Object>(4);
                        alertNotification.put("customerID", 0);
                        alertNotification.put("centreID", 0);
                        alertNotification.put("url", "");
                        alertNotification.put("status", 0);
                        data.put("notificationAlert", alertNotification);
                        break;
                    }
                    case 89: {
                        data.put("motionLevel", 7);
                        break;
                    }
                    case 90: {
                        HashMap<String, Integer> geoDetect = new HashMap<String, Integer>(2);
                        geoDetect.put("status", 1);
                        geoDetect.put("time", 600);
                        data.put("geoDetect", geoDetect);
                        break;
                    }
                    case 91: {
                        HashMap<String, Integer> stepCollect = new HashMap<String, Integer>(2);
                        stepCollect.put("status", 1);
                        stepCollect.put("time", 600);
                        data.put("stepCollect", stepCollect);
                        break;
                    }
                    case 92: {
                        HashMap<String, Integer> dogBarking = new HashMap<String, Integer>(3);
                        dogBarking.put("status", 1);
                        dogBarking.put("level", 5);
                        dogBarking.put("time", 60);
                        data.put("dogBarking", dogBarking);
                        break;
                    }
                    case 93: {
                        HashMap<String, Integer> alertLevel = new HashMap<String, Integer>(1);
                        alertLevel.put("noMotion", 7);
                        data.put("alertLevel", alertLevel);
                        break;
                    }
                    case 94: {
                        HashMap<String, Integer> sideButton = new HashMap<String, Integer>(3);
                        sideButton.put("status", 1);
                        sideButton.put("dial", 0);
                        sideButton.put("sms", 0);
                        data.put("sideButton", sideButton);
                        break;
                    }
                    case 95: {
                        HashMap<String, Integer> homeDetect = new HashMap<String, Integer>(2);
                        homeDetect.put("status", 1);
                        homeDetect.put("time", 600);
                        data.put("homeDetect", homeDetect);
                        break;
                    }
                    case 98: {
                        ArrayList wifiWhiteList = new ArrayList();
                        HashMap<String, Object> wifiWhite = new HashMap<String, Object>(6);
                        wifiWhite.put("index", 0);
                        wifiWhite.put("enable", 1);
                        wifiWhite.put("lat", 0.0);
                        wifiWhite.put("lng", 0.0);
                        wifiWhite.put("describe", "");
                        wifiWhite.put("mac", "00:00:00:00:00:00");
                        wifiWhiteList.add(wifiWhite);
                        data.put("wifiWhiteList", wifiWhiteList);
                        break;
                    }
                    case 99: {
                        HashMap<String, Object> nightMode = new HashMap<String, Object>(3);
                        nightMode.put("status", 0);
                        nightMode.put("from", "00:00");
                        nightMode.put("to", "00:00");
                        data.put("nightMode", nightMode);
                        break;
                    }
                    case 100: {
                        HashMap<String, Object> network = new HashMap<String, Object>(3);
                        network.put("strength", 10);
                        network.put("band", 1300);
                        network.put("name", "CMCC(LTE)");
                        data.put("network", network);
                        break;
                    }
                    case 102: {
                        data.put("IMSI", "123456789012345");
                        break;
                    }
                    case 103: {
                        HashMap<String, Integer> homeWifiMatch = new HashMap<String, Integer>(2);
                        homeWifiMatch.put("matched", 1);
                        homeWifiMatch.put("noMatched", 0);
                        data.put("homeWifiMatch", homeWifiMatch);
                        break;
                    }
                    case 105: {
                        data.put("CLIR", 0);
                        break;
                    }
                    case 106: {
                        HashMap<String, Integer> weather = new HashMap<String, Integer>(3);
                        weather.put("status", 1);
                        weather.put("time1", 0);
                        weather.put("time2", 0);
                        data.put("weather", weather);
                        break;
                    }
                    case 115: {
                        ArrayList beaconList = new ArrayList();
                        HashMap<String, Object> beacon = new HashMap<String, Object>(6);
                        beacon.put("index", 0);
                        beacon.put("enable", 1);
                        beacon.put("mac", "00:00:00:00:00:00");
                        beacon.put("lat", 22.23);
                        beacon.put("lng", 114.45);
                        beacon.put("describe", "beacon_describe");
                        beaconList.add(beacon);
                        data.put("beaconList", beaconList);
                        break;
                    }
                    case 116: {
                        HashMap<String, Integer> findMe = new HashMap<String, Integer>(3);
                        findMe.put("times", 0);
                        findMe.put("playIndex", 0);
                        findMe.put("sound", 0);
                        data.put("findMe", findMe);
                        break;
                    }
                    case 119: {
                        HashMap<String, Integer> alertRunStep = new HashMap<String, Integer>(4);
                        alertRunStep.put("status", 1);
                        alertRunStep.put("time", 60);
                        alertRunStep.put("count", 10);
                        alertRunStep.put("call", 0);
                        data.put("runStepAlert", alertRunStep);
                        break;
                    }
                    case 120: {
                        data.put("deviceState", 0);
                        break;
                    }
                    case 121: {
                        data.put("fallDownTime", 10);
                        break;
                    }
                    case 122: {
                        HashMap<String, Integer> spo2Interval = new HashMap<String, Integer>(2);
                        spo2Interval.put("interval", 39321610);
                        spo2Interval.put("status", 0);
                        data.put("spo2Interval", spo2Interval);
                        break;
                    }
                    case 124: {
                        HashMap<String, Integer> motionAlertExt = new HashMap<String, Integer>(2);
                        motionAlertExt.put("preAlertTime", 3);
                        data.put("motionAlertExt", motionAlertExt);
                        break;
                    }
                    case 125: {
                        data.put("sosAlertExt", 1);
                        break;
                    }
                    case 126: {
                        data.put("voiceParam", 1);
                        break;
                    }
                    case 128: {
                        HashMap<String, Integer> sub1G = new HashMap<String, Integer>(5);
                        sub1G.put("status", 1);
                        sub1G.put("lowBattery", 1);
                        sub1G.put("fallDown", 1);
                        sub1G.put("band", 0);
                        sub1G.put("syncWord", 11732);
                        data.put("sub1G", sub1G);
                        break;
                    }
                    case 129: {
                        ArrayList sub1GWhiteList = new ArrayList();
                        HashMap<String, Object> sub1GMap = new HashMap<String, Object>(3);
                        sub1GMap.put("status", 0);
                        sub1GMap.put("index", 0);
                        sub1GMap.put("deviceID", "123456");
                        sub1GWhiteList.add(sub1GMap);
                        data.put("sub1GWhiteList", sub1GWhiteList);
                        break;
                    }
                    case 130: {
                        data.put("token", "");
                        break;
                    }
                    case 131: {
                        data.put("testAlert", "");
                        break;
                    }
                    case 132: {
                        HashMap<String, Object> nfcMap = new HashMap<String, Object>(2);
                        nfcMap.put("status", 0);
                        nfcMap.put("message", "");
                        data.put("nfc", nfcMap);
                        break;
                    }
                    case 133: {
                        HashMap<String, Integer> lora = new HashMap<String, Integer>(5);
                        lora.put("status", 1);
                        lora.put("lowBattery", 1);
                        lora.put("band", 0);
                        data.put("lora", lora);
                        break;
                    }
                    case 134: {
                        ArrayList loraWhiteList = new ArrayList();
                        HashMap<String, Object> loraMap = new HashMap<String, Object>(3);
                        loraMap.put("status", 0);
                        loraMap.put("index", 0);
                        loraMap.put("deviceType", 1);
                        loraMap.put("deviceID", "123456");
                        loraWhiteList.add(loraMap);
                        data.put("loraWhiteList", loraWhiteList);
                        break;
                    }
                    case 144: {
                        HashMap<String, Object> voip = new HashMap<String, Object>(2);
                        voip.put("status", 0);
                        voip.put("accountInfo", "");
                        data.put("voip", voip);
                        break;
                    }
                    case 145: {
                        ArrayList voipList = new ArrayList();
                        HashMap<String, Object> voipMap = new HashMap<String, Object>(3);
                        voipMap.put("status", 0);
                        voipMap.put("index", 0);
                        voipMap.put("accountInfo", "");
                        voipList.add(voipMap);
                        data.put("voipList", voipList);
                        break;
                    }
                    case 208: {
                        HashMap<String, String> wifiHotspot = new HashMap<String, String>(2);
                        wifiHotspot.put("mac", "00:00:00:00:00:00");
                        wifiHotspot.put("name", "");
                        data.put("wifiHotspot", wifiHotspot);
                        break;
                    }
                    case 209: {
                        HashMap<String, Object> ethernet = new HashMap<String, Object>(7);
                        ethernet.put("ipMode", 0);
                        ethernet.put("mac", "0.0.0.0");
                        ethernet.put("ipv4", "0.0.0.0");
                        ethernet.put("netmask", "0.0.0.0");
                        ethernet.put("gateway", "0.0.0.0");
                        ethernet.put("dns1", "0.0.0.0");
                        ethernet.put("dns2", "0.0.0.0");
                        data.put("ethernet", ethernet);
                        break;
                    }
                    case 210: {
                        HashMap<String, Integer> internetAccessMode = new HashMap<String, Integer>(3);
                        internetAccessMode.put("mode1", 0);
                        internetAccessMode.put("mode2", 0);
                        internetAccessMode.put("mode3", 0);
                        data.put("internetAccessMode", internetAccessMode);
                        break;
                    }
                    case 211: {
                        data.put("internetStatus", 0);
                        break;
                    }
                    case 225: {
                        HashMap<String, Object> mbn = new HashMap<String, Object>(2);
                        mbn.put("state", 7);
                        mbn.put("name", "");
                        data.put("MBN", mbn);
                        break;
                    }
                    case 240: {
                        data.put("Read", "1,2,3,4");
                    }
                }
                break;
            }
            case 3: {
                switch (key) {
                    case 1: {
                        data.put("imei", "123456789012345");
                        break;
                    }
                    case 16: {
                        data.put("heartBeat", 90);
                        break;
                    }
                    case 17: {
                        if (dataType.equals("Req")) {
                            HashMap<String, Double> addresses = new HashMap<String, Double>(2);
                            addresses.put("lat", 0.0);
                            addresses.put("lng", 0.0);
                            data.put("addresses", addresses);
                            break;
                        }
                        if (!dataType.equals("Res")) break;
                        HashMap<String, Object> addresses = new HashMap<String, Object>(3);
                        addresses.put("lat", 0.0);
                        addresses.put("lng", 0.0);
                        addresses.put("address", "");
                        data.put("addresses", addresses);
                        break;
                    }
                    case 18: {
                        if (dataType.equals("Req")) {
                            data.put("systemTime", "null");
                            break;
                        }
                        if (!dataType.equals("Res")) break;
                        data.put("systemTime", now);
                        break;
                    }
                    case 19: {
                        HashMap<String, Object> weather = new HashMap<String, Object>(4);
                        if (dataType.equals("Req")) {
                            weather.put("lang", "en");
                            weather.put("lat", 0.0);
                            weather.put("lng", 0.0);
                        } else if (dataType.equals("Res")) {
                            weather.put("dateTime", now);
                            weather.put("lat", 0.0);
                            weather.put("lng", 0.0);
                            weather.put("city", "");
                        }
                        data.put("weather", weather);
                        break;
                    }
                    case 20: {
                        HashMap<String, Object> weather2 = new HashMap<String, Object>(9);
                        weather2.put("dateTime", now);
                        weather2.put("codeDay", 100);
                        weather2.put("codeNight", 100);
                        weather2.put("tempMax", 20.2);
                        weather2.put("tempMin", 29.8);
                        weather2.put("hum", 86);
                        weather2.put("uvIndex", 0);
                        weather2.put("windSpd", 4);
                        weather2.put("windDeg", 173);
                        data.put("weather2", weather2);
                        break;
                    }
                    case 33: {
                        HashMap gsm = new HashMap();
                        ArrayList gsmList = new ArrayList();
                        HashMap<String, Integer> data_gsm = new HashMap<String, Integer>(5);
                        data_gsm.put("mcc", 724);
                        data_gsm.put("mnc", 10);
                        data_gsm.put("cellId", 15693);
                        data_gsm.put("lac", 7511);
                        data_gsm.put("signal", 26);
                        gsmList.add(data_gsm);
                        gsm.put("gsmList", gsmList);
                        data.put("location_gsm", gsm);
                        break;
                    }
                    case 34: {
                        HashMap wifi = new HashMap();
                        ArrayList list = new ArrayList();
                        HashMap<String, Object> data_wifi = new HashMap<String, Object>(2);
                        data_wifi.put("mac", "AC:C6:62:E4:C9:B0");
                        data_wifi.put("signal", -90);
                        list.add(data_wifi);
                        wifi.put("wifiList", list);
                        data.put("location_wifi", wifi);
                        break;
                    }
                    case 36: {
                        HashMap<String, Object> data_status = new HashMap<String, Object>(2);
                        data_status.put("dateTime", now);
                        HashMap<String, Integer> deviceStatus = new HashMap<String, Integer>(15);
                        deviceStatus.put("isGPS", 1);
                        deviceStatus.put("isWIFI", 0);
                        deviceStatus.put("isGMS", 0);
                        deviceStatus.put("isBLE", 0);
                        deviceStatus.put("isSmart", 0);
                        deviceStatus.put("isBeacon", 0);
                        deviceStatus.put("isCharging", 0);
                        deviceStatus.put("isChargingComplete", 0);
                        deviceStatus.put("isReboot", 0);
                        deviceStatus.put("isHistoricalData", 0);
                        deviceStatus.put("isAGPS", 1);
                        deviceStatus.put("isMotion", 0);
                        deviceStatus.put("workMode", 2);
                        deviceStatus.put("signalSize", 24);
                        deviceStatus.put("battery", 80);
                        data_status.put("deviceStatus", deviceStatus);
                        data.put("status", data_status);
                    }
                }
                break;
            }
            case 4: {
                switch (key) {
                    case 1: {
                        data.put("imei", "123456789012345");
                        break;
                    }
                    case 16: {
                        data.put("resetRecord", "null");
                        break;
                    }
                    case 17: {
                        data.put("reFactory", "null");
                        break;
                    }
                    case 18: {
                        data.put("reboot", "null");
                        break;
                    }
                    case 19: {
                        data.put("findMe", "null");
                        break;
                    }
                    case 20: {
                        data.put("shutdown", "null");
                        break;
                    }
                    case 21: {
                        data.put("led", 0);
                        break;
                    }
                    case 22: {
                        if (dataType.equals("Req")) {
                            data.put("scanBLE", "null");
                            break;
                        }
                        if (!dataType.equals("Res")) break;
                        ArrayList list = new ArrayList(1);
                        HashMap<String, Object> scanBLE = new HashMap<String, Object>(2);
                        scanBLE.put("mac", "00:00:00:00:00:00");
                        scanBLE.put("rssi", 0);
                        list.add(scanBLE);
                        data.put("scanBLE", list);
                        break;
                    }
                    case 23: {
                        data.put("firmwareRecovery", "null");
                        break;
                    }
                    case 25: {
                        HashMap<String, Object> scanBeaconAuto = new HashMap<String, Object>(3);
                        scanBeaconAuto.put("lat", 0.0);
                        scanBeaconAuto.put("lng", 0.0);
                        scanBeaconAuto.put("describe", "");
                        data.put("scanBeaconAuto", scanBeaconAuto);
                        break;
                    }
                    case 26: {
                        HashMap<String, Object> scanWifiAuto = new HashMap<String, Object>(3);
                        scanWifiAuto.put("lat", 0.0);
                        scanWifiAuto.put("lng", 0.0);
                        scanWifiAuto.put("describe", "");
                        data.put("scanWifiAuto", scanWifiAuto);
                        break;
                    }
                    case 27: {
                        if (dataType.equals("Req")) {
                            HashMap<String, Integer> scanWifi = new HashMap<String, Integer>(2);
                            scanWifi.put("rssi", 0);
                            scanWifi.put("interval", 0);
                            data.put("scanWifi", scanWifi);
                            break;
                        }
                        if (!dataType.equals("Res")) break;
                        ArrayList scanWifiList = new ArrayList(1);
                        HashMap<String, Object> scanWifi = new HashMap<String, Object>(5);
                        scanWifi.put("index", 0);
                        scanWifi.put("mac", "00:00:00:00:00:00");
                        scanWifi.put("name", "");
                        scanWifi.put("rssi", 0);
                        scanWifi.put("network", 0);
                        scanWifiList.add(scanWifi);
                        data.put("scanWifi", scanWifiList);
                        break;
                    }
                    case 28: {
                        HashMap<String, Integer> light = new HashMap<String, Integer>(2);
                        light.put("status", 0);
                        light.put("value", 0);
                        data.put("light", light);
                        break;
                    }
                    case 30: {
                        data.put("motor", 0);
                        break;
                    }
                    case 31: {
                        HashMap<String, Object> alarmTTS = new HashMap<String, Object>(2);
                        alarmTTS.put("type", 0);
                        alarmTTS.put("content", "");
                        data.put("alarmTTS", alarmTTS);
                        break;
                    }
                    case 33: {
                        ArrayList uploadingBLEList = new ArrayList(1);
                        HashMap<String, String> uploadingBLE = new HashMap<String, String>(2);
                        uploadingBLE.put("mac", "");
                        uploadingBLE.put("rssi", "");
                        uploadingBLEList.add(uploadingBLE);
                        data.put("uploadingBLE", uploadingBLEList);
                        break;
                    }
                    case 48: {
                        HashMap<String, String> ota = new HashMap<String, String>(1);
                        ota.put("url", "");
                        data.put("ota", ota);
                        break;
                    }
                    case 49: {
                        data.put("heart", 90);
                        break;
                    }
                    case 64: {
                        data.put("alarmControl", 1);
                        break;
                    }
                    case 65: {
                        data.put("cancelSOS", "null");
                        break;
                    }
                    case 66: {
                        if (dataType.equals("Req")) {
                            data.put("scanBeacon", "null");
                            break;
                        }
                        if (!dataType.equals("Res")) break;
                        ArrayList scanBeaconList = new ArrayList();
                        HashMap<String, Object> scanBeacon = new HashMap<String, Object>(2);
                        scanBeacon.put("mac", "00:00:00:00:00:00");
                        scanBeacon.put("rssi", 0);
                        scanBeaconList.add(scanBeacon);
                        data.put("scanBeacon", scanBeaconList);
                        break;
                    }
                    case 68: {
                        data.put("SimCardUnLock", "null");
                    }
                }
                break;
            }
            case 126: {
                switch (key) {
                    case 16: {
                        data.put("InitialData", "null");
                        break;
                    }
                    case 17: {
                        HashMap<String, Integer> firmwareData = new HashMap<String, Integer>();
                        firmwareData.put("offset", 0);
                        data.put("FirmwareData", firmwareData);
                        break;
                    }
                    case 18: {
                        data.put("Validate", "null");
                        break;
                    }
                    case 19: {
                        HashMap<String, Object> state = new HashMap<String, Object>();
                        state.put("updateStateKey", 16);
                        state.put("updateStateKey", "17offset");
                        state.put("updateStateKey", 18);
                        data.put("State", state);
                        break;
                    }
                    case 21: {
                        HashMap<String, Integer> packSize = new HashMap<String, Integer>();
                        packSize.put("updatePackSize", 4096);
                        data.put("PackSize", packSize);
                        break;
                    }
                    case 22: {
                        String byteData = "AB ";
                        data.put("RequestData", byteData);
                    }
                }
                break;
            }
            case 127: {
                data.put("cmdKey", key);
                break;
            }
        }
        return data;
    }
}

