/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b;

import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProtocolUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_DEFAULT = "1970-01-01";
    public static final String DATETIME_DEFAULT = "1970-01-01 00:00:00";
    public static final String HOURMINUTE_DEFAULT = "00:00";
    public static final String MAC_DEFAULT = "00:00:00:00:00:00";
    public static final String IP_DEFAULT = "0.0.0.0";
    public static final String IMEI_DEFAULT = "000000000000000";
    public static final String ICCID_DEFAULT = "00000000000000000000";

    private ProtocolUtil() {
    }

    public static void saveLocationData(Map<String, Object> data, String key, Object value, boolean isSaveList) {
        List dataList;
        if (data.get("dataList") == null) {
            dataList = new ArrayList();
            data.put("dataList", dataList);
        } else {
            dataList = (List)data.get("dataList");
        }
        if (key.equals("status")) {
            HashMap<String, Object> node = new HashMap<String, Object>(16);
            node.put(key, value);
            dataList.add(node);
        } else {
            Map dataObj = (Map)dataList.get(dataList.size() - 1);
            if (isSaveList) {
                ProtocolUtil.saveNewToList(dataObj, key, value);
            } else {
                dataObj.put(key, value);
            }
        }
    }

    public static void saveNewToList(Map<String, Object> data, String key, Object value) {
        List<Map> list;
        if (data.get(key) == null) {
            list = new ArrayList();
            data.put(key, list);
        } else {
            list = (List)data.get(key);
        }
        if (value instanceof Map) {
            list.add((Map)value);
        } else if (value instanceof List) {
            list.addAll((List)value);
        }
    }

    public static Date bytes2DateTime(byte[] data) {
        return ProtocolUtil.bytes2DateTime(data, false);
    }

    public static Date bytes2DateTime(byte[] data, boolean isSign) {
        long dateTime = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 0, 4), isSign);
        return new Date(dateTime * 1000L);
    }

    public static byte[] dateTime2Bytes(Object date) {
        byte[] dateBytes = new byte[]{0, 0, 0, 0};
        try {
            if (date instanceof String) {
                String dateStr = Convert.toStr(date);
                if (dateStr.length() == DATE_DEFAULT.length()) {
                    String dateTime = Convert.toStr(date, DATE_DEFAULT);
                    dateBytes = ProtocolUtil.dateTime2Bytes(new SimpleDateFormat(DATE_FORMAT).parse(dateTime));
                } else if (dateStr.length() == DATETIME_DEFAULT.length()) {
                    String dateTime = Convert.toStr(date, DATETIME_DEFAULT);
                    dateBytes = ProtocolUtil.dateTime2Bytes(new SimpleDateFormat(DATETIME_FORMAT).parse(dateTime));
                }
            } else if (date instanceof Long) {
                dateBytes = ProtocolUtil.dateTime2Bytes(new Date(Convert.toLong(date)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return dateBytes;
    }

    public static byte[] dateTime2Bytes(Date date) {
        long dateTime = date.getTime() / 1000L;
        return new byte[]{(byte)(dateTime & 0xFFL), (byte)(dateTime >> 8 & 0xFFL), (byte)(dateTime >> 16 & 0xFFL), (byte)(dateTime >> 24 & 0xFFL)};
    }

    public static String bytes2Mac(byte[] data, boolean isOrder) {
        String mac = BytesHexStrUtil.bytesToHexString(data, isOrder);
        mac = mac.replaceAll(" ", ":");
        return mac;
    }

    public static byte[] mac2Bytes(String data, boolean isOrder) {
        data = data.replaceAll(":", "").replaceAll("-", "");
        data = ProtocolUtil.strAfterFillZero(data, 12);
        return BytesHexStrUtil.hexStringToBytes(data, isOrder);
    }

    public static String bytes2IpAddr(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append(data[i] & 0xFF);
            sb.append(".");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static byte[] ipAddr2Bytes(String data) {
        String[] split = data.split("\\.");
        byte[] ipBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ipBytes[i] = (byte)Integer.parseInt(split[i]);
        }
        return ipBytes;
    }

    public static double bytes2Latlng(byte[] data) {
        long latlng = ProtocolUtil.bytes2Long(data, true);
        return Double.valueOf(latlng) / 1.0E7;
    }

    public static byte[] latlng2Bytes(double lat, double lng) {
        return ArrayUtils.addAll(ProtocolUtil.latlng2Bytes(lat), ProtocolUtil.latlng2Bytes(lng));
    }

    public static byte[] latlng2Bytes(double data) {
        BigDecimal d1 = BigDecimal.valueOf(data);
        BigDecimal d2 = BigDecimal.valueOf(10000000L);
        BigDecimal latlng = d1.multiply(d2);
        return ProtocolUtil.long2Bytes(latlng.longValue(), 4);
    }

    public static int bytes2Int(byte data, boolean isSign) {
        if (isSign) {
            return data;
        }
        return data & 0xFF;
    }

    public static byte[] long2Bytes(long data, int length) {
        byte[] dataByte = new byte[length];
        for (int i = 0; i < length; ++i) {
            dataByte[i] = (byte)(data >> 8 * i & 0xFFL);
        }
        return dataByte;
    }

    public static long bytes2Long(byte[] data) {
        return ProtocolUtil.bytes2Long(data, false);
    }

    public static long bytes2Long(byte[] data, boolean isSign) {
        long dataLong = 0L;
        for (int i = 0; i < data.length; ++i) {
            if (isSign && i == data.length - 1) {
                dataLong |= (long)data[i] << 8 * i;
                continue;
            }
            dataLong |= (long)(data[i] & 0xFF) << 8 * i;
        }
        return dataLong;
    }

    public static int getbit(long data, int beginIndex, int endIndex) {
        int num = endIndex - beginIndex;
        if (num > 31) {
            throw new RuntimeException("Index out of range");
        }
        num = (1 << num) - 1;
        return (int)(data >> beginIndex & (long)num);
    }

    public static long getBitOfLong(long data, int beginIndex, int endIndex) {
        int range = endIndex - beginIndex;
        if (range > 63) {
            throw new RuntimeException("Index out of range");
        }
        long num = (1L << range) - 1L;
        return data >> beginIndex & num;
    }

    public static String strAfterFillZero(String str, int length) {
        StringBuilder buffer = new StringBuilder(str);
        if (buffer.length() >= length) {
            return buffer.toString();
        }
        while (buffer.length() < length) {
            buffer.append("0");
        }
        return buffer.toString();
    }
}

