/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b;

import com.tracker.ev07b.Protocol;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.service.BodyService;
import com.tracker.ev07b.service.CmdService;
import com.tracker.ev07b.service.HeadService;
import com.tracker.ev07b.service.command.CommandConfig;
import com.tracker.ev07b.service.command.CommandData;
import com.tracker.ev07b.service.command.CommandResponse;
import com.tracker.ev07b.service.command.CommandService;
import com.tracker.ev07b.service.command.CommandSystem;
import com.tracker.ev07b.service.command.CommandUpdate;
import com.tracker.ev07b.service.key.KeyAlarmCode;
import com.tracker.util.RingBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ProtocolAnalysis
implements Protocol {
    public static ProtocolAnalysis INSTANCE = new ProtocolAnalysis();

    private ProtocolAnalysis() {
    }

    @Override
    public String codeAnalysis(byte[] data) {
        return CmdService.INSTANCE.codeAnalysis(data);
    }

    public List<Map<String, Object>> protocolAnalysis(byte[] data) {
        return CmdService.INSTANCE.protocolAnalysis(data);
    }

    @Override
    public Map<String, Object> protocolAnalysis(CmdModel cmdModel) {
        return CmdService.INSTANCE.protocolAnalysis(cmdModel);
    }

    @Override
    public Map<String, Object> getAlarmStatus(long alarmFlag) {
        return KeyAlarmCode.INSTANCE.getAlarmStatus(alarmFlag);
    }

    @Override
    public Map<String, Object> getAlarmStatusExtend(long alarmFlag) {
        return KeyAlarmCode.INSTANCE.getAlarmStatusExtend(alarmFlag);
    }

    @Override
    public byte[] getByteData(CmdHead cmdHead, byte[] cmdBody) {
        return CmdService.INSTANCE.getByteData(cmdHead, cmdBody);
    }

    @Override
    public byte[] getByteData(CmdHead cmdHead, CmdBody cmdBody) {
        return CmdService.INSTANCE.getByteData(cmdHead, cmdBody);
    }

    @Override
    public byte[] getByteData(CmdModel cmdModel) {
        return CmdService.INSTANCE.getByteData(cmdModel);
    }

    @Override
    public void addBuffer(RingBuffer bufferData, Consumer<CmdModel> consumer) {
        CmdService.INSTANCE.addBuffer(bufferData, consumer);
    }

    @Override
    public CmdHead analysisHeadData(byte[] headData) {
        return HeadService.INSTANCE.analysisHeadData(headData);
    }

    @Override
    public CmdHead getCommandHead(int sequenceId, boolean ack) {
        return HeadService.INSTANCE.getCommandHead(sequenceId, ack);
    }

    @Override
    public CmdHead getCommandHead(int sequenceId, boolean ack, int version) {
        return HeadService.INSTANCE.getCommandHead(sequenceId, ack, version);
    }

    @Override
    public CmdBody analysisBodyData(byte[] bodyData) {
        return BodyService.INSTANCE.analysisBodyData(bodyData);
    }

    @Override
    public CmdBody getCommand_config(Map<String, Object> data) {
        return CommandConfig.INSTANCE.decode(data);
    }

    @Override
    public CmdBody getCommand_data(Map<String, Object> data) {
        return CommandData.INSTANCE.decode(data);
    }

    @Override
    public CmdBody getCommand_service(Map<String, Object> data) {
        return CommandService.INSTANCE.decode(data);
    }

    @Override
    public CmdBody getCommand_system(Map<String, Object> data) {
        return CommandSystem.INSTANCE.decode(data);
    }

    @Override
    public CmdBody getCommand_update(Map<String, Object> data) {
        return CommandUpdate.INSTANCE.decode(data);
    }

    @Override
    public CmdBody getCommand_response(Map<String, Object> data) {
        return CommandResponse.INSTANCE.decode(data);
    }

    @Override
    public CmdBody getCommandBody(int cmdType, int cmdKey, byte[] cmdValue) {
        return BodyService.INSTANCE.getCommandBody(cmdType, cmdKey, cmdValue);
    }

    @Override
    public byte[] getByteData_body(CmdBody cmd_bodyData) {
        return BodyService.INSTANCE.getByteData_body(cmd_bodyData);
    }

    @Override
    public List<byte[]> getByteData_body(CmdBody cmd_bodyData, long maxBodySize) {
        return BodyService.INSTANCE.getByteData_body(cmd_bodyData, maxBodySize);
    }
}

