/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b;

import com.tracker.util.AESUtil;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.CheckCRC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EncryptAlgorithm {
    private static int CC = 200;
    private static String algorithmIV = "66998AAB7B7D027DF48423D40D0C2679";

    public List<Map<String, ?>> decode(byte[] data, String algorithmKey) {
        ArrayList cmdList = new ArrayList();
        if (data != null && data.length > 0) {
            int read = 0;
            while (read + 16 < data.length) {
                HashMap<String, Object> cmd_encode = new HashMap<String, Object>();
                if ((data[read] & 0xFF) == 165 && read + 16 < data.length) {
                    byte[] bodyData;
                    int check_body_crc;
                    byte[] headData = Arrays.copyOfRange(data, read, read + 16);
                    int header = headData[read] & 0xFF;
                    int length = headData[read + 2] & 0xFF | (headData[read + 3] & 0xFF) << 8;
                    int cmdData_length = length + 16;
                    int body_crc = headData[read + 4] & 0xFF | (headData[read + 5] & 0xFF) << 8;
                    int sequenceId = headData[read + 6] & 0xFF | (headData[read + 7] & 0xFF) << 8;
                    int encodeId = headData[read + 8] & 0xFF | (headData[read + 9] & 0xFF) << 8 | (headData[read + 10] & 0xFF) << 16;
                    int encodeType = headData[read + 11] & 0xFF;
                    int cc = headData[read + 12] & 0xFF | (headData[read + 13] & 0xFF) << 8;
                    int head_crc = headData[read + 14] & 0xFF | (headData[read + 15] & 0xFF) << 8;
                    int check_head_crc = CheckCRC.crc16_bit(Arrays.copyOfRange(headData, read, read + 14));
                    cmd_encode.put("encodeType", encodeType);
                    cmd_encode.put("encodeId", encodeId);
                    cmd_encode.put("sequenceId", sequenceId);
                    if (head_crc == check_head_crc && data.length >= read + cmdData_length && body_crc == (check_body_crc = CheckCRC.crc16_bit(bodyData = Arrays.copyOfRange(data, read + 16, read + cmdData_length)))) {
                        byte[] key = BytesHexStrUtil.hexStringToBytes(algorithmKey);
                        byte[] iv = BytesHexStrUtil.hexStringToBytes(algorithmIV);
                        byte[] decode = AESUtil.AESDecrypt(key, iv, bodyData);
                        byte[] originalData = ArrayUtils.addAll(headData, bodyData);
                        cmd_encode.put("originalData", BytesHexStrUtil.bytesToHexString(originalData));
                        cmd_encode.put("decodeData", decode);
                        data = Arrays.copyOfRange(data, read + cmdData_length, data.length);
                        read += cmdData_length;
                        continue;
                    }
                }
                ++read;
                cmdList.add(cmd_encode);
            }
        }
        return cmdList;
    }

    public static byte[] encode(Map<String, Object> head, byte[] data, String algorithmKey) {
        int encodeType = (Integer)head.get("encodeType");
        int encodeId = (Integer)head.get("encodeId");
        int sequenceId = (Integer)head.get("sequenceId");
        byte[] key = BytesHexStrUtil.hexStringToBytes(algorithmKey);
        byte[] iv = BytesHexStrUtil.hexStringToBytes(algorithmIV);
        byte[] bodyData = AESUtil.AESEncrypt(key, iv, data);
        byte[] headData = new byte[16];
        headData[0] = -91;
        int properties = 1;
        headData[1] = (byte)(properties & 0xFF);
        int length = bodyData.length;
        headData[2] = (byte)(length & 0xFF);
        headData[3] = (byte)(length >> 8 & 0xFF);
        int body_crc = CheckCRC.crc16_bit(bodyData);
        headData[4] = (byte)(body_crc & 0xFF);
        headData[5] = (byte)(body_crc >> 8 & 0xFF);
        headData[6] = (byte)(sequenceId & 0xFF);
        headData[7] = (byte)(sequenceId >> 8 & 0xFF);
        headData[8] = (byte)(encodeId & 0xFF);
        headData[9] = (byte)(encodeId >> 8 & 0xFF);
        headData[10] = (byte)(encodeId >> 16 & 0xFF);
        headData[11] = (byte)(encodeType & 0xFF);
        headData[12] = (byte)(CC & 0xFF);
        headData[13] = (byte)(CC >> 8 & 0xFF);
        int head_crc = CheckCRC.crc16_bit(Arrays.copyOfRange(headData, 0, 14));
        headData[14] = (byte)(head_crc & 0xFF);
        headData[15] = (byte)(head_crc >> 8 & 0xFF);
        return ArrayUtils.addAll(headData, bodyData);
    }
}

