/*
 * Decompiled with CFR 0.152.
 */
package com.eview.util;

import com.eview.util.PublicUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger log = Logger.getLogger(FileUtil.class);

    public static String getCurrentPath(String path) {
        File file = new File(path);
        String currentPath = null;
        try {
            currentPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return currentPath;
    }

    public static void hideFiles(String filePath) {
        File dir = new File(filePath);
        String sets = "attrib +H \"" + dir.getAbsolutePath() + "\"";
        try {
            Runtime.getRuntime().exec(sets);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean delFolder(String path) {
        boolean flag = false;
        File file = new File(path);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.delFolder(files[i].getAbsolutePath());
            }
        }
        file.delete();
        return flag;
    }

    public static List<String> traverseFolder(String path) {
        ArrayList<String> fileList = new ArrayList<String>();
        File file = new File(path);
        if (file.exists()) {
            File[] files = file.listFiles();
            if (null == files || files.length == 0) {
                System.out.println("\u6587\u4ef6\u5939\u662f\u7a7a\u7684!");
                return null;
            }
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    System.out.println("\u6587\u4ef6\u5939:" + file2.getAbsolutePath());
                    FileUtil.traverseFolder(file2.getAbsolutePath());
                    continue;
                }
                fileList.add(file2.getAbsolutePath());
                System.out.println("\u6587\u4ef6:" + file2.getAbsolutePath());
            }
        } else {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        return fileList;
    }

    public static File[] sort(File[] s) {
        File temp = null;
        for (int j = 0; j < s.length - 1; ++j) {
            String min = s[j].getName();
            int minIndex = j;
            for (int k = j + 1; k < s.length; ++k) {
                if (Integer.parseInt(min.substring(0, min.indexOf("."))) <= Integer.parseInt(s[k].getName().substring(0, s[k].getName().indexOf(".")))) continue;
                min = s[k].getName();
                minIndex = k;
            }
            temp = s[j];
            s[j] = s[minIndex];
            s[minIndex] = temp;
        }
        return s;
    }

    public static void unzip(InputStream inputStream, String filePath) {
        ZipInputStream zis = null;
        BufferedOutputStream bos = null;
        try {
            zis = new ZipInputStream(inputStream);
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null && !entry.isDirectory()) {
                File target = new File(filePath, entry.getName());
                if (!target.getParentFile().exists()) {
                    target.getParentFile().mkdirs();
                }
                bos = new BufferedOutputStream(new FileOutputStream(target));
                int read = 0;
                byte[] buffer = new byte[10240];
                while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, read);
                }
                bos.flush();
                bos.close();
            }
            zis.closeEntry();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                PublicUtil.close(zis, bos);
                throw throwable;
            }
        }
        PublicUtil.close(zis, bos);
    }

    public static void copyFile(String strFilePath, String fileName) {
        try {
            FileInputStream ins = new FileInputStream(strFilePath);
            FileUtil.copyFile(ins, fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inputStream, String fileName) {
        File targetFile = new File(fileName);
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(targetFile);
            byte[] array = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(array)) != -1) {
                outputStream.write(array, 0, bytesRead);
            }
            outputStream.flush();
            log.info((Object)("copy file " + targetFile.getName() + " success."));
        }
        catch (Exception e) {
            try {
                log.error((Object)("copy file " + targetFile.getName() + " error."), (Throwable)e);
            }
            catch (Throwable throwable) {
                PublicUtil.close(inputStream, outputStream);
                throw throwable;
            }
            PublicUtil.close(inputStream, outputStream);
        }
        PublicUtil.close(inputStream, outputStream);
    }

    public static void sendfile4zeroCopy(String from, String to) {
        File sourceFile = new File(from);
        File targetFile = new File(to);
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try (FileChannel source = new FileInputStream(sourceFile).getChannel();
             FileChannel destination = new FileOutputStream(targetFile).getChannel();){
            source.transferTo(0L, source.size(), destination);
        }
        catch (IOException e) {
            log.error((Object)"copy file error.", (Throwable)e);
        }
    }
}

