/*
 * Decompiled with CFR 0.152.
 */
package com.eview.util;

import com.eview.util.Constants;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ConfigFileUtil {
    private Map<String, Map<String, String>> map = null;
    private String currentSection = null;
    private String filePath = null;
    private static final String encryptKey = "eview2020";
    private static ConfigFileUtil instance = null;

    public static ConfigFileUtil getInstance(String path) {
        if (instance == null) {
            instance = new ConfigFileUtil(path);
        }
        return instance;
    }

    private ConfigFileUtil(String path) {
        this.filePath = path;
        try {
            File file;
            String directory = path.substring(0, path.lastIndexOf(Constants.fs));
            File dir = new File(directory);
            if (!dir.isDirectory()) {
                dir.mkdirs();
            }
            if (!(file = new File(path)).exists()) {
                file.createNewFile();
            }
            byte[] data = Files.readAllBytes(file.toPath());
            data = this.encrypt(data, encryptKey.getBytes());
            this.initConfigData(data);
        }
        catch (Exception e) {
            throw new RuntimeException("IO Exception:" + String.valueOf(e));
        }
    }

    public void initConfigData(byte[] data) {
        this.map = new HashMap<String, Map<String, String>>();
        InputStreamReader inReader = new InputStreamReader(new ByteArrayInputStream(data));
        BufferedReader reader = new BufferedReader(inReader);
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.parseLine(line);
            }
            inReader.close();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseLine(String line) {
        if ((line = line.trim()).matches("^\\#.*$")) {
            return;
        }
        if (line.matches("^\\[\\S+\\]$")) {
            String section = line.replaceFirst("^\\[(\\S+)\\]$", "$1");
            this.addSection(this.map, section);
        } else if (line.matches("^\\S+=.*$")) {
            int i = line.indexOf("=");
            String key = line.substring(0, i).trim();
            String value = line.substring(i + 1).trim();
            this.addKeyValue(this.map, this.currentSection, key, value);
        }
    }

    private void addKeyValue(Map<String, Map<String, String>> map, String section, String key, String value) {
        if (!map.containsKey(section)) {
            return;
        }
        Map<String, String> childMap = map.get(section);
        childMap.put(key, value);
    }

    private void addSoftKeyValue(Map<String, Map<String, String>> map, String section, String key, String value) {
        if (!map.containsKey(section)) {
            return;
        }
        Map<String, String> childMap = map.get(section);
        if (!childMap.containsKey(key)) {
            childMap.put(key, value);
        }
    }

    private void addSection(Map<String, Map<String, String>> map, String section) {
        if (!map.containsKey(section)) {
            this.currentSection = section;
            HashMap childMap = new HashMap();
            map.put(section, childMap);
        }
    }

    public String readProperty(String section, String key, String defaults) {
        Map<String, String> map2;
        if (this.map.containsKey(section) && (map2 = this.map.get(section)).containsKey(key)) {
            return map2.get(key);
        }
        return defaults;
    }

    public void setProperty(String section, String key, String value) {
        this.addSection(this.map, section);
        this.addSoftKeyValue(this.map, section, key, value);
    }

    public boolean writeProperty(String section, String key, String value) {
        this.addSection(this.map, section);
        this.addKeyValue(this.map, section, key, value);
        return this.writeProperty();
    }

    public boolean writeProperty() {
        try {
            ByteArrayOutputStream out_b = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(out_b);
            for (String section : this.map.keySet()) {
                out.print(Constants.lines);
                out.println("[" + section + "]");
                Map<String, String> childMap = this.map.get(section);
                for (String key : childMap.keySet()) {
                    out.println(key + "=" + childMap.get(key));
                }
            }
            out.flush();
            out.close();
            byte[] data = this.encrypt(out_b.toByteArray(), encryptKey.getBytes());
            Files.write(Paths.get(this.filePath, new String[0]), data, new OpenOption[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public byte[] encrypt(byte[] data, byte[] key) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return data;
        }
        byte[] result = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = (byte)(data[i] ^ key[i % key.length] ^ i & 0xFF);
        }
        return result;
    }

    public boolean check(byte[] key) {
        return Arrays.equals(encryptKey.getBytes(), key);
    }
}

