/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.queue;

import com.eview.tool.MainPane;
import com.eview.tool.queue.OutputLog;
import com.eview.util.Constants;
import java.awt.Color;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class OutputLogQueue
implements Runnable {
    private final Logger log = LogManager.getLogger(OutputLogQueue.class);
    private final Logger dataLog = LogManager.getLogger((String)"dataLog");
    private final Logger debugLog = LogManager.getLogger((String)"debugLog");
    private final Logger debug2Log = LogManager.getLogger((String)"debug2Log");
    private final Logger socketMockLog = LogManager.getLogger((String)"socketMockLog");
    private final Logger socketProxyLog = LogManager.getLogger((String)"socketProxyLog");
    private static final int maxLength = 102400;
    private static final OutputLogQueue taskQueue = new OutputLogQueue();
    private final BlockingQueue<OutputLog> queue = new LinkedBlockingQueue<OutputLog>();

    private OutputLogQueue() {
    }

    public static OutputLogQueue getInstance() {
        return taskQueue;
    }

    public void addDebugLog(OutputLog task) {
        this.queue.add(task);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    boolean isBottom;
                    OutputLog outputLog;
                    JTextPane textPane;
                    if ((textPane = (outputLog = this.queue.take()).getTextPane()) == null) {
                        continue;
                    }
                    StringBuilder dataStr = new StringBuilder();
                    StyledDocument doc = textPane.getStyledDocument();
                    SimpleAttributeSet attrSet = new SimpleAttributeSet();
                    StyleConstants.setForeground(attrSet, Color.BLACK);
                    if (outputLog.getColor() != null) {
                        StyleConstants.setForeground(attrSet, outputLog.getColor());
                    }
                    boolean bl = isBottom = textPane.getCaretPosition() == doc.getLength();
                    if (outputLog.isLine() && doc.getLength() != 0) {
                        dataStr.append(Constants.lines);
                    }
                    if (outputLog.isShowTime()) {
                        dataStr.append("[").append(Constants.dateTimeFormat.format(new Date())).append("]");
                    }
                    if (outputLog.getType() != null) {
                        dataStr.append("[").append(outputLog.getType()).append("]");
                    }
                    if (outputLog.getChannel() != null) {
                        dataStr.append("[").append(outputLog.getChannel()).append("]");
                    }
                    if (outputLog.getType() != null || outputLog.getChannel() != null || outputLog.isShowTime()) {
                        dataStr.append(":");
                    }
                    dataStr.append(outputLog.getData());
                    if (outputLog.isReplaceLastLine()) {
                        Element element = doc.getCharacterElement(doc.getLength() - 1);
                        int startOffset = element.getStartOffset();
                        int endOffset = element.getEndOffset();
                        doc.remove(startOffset, endOffset - startOffset);
                    }
                    doc.insertString(doc.getLength(), dataStr.toString(), attrSet);
                    if ("dataLog".equals(textPane.getName())) {
                        this.dataLog.debug((Object)dataStr.toString());
                    } else if ("debugLog".equals(textPane.getName())) {
                        this.debugLog.debug((Object)dataStr.toString());
                    } else if ("debug2Log".equals(textPane.getName())) {
                        this.debug2Log.debug((Object)dataStr.toString());
                    } else if ("socketMockLog".equals(textPane.getName())) {
                        this.socketMockLog.debug((Object)dataStr.toString());
                    } else if ("socketProxyLog".equals(textPane.getName())) {
                        this.socketProxyLog.debug((Object)dataStr.toString());
                    }
                    if (doc.getLength() > 102400) {
                        doc.remove(0, doc.getLength() - 102400);
                    }
                    SwingUtilities.invokeLater(() -> {
                        if (isBottom) {
                            textPane.setCaretPosition(doc.getLength());
                        }
                    });
                    MainPane.delay(10L);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"OutputLogQueue error:", (Throwable)ex);
                continue;
            }
            break;
        }
    }
}

