/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.netty;

import com.eview.tool.model.Model_Debug;
import com.eview.tool.netty.NettyServerProxy;
import com.eview.tool.queue.OutputLog;
import com.eview.tool.queue.OutputLogQueue;
import com.tracker.util.BytesHexStrUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.awt.Color;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class NettyServerProxyHandler
extends SimpleChannelInboundHandler<byte[]> {
    private final Logger log = LogManager.getLogger(NettyServerProxyHandler.class);
    private final String remoteHost;
    private final int remotePort;
    private ChannelHandlerContext innerCtx;
    private ChannelHandlerContext outCtx;
    private ChannelFuture connectFuture;

    public NettyServerProxyHandler(String remoteHost, int remotePort) {
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.log.debug((Object)("client " + String.valueOf(ctx.channel().remoteAddress()) + " Online"));
        NettyServerProxy.channels_s.add((Object)ctx.channel());
        Model_Debug.addChannel(ctx.channel());
        this.outCtx = ctx;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ByteArrayEncoder()}).addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
                        if (NettyServerProxyHandler.this.outCtx != null && NettyServerProxyHandler.this.outCtx.channel().isActive()) {
                            byte[] bytes = new byte[in.readableBytes()];
                            in.readBytes(bytes);
                            OutputLog outputLog = new OutputLog().setType("R>>L").setColor(Color.RED).setChannel(ctx.channel().toString().replace("[", "").replace("]", "")).setIsLine(true).setIsShowTime(true).setData(BytesHexStrUtil.bytesToHexString(bytes)).setTextPane(Model_Debug.socketProxy_outputArea);
                            OutputLogQueue.getInstance().addDebugLog(outputLog);
                            NettyServerProxyHandler.this.outCtx.writeAndFlush((Object)bytes);
                        }
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        NettyServerProxy.channels_d.add((Object)ctx.channel());
                        NettyServerProxy.channelIds_d.put(NettyServerProxyHandler.this.outCtx.channel().remoteAddress().toString(), ctx.channel().id());
                        NettyServerProxyHandler.this.innerCtx = ctx;
                        System.out.println("\u94fe\u63a5\u670d\u52a1" + ctx.channel().toString());
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        NettyServerProxy.channels_d.remove((Object)ctx.channel());
                        NettyServerProxy.channelIds_d.remove(NettyServerProxyHandler.this.outCtx.channel().remoteAddress().toString());
                        OutputLog outputLog = new OutputLog().setChannel(ctx.channel().toString().replace("[", "").replace("]", "")).setIsLine(true).setIsShowTime(true).setData("Server Offline").setTextPane(Model_Debug.socketProxy_outputArea);
                        OutputLogQueue.getInstance().addDebugLog(outputLog);
                        if (NettyServerProxyHandler.this.outCtx != null && NettyServerProxyHandler.this.outCtx.channel().isActive()) {
                            NettyServerProxyHandler.this.outCtx.close();
                        }
                    }
                }});
            }
        });
        bootstrap.group((EventLoopGroup)ctx.channel().eventLoop());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.connectFuture = bootstrap.connect((SocketAddress)new InetSocketAddress(this.remoteHost, this.remotePort));
        this.connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    System.err.println("Connect to host error: " + String.valueOf(future.cause()));
                    NettyServerProxyHandler.this.outCtx.close();
                }
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.log.debug((Object)("client " + String.valueOf(ctx.channel().remoteAddress()) + " Offline"));
        NettyServerProxy.channels_s.remove((Object)ctx.channel());
        Model_Debug.removeChannel(ctx.channel());
        OutputLog outputLog = new OutputLog().setChannel(ctx.channel().toString().replace("[", "").replace("]", "")).setIsLine(true).setIsShowTime(true).setData("Client Offline").setTextPane(Model_Debug.socketProxy_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
        if (this.innerCtx != null && this.innerCtx.channel().isActive()) {
            this.innerCtx.close();
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, byte[] msg) throws Exception {
        if (this.connectFuture.isDone()) {
            OutputLog outputLog = new OutputLog().setType("L>>R").setChannel(ctx.channel().toString().replace("[", "").replace("]", "")).setIsLine(true).setIsShowTime(true).setData(BytesHexStrUtil.bytesToHexString(msg)).setTextPane(Model_Debug.socketProxy_outputArea);
            OutputLogQueue.getInstance().addDebugLog(outputLog);
            if (this.innerCtx != null && this.innerCtx.channel().isActive()) {
                this.innerCtx.writeAndFlush((Object)msg);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.log.error((Object)("client " + String.valueOf(ctx.channel().remoteAddress()) + " Exception:"), cause);
    }
}

