/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.netty;

import com.eview.tool.model.Model_Debug;
import com.eview.tool.netty.NettyServerProxyHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class NettyServerProxy
extends Thread {
    private final Logger log = Logger.getLogger(this.getClass());
    private String host = "127.0.0.1";
    private int port = 5050;
    private String remoteHost = "127.0.0.1";
    private int remotePort = 5050;
    private static boolean isConnection = false;
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workGroup = new NioEventLoopGroup();
    private ChannelFuture future;
    public static ChannelGroup channels_s = new DefaultChannelGroup("ChannelGroups_S", (EventExecutor)GlobalEventExecutor.INSTANCE);
    public static ChannelGroup channels_d = new DefaultChannelGroup("ChannelGroups_D", (EventExecutor)GlobalEventExecutor.INSTANCE);
    public static Map<String, ChannelId> channelIds_s = new HashMap<String, ChannelId>();
    public static Map<String, ChannelId> channelIds_d = new HashMap<String, ChannelId>();

    public NettyServerProxy(String host, int port, String remoteHost, int remotePort) {
        System.out.println("host=" + host + " port=" + port + " remoteHost=" + remoteHost + " remotePort=" + remotePort);
        this.host = host;
        this.port = port;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public static boolean isConnection() {
        return isConnection;
    }

    @Override
    public void run() {
        try {
            ServerBootstrap bootstrap_tcp = new ServerBootstrap();
            bootstrap_tcp.group(this.bossGroup, this.workGroup);
            bootstrap_tcp.channel(NioServerSocketChannel.class);
            bootstrap_tcp.option(ChannelOption.SO_BACKLOG, (Object)1024);
            bootstrap_tcp.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            bootstrap_tcp.childOption(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap_tcp.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap_tcp.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            bootstrap_tcp.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler(300)});
                    pipeline.addLast(new ChannelHandler[]{new ByteArrayDecoder()}).addLast(new ChannelHandler[]{new ByteArrayEncoder()});
                    pipeline.addLast(new ChannelHandler[]{new NettyServerProxyHandler(NettyServerProxy.this.remoteHost, NettyServerProxy.this.remotePort)});
                }
            });
            this.future = bootstrap_tcp.bind(this.host, this.port).sync();
            if (this.future.isSuccess()) {
                isConnection = true;
                Model_Debug.socketProxy_connection.setText("Disconnect");
                Model_Debug.socketProxy_hostSrc.setEnabled(false);
                Model_Debug.socketProxy_portSrc.setEnabled(false);
                Model_Debug.socketProxy_hostDst.setEnabled(false);
                Model_Debug.socketProxy_portDst.setEnabled(false);
                System.out.println("TcpServer Start successfully, host\uff1a" + this.host + " port\uff1a" + this.port);
                this.log.debug((Object)("TcpServer Start successfully, host\uff1a" + this.host + " port\uff1a" + this.port));
            }
            this.future.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    future.channel().close();
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)"NettyServer Exception:", (Throwable)e);
        }
    }

    public void sendData(byte[] data) {
        ByteBuf buffer = Unpooled.buffer((int)data.length);
        buffer.writeBytes(data);
        for (Channel channel : channels_s) {
            channel.writeAndFlush((Object)buffer);
        }
    }

    public void shutdown() {
        isConnection = false;
        if (this.workGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.workGroup.shutdownGracefully();
            Model_Debug.socketProxy_connection.setText("Connection");
            Model_Debug.socketProxy_hostSrc.setEnabled(true);
            Model_Debug.socketProxy_portSrc.setEnabled(true);
            Model_Debug.socketProxy_hostDst.setEnabled(true);
            Model_Debug.socketProxy_portDst.setEnabled(true);
            this.log.debug((Object)"NettyServer stoped.");
        }
    }
}

