/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.model;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.CheckDocument;
import com.eview.tool.customUI.MultiComboBox;
import com.eview.tool.customUI.MyJComboBox;
import com.eview.tool.customUI.PlaceholderTextField;
import com.eview.tool.customUI.TabbedPaneUI;
import com.eview.tool.customUI.Toast;
import com.eview.tool.dialog.PasswordJDialog;
import com.eview.util.Constants;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;

public class PanelUtil {
    private static final Logger log = Logger.getLogger(PanelUtil.class);

    private PanelUtil() {
    }

    public static JTabbedPane createTabbedPane(LayoutManager layout) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        tabbedPane.setPreferredSize(new Dimension(945, 574));
        FlowLayout f = (FlowLayout)layout;
        f.setHgap(0);
        f.setVgap(0);
        tabbedPane.setUI(new TabbedPaneUI(172, 56));
        tabbedPane.setBackground(Constants.background);
        tabbedPane.setTabPlacement(2);
        return tabbedPane;
    }

    public static void setTabbedPaneScroll(JTabbedPane tabbedPane) {
        tabbedPane.setTabLayoutPolicy(1);
        tabbedPane.addMouseWheelListener(e -> {
            if (e.getX() < 175) {
                JTabbedPane pane = (JTabbedPane)e.getSource();
                int units = e.getWheelRotation();
                int oldIndex = pane.getSelectedIndex();
                int newIndex = oldIndex + units;
                if (newIndex < 0) {
                    pane.setSelectedIndex(0);
                } else if (newIndex >= pane.getTabCount()) {
                    pane.setSelectedIndex(pane.getTabCount() - 1);
                } else {
                    pane.setSelectedIndex(newIndex);
                }
            }
        });
    }

    public static void setTextAreaCursor(final JTextComponent outputArea) {
        outputArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                outputArea.setCursor(new Cursor(2));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                outputArea.setCursor(new Cursor(0));
            }
        });
        outputArea.getCaret().addChangeListener(e -> outputArea.getCaret().setVisible(true));
    }

    public static JLabel createLabel(String title, int x, int y, int width, int height) {
        JLabel lab = new JLabel(title);
        lab.setBounds(new Rectangle(x, y, width, height));
        return lab;
    }

    public static JButton createButton(String title, int x, int y, int width, int height) {
        JButton button = new JButton(title);
        button.setBounds(new Rectangle(x, y, width, height));
        return button;
    }

    public static JToggleButton createToggleButton(int x, int y, int width, int height) {
        JToggleButton button = new JToggleButton();
        button.setBounds(new Rectangle(x, y, width, height));
        return button;
    }

    public static JCheckBox createCheckBox(String title, int x, int y, int width, int height) {
        JCheckBox cbox = new JCheckBox(title);
        cbox.setBounds(new Rectangle(x, y, width, height));
        return cbox;
    }

    public static JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        return panel;
    }

    public static JPanel createPanel(int width, int height) {
        JPanel panel = PanelUtil.createPanel();
        panel.setPreferredSize(new Dimension(width, height));
        return panel;
    }

    public static JPanel createPanel(String title, int x, int y, int width, int height) {
        JPanel panel = PanelUtil.createPanel();
        panel.setBounds(x, y, width, height);
        PanelUtil.showTitle(panel, title);
        return panel;
    }

    public static void showTitle(JComponent panel, String title) {
        panel.setBorder(BorderFactory.createTitledBorder(title));
    }

    public static JScrollPane createScrollPanel(JComponent panel, int x, int y, int width, int height) {
        JScrollPane scrollPanel = PanelUtil.createScrollPanel(panel);
        scrollPanel.setBounds(new Rectangle(x, y, width, height));
        return scrollPanel;
    }

    public static JScrollPane createScrollPanel(JComponent panel, int width, int height) {
        JScrollPane scrollPanel = PanelUtil.createScrollPanel(panel);
        scrollPanel.setPreferredSize(new Dimension(width, height));
        return scrollPanel;
    }

    public static JScrollPane createScrollPanel(JComponent panel) {
        JScrollPane scrollPanel = new JScrollPane(panel);
        scrollPanel.setVerticalScrollBarPolicy(20);
        scrollPanel.getVerticalScrollBar().setUnitIncrement(10);
        return scrollPanel;
    }

    public static void checkInput(JTextField input, String regex) {
        input.getDocument().addDocumentListener(new CheckDocument(text -> {
            if (text.isEmpty() || Pattern.matches(regex, text)) {
                input.setForeground(Color.BLACK);
            } else {
                input.setForeground(Color.RED);
            }
        }));
    }

    public static void checkInput(JTextField input, String regex, JSONArray jsonArray) {
        input.getDocument().addDocumentListener(new CheckDocument(text -> {
            if (text.isEmpty() || Pattern.matches(regex, text)) {
                input.setForeground(Color.BLACK);
                if (jsonArray.contains((Object)input)) {
                    jsonArray.remove((Object)input);
                }
            } else {
                input.setForeground(Color.RED);
                if (!jsonArray.contains((Object)input)) {
                    jsonArray.add((Object)input);
                }
            }
        }));
    }

    public static void checkInput(JTextField input, String regex, JCheckBox cbox, JSONArray jsonArray) {
        input.getDocument().addDocumentListener(new CheckDocument(text -> {
            if (text.isEmpty() || Pattern.matches(regex, text)) {
                input.setForeground(Color.BLACK);
                if (jsonArray.contains((Object)input)) {
                    jsonArray.remove((Object)input);
                }
            } else {
                input.setForeground(Color.RED);
                if (!jsonArray.contains((Object)input)) {
                    jsonArray.add((Object)input);
                }
            }
            if (text.equals("911")) {
                cbox.setEnabled(false);
                cbox.setSelected(false);
            } else {
                cbox.setEnabled(true);
            }
        }));
    }

    public static boolean checkOnlyOne(JSONObject wifiObject) {
        boolean check;
        ArrayList<String> wifiNames = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            String wifiListKey = "wifiList$" + i + "_name";
            JTextField input = (JTextField)wifiObject.get((Object)wifiListKey);
            if (input.getText().isEmpty()) continue;
            wifiNames.add(input.getText());
        }
        long sum = wifiNames.stream().distinct().count();
        boolean bl = check = sum < (long)wifiNames.size();
        if (check) {
            Toast.showMsg("You have a uniqueness check errors, please check", 2000L, 2);
        }
        return check;
    }

    public static boolean checkError(JSONObject paneObjectAll, JSONObject ... paneObject) {
        AtomicInteger sum = new AtomicInteger(0);
        Arrays.stream(paneObject).forEach(paneObj -> {
            JSONArray array = paneObjectAll.getJSONArray(paneObj.getString("check"));
            boolean checked = Optional.ofNullable(array).map(list -> list.stream().filter(input -> ((JTextField)input).isVisible()).filter(input -> !StrUtil.isBlank((CharSequence)((JTextField)input).getText())).collect(Collectors.toCollection(JSONArray::new))).filter(list -> !list.isEmpty()).isPresent();
            if (checked) {
                log.info((Object)("CheckError:" + array.size()));
                sum.addAndGet(array.size());
            }
        });
        if (sum.get() > 0) {
            Toast.showMsg("You have " + sum.get() + " errors, please check", 2000L);
        }
        return sum.get() > 0;
    }

    public static JSONArray setCheck(JPanel panel, JSONObject paneObjectAll, JSONObject panelObject) {
        panelObject.put("check", (Object)panel.hashCode());
        JSONArray checkArray = new JSONArray();
        paneObjectAll.put("" + panel.hashCode(), (Object)checkArray);
        return checkArray;
    }

    public static void changeWorkMode(JSONObject paneSystems, JSONObject paneObjectAll, String[] infos) {
        JComboBox workMode = (JComboBox)paneSystems.get((Object)"workMode_mode");
        JTextField input_time = (JTextField)paneSystems.getObject("workMode_time", JTextField.class);
        JTextField input_upload = (JTextField)paneSystems.getObject("timeInterval_upload", JTextField.class);
        JTextField input_uploadLazy = (JTextField)paneSystems.getObject("timeInterval_uploadLazy", JTextField.class);
        JLabel lab_info = (JLabel)paneObjectAll.getObject("lab_infoTimeInterval", JLabel.class);
        JToggleButton btn_heartBeatStatus = (JToggleButton)paneSystems.get((Object)"timeInterval_heartBeatStatus");
        PlaceholderTextField input_heartBeat = (PlaceholderTextField)paneSystems.get((Object)"timeInterval_heartBeat");
        switch (workMode.getSelectedIndex()) {
            case 0: {
                input_time.setVisible(false);
                input_upload.setVisible(false);
                input_uploadLazy.setVisible(false);
                lab_info.setText(infos[0]);
                btn_heartBeatStatus.setEnabled(true);
                input_heartBeat.setEnabled(true);
                break;
            }
            case 1: 
            case 5: {
                input_time.setVisible(false);
                input_upload.setVisible(true);
                input_uploadLazy.setVisible(true);
                lab_info.setText(infos[1]);
                btn_heartBeatStatus.setEnabled(true);
                input_heartBeat.setEnabled(true);
                break;
            }
            case 2: {
                input_time.setVisible(false);
                input_upload.setVisible(true);
                input_uploadLazy.setVisible(false);
                lab_info.setText(infos[2]);
                btn_heartBeatStatus.setEnabled(true);
                input_heartBeat.setEnabled(true);
                break;
            }
            case 3: {
                input_time.setVisible(true);
                input_upload.setVisible(false);
                input_uploadLazy.setVisible(false);
                lab_info.setText(infos[3]);
                btn_heartBeatStatus.setEnabled(false);
                input_heartBeat.setEnabled(false);
                break;
            }
            case 4: {
                input_time.setVisible(true);
                input_upload.setVisible(false);
                input_uploadLazy.setVisible(false);
                lab_info.setText(infos[4]);
                btn_heartBeatStatus.setEnabled(false);
                input_heartBeat.setEnabled(false);
            }
        }
    }

    public static void showPasswordJDialog(int code) {
        SwingUtilities.invokeLater(() -> {
            if (code == 64 || code == 18) {
                if (!PasswordJDialog.getInstance().isVisible()) {
                    PasswordJDialog.getInstance().setVisible(true);
                }
            } else if (PasswordJDialog.getInstance().isVisible()) {
                PasswordJDialog.getInstance().setVisible(false);
            }
        });
    }

    public static void setCenter(Shell shell) {
        int width = shell.getMonitor().getClientArea().width;
        int height = shell.getMonitor().getClientArea().height;
        int x = shell.getSize().x;
        int y = shell.getSize().y;
        if (x > width) {
            shell.getSize().x = width;
        }
        if (y > height) {
            shell.getSize().y = height;
        }
        shell.setLocation((width - x) / 2, (height - y) / 2);
    }

    public static MyJComboBox<Integer> getWorkMode(String ... names) {
        MyJComboBox<Integer> cbx_workMode = new MyJComboBox<Integer>();
        for (int i = 0; i < names.length; ++i) {
            cbx_workMode.addItem(i + 1, names[i]);
        }
        return cbx_workMode;
    }

    public static MyJComboBox<Integer> getSex() {
        MyJComboBox<Integer> cbx_sex = new MyJComboBox<Integer>();
        cbx_sex.addItem(2, "empty");
        cbx_sex.addItem(0, "male");
        cbx_sex.addItem(1, "female");
        return cbx_sex;
    }

    public static MyJComboBox<Integer> getBloodType() {
        MyJComboBox<Integer> cbx_bloodType = new MyJComboBox<Integer>();
        cbx_bloodType.addItem(15, "empty");
        cbx_bloodType.addItem(0, "Rh(-)  O");
        cbx_bloodType.addItem(1, "Rh(-)  B");
        cbx_bloodType.addItem(2, "Rh(-)  A");
        cbx_bloodType.addItem(3, "Rh(-)  AB");
        cbx_bloodType.addItem(16, "Rh(+)  O");
        cbx_bloodType.addItem(17, "Rh(+)  B");
        cbx_bloodType.addItem(18, "Rh(+)  A");
        cbx_bloodType.addItem(19, "Rh(+)  AB");
        return cbx_bloodType;
    }

    public static MyJComboBox<Integer> getButtonsTask() {
        MyJComboBox<Integer> button_task = new MyJComboBox<Integer>();
        button_task.addItem(0, "Call who?");
        button_task.addItem(1, "Auth 1");
        button_task.addItem(2, "Auth 2");
        button_task.addItem(3, "Auth 3");
        button_task.addItem(4, "Auth 4");
        button_task.addItem(5, "Auth 5");
        button_task.addItem(6, "Auth 6");
        button_task.addItem(7, "Auth 7");
        button_task.addItem(8, "Auth 8");
        button_task.addItem(9, "Auth 9");
        button_task.addItem(10, "Auth 10");
        button_task.addItem(15, "SOS standard");
        return button_task;
    }

    public static MyJComboBox<Float> getTimeZone() {
        MyJComboBox<Float> timeZone = new MyJComboBox<Float>();
        timeZone.addItem(Float.valueOf(0.0f), "UTC 00:00");
        timeZone.addItem(Float.valueOf(1.0f), "UTC +01:00");
        timeZone.addItem(Float.valueOf(2.0f), "UTC +02:00");
        timeZone.addItem(Float.valueOf(3.0f), "UTC +03:00");
        timeZone.addItem(Float.valueOf(4.0f), "UTC +04:00");
        timeZone.addItem(Float.valueOf(4.5f), "UTC +04:30");
        timeZone.addItem(Float.valueOf(5.0f), "UTC +05:00");
        timeZone.addItem(Float.valueOf(5.5f), "UTC +05:30");
        timeZone.addItem(Float.valueOf(5.75f), "UTC +05:45");
        timeZone.addItem(Float.valueOf(6.0f), "UTC +06:00");
        timeZone.addItem(Float.valueOf(6.5f), "UTC +06:30");
        timeZone.addItem(Float.valueOf(7.0f), "UTC +07:00");
        timeZone.addItem(Float.valueOf(8.0f), "UTC +08:00");
        timeZone.addItem(Float.valueOf(9.0f), "UTC +09:00");
        timeZone.addItem(Float.valueOf(9.5f), "UTC +09:30");
        timeZone.addItem(Float.valueOf(10.0f), "UTC +10:00");
        timeZone.addItem(Float.valueOf(11.0f), "UTC +11:00");
        timeZone.addItem(Float.valueOf(12.0f), "UTC +12:00");
        timeZone.addItem(Float.valueOf(13.0f), "UTC +13:00");
        timeZone.addItem(Float.valueOf(-1.0f), "UTC -01:00");
        timeZone.addItem(Float.valueOf(-2.0f), "UTC -02:00");
        timeZone.addItem(Float.valueOf(-2.5f), "UTC -02:30");
        timeZone.addItem(Float.valueOf(-3.0f), "UTC -03:00");
        timeZone.addItem(Float.valueOf(-4.0f), "UTC -04:00");
        timeZone.addItem(Float.valueOf(-5.0f), "UTC -05:00");
        timeZone.addItem(Float.valueOf(-6.0f), "UTC -06:00");
        timeZone.addItem(Float.valueOf(-7.0f), "UTC -07:00");
        timeZone.addItem(Float.valueOf(-8.0f), "UTC -08:00");
        timeZone.addItem(Float.valueOf(-10.0f), "UTC -10:00");
        timeZone.addItem(Float.valueOf(-11.0f), "UTC -11:00");
        return timeZone;
    }

    public static MyJComboBox<Float> getTimeZone2() {
        int i;
        MyJComboBox<Float> timeZone = new MyJComboBox<Float>();
        timeZone.addItem(Float.valueOf(0.0f), "UTC 00:00");
        for (i = 0; i < 14; ++i) {
            timeZone.addItem(Float.valueOf((float)i + 0.25f), String.format("UTC %02d:15", i));
            timeZone.addItem(Float.valueOf((float)i + 0.5f), String.format("UTC %02d:30", i));
            timeZone.addItem(Float.valueOf((float)i + 0.75f), String.format("UTC %02d:45", i));
            timeZone.addItem(Float.valueOf((float)i + 1.0f), String.format("UTC %02d:00", i + 1));
        }
        for (i = 0; i < 12; ++i) {
            timeZone.addItem(Float.valueOf(((float)i + 0.25f) * -1.0f), String.format("UTC -%02d:15", i));
            timeZone.addItem(Float.valueOf(((float)i + 0.5f) * -1.0f), String.format("UTC -%02d:30", i));
            timeZone.addItem(Float.valueOf(((float)i + 0.75f) * -1.0f), String.format("UTC -%02d:45", i));
            timeZone.addItem(Float.valueOf(((float)i + 1.0f) * -1.0f), String.format("UTC -%02d:00", i + 1));
        }
        return timeZone;
    }

    public static JSONObject getPanel(JSONObject paneObject) {
        JSONObject jsonData = new JSONObject();
        for (Map.Entry entry : paneObject.entrySet()) {
            JComboBox cbBox;
            String key = (String)entry.getKey();
            Object object = entry.getValue();
            if (object instanceof JTextField) {
                JTextField input = (JTextField)object;
                jsonData.put(key, (Object)input.getText());
                continue;
            }
            if (object instanceof ButtonGroup) {
                ButtonGroup group = (ButtonGroup)object;
                Enumeration<AbstractButton> radioBtns = group.getElements();
                while (radioBtns.hasMoreElements()) {
                    AbstractButton btn = radioBtns.nextElement();
                    if (!btn.isSelected()) continue;
                    jsonData.put(key, (Object)(btn.getName().contains("_1") ? 1 : 0));
                }
                continue;
            }
            if (object instanceof JCheckBox) {
                JCheckBox chBox = (JCheckBox)object;
                jsonData.put(key, (Object)(chBox.isSelected() ? 1 : 0));
                continue;
            }
            if (object instanceof JToggleButton) {
                JToggleButton toggleBtn = (JToggleButton)object;
                jsonData.put(key, (Object)(toggleBtn.isSelected() ? 1 : 0));
                continue;
            }
            if (object instanceof MultiComboBox) {
                cbBox = (MultiComboBox)object;
                jsonData.put(key, (Object)((MultiComboBox)cbBox).getComboVc());
                continue;
            }
            if (object instanceof MyJComboBox) {
                cbBox = (MyJComboBox)object;
                jsonData.put(key, ((MyJComboBox)cbBox).getSelectedId());
                continue;
            }
            if (!(object instanceof JComboBox)) continue;
            cbBox = (JComboBox)object;
            jsonData.put(key, (Object)cbBox.getSelectedIndex());
        }
        return jsonData;
    }

    public static void showPaneData(JSONObject paneObject, JSONObject configData) {
        for (Map.Entry entry : paneObject.entrySet()) {
            SwingUtilities.invokeLater(() -> {
                try {
                    Object data = configData.get(entry.getKey());
                    if (data != null) {
                        Object object = entry.getValue();
                        if (object instanceof JTextField) {
                            JTextField input = (JTextField)object;
                            input.setText(Convert.toStr((Object)data, (String)""));
                        } else if (object instanceof ButtonGroup) {
                            ButtonGroup group = (ButtonGroup)object;
                            int index = Convert.toInt((Object)data, (Integer)0);
                            Enumeration<AbstractButton> radioBtns = group.getElements();
                            while (radioBtns.hasMoreElements()) {
                                AbstractButton btn = radioBtns.nextElement();
                                if (index == 1 && btn.getName().contains("_1")) {
                                    btn.setSelected(true);
                                    continue;
                                }
                                if (index != 0 || !btn.getName().contains("_0")) continue;
                                btn.setSelected(true);
                            }
                        } else if (object instanceof JCheckBox) {
                            JCheckBox chbox = (JCheckBox)object;
                            int status = Convert.toInt((Object)data);
                            chbox.setSelected(status == 1);
                        } else if (object instanceof JToggleButton) {
                            JToggleButton toggleBtn = (JToggleButton)object;
                            int status = Convert.toInt((Object)data);
                            toggleBtn.setSelected(status == 1);
                        } else if (object instanceof MultiComboBox) {
                            MultiComboBox cbBox = (MultiComboBox)object;
                            cbBox.setComboVc(Convert.toLong((Object)data));
                        } else if (object instanceof MyJComboBox) {
                            MyJComboBox cbBox = (MyJComboBox)object;
                            cbBox.setSelectedById(data);
                        } else if (object instanceof JComboBox) {
                            JComboBox cbBox = (JComboBox)object;
                            int index = Convert.toInt((Object)data) % cbBox.getItemCount();
                            cbBox.setSelectedIndex(index);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)("key=" + (String)entry.getKey() + " value=" + String.valueOf(configData.get(entry.getKey()))), (Throwable)e);
                }
            });
        }
    }
}

