/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.BottomStatusPanel;
import com.eview.tool.ChannelEnum;
import com.eview.tool.CheckDocument;
import com.eview.tool.DocumentObject;
import com.eview.tool.MainPane;
import com.eview.tool.customUI.MyJComboBox;
import com.eview.tool.customUI.PlaceholderTextField;
import com.eview.tool.customUI.Toast;
import com.eview.tool.event.CmdData;
import com.eview.tool.handler.HandlerChain;
import com.eview.tool.handler.HandlerDeviceID;
import com.eview.tool.handler.HandlerGeoLatLng;
import com.eview.tool.handler.HandlerListMap;
import com.eview.tool.handler.HandlerNoMotionTime;
import com.eview.tool.handler.HandlerRemoveField;
import com.eview.tool.model.Model;
import com.eview.tool.model.PanelUtil;
import com.eview.util.Constants;
import com.eview.util.PublicUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;

public class Model_EV201
extends Model
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final Logger log = Logger.getLogger(this.getClass());
    private final JSONObject paneObjectAll = new JSONObject();
    private final JSONObject paneInformation = new JSONObject();
    private final JSONObject paneContactList = new JSONObject();
    private final JSONObject paneSystems = new JSONObject();
    private final JSONObject paneButtons = new JSONObject();
    private final JSONObject paneFunction = new JSONObject();
    private final JSONObject paneAlert = new JSONObject();
    private Map<String, JSONObject> panels = new HashMap<String, JSONObject>(6);
    private int spa = 12;
    private int height = 35;
    private int row_h = 47;
    private final int lab_w = 110;
    private final int lab_w2 = 150;
    private final int input_w = 218;
    private final int toggleBtn_w = 82;
    private int lab_input_w = this.spa + 110 + 218 + 40;
    private int button_w = 85;
    private int chbox_w = 80;
    private boolean isShow_Model;
    private boolean bleLongConnect_isShow;
    private JTabbedPane tabbedPane;

    public Model_EV201(String key, String name, boolean isShow) {
        this.key = key;
        this.name = name;
        this.isShow = isShow;
        this.panels.put("save_system_info", this.paneInformation);
        this.panels.put("save_contactList", this.paneContactList);
        this.panels.put("save_tracking", this.paneSystems);
        this.panels.put("save_buttons", this.paneButtons);
        this.panels.put("save_function", this.paneFunction);
        this.panels.put("save_alert_settings", this.paneAlert);
        this.init();
    }

    private void init() {
        this.isShow_Model = MainPane.isShowProperty(this.getKey(), "isShow_Model", "true");
        this.bleLongConnect_isShow = MainPane.isShowProperty(this.getKey(), "isShow_BleLongConnect", "true");
        this.isGlobalCheckError = MainPane.isShowProperty(this.getKey(), "checkError", "false");
        this.setBackground(Constants.background);
        this.tabbedPane = PanelUtil.createTabbedPane(this.getLayout());
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.tabbedPane, "West");
        JPanel panel_information = new JPanel();
        panel_information.setLayout(null);
        this.tabbedPane.add("System Info", panel_information);
        JPanel panel_phone = new JPanel();
        panel_phone.setLayout(null);
        this.tabbedPane.add("Contact Number", panel_phone);
        JPanel panel_systems = new JPanel();
        panel_systems.setLayout(null);
        this.tabbedPane.add("Tracking Settings", panel_systems);
        JPanel panel_buttons = new JPanel();
        panel_buttons.setLayout(null);
        this.tabbedPane.add("<html><body><p align=\"center\">Buttons/Phone<br/>Settings</p></body></html>", panel_buttons);
        JPanel panel_function = new JPanel();
        panel_function.setLayout(null);
        this.tabbedPane.add("Function Settings", panel_function);
        JPanel panel_alert = new JPanel();
        panel_alert.setLayout(null);
        this.tabbedPane.add("Alert Settings", panel_alert);
        this.initPanel_SystemInfo(panel_information, this.paneInformation);
        this.initPanel_ContactSetting(panel_phone, this.paneContactList);
        this.initPanel_TrackingSettings(panel_systems, this.paneSystems);
        this.initPanel_ButtonsSettings(panel_buttons, this.paneButtons);
        this.initPanel_FunctionSettings(panel_function, this.paneFunction);
        this.initPanel_AlertSettings(panel_alert, this.paneAlert);
    }

    private void initPanel_SystemInfo(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        String[][] lab_Information = new String[][]{{"Model", "Delivery date", "IMEI", "ICCID", "BLE MAC", "Date Time", "Start Time", "Run Time", "Version", "FW Version"}, {"Firmware Size", "Hardware Version", "<html><body><p align=\"left\">Password<br/>(For SMS Command)</p></body></html>", "Time Zone"}};
        for (int i = 0; i < lab_Information.length; ++i) {
            for (int j = 0; j < lab_Information[i].length; ++j) {
                JLabel lab = new JLabel(lab_Information[i][j]);
                if (i == 0) {
                    lab.setBounds(new Rectangle(this.spa, this.spa + this.row_h * j, 110, this.height));
                } else {
                    lab.setBounds(new Rectangle(this.lab_input_w, this.spa + this.row_h * j, 150, this.height));
                }
                panel.add(lab);
            }
        }
        String[][] input_Information = new String[][]{{"deviceName", "module", "IMEI", "ICCID", "MAC", "dateTime", "startTime", "runTime", "version", "fwVersion"}, {"firmware_firmwareSize", "firmware_hardwareVersion", "password", "timeZone"}};
        for (int i = 0; i < input_Information.length; ++i) {
            for (int j = 0; j < input_Information[i].length; ++j) {
                JTextField input;
                if (i == 0) {
                    input = new JTextField();
                    input.setBounds(new Rectangle(this.spa + 110, this.spa + this.row_h * j, 218, this.height));
                    input.setEditable(false);
                    panel.add(input);
                    jsonObj.put(input_Information[i][j], (Object)input);
                    continue;
                }
                if (i == 1 && j == 2) {
                    JToggleButton toggleBtn = new JToggleButton();
                    toggleBtn.setIcon(MainPane.toggle_off);
                    toggleBtn.setSelectedIcon(MainPane.toggle_on);
                    toggleBtn.setBounds(new Rectangle(this.lab_input_w + 150, this.spa + this.row_h * j, 82, this.height));
                    panel.add(toggleBtn);
                    jsonObj.put(input_Information[i][j] + "_status", (Object)toggleBtn);
                    PlaceholderTextField input2 = new PlaceholderTextField();
                    input2.setPlaceholder("0~999999");
                    input2.setBounds(new Rectangle(this.lab_input_w + 150 + 82 + 8, this.spa + this.row_h * j, 128, this.height));
                    PanelUtil.checkInput(input2, "^\\d{0,6}$", checkArray);
                    panel.add(input2);
                    jsonObj.put(input_Information[i][j] + "_password", (Object)input2);
                    continue;
                }
                if (i == 1 && j == 3) {
                    MyJComboBox<Float> cbt_timeZone = PanelUtil.getTimeZone2();
                    cbt_timeZone.setBounds(new Rectangle(this.lab_input_w + 150, this.spa + this.row_h * j, 218, this.height));
                    panel.add(cbt_timeZone);
                    jsonObj.put(input_Information[i][j], cbt_timeZone);
                    continue;
                }
                input = new JTextField();
                input.setBounds(new Rectangle(150 + this.lab_input_w, this.spa + this.row_h * j, 218, this.height));
                input.setEditable(false);
                panel.add(input);
                jsonObj.put(input_Information[i][j], (Object)input);
            }
        }
        JLabel lab_smsPrefix = new JLabel("SMS Prefix");
        lab_smsPrefix.setBounds(new Rectangle(this.lab_input_w, this.spa + (this.spa + this.height) * 6, 150, this.height));
        panel.add(lab_smsPrefix);
        JToggleButton tButtonStatus = new JToggleButton();
        tButtonStatus.setIcon(MainPane.toggle_off);
        tButtonStatus.setSelectedIcon(MainPane.toggle_on);
        tButtonStatus.setBounds(new Rectangle(this.lab_input_w + 150, this.spa + (this.spa + this.height) * 6, 82, this.height));
        panel.add(tButtonStatus);
        jsonObj.put("smsOption_status", (Object)tButtonStatus);
        PlaceholderTextField input_smsPrefix = new PlaceholderTextField();
        input_smsPrefix.setPlaceholder("0~19 bytes");
        input_smsPrefix.setBounds(new Rectangle(this.lab_input_w + 150 + 82 + 10, this.spa + (this.spa + this.height) * 6, 128, this.height));
        PanelUtil.checkInput(input_smsPrefix, "^[\\w\\W]{0,19}$", checkArray);
        panel.add(input_smsPrefix);
        jsonObj.put("smsOption_prefix", (Object)input_smsPrefix);
        JButton save_information = new JButton("Save");
        save_information.setBounds(new Rectangle(this.spa, 525, this.button_w, this.height));
        panel.add(save_information);
        save_information.addActionListener(this);
        this.paneObjectAll.put("save_system_info", (Object)save_information);
    }

    private void initPanel_ContactSetting(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        JLabel lab_number = new JLabel("When there is an alarm");
        lab_number.setBounds(new Rectangle(this.spa + 110 + 218 - 15, 7, 180, this.height));
        panel.add(lab_number);
        JSeparator sep = new JSeparator(0);
        sep.setBounds(new Rectangle(this.spa + 110 + 218 - 15, this.height + 5, 360, this.height));
        panel.add(sep);
        for (int i = 0; i < 10; ++i) {
            JLabel lab = new JLabel("A" + (i + 1));
            lab.setBounds(new Rectangle(this.spa, this.row_h + this.row_h * i, 60, this.height));
            panel.add(lab);
            String numberKey = "number$" + i;
            PlaceholderTextField input = new PlaceholderTextField();
            input.setPlaceholder("Phone number");
            input.setBounds(new Rectangle(this.spa + 110 - 50, this.row_h + this.row_h * i, 218, this.height));
            panel.add(input);
            jsonObj.put(numberKey + "_number", (Object)input);
            JCheckBox cbox_SMS = new JCheckBox("Receive SMS");
            cbox_SMS.setBounds(new Rectangle(this.spa + 110 + 218 + 30 - 50, this.row_h + this.row_h * i, 120, this.height));
            panel.add(cbox_SMS);
            jsonObj.put(numberKey + "_sms", (Object)cbox_SMS);
            PanelUtil.checkInput(input, CheckDocument.regex_phone, cbox_SMS, checkArray);
            JCheckBox cbox_Call = new JCheckBox("Receive Call");
            cbox_Call.setBounds(new Rectangle(this.spa + this.lab_input_w + 120 - 50, this.row_h + this.row_h * i, 120, this.height));
            panel.add(cbox_Call);
            jsonObj.put(numberKey + "_call", (Object)cbox_Call);
            JToggleButton toggleBtn = new JToggleButton();
            toggleBtn.setIcon(MainPane.toggle_off);
            toggleBtn.setSelectedIcon(MainPane.toggle_on);
            toggleBtn.setBounds(new Rectangle(this.spa + this.lab_input_w + 240 - 30, this.row_h + this.row_h * i, 82, this.height));
            panel.add(toggleBtn);
            jsonObj.put(numberKey + "_enable", (Object)toggleBtn);
        }
        JButton save_phone = new JButton("Save");
        save_phone.setBounds(new Rectangle(this.spa, 525, this.button_w, this.height));
        panel.add(save_phone);
        save_phone.addActionListener(this);
        this.paneObjectAll.put("save_contactList", (Object)save_phone);
    }

    private void initPanel_TrackingSettings(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        String[][] lab_systems = new String[][]{{"Working Mode", "", "", "", "", "Heart-beat interval"}, {"APN", "APN User Name", "APN Password", "Server Type", "Server IP", "Server Port"}};
        for (int i = 0; i < lab_systems.length; ++i) {
            for (int j = 0; j < lab_systems[i].length; ++j) {
                JLabel lab = new JLabel(lab_systems[i][j]);
                lab.setBounds(new Rectangle(this.spa + this.lab_input_w * i, this.spa + this.row_h * j, 140, this.height));
                panel.add(lab);
            }
        }
        String[][] input_systems = new String[][]{{"workMode", "", "", "", "", "timeInterval"}, {"apn", "apnUserName", "apnPassword", "sever", "sever_ip", "sever_port"}};
        for (int i = 0; i < input_systems.length; ++i) {
            for (int j = 0; j < input_systems[i].length; ++j) {
                JToggleButton toggleBtn;
                if (i == 0 && j == 0) {
                    MyJComboBox<Integer> workMode = PanelUtil.getWorkMode("MODE 1", "MODE 2", "MODE 3", "MODE 4", "MODE 5", "MODE 6");
                    workMode.setBounds(new Rectangle(this.spa + 110 + this.lab_input_w * i, this.spa + this.row_h * j, 100, this.height));
                    panel.add(workMode);
                    jsonObj.put(input_systems[i][j] + "_mode", workMode);
                    workMode.addActionListener(this);
                    PlaceholderTextField input = new PlaceholderTextField();
                    input.setPlaceholder("S/M/H");
                    input.setBounds(new Rectangle(this.spa + 110 + 5 + 100, this.spa + this.row_h * j, 60, this.height));
                    PanelUtil.checkInput(input, CheckDocument.regex_time5, checkArray);
                    input.setVisible(false);
                    panel.add(input);
                    jsonObj.put(input_systems[i][j] + "_time", (Object)input);
                    PlaceholderTextField input2 = new PlaceholderTextField();
                    input2.setPlaceholder("S/M/H");
                    input2.setBounds(new Rectangle(this.spa + 110 + 5 + 100, this.spa + this.row_h * j, 60, this.height));
                    PanelUtil.checkInput(input2, "^([1-9]\\d|[1-9]\\d{2,8})$", checkArray);
                    input2.setVisible(false);
                    panel.add(input2);
                    jsonObj.put("timeInterval_upload", (Object)input2);
                    PlaceholderTextField input3 = new PlaceholderTextField();
                    input3.setPlaceholder("S/M/H");
                    input3.setBounds(new Rectangle(this.spa + 110 + 10 + 160, this.spa + this.row_h * j, 60, this.height));
                    PanelUtil.checkInput(input3, "^([3-9]\\d{2}|[1-9]\\d{3,8})$", checkArray);
                    input3.setVisible(false);
                    panel.add(input3);
                    jsonObj.put("timeInterval_uploadLazy", (Object)input3);
                    JPanel timeIntervalPanel = PanelUtil.createPanel("", this.spa, this.spa + this.row_h, 340, this.row_h * 4 - this.spa);
                    panel.add(timeIntervalPanel);
                    JLabel lab_info = new JLabel(Constants.info1);
                    lab_info.setBounds(new Rectangle(5, 5, 330, this.row_h * 4 - this.spa - 10));
                    lab_info.setForeground(Color.GRAY);
                    JScrollPane infoScroll = PanelUtil.createScrollPanel(lab_info, 0, 0, 340, this.row_h * 4 - this.spa);
                    timeIntervalPanel.add(infoScroll);
                    this.paneObjectAll.put("lab_infoTimeInterval", (Object)lab_info);
                    continue;
                }
                if (i == 0 && (j == 1 || j == 2 || j == 3 || j == 4)) continue;
                if (i == 0 && j == 5) {
                    toggleBtn = new JToggleButton();
                    toggleBtn.setIcon(MainPane.toggle_off);
                    toggleBtn.setSelectedIcon(MainPane.toggle_on);
                    toggleBtn.setBounds(new Rectangle(this.spa + 110 + 30, this.spa + this.row_h * j, 82, this.height));
                    panel.add(toggleBtn);
                    jsonObj.put(input_systems[i][j] + "_heartBeatStatus", (Object)toggleBtn);
                    PlaceholderTextField input_heartBeat = new PlaceholderTextField();
                    input_heartBeat.setPlaceholder("Unit: S/M/H");
                    input_heartBeat.setBounds(new Rectangle(this.spa + 110 + 40 + 82, this.spa + this.row_h * j, 110, this.height));
                    PanelUtil.checkInput(input_heartBeat, CheckDocument.regex_time4, checkArray);
                    panel.add(input_heartBeat);
                    jsonObj.put(input_systems[i][j] + "_heartBeat", (Object)input_heartBeat);
                    continue;
                }
                if (i == 1 && j == 3) {
                    toggleBtn = new JToggleButton();
                    toggleBtn.setIcon(MainPane.toggle_off);
                    toggleBtn.setSelectedIcon(MainPane.toggle_on);
                    toggleBtn.setBounds(new Rectangle(this.spa + 110 + 30 + this.lab_input_w * i, this.spa + this.row_h * j, 82, this.height));
                    panel.add(toggleBtn);
                    jsonObj.put(input_systems[i][j] + "_status", (Object)toggleBtn);
                    JComboBox<String> severType = new JComboBox<String>(new String[]{"TCP"});
                    severType.setBounds(new Rectangle(this.spa + 110 + 30 + this.lab_input_w * i + 82 + 10, this.spa + this.row_h * j, 125, this.height));
                    panel.add(severType);
                    jsonObj.put(input_systems[i][j] + "_type", severType);
                    continue;
                }
                PlaceholderTextField input = new PlaceholderTextField();
                if (i == 1 && j == 0) {
                    input.setPlaceholder("0~31 bytes");
                    PanelUtil.checkInput(input, "^[\\w\\W]{0,31}$", checkArray);
                } else if (i == 1 && j == 1) {
                    input.setPlaceholder("0~15 bytes");
                    PanelUtil.checkInput(input, "^[\\w\\W]{0,15}$", checkArray);
                } else if (i == 1 && j == 2) {
                    input.setPlaceholder("0~15 bytes");
                    PanelUtil.checkInput(input, "^[\\w\\W]{0,15}$", checkArray);
                } else if (i == 1 && j == 4) {
                    input.setPlaceholder("0~49 bytes");
                    PanelUtil.checkInput(input, "^[a-zA-Z0-9-\\.]{0,49}$", checkArray);
                } else if (i == 1 && j == 5) {
                    input.setPlaceholder("0~65535");
                    PanelUtil.checkInput(input, CheckDocument.regex_int, checkArray);
                }
                input.setBounds(new Rectangle(this.spa + 110 + 30 + this.lab_input_w * i, this.spa + this.row_h * j, 218, this.height));
                panel.add(input);
                jsonObj.put(input_systems[i][j], (Object)input);
            }
        }
        JPanel continuLocatePanel = PanelUtil.createPanel("Continuous locate", this.spa, this.spa + this.row_h * 6, 345, this.row_h * 2 + this.spa * 2);
        JLabel lab_time = new JLabel("Time interval");
        lab_time.setBounds(new Rectangle(this.spa, this.spa * 2, 150, this.height));
        continuLocatePanel.add(lab_time);
        PlaceholderTextField input_time = new PlaceholderTextField();
        input_time.setPlaceholder("Unit: S/M/H");
        input_time.setBounds(new Rectangle(this.spa + 150, this.spa * 2, 160, this.height));
        PanelUtil.checkInput(input_time, "^([1-9][0-9]|[1-5][0-9][0-9]|600)$", checkArray);
        continuLocatePanel.add(input_time);
        jsonObj.put("continueLocate_interval", (Object)input_time);
        JLabel lab_last = new JLabel("Duration time");
        lab_last.setBounds(new Rectangle(this.spa, this.spa * 2 + this.row_h, 150, this.height));
        continuLocatePanel.add(lab_last);
        PlaceholderTextField input_last = new PlaceholderTextField();
        input_last.setPlaceholder("Unit: S/M/H");
        input_last.setBounds(new Rectangle(this.spa + 150, this.spa * 2 + this.row_h, 160, this.height));
        PanelUtil.checkInput(input_last, CheckDocument.regex_time, checkArray);
        continuLocatePanel.add(input_last);
        jsonObj.put("continueLocate_time", (Object)input_last);
        panel.add(continuLocatePanel);
        JPanel panel_DeviceID = PanelUtil.createPanel("Customized Device ID", this.spa, this.row_h * 9, 345, this.row_h + this.spa * 2);
        panel.add(panel_DeviceID);
        JToggleButton toggleBtn = PanelUtil.createToggleButton(this.spa, this.spa * 2, 82, this.height);
        toggleBtn.setIcon(MainPane.toggle_off);
        toggleBtn.setSelectedIcon(MainPane.toggle_on);
        panel_DeviceID.add(toggleBtn);
        jsonObj.put("customizedIDStatus", (Object)toggleBtn);
        PlaceholderTextField input_deviceID = new PlaceholderTextField();
        input_deviceID.setPlaceholder("0~32 bytes");
        input_deviceID.setBounds(new Rectangle(this.spa + 82 + 10, this.spa * 2, 220, this.height));
        PanelUtil.checkInput(input_deviceID, "^[\\x00-\\xFF]{0,32}$", checkArray);
        panel_DeviceID.add(input_deviceID);
        jsonObj.put("customizedID", (Object)input_deviceID);
        JPanel urlPanel = PanelUtil.createPanel("SMS URL", this.spa + this.lab_input_w, this.spa + this.row_h * 6, 360, this.row_h * 2 + this.spa * 2);
        JLabel lab_gpsurl = new JLabel("GPS URL");
        lab_gpsurl.setBounds(new Rectangle(this.spa, this.spa * 2, 100, this.height));
        urlPanel.add(lab_gpsurl);
        PlaceholderTextField input_gpsurl = new PlaceholderTextField();
        input_gpsurl.setPlaceholder("0~40 bytes");
        input_gpsurl.setText(Constants.url_gps);
        input_gpsurl.setBounds(new Rectangle(this.spa + 75, this.spa * 2, 260, this.height));
        PanelUtil.checkInput(input_gpsurl, "^[\\w\\W]{0,40}$", checkArray);
        urlPanel.add(input_gpsurl);
        jsonObj.put("smsgpsurl", (Object)input_gpsurl);
        JLabel lab_wifiurl = new JLabel("WIFI URL");
        lab_wifiurl.setBounds(new Rectangle(this.spa, this.spa * 2 + this.row_h, 100, this.height));
        urlPanel.add(lab_wifiurl);
        PlaceholderTextField input_wifiurl = new PlaceholderTextField();
        input_wifiurl.setPlaceholder("0~40 bytes");
        input_wifiurl.setText(Constants.url_wifi);
        input_wifiurl.setBounds(new Rectangle(this.spa + 75, this.spa * 2 + this.row_h, 260, this.height));
        PanelUtil.checkInput(input_wifiurl, "^[\\w\\W]{0,40}$", checkArray);
        urlPanel.add(input_wifiurl);
        jsonObj.put("smswifiurl", (Object)input_wifiurl);
        panel.add(urlPanel);
        JButton save_systems = new JButton("Save");
        save_systems.setBounds(new Rectangle(this.spa, 525, this.button_w, this.height));
        panel.add(save_systems);
        save_systems.addActionListener(this);
        this.paneObjectAll.put("save_tracking", (Object)save_systems);
    }

    private void initPanel_ButtonsSettings(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        JPanel buttonsPanel = PanelUtil.createPanel("Buttons", this.spa, 0, 740, this.spa * 2 + this.row_h);
        panel.add(buttonsPanel);
        String[][] lab_buttons = new String[][]{{"SOS"}};
        for (int i = 0; i < lab_buttons.length; ++i) {
            for (int j = 0; j < lab_buttons[i].length; ++j) {
                JLabel lab = new JLabel(lab_buttons[i][j]);
                lab.setBounds(new Rectangle(this.spa + this.lab_input_w * i, this.spa * 2 + this.row_h * j, 60, this.height));
                buttonsPanel.add(lab);
            }
        }
        String[][] input_buttons = new String[][]{{"sosButton"}};
        for (int i = 0; i < input_buttons.length; ++i) {
            for (int j = 0; j < input_buttons[i].length; ++j) {
                JToggleButton toggleBtn = new JToggleButton();
                toggleBtn.setIcon(MainPane.toggle_off);
                toggleBtn.setSelectedIcon(MainPane.toggle_on);
                toggleBtn.setBounds(new Rectangle(this.spa + 66, this.spa * 2 + this.row_h * j, 82, this.height));
                buttonsPanel.add(toggleBtn);
                jsonObj.put(input_buttons[i][j] + "_status", (Object)toggleBtn);
                JComboBox<String> button_mode = new JComboBox<String>(new String[]{"Long Press", "Double Click"});
                button_mode.setBounds(new Rectangle(this.spa + 82 + 66 + 10, this.spa * 2 + this.row_h * j, 125, this.height));
                buttonsPanel.add(button_mode);
                jsonObj.put(input_buttons[i][j] + "_mode", button_mode);
                JComboBox<String> button_feedBack = new JComboBox<String>(new String[]{"No feedback", "vibration", "voice warning", "vibrate and voice"});
                button_feedBack.setSelectedIndex(3);
                button_feedBack.setBounds(new Rectangle(this.spa + 82 + 191 + 20, this.spa * 2 + this.row_h * j, 150, this.height));
                buttonsPanel.add(button_feedBack);
                jsonObj.put(input_buttons[i][j] + "_feedBack", button_feedBack);
                PlaceholderTextField button_time = new PlaceholderTextField();
                button_time.setPlaceholder("Press Unit: 0.1s");
                button_time.setBounds(new Rectangle(this.spa + 82 + 341 + 30, this.spa * 2 + this.row_h * j, 115, this.height));
                PanelUtil.checkInput(button_time, "^([1-9][0-9]|100)$", checkArray);
                buttonsPanel.add(button_time);
                jsonObj.put(input_buttons[i][j] + "_time", (Object)button_time);
                MyJComboBox<Integer> button_task = PanelUtil.getButtonsTask();
                button_task.setSelectedIndex(button_task.getItemCount() - 1);
                button_task.setBounds(new Rectangle(this.spa + 82 + 456 + 40, this.spa * 2 + this.row_h * j, 132, this.height));
                buttonsPanel.add(button_task);
                jsonObj.put(input_buttons[i][j] + "_task", button_task);
            }
        }
        JPanel sosPanel = PanelUtil.createPanel("After press SOS", this.spa, this.spa * 2 + this.row_h * 2, 380, this.spa * 2 + this.row_h * 3);
        panel.add(sosPanel);
        JLabel lab_ringsTime = new JLabel("Ring time");
        lab_ringsTime.setBounds(new Rectangle(this.spa, this.spa * 2, 146, this.height));
        sosPanel.add(lab_ringsTime);
        PlaceholderTextField input_ringsTime = new PlaceholderTextField();
        input_ringsTime.setPlaceholder("1~60s Unit: S/M/H");
        input_ringsTime.setBounds(new Rectangle(this.spa + 100, this.spa * 2, 160, this.height));
        PanelUtil.checkInput(input_ringsTime, "^([1-9]|[1-5][0-9]|60)$", checkArray);
        sosPanel.add(input_ringsTime);
        jsonObj.put("sosOption_ringsTime", (Object)input_ringsTime);
        JLabel lab_holdTime = new JLabel("Talking time");
        lab_holdTime.setBounds(new Rectangle(this.spa, this.spa * 2 + this.row_h, 146, this.height));
        sosPanel.add(lab_holdTime);
        PlaceholderTextField input_holdTime = new PlaceholderTextField();
        input_holdTime.setPlaceholder("0~65535s Unit: S/M/H");
        input_holdTime.setBounds(new Rectangle(this.spa + 100, this.spa * 2 + this.row_h, 160, this.height));
        PanelUtil.checkInput(input_holdTime, CheckDocument.regex_int, checkArray);
        sosPanel.add(input_holdTime);
        jsonObj.put("sosOption_holdTime", (Object)input_holdTime);
        JLabel lab_loops = new JLabel("Call loops");
        lab_loops.setBounds(new Rectangle(this.spa, this.spa * 2 + this.row_h * 2, 146, this.height));
        sosPanel.add(lab_loops);
        PlaceholderTextField input_loops = new PlaceholderTextField();
        input_loops.setPlaceholder("0~10, 0: infinite");
        input_loops.setBounds(new Rectangle(this.spa + 100, this.spa * 2 + this.row_h * 2, 160, this.height));
        PanelUtil.checkInput(input_loops, "^([0-9]|10)$", checkArray);
        sosPanel.add(input_loops);
        jsonObj.put("sosOption_loops", (Object)input_loops);
        JPanel volumePanel = PanelUtil.createPanel("Volume Option", this.spa, this.spa * 4 + this.row_h * 5, 380, this.spa * 2 + this.row_h * 3);
        panel.add(volumePanel);
        JLabel lab_micVolume = new JLabel("Microphone volume during talking");
        lab_micVolume.setBounds(new Rectangle(this.spa, this.spa * 2 + this.row_h * 2, 250, this.height));
        volumePanel.add(lab_micVolume);
        PlaceholderTextField input_micVolume = new PlaceholderTextField();
        input_micVolume.setPlaceholder("0~15");
        input_micVolume.setBounds(new Rectangle(this.spa + 250, this.spa * 2 + this.row_h * 2, 100, this.height));
        PanelUtil.checkInput(input_micVolume, "^([0-9]|1[0-5])$", checkArray);
        volumePanel.add(input_micVolume);
        jsonObj.put("micVolume", (Object)input_micVolume);
        JButton save_buttons = new JButton("Save");
        save_buttons.setBounds(new Rectangle(this.spa, 525, this.button_w, this.height));
        panel.add(save_buttons);
        save_buttons.addActionListener(this);
        this.paneObjectAll.put("save_buttons", (Object)save_buttons);
    }

    private void initPanel_FunctionSettings(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        JPanel phonePanel = PanelUtil.createPanel("Phone Option", this.spa, 0, 330, this.spa * 2 + this.row_h * 2);
        panel.add(phonePanel);
        JRadioButton radio_s1_1 = new JRadioButton("Auto answer call after ring");
        radio_s1_1.setName("s1_1");
        radio_s1_1.setBounds(new Rectangle(this.spa, this.spa * 2, 220, this.height));
        phonePanel.add(radio_s1_1);
        JRadioButton radio_s1_0 = new JRadioButton("Answer call by pressing any button");
        radio_s1_0.setName("s1_0");
        radio_s1_0.setBounds(new Rectangle(this.spa, this.spa * 2 + this.row_h, 280, this.height));
        phonePanel.add(radio_s1_0);
        ButtonGroup bg_1 = new ButtonGroup();
        bg_1.add(radio_s1_1);
        bg_1.add(radio_s1_0);
        this.paneFunction.put("phoneOption_s1", (Object)bg_1);
        PlaceholderTextField input_rings = new PlaceholderTextField();
        input_rings.setPlaceholder("0~10");
        input_rings.setBounds(new Rectangle(this.spa + 240, this.spa * 2, 50, this.height));
        PanelUtil.checkInput(input_rings, "^([0-9]|10)$", checkArray);
        phonePanel.add(input_rings);
        this.paneFunction.put("phoneOption_rings", (Object)input_rings);
        JPanel phonePanel2 = PanelUtil.createPanel("Phone Option", this.spa, this.spa * 2 + this.row_h * 2, 330, this.spa * 2 + this.row_h * 2);
        panel.add(phonePanel2);
        JRadioButton radio_s2_1 = new JRadioButton("Only authorized number to call in");
        radio_s2_1.setName("s2_1");
        radio_s2_1.setBounds(new Rectangle(this.spa, this.spa * 2, 280, this.height));
        phonePanel2.add(radio_s2_1);
        JRadioButton radio_s2_0 = new JRadioButton("Allow all numbers to call in");
        radio_s2_0.setName("s2_0");
        radio_s2_0.setBounds(new Rectangle(this.spa, this.spa * 2 + this.row_h, 280, this.height));
        phonePanel2.add(radio_s2_0);
        ButtonGroup bg_2 = new ButtonGroup();
        bg_2.add(radio_s2_1);
        bg_2.add(radio_s2_0);
        this.paneFunction.put("phoneOption_s2", (Object)bg_2);
        JPanel phonePanel3 = PanelUtil.createPanel("Phone Option", this.spa, this.spa * 4 + this.row_h * 4, 330, this.spa * 2 + this.row_h * 2);
        panel.add(phonePanel3);
        JRadioButton radio_s3_1 = new JRadioButton("Hang up call by pressing any button");
        radio_s3_1.setName("s3_1");
        radio_s3_1.setBounds(new Rectangle(this.spa, this.spa * 2, 280, this.height));
        phonePanel3.add(radio_s3_1);
        JRadioButton radio_s3_0 = new JRadioButton("Do not allow to hang up call manually");
        radio_s3_0.setName("s3_0");
        radio_s3_0.setBounds(new Rectangle(this.spa, this.spa * 2 + this.row_h, 280, this.height));
        phonePanel3.add(radio_s3_0);
        ButtonGroup bg_3 = new ButtonGroup();
        bg_3.add(radio_s3_1);
        bg_3.add(radio_s3_0);
        this.paneFunction.put("phoneOption_s3", (Object)bg_3);
        JPanel phonePanel5 = PanelUtil.createPanel("Phone Option", this.spa, this.spa * 6 + this.row_h * 6, 330, this.spa * 2 + this.row_h * 2);
        panel.add(phonePanel5);
        JRadioButton radio_s5_1 = new JRadioButton("Receive SMS from preset numbers");
        radio_s5_1.setName("s5_1");
        radio_s5_1.setBounds(new Rectangle(this.spa, this.spa * 2, 280, this.height));
        phonePanel5.add(radio_s5_1);
        JRadioButton radio_s5_0 = new JRadioButton("Receive SMS from all numbers");
        radio_s5_0.setName("s5_0");
        radio_s5_0.setBounds(new Rectangle(this.spa, this.spa * 2 + this.row_h, 280, this.height));
        phonePanel5.add(radio_s5_0);
        ButtonGroup bg_5 = new ButtonGroup();
        bg_5.add(radio_s5_1);
        bg_5.add(radio_s5_0);
        this.paneFunction.put("phoneOption_s5", (Object)bg_5);
        ArrayList<DocumentObject> enableControl = new ArrayList<DocumentObject>();
        enableControl.add(new DocumentObject("enableControl_led", "LED", true));
        enableControl.add(new DocumentObject("enableControl_motor", "Vibration", true));
        enableControl.add(new DocumentObject("enableControl_agps", "AGPS", true));
        enableControl.add(new DocumentObject("enableControl_bleLoc", "Bluetooth positioning", true));
        enableControl.add(new DocumentObject("enableControl_gsmLoc", "LBS positioning", true));
        enableControl.add(new DocumentObject("enableControl_bleLongConnect", "Bluetooth always connect to charging base", this.bleLongConnect_isShow));
        enableControl.add(new DocumentObject("enableControl_autoUpdate", "Allow update firmware automatically", true));
        enableControl.add(new DocumentObject("enableControl_bleAdvAlways", "BLE Always On", true));
        for (int i = 0; i < enableControl.size(); ++i) {
            if (!((DocumentObject)enableControl.get(i)).getIsShow()) continue;
            JLabel lab = new JLabel(((DocumentObject)enableControl.get(i)).getText());
            lab.setBounds(new Rectangle(this.spa + 176 + 82 + 100, this.spa + this.row_h * i, 330, this.height));
            panel.add(lab);
            JToggleButton toggleBtn = new JToggleButton();
            toggleBtn.setIcon(MainPane.toggle_off);
            toggleBtn.setSelectedIcon(MainPane.toggle_on);
            toggleBtn.setBounds(new Rectangle(this.spa + 176 + 82 + 60 + 330, this.spa + this.row_h * i, 82, this.height));
            panel.add(toggleBtn);
            this.paneFunction.put(((DocumentObject)enableControl.get(i)).getName(), (Object)toggleBtn);
        }
        JTextField flagValue = new JTextField();
        flagValue.setVisible(false);
        panel.add(flagValue);
        this.paneFunction.put("enableControl_flagValue", (Object)flagValue);
        JButton save_function = new JButton("Save");
        save_function.setBounds(new Rectangle(this.spa, 525, this.button_w, this.height));
        panel.add(save_function);
        save_function.addActionListener(this);
        this.paneObjectAll.put("save_function", (Object)save_function);
    }

    private void initPanel_AlertSettings(JPanel panel, JSONObject jsonObj) {
        JSONArray checkArray = PanelUtil.setCheck(panel, this.paneObjectAll, jsonObj);
        String[][] lab_alert = new String[][]{{"GEO NO.1", "GEO NO.2", "GEO NO.3", "GEO NO.4", "Over Speed", "Tilt Alert", "Motion Alert", "No-Motion Alert", "Fall Down Alert", "Low Power Alert"}};
        for (int i = 0; i < lab_alert.length; ++i) {
            for (int j = 0; j < lab_alert[i].length; ++j) {
                JLabel lab = new JLabel(lab_alert[i][j]);
                lab.setBounds(new Rectangle(this.spa + this.lab_input_w * i, this.spa + this.row_h * j, 110, this.height));
                panel.add(lab);
            }
        }
        String[][] input_alert = new String[][]{{"geoAlert$0", "geoAlert$1", "geoAlert$2", "geoAlert$3", "overSpeedAlert", "tiltAlert", "motionAlert", "noMotionAlert", "fallDownAlert", "powerLowAlert"}};
        for (int i = 0; i < input_alert.length; ++i) {
            for (int j = 0; j < input_alert[i].length; ++j) {
                PlaceholderTextField input2;
                PlaceholderTextField input;
                JToggleButton toggleBtn = new JToggleButton();
                toggleBtn.setIcon(MainPane.toggle_off);
                toggleBtn.setSelectedIcon(MainPane.toggle_on);
                toggleBtn.setBounds(new Rectangle(this.spa + 110 + this.lab_input_w * i, this.spa + this.row_h * j, 82, this.height));
                panel.add(toggleBtn);
                jsonObj.put(input_alert[i][j] + "_status", (Object)toggleBtn);
                if (j < 4) {
                    JComboBox<String> geoDirection = new JComboBox<String>(new String[]{"OUT", "IN"});
                    geoDirection.setBounds(new Rectangle(this.spa + 110 + 82 + 10, this.spa + this.row_h * j, 75, this.height));
                    panel.add(geoDirection);
                    jsonObj.put(input_alert[i][j] + "_direction", geoDirection);
                    JComboBox<String> geoType = new JComboBox<String>(new String[]{"Circle", "Polygon"});
                    geoType.setEnabled(false);
                    geoType.setBounds(new Rectangle(this.spa + 110 + 82 + 70 + 20, this.spa + this.row_h * j, 105, this.height));
                    panel.add(geoType);
                    jsonObj.put(input_alert[i][j] + "_type", geoType);
                    geoType.addActionListener(this);
                    PlaceholderTextField input3 = new PlaceholderTextField();
                    input3.setPlaceholder("Radius");
                    input3.setBounds(new Rectangle(this.spa + 110 + 82 + 170 + 30, this.spa + this.row_h * j, 75, this.height));
                    PanelUtil.checkInput(input3, CheckDocument.regex_int, checkArray);
                    panel.add(input3);
                    jsonObj.put(input_alert[i][j] + "_radius", (Object)input3);
                    PlaceholderTextField input22 = new PlaceholderTextField();
                    input22.setPlaceholder("Latitude and Longitude");
                    input22.setEditable(false);
                    input22.setBounds(new Rectangle(this.spa + 110 + 82 + 240 + 40, this.spa + this.row_h * j, 218, this.height));
                    panel.add(input22);
                    jsonObj.put(input_alert[i][j] + "_latlng", (Object)input22);
                    JButton buttonEdit = new JButton();
                    buttonEdit.setBounds(new Rectangle(this.spa + 110 + 82 + 455 + 50, this.spa + this.row_h * j, this.height, this.height));
                    buttonEdit.setIcon(MainPane.editIcon);
                    buttonEdit.setPressedIcon(MainPane.editIcon);
                    panel.add(buttonEdit);
                    buttonEdit.addActionListener(this);
                    jsonObj.put(input_alert[i][j] + "_edit", (Object)buttonEdit);
                    continue;
                }
                if (j == 4) {
                    PlaceholderTextField input_speed = new PlaceholderTextField();
                    input_speed.setPlaceholder("20~400 Unit: km/h");
                    input_speed.setBounds(new Rectangle(this.spa + 110 + 82 + 10, this.spa + this.row_h * j, 178, this.height));
                    PanelUtil.checkInput(input_speed, "^([2-9][0-9]|[1-3][0-9][0-9]|400)$", checkArray);
                    panel.add(input_speed);
                    jsonObj.put(input_alert[i][j] + "_speed", (Object)input_speed);
                    continue;
                }
                if (j == 5) {
                    input = new PlaceholderTextField();
                    input.setPlaceholder("Angle: 30~90 degree");
                    input.setBounds(new Rectangle(this.spa + 110 + 82 + 10, this.spa + this.row_h * j, 178, this.height));
                    PanelUtil.checkInput(input, "^([3-8][0-9]|90)$", checkArray);
                    panel.add(input);
                    jsonObj.put(input_alert[i][j] + "_angle", (Object)input);
                    input2 = new PlaceholderTextField();
                    input2.setPlaceholder("10~180s Unit: seconds");
                    input2.setBounds(new Rectangle(this.spa + 110 + 82 + 218 - 40 + 20, this.spa + this.row_h * j, 178, this.height));
                    PanelUtil.checkInput(input2, "^([1-9][0-9]|1[0-7][0-9]|180)$", checkArray);
                    panel.add(input2);
                    jsonObj.put(input_alert[i][j] + "_time", (Object)input2);
                    continue;
                }
                if (j == 6) {
                    input = new PlaceholderTextField();
                    input.setPlaceholder("Static duration time");
                    input.setBounds(new Rectangle(this.spa + 110 + 82 + 10, this.spa + this.row_h * j, 178, this.height));
                    PanelUtil.checkInput(input, "^([1-9]|[1-5][0-9]|60)$", checkArray);
                    panel.add(input);
                    jsonObj.put(input_alert[i][j] + "_staticTime", (Object)input);
                    input2 = new PlaceholderTextField();
                    input2.setPlaceholder("Move duration time");
                    input2.setBounds(new Rectangle(this.spa + 110 + 82 + 218 - 40 + 20, this.spa + this.row_h * j, 178, this.height));
                    PanelUtil.checkInput(input2, "^[3-9]|[1-9]\\d{1}||[1-5]\\d{2}|600$", checkArray);
                    panel.add(input2);
                    jsonObj.put(input_alert[i][j] + "_moveTime", (Object)input2);
                    continue;
                }
                if (j == 7) {
                    input = new PlaceholderTextField();
                    input.setPlaceholder("No move duration time");
                    input.setBounds(new Rectangle(this.spa + 110 + 82 + 10, this.spa + this.row_h * j, 178, this.height));
                    PanelUtil.checkInput(input, "^([1-9]|10)(\\.0)?$", checkArray);
                    panel.add(input);
                    jsonObj.put(input_alert[i][j] + "_time", (Object)input);
                    continue;
                }
                if (j == 8) {
                    input = new PlaceholderTextField();
                    input.setPlaceholder("Sensitive level: 1~9");
                    input.setBounds(new Rectangle(this.spa + 110 + 82 + 10, this.spa + this.row_h * j, 178, this.height));
                    PanelUtil.checkInput(input, "^([1-9])$", checkArray);
                    panel.add(input);
                    jsonObj.put(input_alert[i][j] + "_level", (Object)input);
                    continue;
                }
                if (j != 9) continue;
                input = new PlaceholderTextField();
                input.setPlaceholder("10~50%");
                input.setBounds(new Rectangle(this.spa + 110 + 82 + 10, this.spa + this.row_h * j, 178, this.height));
                PanelUtil.checkInput(input, "^([1-4][0-9]|50)$", checkArray);
                panel.add(input);
                jsonObj.put(input_alert[i][j] + "_power", (Object)input);
                JCheckBox cbox_powerON = new JCheckBox("Power ON");
                cbox_powerON.setBounds(new Rectangle(this.spa + 110 + 82 + 218 - 40 + 20, this.spa + this.row_h * j, this.chbox_w + 40, this.height));
                panel.add(cbox_powerON);
                jsonObj.put(input_alert[i][j] + "_powerON", (Object)cbox_powerON);
                JCheckBox cbox_powerOFF = new JCheckBox("Power OFF");
                cbox_powerOFF.setBounds(new Rectangle(this.spa + 110 + 82 + 218 + 80 + 30, this.spa + this.row_h * j, this.chbox_w + 40, this.height));
                panel.add(cbox_powerOFF);
                jsonObj.put(input_alert[i][j] + "_powerOFF", (Object)cbox_powerOFF);
            }
        }
        JButton save_alert = new JButton("Save");
        save_alert.setBounds(new Rectangle(this.spa, 525, this.button_w, this.height));
        panel.add(save_alert);
        save_alert.addActionListener(this);
        this.paneObjectAll.put("save_alert_settings", (Object)save_alert);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.panels.forEach((key, value) -> {
            if (e.getSource().equals(this.paneObjectAll.get(key))) {
                if (this.isGlobalCheckError && PanelUtil.checkError(this.paneObjectAll, value)) {
                    return;
                }
                this.savePanel(PanelUtil.getPanel(value));
            }
        });
        if (e.getSource().equals(this.paneSystems.get((Object)"workMode_mode"))) {
            JComboBox workMode = (JComboBox)this.paneSystems.get((Object)"workMode_mode");
            JTextField input = (JTextField)this.paneSystems.get((Object)"workMode_time");
            JTextField input2 = (JTextField)this.paneSystems.get((Object)"timeInterval_upload");
            JTextField input3 = (JTextField)this.paneSystems.get((Object)"timeInterval_uploadLazy");
            JLabel lab_info = (JLabel)this.paneObjectAll.get((Object)"lab_infoTimeInterval");
            if (workMode.getSelectedIndex() == 0) {
                input.setVisible(false);
                input2.setVisible(false);
                input3.setVisible(false);
                lab_info.setText(Constants.info1);
            } else if (workMode.getSelectedIndex() == 1 || workMode.getSelectedIndex() == 5) {
                input.setVisible(false);
                input2.setVisible(true);
                input3.setVisible(true);
                lab_info.setText(Constants.info2);
            } else if (workMode.getSelectedIndex() == 2) {
                input.setVisible(false);
                input2.setVisible(true);
                input3.setVisible(false);
                lab_info.setText(Constants.info3);
            } else if (workMode.getSelectedIndex() == 3) {
                input.setVisible(true);
                input2.setVisible(false);
                input3.setVisible(false);
                lab_info.setText(Constants.info4);
            } else if (workMode.getSelectedIndex() == 4) {
                input.setVisible(true);
                input2.setVisible(false);
                input3.setVisible(false);
                lab_info.setText(Constants.info5);
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (e.getSource().equals(this.paneAlert.get((Object)("geoAlert$" + i + "_type")))) {
                PublicUtil.changeGeoType(this.paneAlert, i);
            }
            if (!e.getSource().equals(this.paneAlert.get((Object)("geoAlert$" + i + "_edit")))) continue;
            PublicUtil.showGeoEditPage(this.paneAlert, i);
        }
    }

    @Override
    public void saveAll() {
        JSONObject configData = new JSONObject();
        for (JSONObject paneObject : this.panels.values()) {
            configData.putAll((Map)PanelUtil.getPanel(paneObject));
        }
        JSONObject[] jsonObjs = this.panels.values().toArray(new JSONObject[this.panels.size()]);
        if (this.isGlobalCheckError && PanelUtil.checkError(this.paneObjectAll, jsonObjs)) {
            return;
        }
        this.savePanel(configData);
    }

    public void savePanel(JSONObject configData) {
        HandlerChain.Builder(configData).addHandler(HandlerRemoveField.INSTANCE).addHandler(HandlerNoMotionTime.INSTANCE).addHandler(HandlerGeoLatLng.INSTANCE).addHandler(HandlerDeviceID.INSTANCE).addHandler(HandlerListMap.INSTANCE).handleResponse();
        PublicUtil.savePanel(configData);
    }

    @Override
    public void clearAll() {
        for (JSONObject paneObject : this.panels.values()) {
            PublicUtil.clearPanel((Map<String, Object>)paneObject);
        }
        BottomStatusPanel.setBattery(-1);
    }

    @Override
    public void initChannelList(JComboBox<ChannelEnum> cList) {
        cList.removeAllItems();
        cList.addItem(ChannelEnum.SERIAL_BLUETOOTH);
    }

    @Override
    public void listenReceiveData(CmdData cmdData) {
        MainPane.getDebugModel().listenReceiveData(cmdData);
        if ("R".equals(cmdData.getDateType())) {
            JSONObject responseData;
            JSONObject data_json = new JSONObject((Map)cmdData.getData());
            JSONObject dataClone = JSONObject.parseObject((String)data_json.toJSONString());
            JSONObject cmdBodyData = dataClone.getJSONObject("cmdBodyData");
            JSONObject configData = cmdBodyData.getJSONObject("configData");
            if (!this.isShow_Model) {
                configData.remove((Object)"deviceName");
            }
            if (configData != null) {
                HandlerChain.Builder(configData).addHandler(HandlerListMap.INSTANCE).addHandler(HandlerDeviceID.INSTANCE).addHandler(HandlerGeoLatLng.INSTANCE).addHandler(HandlerNoMotionTime.INSTANCE).handleRequest();
                for (JSONObject paneObject : this.panels.values()) {
                    PanelUtil.showPaneData(paneObject, configData);
                }
                if (configData.get((Object)"battery_battery") != null) {
                    BottomStatusPanel.setBattery(configData.getIntValue("battery_battery"));
                }
                Toast.showMsg("Read successfully.", 1000L);
            }
            if ((responseData = cmdBodyData.getJSONObject("responseData")) != null) {
                Object returnMsg = responseData.getString("returnStatus");
                if (((String)returnMsg).equals("ok")) {
                    returnMsg = "OK";
                } else if (((String)returnMsg).equals("error")) {
                    returnMsg = "ERROR:" + responseData.getString("msg");
                    if (responseData.getIntValue("code") == 22) {
                        returnMsg = "OK";
                    }
                }
                Toast.showMsg((String)returnMsg, 2000L);
            }
        }
    }

    @Override
    public void readProfile() {
        JSONObject configData = PublicUtil.readProfile();
        HandlerChain.Builder(configData).addHandler(HandlerListMap.INSTANCE).addHandler(HandlerDeviceID.INSTANCE).addHandler(HandlerGeoLatLng.INSTANCE).addHandler(HandlerNoMotionTime.INSTANCE).handleRequest();
        for (JSONObject paneObject : this.panels.values()) {
            PanelUtil.showPaneData(paneObject, configData);
        }
    }

    @Override
    public void writeProfile() {
        JSONObject configData = new JSONObject();
        for (JSONObject paneObject : this.panels.values()) {
            configData.putAll((Map)PanelUtil.getPanel(paneObject));
        }
        HandlerChain.Builder(configData).addHandler(HandlerRemoveField.INSTANCE).addHandler(HandlerNoMotionTime.INSTANCE).addHandler(HandlerGeoLatLng.INSTANCE).addHandler(HandlerDeviceID.INSTANCE).addHandler(HandlerListMap.INSTANCE).handleResponse();
        PublicUtil.writeProfile(configData);
    }

    @Override
    public void setConfigFile() {
        Constants.configFileUtil.setProperty(this.getKey(), "isShow_Model", "true");
        Constants.configFileUtil.setProperty(this.getKey(), "isShow_BleLongConnect", "true");
        Constants.configFileUtil.setProperty(this.getKey(), "checkError", "false");
    }
}

