/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.model;

import com.eview.tool.MainPane;
import com.eview.tool.event.CmdData;
import com.eview.tool.event.EventBusFactory;
import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.ev07b.model.CmdModel;
import com.tracker.ev07b.service.CmdService;
import com.tracker.ev07b.service.HeadService;
import com.tracker.ev07b.service.command.CommandDebug;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.LockRingBuffer;
import java.util.HashMap;
import java.util.Map;

public class CMD_Public {
    public static void addRingBuffer(LockRingBuffer ringBuffer, String key) {
        CmdService.INSTANCE.addBuffer(ringBuffer, cmdModel -> {
            Map<String, Object> objectData = CmdService.INSTANCE.protocolAnalysis((CmdModel)cmdModel);
            if (objectData != null) {
                CmdData cmdData = new CmdData().setChannel(key).setDateType("R").setSequenceId(cmdModel.getHeadData().getSequenceId()).setData(objectData);
                EventBusFactory.getInstance().post((Object)cmdData);
            }
        });
    }

    public static byte[] getPasswordVerify(int sequenceId, String password, boolean isOldKey) {
        int key;
        byte[] passwordByte;
        if (isOldKey) {
            passwordByte = ProtocolUtil.long2Bytes(Long.parseLong(password), 4);
            key = 13;
        } else {
            passwordByte = BytesHexStrUtil.string2BytesByUTF_8(password);
            key = 14;
        }
        CmdHead cmd_headData = MainPane.protocol.getCommandHead(sequenceId, true);
        CmdBody cmd_bodyData = MainPane.protocol.getCommandBody(9, key, passwordByte);
        return MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
    }

    public static byte[] shutdown() {
        byte[] bodyData = new byte[]{4, 1, 20};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] reboot() {
        byte[] bodyData = new byte[]{4, 1, 18};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] reFactory() {
        byte[] bodyData = new byte[]{4, 1, 17};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] isSimCardUnLock() {
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("SimCardUnLock", "null");
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_headData = MainPane.protocol.getCommandHead(sequenceId, true);
        CmdBody cmd_bodyData = MainPane.protocol.getCommand_system(param);
        return MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
    }

    public static byte[] sendMusicTest() {
        byte[] bodyData = new byte[]{-2, 6, 23, 1, 0, 0, 0, 0};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendNone() {
        byte[] bodyData = new byte[]{6, 5, 80, 0, 0, 0, 0};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendGPS() {
        byte[] bodyData = new byte[]{6, 5, 80, 1, 0, 0, 0};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendGSM() {
        byte[] bodyData = new byte[]{6, 5, 80, 2, 0, 0, 0};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendAT(byte[] cmd) {
        byte[] bodyData = new byte[]{6, 0, 84};
        if (cmd != null) {
            bodyData = ArrayUtils.addAll(bodyData, cmd);
        }
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] sendSMS(byte[] cmd) {
        byte[] bodyData = new byte[]{6, 0, 38};
        if (cmd != null) {
            bodyData = ArrayUtils.addAll(bodyData, cmd);
        }
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] onlyAT() {
        byte[] bodyData = new byte[]{6, 1, 52};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] heatBeat() {
        byte[] bodyData = new byte[]{3, 1, 49};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] divStatus() {
        byte[] bodyData = new byte[]{6, 1, 48};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] dsStatus() {
        byte[] bodyData = new byte[]{6, 1, 64};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] getDebugCommand(Map<String, Object> param) {
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_headData = HeadService.INSTANCE.getCommandHead(sequenceId, true);
        CmdBody cmd_bodyData = CommandDebug.INSTANCE.decode(param);
        return MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
    }

    public static byte[] setLog(long value) {
        byte[] bodyData = new byte[]{6, 5, 86};
        byte[] valueBytes = ProtocolUtil.long2Bytes(value, 4);
        bodyData = ArrayUtils.addAll(bodyData, valueBytes);
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] scanBeacon(String lat, String lng, String describe) {
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        HashMap<String, String> scanBeacon = new HashMap<String, String>(3);
        scanBeacon.put("lat", lat);
        scanBeacon.put("lng", lng);
        scanBeacon.put("describe", describe);
        param.put("scanBeaconAuto", scanBeacon);
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_headData = MainPane.protocol.getCommandHead(sequenceId, true);
        CmdBody cmd_bodyData = MainPane.protocol.getCommand_system(param);
        return MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
    }

    public static byte[] scanWifiAuto(String lat, String lng, String describe) {
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        HashMap<String, String> scanWifiAuto = new HashMap<String, String>(3);
        scanWifiAuto.put("lat", lat);
        scanWifiAuto.put("lng", lng);
        scanWifiAuto.put("describe", describe);
        param.put("scanWifiAuto", scanWifiAuto);
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_headData = MainPane.protocol.getCommandHead(sequenceId, true);
        CmdBody cmd_bodyData = MainPane.protocol.getCommand_system(param);
        return MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
    }
}

