/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.handler;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.handler.HandlerChain;
import com.eview.tool.handler.IHandler;
import com.eview.util.Constants;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HandlerListMap
implements IHandler {
    public static final String LIST = "$";
    public static final String CHILD = "_";
    public static HandlerListMap INSTANCE = new HandlerListMap();

    private HandlerListMap() {
    }

    @Override
    public void handleRequest(HandlerChain chain) {
        this.doJson2Map(chain.getData());
        chain.handleRequest();
    }

    @Override
    public void handleResponse(HandlerChain chain) {
        this.doMap2Json(chain.getData());
        chain.handleResponse();
    }

    private void doJson2Map(JSONObject configData) {
        JSONObject configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (!(configData_copy.get((Object)key) instanceof List)) continue;
            JSONArray list = configData_copy.getJSONArray(key);
            for (int i = 0; i < list.size(); ++i) {
                int index = list.getJSONObject(i).getIntValue("index");
                configData.put(key + LIST + index, (Object)list.getJSONObject(i));
            }
            configData.remove((Object)key);
        }
        configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (!(configData_copy.get((Object)key) instanceof Map)) continue;
            JSONObject object = configData_copy.getJSONObject(key);
            for (String key2 : object.keySet()) {
                configData.put(key + CHILD + key2, object.get((Object)key2));
            }
            configData.remove((Object)key);
        }
        configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (key.equals("dateTime")) {
                Date dateTime = configData_copy.getDate(key);
                configData.put("dateTime", (Object)Constants.dateTimeFormat.format(dateTime));
                int runTime = configData_copy.getIntValue("runTime");
                Date startTime = new Date(dateTime.getTime() - (long)runTime * 1000L);
                configData.put("startTime", (Object)Constants.dateTimeFormat.format(startTime));
                continue;
            }
            if (key.contains("birthday")) {
                Date birthday = configData_copy.getDate(key);
                configData.put(key, (Object)Constants.dateFormat.format(birthday));
                continue;
            }
            if (!key.equals("password_password")) continue;
            int data = configData_copy.getIntValue("password_password");
            configData.put(key, (Object)String.format("%06d", Convert.toInt((Object)data)));
        }
    }

    private void doMap2Json(JSONObject configData) {
        JSONObject obj;
        JSONObject configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (!key.contains(CHILD)) continue;
            String[] keys = key.split(CHILD);
            obj = null;
            obj = configData.get((Object)keys[0]) == null ? new JSONObject() : configData.getJSONObject(keys[0]);
            obj.put(keys[1], configData_copy.get((Object)key));
            configData.put(keys[0], (Object)obj);
            configData.remove((Object)key);
        }
        configData_copy = (JSONObject)configData.clone();
        for (String key : configData_copy.keySet()) {
            if (!key.contains(LIST)) continue;
            String index = key.substring(key.indexOf(LIST) + 1).split("\\D+")[0];
            obj = configData_copy.getJSONObject(key);
            obj.put("index", (Object)Integer.parseInt(index));
            String key2 = key.replaceAll("\\$\\d+", "");
            if (configData.get((Object)key2) != null) {
                configData.getJSONArray(key2).add((Object)obj);
            } else {
                JSONArray list = new JSONArray();
                list.add((Object)obj);
                configData.put(key2, (Object)list);
            }
            configData.remove((Object)key);
        }
    }
}

