/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.event;

import com.alibaba.fastjson.JSONObject;
import com.eview.tool.MainPane;
import com.eview.tool.bluetooth.BlueSerialJDialog;
import com.eview.tool.bluetooth.ScanWiFiJDialog;
import com.eview.tool.event.CmdData;
import com.eview.tool.event.Condition;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import java.util.Optional;
import javax.swing.SwingUtilities;

public class CmdReceiveListener {
    private final String channel;
    private CmdData cmdData;
    private Condition condition;

    public CmdReceiveListener(String channel) {
        this.channel = channel;
    }

    @Subscribe
    private void handleMethod(CmdData cmdData) {
        if (this.condition != null) {
            this.timeOutNotify(this.condition, cmdData);
        }
        if (!cmdData.getChannel().equals(this.channel)) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            MainPane.getThisModel().listenReceiveData(cmdData);
            if ("R".equals(cmdData.getDateType())) {
                JSONObject data_json = new JSONObject((Map)cmdData.getData());
                if (BlueSerialJDialog.getInstance().isVisible()) {
                    BlueSerialJDialog.getInstance().listenReceiveData(data_json);
                }
                if (ScanWiFiJDialog.getInstance().isVisible()) {
                    ScanWiFiJDialog.getInstance().listenReceiveData(data_json);
                }
            }
        });
    }

    public Map<String, Object> getData(Condition condition, long time) {
        this.timeOutWait(condition, time);
        return (Map)this.cmdData.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeOutWait(Condition condition, long time) {
        CmdReceiveListener cmdReceiveListener = this;
        synchronized (cmdReceiveListener) {
            try {
                this.condition = condition;
                this.wait(time);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.condition = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeOutNotify(Condition condition, CmdData cmdData) {
        CmdReceiveListener cmdReceiveListener = this;
        synchronized (cmdReceiveListener) {
            Optional.ofNullable(condition).filter(c -> {
                if (c.getChannel() != null) {
                    return c.getChannel().equals(cmdData.getChannel());
                }
                return true;
            }).filter(c -> {
                if (c.getDateType() != null) {
                    return c.getDateType().equals(cmdData.getDateType());
                }
                return true;
            }).filter(c -> {
                if (c.getSequenceId() != null) {
                    return c.getSequenceId().equals(cmdData.getSequenceId());
                }
                return true;
            }).ifPresent(c -> {
                this.cmdData = cmdData;
                this.notify();
            });
        }
    }
}

