/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.dialog;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONObject;
import com.eview.adb.UsbAdbServices;
import com.eview.tool.ChannelEnum;
import com.eview.tool.MainPane;
import com.eview.tool.customUI.Toast;
import com.eview.util.Constants;
import com.eview.util.FileUtil;
import com.eview.util.PublicUtil;
import com.tracker.ev07b.Upgrade;
import com.tracker.ev07b.service.HeadService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.ButtonUI;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;

public class UpgradeJDialog
extends JDialog
implements ActionListener {
    public static JTextField upgradePath = new JTextField();
    public static JButton selectfile = new JButton("Select");
    public static JToggleButton upgrade = new JToggleButton("Upgrade");
    public static JCheckBox isSystemUpdate = new JCheckBox("system update");
    public static JProgressBar progressbar = new JProgressBar();
    public static JLabel upgradeInfo = new JLabel();
    private Upgrade upgrade_ev07b;
    private Process process;
    private Thread upgrade_evd;
    private boolean isEvdUpgradeCheck = MainPane.isShowProperty("MainPane", "isEvdUpgradeVersionCheck", "true");
    private static final String zipFilePassword = "tieappecare12345601";
    private UpdateProgressbarThread updateProgressbarThread;
    private static final UpgradeJDialog instance = new UpgradeJDialog();

    public static UpgradeJDialog getInstance() {
        return instance;
    }

    private UpgradeJDialog() {
        this.setTitle("Firmware Upgrade");
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(null);
        Container desktopPane = this.getContentPane();
        contentPane.add((Component)desktopPane, "Center");
        this.setContentPane(contentPane);
        this.setBounds(new Rectangle(0, 0, 500, 210));
        this.setModal(true);
        this.setLocationRelativeTo(null);
        int input_w = 285;
        int button_w = 75;
        int height = 35;
        upgradePath.setBounds(new Rectangle(12, 12, input_w, height));
        upgradePath.setEditable(false);
        contentPane.add(upgradePath);
        selectfile.setBounds(new Rectangle(12 + input_w + 5, 12, button_w, height));
        contentPane.add(selectfile);
        upgrade.setBounds(new Rectangle(12 + input_w + button_w + 10, 12, button_w + 15, height));
        upgrade.setUI((ButtonUI)Constants.btnUI);
        contentPane.add(upgrade);
        isSystemUpdate.setBounds(new Rectangle(12, 12 + height + 7, input_w, height));
        contentPane.add(isSystemUpdate);
        progressbar.setOrientation(0);
        progressbar.setMinimum(0);
        progressbar.setMaximum(100);
        progressbar.setValue(0);
        progressbar.setStringPainted(true);
        progressbar.setPreferredSize(new Dimension(460, 15));
        progressbar.setBorderPainted(true);
        progressbar.setForeground(Color.blue);
        progressbar.setBounds(new Rectangle(12, 94, 460, 15));
        contentPane.add(progressbar);
        upgradeInfo.setBounds(new Rectangle(12, 12 + height * 3 + 10, 460, height));
        contentPane.add(upgradeInfo);
        selectfile.addActionListener(this);
        upgrade.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == selectfile) {
            String filePath = Constants.configFileUtil.readProperty(MainPane.getThisModel().getKey(), "UpgradeFilePath", ".");
            JFileChooser chooser = new JFileChooser(filePath);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("*.zip", "zip");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                String path = chooser.getSelectedFile().getPath();
                Constants.configFileUtil.writeProperty(MainPane.getThisModel().getKey(), "UpgradeFilePath", path);
                upgradePath.setText(path);
            }
            if (ChannelEnum.EVD.equals(MainPane.getCList().getSelectedItem())) {
                ZipFile zipFile = new ZipFile(upgradePath.getText());
                try {
                    if (zipFile.isEncrypted()) {
                        isSystemUpdate.setSelected(false);
                    } else {
                        isSystemUpdate.setSelected(true);
                    }
                }
                catch (ZipException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (e.getSource() == upgrade) {
            try {
                if (upgrade.isSelected()) {
                    upgrade.setText("Cancel");
                    selectfile.setEnabled(false);
                    FileInputStream fis = new FileInputStream(upgradePath.getText());
                    this.upgradeFile(fis);
                } else {
                    upgrade.setText("Upgrade");
                    selectfile.setEnabled(true);
                    this.upgradeCancel();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void upgradeFile(InputStream inputStream) {
        upgradeInfo.setText("");
        if (ChannelEnum.EVD.equals(MainPane.getCList().getSelectedItem())) {
            this.evdUpgrade();
        } else {
            String modeKey = MainPane.getThisModel().getKey();
            Object[] keys = new String[]{"EV201M", "EV206M"};
            if (ArrayUtil.contains((Object[])keys, (Object)modeKey)) {
                PublicUtil.readConfig(new byte[]{20});
                int sequenceId = HeadService.INSTANCE.getSequenceId(false);
                Map<String, Object> configMap = MainPane.receiveData(sequenceId, 3000L);
                boolean checkB = this.checkBattery(configMap, 10);
                if (!checkB) {
                    selectfile.setEnabled(true);
                    upgrade.setSelected(false);
                    upgrade.setText("Upgrade");
                    return;
                }
            }
            this.upgrade_ev07b = new Upgrade(inputStream, new Upgrade.CallBack(){

                @Override
                public void sendData(byte[] byteData) {
                    MainPane.sendData(byteData);
                }

                @Override
                public Map<String, Object> receiveData(int sequenceId) {
                    return MainPane.receiveData(sequenceId, 2000L);
                }

                @Override
                public void setProgressbar(int percent) {
                    if (percent <= progressbar.getMaximum()) {
                        progressbar.setValue(percent);
                    } else {
                        progressbar.setValue(0);
                    }
                    if (percent == 100) {
                        selectfile.setEnabled(true);
                        upgrade.setSelected(false);
                        upgrade.setText("Upgrade");
                    }
                }

                @Override
                public void message(String type, String message) {
                    upgradeInfo.setText(type + ":" + message);
                }
            });
            this.upgrade_ev07b.start();
        }
    }

    private void updateProgressbar(int num, int size, int time) {
        this.updateProgressbarThread = new UpdateProgressbarThread(num, size, time);
        Constants.threadPool.execute(this.updateProgressbarThread);
    }

    private void evdUpgrade() {
        this.upgrade_evd = new Thread(() -> {
            if (isSystemUpdate.isSelected()) {
                this.updateProgressbar(0, 10, 15);
                Object filePath = upgradePath.getText();
                PublicUtil.readConfig(new byte[]{26, 20});
                int sequenceId = HeadService.INSTANCE.getSequenceId(false);
                Map<String, Object> configMap = MainPane.receiveData(sequenceId, 3000L);
                boolean checkB = this.checkBattery(configMap, 30);
                boolean checkZ = this.checkZipFileVersion(configMap, (String)filePath);
                if (!checkB || !checkZ) {
                    selectfile.setEnabled(true);
                    upgrade.setSelected(false);
                    upgrade.setText("Upgrade");
                    return;
                }
                String fileName = ((String)filePath).substring(((String)filePath).lastIndexOf(Constants.fs) + 1);
                String newFilePath = FileUtil.getCurrentPath("./temp/upgradeFile/") + Constants.fs + fileName;
                FileUtil.sendfile4zeroCopy((String)filePath, newFilePath);
                this.updateProgressbarThread.close();
                this.updateProgressbar(10, 80, 65);
                filePath = "\"" + Constants.currentPath + Constants.fs + "temp" + Constants.fs + "upgradeFile" + Constants.fs + fileName + "\"";
                UsbAdbServices.getInstance().cmdexec("evd push " + (String)filePath + " /sdcard/update.zip", MainPane.getADBKey(), pro -> {
                    this.process = pro;
                }, obj -> {
                    if (obj != null && obj.getString("out").indexOf("100%") >= 0) {
                        UsbAdbServices.getInstance().cmdexec("evd shell am broadcast -a \"android.intent.action.LUNCH_ECARE_INSTALL_SYSTEM\" -f 0x01000000 --el version \"001\" --es filepath \"/mnt/sdcard/update.zip\"", MainPane.getADBKey());
                        this.updateProgressbarThread.close();
                        MainPane.delay(100L);
                        progressbar.setValue(100);
                        upgradeInfo.setText("Upgrade complete");
                        selectfile.setEnabled(true);
                        upgrade.setSelected(false);
                        upgrade.setText("Upgrade");
                    }
                });
                FileUtil.delFolder(newFilePath);
            } else {
                progressbar.setValue(0);
                upgradeInfo.setText("");
                String tempPath = Constants.currentPath + "/temp/apk";
                FileUtil.delFolder(tempPath);
                try {
                    ZipFile zipFile = new ZipFile(upgradePath.getText());
                    if (zipFile.isEncrypted()) {
                        zipFile.setPassword(zipFilePassword.toCharArray());
                    }
                    zipFile.extractAll(tempPath);
                }
                catch (ZipException e) {
                    e.printStackTrace();
                }
                List<String> filePathList = FileUtil.traverseFolder(tempPath);
                int index = 0;
                while (index < filePathList.size()) {
                    String filePath = "\"" + filePathList.get(index) + "\"";
                    int finalIndex = index++;
                    UsbAdbServices.getInstance().cmdexec("evd install -r " + filePath, MainPane.getADBKey(), pro -> {
                        this.process = pro;
                    }, obj -> {
                        upgradeInfo.setText(obj.getString("out") + " (" + (finalIndex + 1) + "/" + filePathList.size() + ")");
                        if (obj.getString("out").indexOf("Success") >= 0) {
                            progressbar.setValue((finalIndex + 1) * 90 / filePathList.size());
                            if (finalIndex + 1 == filePathList.size()) {
                                UsbAdbServices.getInstance().cmdexec("evd reboot", MainPane.getADBKey());
                                progressbar.setValue(100);
                                upgradeInfo.setText("Upgrade complete");
                                selectfile.setEnabled(true);
                                upgrade.setSelected(false);
                                upgrade.setText("Upgrade");
                            }
                        } else if (obj.getString("error").indexOf("INSTALL_FAILED_VERSION_DOWNGRADE") >= 0) {
                            String returnMsg = "Only upgrade to a higher firmware version";
                            Toast.showMsg(this, returnMsg, 3000L);
                        }
                    });
                }
                FileUtil.delFolder(tempPath);
            }
        });
        Constants.threadPool.execute(this.upgrade_evd);
    }

    public void upgradeCancel() {
        if (ChannelEnum.EVD.equals(MainPane.getCList().getSelectedItem())) {
            if (this.process != null) {
                ProcessHandle handle = this.process.toHandle();
                handle.destroy();
                handle.descendants().forEach(ProcessHandle::destroy);
            }
            if (this.updateProgressbarThread != null) {
                this.updateProgressbarThread.close();
            }
        } else if (this.upgrade_ev07b != null) {
            this.upgrade_ev07b.exitThread();
            String tempPath = Constants.currentPath + "/temp/apk";
            FileUtil.delFolder(tempPath);
        }
    }

    private boolean checkZipFileVersion(Map<String, Object> configMap, String file) {
        if (!this.isEvdUpgradeCheck) {
            return true;
        }
        boolean checked = true;
        String trackerVersion = "";
        String fileVersion = null;
        try {
            if (configMap != null) {
                JSONObject version_json = new JSONObject(configMap);
                JSONObject configData = version_json.getJSONObject("cmdBodyData").getJSONObject("configData");
                trackerVersion = configData.getString("fwVersion");
            }
            ZipFile zip = new ZipFile(file);
            List list = zip.getFileHeaders();
            block2: for (FileHeader fileHeader : list) {
                String fileName = fileHeader.getFileName();
                if (!fileName.equals("META-INF/com/android/metadata")) continue;
                ZipInputStream inputStream = zip.getInputStream(fileHeader);
                InputStreamReader inReader = new InputStreamReader((InputStream)inputStream);
                BufferedReader reader = new BufferedReader(inReader);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (!line.contains("post-build=")) continue;
                    fileVersion = line.substring(line.lastIndexOf(":") + 1);
                    if (fileVersion.lastIndexOf(".") <= 0) continue block2;
                    fileVersion = fileVersion.substring(0, fileVersion.lastIndexOf("."));
                    checked = trackerVersion.contains(fileVersion);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        if (!checked) {
            trackerVersion = trackerVersion.substring(0, 13);
            String errorMsg = String.format("<html><body><span style=\"color:red;\">Status\uff1aVersion mismatch</span><br>Info\uff1a FileVersion:%s TrackerVersion:%s</span></body></html>", fileVersion, trackerVersion);
            upgradeInfo.setText(errorMsg);
        }
        return checked;
    }

    private boolean checkBattery(Map<String, Object> configMap, int minBattery) {
        JSONObject configJson;
        JSONObject configData;
        int trackerBattery;
        boolean checked = true;
        if (configMap != null && (trackerBattery = (configData = (configJson = new JSONObject(configMap)).getJSONObject("cmdBodyData").getJSONObject("configData")).getJSONObject("battery").getIntValue("battery")) < minBattery) {
            String errorMsg = String.format("<html><body><span style=\"color:red;\">The device cannot be upgraded if its battery capacity is lower than %s</span></body></html>", minBattery + "%");
            upgradeInfo.setText(errorMsg);
            checked = false;
        }
        return checked;
    }

    class UpdateProgressbarThread
    implements Runnable {
        private boolean isRunning = true;
        private int num;
        private int size;
        private int time;

        public UpdateProgressbarThread(int num, int size, int time) {
            this.num = num;
            this.size = size;
            this.time = time;
        }

        public void close() {
            this.isRunning = false;
        }

        @Override
        public void run() {
            int percent = this.num + this.size;
            if (percent > 100) {
                throw new RuntimeException("parameter error");
            }
            progressbar.setValue(this.num);
            double incr = (double)this.size / ((double)this.time * 10.0);
            double sum = 0.0;
            while (this.isRunning && progressbar.getValue() <= percent && !((sum += incr) > (double)this.size)) {
                progressbar.setValue((int)Math.round((double)this.num + sum));
                MainPane.delay(100L);
            }
        }
    }
}

