/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.dialog;

import com.eview.tool.customUI.SearchText;
import com.eview.tool.customUI.Toast;
import com.eview.util.Constants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ConfigFileJDialog
extends JDialog
implements ActionListener {
    private JPasswordField passWordField = new JPasswordField();
    private static JButton read = new JButton("Read");
    private static JButton save = new JButton("Save");
    private final JTextArea textArea_config = new JTextArea();
    private static ConfigFileJDialog instance = new ConfigFileJDialog();

    public static ConfigFileJDialog getInstance() {
        return instance;
    }

    private ConfigFileJDialog() {
        this.setTitle("Config File Setting");
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(null);
        Container desktopPane = this.getContentPane();
        contentPane.add((Component)desktopPane, "Center");
        this.setContentPane(contentPane);
        this.setBounds(new Rectangle(0, 0, 580, 500));
        this.setLocationRelativeTo(null);
        this.setModal(true);
        int s = 14;
        int input_w = 285;
        int height = 33;
        int button_w = 75;
        this.passWordField.setBounds(new Rectangle(5, s, input_w, height));
        contentPane.add(this.passWordField);
        read.setBounds(new Rectangle(input_w + 10, s, button_w, height));
        contentPane.add(read);
        save.setBounds(new Rectangle(input_w + button_w + 15, s, button_w, height));
        contentPane.add(save);
        this.textArea_config.setLineWrap(true);
        this.textArea_config.setWrapStyleWord(true);
        JScrollPane outputscroll_analysis = new JScrollPane(this.textArea_config);
        outputscroll_analysis.setVerticalScrollBarPolicy(22);
        outputscroll_analysis.setBounds(new Rectangle(5, 60, 560, 390));
        contentPane.add(outputscroll_analysis);
        new SearchText().register(this.textArea_config, outputscroll_analysis);
        read.addActionListener(this);
        save.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == read) {
            this.textArea_config.setText("");
            String password = new String(this.passWordField.getPassword());
            if (!Constants.configFileUtil.check(password.getBytes())) {
                Toast.showMsg("Password error", 2000L);
                return;
            }
            Toast.showMsg(this, "Read successfully", 2000L);
            try {
                byte[] data = Files.readAllBytes(new File(Constants.configFilePath).toPath());
                data = Constants.configFileUtil.encrypt(data, password.getBytes());
                InputStreamReader inReader = new InputStreamReader(new ByteArrayInputStream(data));
                BufferedReader reader = new BufferedReader(inReader);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                    this.textArea_config.append(line);
                    this.textArea_config.append(Constants.lines);
                }
                inReader.close();
                reader.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource() == save) {
            SwingUtilities.invokeLater(() -> {
                String password = new String(this.passWordField.getPassword());
                if (!Constants.configFileUtil.check(password.getBytes())) {
                    Toast.showMsg("Password error", 2000L);
                    return;
                }
                Toast.showMsg(this, "Saved successfully", 2000L);
                byte[] data = this.textArea_config.getText().getBytes();
                Constants.configFileUtil.initConfigData(data);
                data = Constants.configFileUtil.encrypt(data, password.getBytes());
                try {
                    Files.write(Paths.get(Constants.configFilePath, new String[0]), data, new OpenOption[0]);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            });
        }
    }
}

