/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.dialog;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.CheckDocument;
import com.eview.tool.MainPane;
import com.eview.tool.model.PanelUtil;
import com.eview.util.Constants;
import com.eview.util.PublicUtil;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.ev07b.service.HeadService;
import com.tracker.ev07b.service.command.CommandConfig;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class AesKeyJDialog
extends JDialog
implements ActionListener {
    private static final JComboBox<String> keyType = new JComboBox<String>(new String[]{"None", "Dynamic AES", "Static AES", "Public RSA", "Private RSA"});
    private static JLabel lab_keyId = new JLabel("ID");
    private static JLabel lab_CRC = new JLabel("CRC");
    private static JTextField input_keyId = new JTextField();
    private static JTextField input_crc = new JTextField();
    private static JButton read = new JButton("Read");
    private static final JToggleButton aes_status = new JToggleButton();
    private static final JComboBox<String> keyType2 = new JComboBox<String>(new String[]{"None", "Dynamic AES", "Static AES", "Public RSA", "Private RSA"});
    private static JLabel lab_keyId2 = new JLabel("ID");
    private static JLabel lab_aesKey = new JLabel("Aes Key");
    private static JLabel lab_aesIV = new JLabel("Aes IV");
    private static JTextField aesId = new JTextField();
    private static JTextField aesKey = new JTextField();
    private static JTextField aesIV = new JTextField();
    private static JButton load = new JButton("Load");
    private static JButton save = new JButton("Save");
    private static AesKeyJDialog instance = new AesKeyJDialog();

    public static AesKeyJDialog getInstance() {
        return instance;
    }

    private AesKeyJDialog() {
        this.setTitle("AES key profile");
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(null);
        Container desktopPane = this.getContentPane();
        contentPane.add((Component)desktopPane, "Center");
        this.setContentPane(contentPane);
        this.setBounds(new Rectangle(0, 0, 480, 250));
        this.setLocationRelativeTo(null);
        keyType.setBounds(new Rectangle(5, 10, 130, 30));
        keyType.setToolTipText("Type");
        contentPane.add(keyType);
        lab_keyId.setBounds(new Rectangle(140, 10, 40, 30));
        contentPane.add(lab_keyId);
        input_keyId.setBounds(new Rectangle(165, 10, 60, 30));
        input_keyId.setEditable(false);
        contentPane.add(input_keyId);
        lab_CRC.setBounds(new Rectangle(235, 10, 35, 30));
        contentPane.add(lab_CRC);
        input_crc.setBounds(new Rectangle(275, 10, 95, 30));
        input_crc.setEditable(false);
        contentPane.add(input_crc);
        read.setBounds(new Rectangle(375, 10, 65, 30));
        contentPane.add(read);
        JPanel settingPanel = PanelUtil.createPanel("Setting key", 5, 45, 460, 160);
        contentPane.add(settingPanel);
        aes_status.setIcon(MainPane.toggle_off);
        aes_status.setSelectedIcon(MainPane.toggle_on);
        aes_status.setBounds(new Rectangle(10, 30, 82, 33));
        settingPanel.add(aes_status);
        keyType2.setBounds(new Rectangle(100, 30, 130, 30));
        keyType2.setToolTipText("Type");
        settingPanel.add(keyType2);
        lab_keyId2.setBounds(new Rectangle(255, 30, 40, 30));
        settingPanel.add(lab_keyId2);
        aesId.setBounds(new Rectangle(300, 30, 60, 30));
        PanelUtil.checkInput(aesId, "^\\d{1,7}$");
        settingPanel.add(aesId);
        lab_aesKey.setBounds(new Rectangle(5, 70, 55, 30));
        settingPanel.add(lab_aesKey);
        aesKey.setBounds(new Rectangle(60, 70, 300, 30));
        PanelUtil.checkInput(aesKey, CheckDocument.regex_hex_32);
        settingPanel.add(aesKey);
        load.setBounds(new Rectangle(365, 70, 65, 30));
        settingPanel.add(load);
        lab_aesIV.setBounds(new Rectangle(5, 110, 55, 30));
        settingPanel.add(lab_aesIV);
        aesIV.setBounds(new Rectangle(60, 110, 300, 30));
        PanelUtil.checkInput(aesIV, CheckDocument.regex_hex_32);
        settingPanel.add(aesIV);
        save.setBounds(new Rectangle(365, 110, 65, 30));
        settingPanel.add(save);
        read.addActionListener(this);
        load.addActionListener(this);
        save.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == read) {
            SwingUtilities.invokeLater(() -> {
                PublicUtil.readConfig(new byte[]{73});
                int sequenceId = HeadService.INSTANCE.getSequenceId(false);
                Map<String, Object> configData = MainPane.receiveData(sequenceId, 3000L);
                if (configData != null) {
                    JSONObject jsonObject = new JSONObject(configData);
                    JSONObject aesCRC = jsonObject.getJSONObject("cmdBodyData").getJSONObject("configData").getJSONObject("aesCRC");
                    keyType.setSelectedIndex(aesCRC.getIntValue("type"));
                    input_keyId.setText(aesCRC.getString("id"));
                    input_crc.setText(aesCRC.getString("aesCRC"));
                }
            });
        }
        if (e.getSource() == load) {
            String filePath = Constants.configFileUtil.readProperty("MenuItem", "AesKeyFilePath", ".");
            JFileChooser chooser = new JFileChooser(filePath);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("*.txt", "txt", "config");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                String path = chooser.getSelectedFile().getPath();
                Constants.configFileUtil.writeProperty(MainPane.getThisModel().getKey(), "AesKeyFilePath", path);
                List lines = FileUtil.readLines((File)new File(path), (String)"UTF-8");
                String[] aesKeys = ((String)lines.get(1)).split("\\|");
                keyType2.setSelectedIndex(Convert.toInt((Object)aesKeys[0], (Integer)0));
                aesId.setText(aesKeys[1]);
                aesKey.setText(aesKeys[2]);
                aesIV.setText(aesKeys[3]);
            }
        }
        if (e.getSource() == save) {
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            HashMap<String, Object> aesKeyObj = new HashMap<String, Object>(4);
            if (aes_status.isSelected()) {
                aesKeyObj.put("id", Convert.toLong((Object)aesId.getText(), (Long)0L));
                aesKeyObj.put("type", Convert.toLong((Object)keyType2.getSelectedIndex(), (Long)0L));
                aesKeyObj.put("aesKey", aesKey.getText().trim());
                aesKeyObj.put("aesIV", aesIV.getText().trim());
            } else {
                aesKeyObj.put("id", 0);
                aesKeyObj.put("type", 0);
            }
            param.put("aesKey", aesKeyObj);
            int sequenceId = HeadService.INSTANCE.getSequenceId(true);
            CmdHead cmd_headData = HeadService.INSTANCE.getCommandHead(sequenceId, true);
            CmdBody cmd_bodyData = CommandConfig.INSTANCE.decode(param);
            byte[] sendData = MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
            MainPane.sendData(sendData);
        }
    }
}

