/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.customUI;

import com.eview.Application;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class Toast
extends JWindow {
    private static final long serialVersionUID = 1L;
    private String message = "";
    private long period = 1500L;
    private final Insets insets = new Insets(12, 24, 12, 24);
    private final Font font = new Font("Dialog", 0, 15);
    private Color background;
    private Color foreground;
    private static int width = 300;
    private static int height = 60;
    public static final int success = 1;
    public static final int warning = 2;
    public static final int error = 3;
    public static final int info = 0;

    public Toast(Window parent, String message, int period) {
        this(parent, message, period, 0);
    }

    public Toast(Window parent, String message, long period, int type) {
        super(parent);
        this.message = message;
        this.period = period;
        Dimension size = this.getStringSize(this.font, true, message);
        if (size.width > width) {
            width = size.width;
        }
        if (size.height > height) {
            height = size.height;
        }
        this.setSize(new Dimension(width, height));
        this.setLocationRelativeTo(parent);
        this.installTheme(type);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Composite oldComposite = g2.getComposite();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(this.font);
        FontMetrics fm = g2.getFontMetrics();
        g2.setColor(this.background);
        g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 5, 5);
        g2.setColor(this.foreground);
        int textWidth = fm.stringWidth(this.message);
        int x = (width - textWidth) / 2;
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int y = (height - (ascent + descent)) / 2 + ascent;
        g2.drawString(this.message, x, y);
        g2.setComposite(oldComposite);
    }

    public void start() {
        this.setVisible(true);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Toast.this.setVisible(false);
            }
        }, this.period);
    }

    public void setMessage(String message) {
        this.message = message;
        Dimension size = this.getStringSize(this.font, true, message);
        this.setSize(size);
        this.revalidate();
        this.repaint(0, 0, size.width, size.height);
        if (!this.isVisible()) {
            this.start();
        }
    }

    private void installTheme(int type) {
        switch (type) {
            case 1: {
                this.background = new Color(9, 163, 200);
                this.foreground = Color.WHITE;
                break;
            }
            case 2: {
                this.background = new Color(15641677);
                this.foreground = Color.WHITE;
                break;
            }
            case 3: {
                this.background = new Color(242, 222, 222);
                this.foreground = new Color(215, 82, 78);
                break;
            }
            default: {
                this.background = new Color(0x515151);
                this.foreground = Color.WHITE;
            }
        }
    }

    private Dimension getStringSize(Font font, boolean isAntiAliased, String text) {
        FontRenderContext renderContext = new FontRenderContext(null, isAntiAliased, false);
        Rectangle2D bounds = font.getStringBounds(text, renderContext);
        int width = (int)bounds.getWidth() + 2 * this.insets.left;
        int height = (int)bounds.getHeight() + this.insets.top * 2;
        return new Dimension(width, height);
    }

    public static void showMsg(String msg, long time) {
        SwingUtilities.invokeLater(() -> new Toast(Application.mainPane, msg, time, 1).start());
    }

    public static void showMsg(Window parent, String msg, long time) {
        SwingUtilities.invokeLater(() -> new Toast(parent, msg, time, 1).start());
    }

    public static void showMsg(String msg, long time, int type) {
        SwingUtilities.invokeLater(() -> new Toast(Application.mainPane, msg, time, type).start());
    }
}

