/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.customUI;

import com.eview.tool.MainPane;
import com.eview.tool.customUI.PlaceholderTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class SearchText
extends JPanel {
    private static final int DEFAULT_WIDTH = 230;
    private static final int DEFAULT_HEIGHT = 40;
    private final PlaceholderTextField search_text = new PlaceholderTextField();
    private final JLabel up = new JLabel("\u2227", 0);
    private final JLabel down = new JLabel("\u2228", 0);
    private final JLabel close = new JLabel("x", 0);
    private final JLabel centerContainer = new JLabel("", 0);
    private JTextComponent outputArea;
    private JScrollPane scroll;
    private Popup pop;
    private boolean isShow = false;

    public SearchText() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(null);
        this.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170)));
        this.setPreferredSize(new Dimension(230, 40));
        this.search_text.setBounds(new Rectangle(5, 5, 160, 30));
        this.search_text.setPlaceholder("Search: ignore case");
        this.centerContainer.setBounds(new Rectangle(160, 5, 60, 30));
        this.up.setToolTipText("Previous(Shift+Enter)");
        this.down.setToolTipText("Next(Enter)");
        this.close.setToolTipText("Close");
        this.up.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        this.down.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        this.close.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        this.centerContainer.setLayout(new BorderLayout());
        this.centerContainer.add((Component)this.up, "West");
        this.centerContainer.add((Component)this.down, "Center");
        this.centerContainer.add((Component)this.close, "East");
        this.clickedListener(this.up, this::findPrevious);
        this.clickedListener(this.down, this::findNext);
        this.clickedListener(this.close, this::hidePanel);
        this.add(this.search_text);
        this.add(this.centerContainer);
    }

    public void register(final JTextComponent showComponent, JScrollPane scroll) {
        this.scroll = scroll;
        this.outputArea = showComponent;
        showComponent.setRequestFocusEnabled(true);
        showComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                showComponent.requestFocusInWindow();
            }
        });
        this.setPreferredSize(new Dimension(230, 40));
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        showComponent.getInputMap().put(KeyStroke.getKeyStroke(70, 2), "find");
        showComponent.getActionMap().put("find", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedText = SearchText.this.outputArea.getSelectedText();
                if (selectedText != null) {
                    SearchText.this.search_text.setText(selectedText);
                }
                SearchText.this.showPanel(showComponent);
                SearchText.this.search_text.requestFocusInWindow();
            }
        });
        this.outputArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchText.this.refresh();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchText.this.refresh();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchText.this.refresh();
            }
        });
        this.outputArea.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SwingUtilities.invokeLater(() -> {
                    MainPane.delay(50L);
                    if (!SearchText.this.search_text.isFocusOwner()) {
                        SearchText.this.hidePanel();
                    }
                });
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.search_text.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SwingUtilities.invokeLater(() -> {
                    MainPane.delay(50L);
                    if (!SearchText.this.outputArea.isFocusOwner()) {
                        SearchText.this.hidePanel();
                    }
                });
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.search_text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getModifiersEx() == 64 && e.getKeyChar() == '\n') {
                    SearchText.this.findPrevious();
                } else if (e.getKeyChar() == '\n') {
                    SearchText.this.findNext();
                }
            }
        });
        scroll.getVerticalScrollBar().addAdjustmentListener(e -> this.refresh());
    }

    private void showPanel(Component owner) {
        if (this.pop != null) {
            this.pop.hide();
        }
        int w = this.scroll.getViewport().getWidth();
        int h = this.scroll.getViewport().getHeight();
        Point point = new Point(w - this.outputArea.getX() - 230, -this.outputArea.getY());
        SwingUtilities.convertPointToScreen(point, this.outputArea);
        this.pop = PopupFactory.getSharedInstance().getPopup(owner, this, point.x, point.y);
        this.pop.show();
        this.isShow = true;
    }

    private void hidePanel() {
        if (this.pop != null) {
            this.isShow = false;
            this.pop.hide();
            this.pop = null;
        }
    }

    private void refresh() {
        if (this.isShow) {
            this.outputArea.repaint();
            this.scroll.repaint();
            SwingUtilities.invokeLater(() -> SwingUtilities.updateComponentTreeUI(this));
        }
    }

    private void findNext() {
        String text = this.search_text.getText();
        if (text.isEmpty()) {
            return;
        }
        int length = text.length();
        int findIndex = this.outputArea.getCaret().getDot();
        int offset = this.outputArea.getText().toLowerCase().indexOf(text.toLowerCase(), findIndex);
        if (offset >= 0) {
            this.outputArea.getCaret().setDot(offset);
            this.outputArea.getCaret().moveDot(offset + length);
            this.outputArea.getCaret().setSelectionVisible(true);
        } else if (findIndex > 0) {
            this.outputArea.getCaret().setDot(0);
            this.findNext();
        }
    }

    private void findPrevious() {
        String text = this.search_text.getText();
        if (text.isEmpty()) {
            return;
        }
        int length = text.length();
        int findIndex = this.outputArea.getCaret().getDot();
        int offset = this.outputArea.getText().toLowerCase().lastIndexOf(text.toLowerCase(), findIndex - length);
        if (offset >= 0) {
            this.outputArea.getCaret().setDot(offset + length);
            this.outputArea.getCaret().moveDot(offset);
            this.outputArea.getCaret().setSelectionVisible(true);
        } else if (findIndex < this.outputArea.getText().length()) {
            this.outputArea.getCaret().setDot(this.outputArea.getText().length());
            this.findPrevious();
        }
    }

    private void clickedListener(JComponent component, final Runnable runnable) {
        component.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                runnable.run();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }
}

