/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.customUI;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class PlaceholderTextField
extends JTextField {
    private BufferedImage buffer = null;
    private String placeholder = "";

    public PlaceholderTextField() {
    }

    public PlaceholderTextField(int pColumns) {
        super(pColumns);
    }

    public PlaceholderTextField(String pText) {
        super(pText);
    }

    public PlaceholderTextField(String pText, int pColumns) {
        super(pText, pColumns);
    }

    public PlaceholderTextField(Document pDoc, String pText, int pColumns) {
        super(pDoc, pText, pColumns);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String s) {
        this.placeholder = s;
        this.setToolTipText(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics pG) {
        Container window = this.getTopLevelAncestor();
        if (window instanceof Window && !((Window)window).isOpaque()) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.buffer == null || this.buffer.getWidth() != w || this.buffer.getHeight() != h) {
                GraphicsConfiguration gc = this.getGraphicsConfiguration();
                this.buffer = gc.createCompatibleImage(w, h, 3);
            }
            Graphics2D bufferGraphics = this.buffer.createGraphics();
            try {
                super.paintComponent(bufferGraphics);
            }
            finally {
                bufferGraphics.dispose();
            }
            pG.drawImage(this.buffer, 0, 0, w, h, 0, 0, w, h, null);
        } else {
            super.paintComponent(pG);
        }
        if (this.placeholder.length() == 0 || this.getText().length() > 0) {
            return;
        }
        Graphics2D g = (Graphics2D)pG;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.GRAY);
        g.drawString(this.placeholder, this.getInsets().left, pG.getFontMetrics().getMaxAscent() + this.getInsets().top + 2);
    }
}

