/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool.bluetooth;

import com.alibaba.fastjson.JSONObject;
import com.eview.tool.MainPane;
import com.eview.tool.bluetooth.WiFiCellRender;
import com.eview.tool.customUI.PlaceholderTextField;
import com.eview.tool.model.PanelUtil;
import com.eview.util.Constants;
import com.tracker.ev07b.model.CmdBody;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.ev07b.service.HeadService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.plaf.ButtonUI;

public class ScanWiFiJDialog
extends JDialog
implements ActionListener {
    public static MainPane mainPane;
    public static PlaceholderTextField input_rssi;
    public static JButton scan;
    public static JToggleButton add;
    private static final JComboBox<String> cList;
    private final JPanel wifiListPanel = new JPanel();
    private static JList<Map<String, Object>> wifiList;
    private static Map<String, Object> paneWifiList;
    private static WiFiListModel listModel;
    private JScrollPane scrollPane = null;
    private final int jdialogWidth = 500;
    private final int jdialogHeight = 460;
    private static int scanWiFiListSize;
    private static ScanWiFiJDialog instance;

    public void setParam(Map<String, Object> paneWifiList) {
        ScanWiFiJDialog.paneWifiList = paneWifiList;
        this.scanWifi();
    }

    public void setScanWiFiListSize(int scanWiFiListSize) {
        ScanWiFiJDialog.scanWiFiListSize = scanWiFiListSize;
    }

    public static ScanWiFiJDialog getInstance() {
        return instance;
    }

    private ScanWiFiJDialog() {
        super(mainPane, "Scan WiFi", true);
        this.setResizable(false);
        this.wifiListPanel.setLayout(null);
        Container desktopPane = this.getContentPane();
        this.wifiListPanel.add((Component)desktopPane, "Center");
        this.setContentPane(this.wifiListPanel);
        this.setBounds(new Rectangle(0, 0, 500, 460));
        this.setLocationRelativeTo(null);
        input_rssi.setBounds(new Rectangle(5, 10, 80, 33));
        input_rssi.setPlaceholder("Rssi");
        this.wifiListPanel.add(input_rssi);
        cList.setBounds(new Rectangle(170, 10, 80, 33));
        this.wifiListPanel.add(cList);
        cList.addItem("0s");
        cList.addItem("1s");
        cList.addItem("2s");
        cList.setVisible(false);
        scan.setBounds(new Rectangle(310, 10, 80, 33));
        this.wifiListPanel.add(scan);
        add.setBounds(new Rectangle(400, 10, 80, 33));
        add.setUI((ButtonUI)Constants.btnUI);
        this.wifiListPanel.add(add);
        listModel = new WiFiListModel();
        wifiList = new JList(listModel);
        wifiList.setSelectionMode(2);
        this.scrollPane = PanelUtil.createScrollPanel(wifiList, 5, 50, 480, 370);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.wifiListPanel.add((Component)this.scrollPane, "Center");
        scan.addActionListener(this);
        add.addActionListener(this);
    }

    public void listenReceiveData(JSONObject data_json) {
        JSONObject systemObj;
        JSONObject jsonObject = data_json.getJSONObject("cmdBodyData");
        int cmdType = jsonObject.getIntValue("cmdType");
        if (cmdType == 4 && (systemObj = jsonObject.getJSONObject("systemData")).get((Object)"scanWifi") instanceof List) {
            List scanWifiList = (List)systemObj.getObject("scanWifi", List.class);
            for (Map scanWifi : scanWifiList) {
                if (ScanWiFiJDialog.filterWifiList(scanWifi.get("mac").toString())) {
                    ((WiFiListModel)wifiList.getModel()).addElement(scanWifi);
                    listModel.addElement(scanWifi);
                    continue;
                }
                System.out.println("Filter the list of WiFi that already exists:" + String.valueOf(scanWifi));
            }
        }
    }

    private void scanWifi() {
        listModel.clear();
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> scanWifi = new HashMap<String, String>();
        scanWifi.put("rssi", input_rssi.getText());
        scanWifi.put("interval", cList.getSelectedItem().toString().replace("s", ""));
        param.put("scanWifi", scanWifi);
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_headData = MainPane.protocol.getCommandHead(sequenceId, true);
        CmdBody cmd_bodyData = MainPane.protocol.getCommand_system(param);
        byte[] sendData = MainPane.protocol.getByteData(cmd_headData, cmd_bodyData);
        MainPane.sendData(sendData);
    }

    private static boolean filterWifiList(String mac) {
        String wifiWhiteListKey = "wifiWhiteList$";
        for (int i = 0; i < scanWiFiListSize; ++i) {
            JTextField wifi_mac = (JTextField)paneWifiList.get(wifiWhiteListKey + i + "_mac");
            if (!wifi_mac.getText().equals(mac)) continue;
            return false;
        }
        return true;
    }

    private boolean addWifiList(Map<String, Object> data) {
        String wifiWhiteListKey = "wifiWhiteList$";
        for (int i = 0; i < scanWiFiListSize; ++i) {
            JTextField wifi_mac = (JTextField)paneWifiList.get(wifiWhiteListKey + i + "_mac");
            if (!wifi_mac.getText().isEmpty()) continue;
            wifi_mac.setText(data.get("mac").toString());
            JTextField wifi_describe = (JTextField)paneWifiList.get(wifiWhiteListKey + i + "_describe");
            wifi_describe.setText(data.get("name").toString());
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == scan) {
            this.scanWifi();
        }
        if (e.getSource() == add) {
            List<Map<String, Object>> list = wifiList.getSelectedValuesList();
            for (Map<String, Object> map : list) {
                boolean b;
                if (map == null || !(b = this.addWifiList(map))) continue;
                listModel.removeElement(map.get("mac").toString());
            }
        }
    }

    static {
        input_rssi = new PlaceholderTextField("-100");
        scan = new JButton("Scan");
        add = new JToggleButton("Add");
        cList = new JComboBox();
        scanWiFiListSize = 10;
        instance = new ScanWiFiJDialog();
    }

    class WiFiListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private final List<String> keyList = new ArrayList<String>();
        private final Map<String, Map> mapBuffer = new HashMap<String, Map>();

        WiFiListModel() {
        }

        public void clear() {
            this.keyList.clear();
            this.mapBuffer.clear();
            wifiList.repaint();
            ScanWiFiJDialog.this.scrollPane.getViewport().doLayout();
        }

        public void addElement(Map map) {
            int rssi;
            String key = (String)map.get("mac");
            int thisrssi = Integer.parseInt(String.valueOf(map.get("rssi")));
            if (thisrssi > (rssi = Integer.parseInt(input_rssi.getText()))) {
                if (!this.mapBuffer.containsKey(key)) {
                    this.keyList.add(key);
                    wifiList.paintImmediately(wifiList.getBounds());
                }
                this.mapBuffer.put(key, map);
                wifiList.setCellRenderer(new WiFiCellRender());
                wifiList.repaint();
                ScanWiFiJDialog.this.scrollPane.getViewport().doLayout();
            }
        }

        public void removeElement(String key) {
            this.mapBuffer.remove(key);
            this.keyList.remove(key);
            wifiList.repaint();
            ScanWiFiJDialog.this.scrollPane.getViewport().doLayout();
        }

        @Override
        public Map getElementAt(int index) {
            if (this.keyList.size() > index) {
                String key = this.keyList.get(index);
                return this.mapBuffer.get(key);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.keyList.size();
        }
    }
}

