/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.eview.tool.UpgradeFileModel;
import com.eview.tool.model.CMD_Public;
import com.eview.tool.model.Model_Debug;
import com.eview.tool.queue.OutputLog;
import com.eview.tool.queue.OutputLogQueue;
import com.eview.util.Constants;
import com.eview.util.PublicUtil;
import com.tracker.event.RD_ObserverCallBack;
import com.tracker.event.ReturnDataUtil;
import java.awt.Color;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class UIUpgrade
extends Thread {
    private final Logger log = Logger.getLogger(this.getClass());
    private final List<UpgradeFileModel> upgradeFiles = new ArrayList<UpgradeFileModel>();
    private final CallBack callBack;
    private volatile boolean isExit = false;
    private final String rootPath;
    private final String[] filePath;
    private final Semaphore semaphore = new Semaphore(1);
    private RD_ObserverCallBack observer;

    public UIUpgrade(String rootPath, String[] filePath, CallBack callBack) {
        this.rootPath = rootPath;
        this.filePath = filePath;
        this.callBack = callBack;
    }

    private void subscription_EV06() {
        this.observer = ReturnDataUtil.getObserverData("debug_ui", (object, rd_condition) -> {
            String type = rd_condition.getDateType();
            JSONObject jsonBody = (JSONObject)object;
            if ("R".equals(type)) {
                boolean open_ok = Optional.ofNullable(jsonBody).map(jsonObject -> jsonObject.getJSONObject("debugData")).filter(jsonObject -> jsonObject.getIntValue("cmdKey") == 112).filter(jsonObject -> "OK".equals(jsonObject.getString("open"))).isPresent();
                boolean close_ok = Optional.ofNullable(jsonBody).map(jsonObject -> jsonObject.getJSONObject("debugData")).filter(jsonObject -> jsonObject.getIntValue("cmdKey") == 113).filter(jsonObject -> "OK".equals(jsonObject.getString("close"))).isPresent();
                boolean write_ok = Optional.ofNullable(jsonBody).map(jsonObject -> jsonObject.getJSONObject("debugData")).filter(jsonObject -> jsonObject.getIntValue("cmdKey") == 114).filter(jsonObject -> jsonObject.getLongValue("write") > 0L).isPresent();
                if (open_ok || write_ok || close_ok) {
                    this.semaphore.release();
                }
            }
        });
    }

    private void unSubscription() {
        ReturnDataUtil.deleteObserverData("debug_ui", this.observer);
    }

    private void sendOpen(String fileName) {
        String filePath = this.rootPath + "/" + fileName;
        HashMap<String, Object> param2 = new HashMap<String, Object>(2);
        param2.put("flag", 256);
        param2.put("fileName", filePath);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("open", param2);
        byte[] cmdData = CMD_Public.getDebugCommand(param);
        this.sendData(cmdData);
        OutputLog outputLog = new OutputLog().setType("S").setData("Open File:" + filePath + Constants.lines).setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setIsLine(true).setTextPane(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
    }

    private void sendWrite(byte[] fileData) {
        int readed = 0;
        int readSize = 1024;
        while (readed < fileData.length) {
            if (readed > 0 && !this.getSemaphore(this.semaphore)) {
                this.isExit = true;
                break;
            }
            if (readed + readSize > fileData.length) {
                readSize = fileData.length - readed;
            }
            byte[] buffer = Arrays.copyOfRange(fileData, readed, readed + readSize);
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("write", buffer);
            byte[] cmdData = CMD_Public.getDebugCommand(param);
            this.sendData(cmdData);
            double percent = NumberUtil.div((String)("" + (readed += readSize)), (String)("" + fileData.length), (int)4).multiply(BigDecimal.valueOf(100L)).doubleValue();
            String percentStr = PublicUtil.getProgressBarStr(percent, 50);
            OutputLog outputLog = new OutputLog().setData(percentStr).setColor(Color.BLUE).setTextPane(Model_Debug.debug_outputArea);
            if (readed != readSize) {
                outputLog.setIsReplaceLastLine(true);
            }
            OutputLogQueue.getInstance().addDebugLog(outputLog);
        }
    }

    private void sendClose() {
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("close", "null");
        byte[] cmdData = CMD_Public.getDebugCommand(param);
        this.sendData(cmdData);
        OutputLog outputLog = new OutputLog().setType("S").setData("Close File").setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setIsLine(true).setTextPane(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
    }

    public void exitThread() {
        this.isExit = true;
        this.interrupt();
        this.unSubscription();
    }

    private boolean getSemaphore(Semaphore semaphore) {
        try {
            return semaphore.tryAcquire(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void run() {
        boolean semaphore1;
        this.subscription_EV06();
        for (String path : this.filePath) {
            UpgradeFileModel upgradeFile = new UpgradeFileModel();
            File tempFile = new File(path.trim());
            byte[] bytes = FileUtil.readBytes((File)tempFile);
            upgradeFile.setFileName(tempFile.getName());
            upgradeFile.setFileData(bytes);
            this.upgradeFiles.add(upgradeFile);
        }
        int index = 0;
        int step = 1;
        while (!this.isExit && index < this.upgradeFiles.size() && step <= 3 && (semaphore1 = this.getSemaphore(this.semaphore))) {
            UpgradeFileModel upgradeFile = this.upgradeFiles.get(index);
            switch (step) {
                case 1: {
                    this.sendOpen(upgradeFile.getFileName());
                    break;
                }
                case 2: {
                    this.sendWrite(upgradeFile.getFileData());
                    break;
                }
                case 3: {
                    this.sendClose();
                }
            }
            if (step == 3) {
                ++index;
                step = 1;
                continue;
            }
            ++step;
        }
        this.unSubscription();
    }

    public void sendData(byte[] byteData) {
        this.callBack.sendData(byteData);
    }

    public static interface CallBack {
        public void sendData(byte[] var1);

        public void error(String var1);
    }
}

