/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool;

import com.eview.adb.UsbAdbServices;
import com.eview.tool.MainPane;
import com.eview.tool.model.Model_Debug;
import com.eview.tool.queue.OutputLog;
import com.eview.tool.queue.OutputLogQueue;
import com.eview.util.Constants;
import com.eview.util.FileUtil;
import com.tracker.ev07b.model.CmdHead;
import com.tracker.ev07b.service.HeadService;
import com.tracker.event.RD_Condition;
import com.tracker.event.ReturnDataUtil;
import com.tracker.util.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class MusicUpgrade
extends Thread {
    private final Logger log = Logger.getLogger(this.getClass());
    public static final int CMD_Debug = 6;
    public static final int CMD_Music_Start = 96;
    public static final int CMD_Music_Down = 97;
    public static final String CMD_Music_FS_Path = "music";
    public static final int CMD_Music_FS_Start = 121;
    public static final int CMD_Music_FS_Down = 112;
    public static final int CMD_Music_FS_Down2 = 114;
    public static final int CMD_Music_FS_Down3 = 113;
    private String[] musicFileName;
    private byte[][] firmwareData;
    private final CallBack callBack;
    private volatile boolean isExit = false;
    private final boolean isOver = false;
    private int percent = 0;
    private int state = 1;
    private int index = 0;
    private int readed = 0;
    private int all = 0;
    private int allReaded = 0;
    private final String[] musicPath;

    public MusicUpgrade(String[] musicPath, CallBack callBack) {
        this.musicPath = musicPath;
        this.callBack = callBack;
        String musicType = Model_Debug.debug_typeMusic.getSelectedItem().toString();
        if (musicType.equals("2G")) {
            this.musicDown_2G();
        } else if (musicType.equals("EV07BX") || musicType.equals("EV07BA") || musicType.equals("EV06X") || musicType.equals("EV06A")) {
            String disk = musicType.equals("EV07BX") || musicType.equals("EV06X") ? "E" : "C";
            this.musicDown_07BX_07BA(disk);
        } else if (musicType.equals("FS")) {
            this.musicDown_FS();
        } else if (musicType.equals("EVD")) {
            this.musicDown_EVD();
        }
    }

    private void musicDown_2G() {
        ReturnDataUtil.getObserverData("debug_music", (object, rd_condition) -> {
            String type = rd_condition.getDateType();
            String data = (String)object;
            if (!this.isExit && "R".equals(type) && this.index < this.firmwareData.length) {
                if (data.equals("DownMusicOK")) {
                    this.state = 1;
                }
                String musicName = this.musicFileName[this.index];
                byte[] firData = this.firmwareData[this.index];
                int total = this.firmwareData[this.index].length;
                boolean isNext = this.isNext(data);
                if (isNext && this.state == 1) {
                    ++this.state;
                    MainPane.delay(100L);
                    this.sendData(this.musicDown1_2G(musicName));
                    ++this.percent;
                    this.readed = 0;
                } else if (isNext && this.state == 2) {
                    ++this.state;
                    MainPane.delay(100L);
                    int readSize = 800;
                    if (this.readed + readSize > total) {
                        readSize = total - this.readed;
                    }
                    this.sendData(this.musicDown2_2G(musicName, readSize));
                    ++this.percent;
                } else if (isNext && this.state == 3) {
                    ++this.state;
                    int readSize = 800;
                    if (this.readed + readSize > total) {
                        readSize = total - this.readed;
                    }
                    byte[] buffer = Arrays.copyOfRange(firData, this.readed, this.readed + readSize);
                    this.sendData(this.musicDown3_2G(buffer));
                    this.readed += readSize;
                    this.allReaded += readSize;
                    this.percent = Math.round((float)this.allReaded / (float)this.all * 100.0f);
                    if (this.readed == total) {
                        ++this.index;
                        this.state = 1;
                    }
                }
                this.callBack.setProgressbar(this.percent);
                if (this.index >= this.firmwareData.length) {
                    this.isExit = true;
                }
            }
        });
    }

    private void musicDown_07BX_07BA(String disk) {
        ReturnDataUtil.getObserverData("debug_music", (object, rd_condition) -> {
            String type = rd_condition.getDateType();
            String data = (String)object;
            if (!this.isExit && "R".equals(type) && this.index < this.firmwareData.length) {
                if (data.equals("DownMusicOK")) {
                    this.state = 1;
                }
                String musicName = this.musicFileName[this.index];
                byte[] firData = this.firmwareData[this.index];
                int total = this.firmwareData[this.index].length;
                boolean isNext = this.isNext(data);
                if (isNext && this.state == 1) {
                    ++this.state;
                    this.sendData(this.musicDown1_07BX(disk));
                    ++this.percent;
                    this.readed = 0;
                    MainPane.delay(500L);
                } else if (isNext && this.state == 2) {
                    ++this.state;
                    this.sendData(this.musicDown2_07BX(musicName, total, disk));
                    ++this.percent;
                    MainPane.delay(500L);
                } else if (isNext && this.state == 3) {
                    this.state = 1;
                    while (this.readed < total) {
                        MainPane.delay(40L);
                        int readSize = 200;
                        if (this.readed + readSize > total) {
                            readSize = total - this.readed;
                        }
                        byte[] buffer = Arrays.copyOfRange(firData, this.readed, this.readed + readSize);
                        this.sendData(this.musicDown3_07BX(buffer));
                        this.readed += readSize;
                        this.allReaded += readSize;
                        this.percent = Math.round((float)this.allReaded / (float)this.all * 100.0f);
                    }
                    if (this.readed == total) {
                        MainPane.delay(400L);
                        ++this.index;
                        this.state = 1;
                    }
                }
                this.callBack.setProgressbar(this.percent);
                if (this.index >= this.firmwareData.length) {
                    this.isExit = true;
                }
            }
        });
    }

    private void musicDown_FS() {
        ReturnDataUtil.getObserverData("debug_music", (object, rd_condition) -> {
            String type = rd_condition.getDateType();
            String data = (String)object;
            if (!this.isExit && "R".equals(type) && this.index < this.firmwareData.length) {
                String musicName = this.musicFileName[this.index];
                byte[] firData = this.firmwareData[this.index];
                int total = this.firmwareData[this.index].length;
                if (data.equals("DownMusicOK") || data.indexOf("ok") == 0 && this.state == 1) {
                    this.state = 2;
                    this.sendData(this.musicDown1_FS(musicName));
                    OutputLog outputLog = new OutputLog().setType("S").setData(musicName + " [").setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setIsLine(true).setTextPane(Model_Debug.debug_outputArea);
                    OutputLogQueue.getInstance().addDebugLog(outputLog);
                    ++this.percent;
                    this.readed = 0;
                } else if (data.indexOf("ok") == 0 && this.state == 2) {
                    if (this.readed < total) {
                        int readSize = 200;
                        if (this.readed + readSize > total) {
                            readSize = total - this.readed;
                        }
                        byte[] buffer = Arrays.copyOfRange(firData, this.readed, this.readed + readSize);
                        this.sendData(this.musicDown2_FS(buffer));
                        if (this.readed / readSize % 4 == 0) {
                            OutputLog outputLog = new OutputLog().setData("=").setTextPane(Model_Debug.debug_outputArea);
                            OutputLogQueue.getInstance().addDebugLog(outputLog);
                        }
                        this.readed += readSize;
                        this.allReaded += readSize;
                        this.percent = Math.round((float)this.allReaded / (float)this.all * 100.0f);
                    }
                    if (this.readed == total) {
                        this.state = 3;
                    }
                } else if (data.indexOf("ok") == 0 && this.state == 3) {
                    this.sendData(this.musicDown3_FS());
                    OutputLog outputLog = new OutputLog().setData("]OK").setTextPane(Model_Debug.debug_outputArea);
                    OutputLogQueue.getInstance().addDebugLog(outputLog);
                    this.state = 1;
                    ++this.index;
                }
                this.callBack.setProgressbar(this.percent);
                if (this.index >= this.firmwareData.length) {
                    this.isExit = true;
                }
            }
        });
    }

    private void musicDown_EVD() {
        ReturnDataUtil.getObserverData("debug_music", (object, rd_condition) -> {
            String type = rd_condition.getDateType();
            String data = (String)object;
            if (!this.isExit && "R".equals(type) && this.index < this.firmwareData.length) {
                String musicName = this.musicPath[this.index];
                if (data.equals("DownMusicOK")) {
                    this.musicDown1_EVD();
                    this.musicDown2_EVD(musicName);
                    OutputLog outputLog = new OutputLog().setType("S").setData("\r\n Music Down ok").setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextPane(Model_Debug.debug_outputArea);
                    OutputLogQueue.getInstance().addDebugLog(outputLog);
                    this.percent = 100;
                    ++this.index;
                }
                this.callBack.setProgressbar(this.percent);
                if (this.index >= this.firmwareData.length) {
                    this.isExit = true;
                }
            }
        });
    }

    public boolean isNext(String data) {
        this.state = this.state <= 3 ? this.state : 2;
        String type = "";
        if (this.state == 2) {
            type = "OK";
        } else if (this.state == 3) {
            type = ">";
        } else if (this.state == 4) {
            type = "OK";
        }
        return data.indexOf(type) >= 0;
    }

    public boolean getIsOver() {
        return this.isOver;
    }

    public void exitThread() {
        this.isExit = true;
        this.interrupt();
    }

    public static byte[] musicStart() {
        byte[] bodyData = new byte[]{6, 1, 96};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public static byte[] musicStartFS() {
        byte[] path = CMD_Music_FS_Path.getBytes(StandardCharsets.UTF_8);
        byte[] bodyData = new byte[]{6, 6, 121};
        bodyData = ArrayUtils.addAll(bodyData, path);
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] musicDown1_2G(String fileName) {
        String cmd = "AT+FSCREATE=USER\\" + fileName + "\r\n";
        OutputLog outputLog = new OutputLog().setType("S").setData(cmd).setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextPane(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
        byte[] bodyData = new byte[]{6, 0, 97};
        bodyData = ArrayUtils.addAll(bodyData, cmd.getBytes());
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] musicDown2_2G(String fileName, int size) {
        String cmd = "AT + FSWRITE = USER\\" + fileName + ",1," + size + ",60\r\n";
        OutputLog outputLog = new OutputLog().setType("S").setData(cmd).setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextPane(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
        byte[] bodyData = new byte[]{6, 0, 97};
        bodyData = ArrayUtils.addAll(bodyData, cmd.getBytes());
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] musicDown3_2G(byte[] data) {
        byte[] bodyData = new byte[]{6, 0, 97};
        bodyData = ArrayUtils.addAll(bodyData, data);
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] musicDown1_07BX(String disk) {
        String cmd = "AT+FSCD=" + disk + ":\r\n";
        OutputLog outputLog = new OutputLog().setType("S").setData(cmd).setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextPane(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
        byte[] bodyData = new byte[]{6, (byte)(cmd.length() + 1), 97};
        bodyData = ArrayUtils.addAll(bodyData, cmd.getBytes());
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] musicDown2_07BX(String fileName, int size, String disk) {
        String cmd = "AT+CFTRANRX=\"" + disk + ":/" + fileName + "\"," + size + "\r\n";
        OutputLog outputLog = new OutputLog().setType("S").setData(cmd).setIsShowTime(Model_Debug.debug_isShowTime.isSelected()).setTextPane(Model_Debug.debug_outputArea);
        OutputLogQueue.getInstance().addDebugLog(outputLog);
        byte[] bodyData = new byte[]{6, 0, 97};
        bodyData = ArrayUtils.addAll(bodyData, cmd.getBytes());
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] musicDown3_07BX(byte[] data) {
        byte[] bodyData = new byte[]{6, (byte)(data.length + 1), 97};
        bodyData = ArrayUtils.addAll(bodyData, data);
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] musicDown1_FS(String fileName) {
        byte[] bodyData = new byte[]{6, 0, 112};
        byte[] flag = new byte[]{3, 5, 0, 0};
        bodyData = ArrayUtils.addAll(bodyData, flag);
        byte[] path = ("music/" + fileName).getBytes(StandardCharsets.UTF_8);
        bodyData = ArrayUtils.addAll(bodyData, path);
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] musicDown2_FS(byte[] data) {
        byte[] bodyData = new byte[]{6, 0, 114};
        bodyData = ArrayUtils.addAll(bodyData, data);
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public byte[] musicDown3_FS() {
        byte[] bodyData = new byte[]{6, 1, 113};
        int sequenceId = HeadService.INSTANCE.getSequenceId(true);
        CmdHead cmd_head = MainPane.protocol.getCommandHead(sequenceId, true);
        return MainPane.protocol.getByteData(cmd_head, bodyData);
    }

    public void musicDown1_EVD() {
        UsbAdbServices.getInstance().cmdexec("evd shell mkdir /sdcard/res", MainPane.getADBKey());
    }

    public void musicDown2_EVD(String filePath) {
        String fileName = ((String)filePath).substring(((String)filePath).lastIndexOf(Constants.fs) + 1);
        String newFilePath = FileUtil.getCurrentPath("./temp/musicFile/") + Constants.fs + fileName;
        FileUtil.copyFile((String)filePath, newFilePath);
        filePath = "\"" + Constants.currentPath + Constants.fs + "temp" + Constants.fs + "musicFile" + Constants.fs + fileName + "\"";
        UsbAdbServices.getInstance().cmdexec("evd push " + (String)filePath + " /sdcard/res", MainPane.getADBKey());
    }

    public void sendData(byte[] byteData) {
        this.callBack.sendData(byteData);
    }

    @Override
    public void run() {
        this.musicFileName = new String[this.musicPath.length];
        this.firmwareData = new byte[this.musicPath.length][];
        for (int i = 0; i < this.musicPath.length; ++i) {
            System.out.println("paths[" + i + "]=" + this.musicPath[i].trim());
            File tempFile = new File(this.musicPath[i].trim());
            try {
                FileInputStream inputStream = new FileInputStream(tempFile);
                this.musicFileName[i] = tempFile.getName();
                byte[] buffer = new byte[800];
                int read = 0;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                while ((read = ((InputStream)inputStream).read(buffer, 0, buffer.length)) != -1) {
                    output.write(buffer, 0, read);
                }
                this.firmwareData[i] = output.toByteArray();
                this.all += this.firmwareData[i].length;
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"Update device error !", (Throwable)e);
                this.callBack.error("Exception:" + this.musicFileName[i]);
            }
        }
        RD_Condition condition = new RD_Condition().setDateType("R");
        ReturnDataUtil.setObservableData("debug_music", condition, (Object)"DownMusicOK");
        this.percent = 2;
    }

    public static interface CallBack {
        public void sendData(byte[] var1);

        public void setProgressbar(int var1);

        public void error(String var1);
    }
}

