/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.resource.ResourceUtil;
import com.eview.adb.UsbAdbServices;
import com.eview.hid.UsbHidServices;
import com.eview.serial.SerialPortsService;
import com.eview.tool.BottomStatusPanel;
import com.eview.tool.ChannelEnum;
import com.eview.tool.MenuItem;
import com.eview.tool.MessageDialog;
import com.eview.tool.WelcomeWindow;
import com.eview.tool.bluetooth.BlueSerialJDialog;
import com.eview.tool.dialog.AesKeyJDialog;
import com.eview.tool.dialog.ConfigFileJDialog;
import com.eview.tool.dialog.FactoryMadeJDialog;
import com.eview.tool.dialog.UpgradeJDialog;
import com.eview.tool.model.CMD_Public;
import com.eview.tool.model.Model;
import com.eview.tool.model.Model_DS02;
import com.eview.tool.model.Model_DS3;
import com.eview.tool.model.Model_Debug;
import com.eview.tool.model.Model_EC01;
import com.eview.tool.model.Model_EC02;
import com.eview.tool.model.Model_EC03;
import com.eview.tool.model.Model_EV04;
import com.eview.tool.model.Model_EV05;
import com.eview.tool.model.Model_EV06;
import com.eview.tool.model.Model_EV07B;
import com.eview.tool.model.Model_EV09;
import com.eview.tool.model.Model_EV10;
import com.eview.tool.model.Model_EV12;
import com.eview.tool.model.Model_EV201;
import com.eview.tool.model.Model_EV201G;
import com.eview.tool.model.Model_EV201M;
import com.eview.tool.model.Model_EV202;
import com.eview.tool.model.Model_EV206M;
import com.eview.tool.model.Model_EVHUB;
import com.eview.tool.model.PanelUtil;
import com.eview.util.Constants;
import com.eview.util.PublicUtil;
import com.eview.util.VersionUtil;
import com.tracker.ev07b.Protocol;
import com.tracker.ev07b.ProtocolAnalysis;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import org.apache.log4j.Logger;

public class MainPane
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MainPane.class);
    private static final String programVersion = "version " + VersionUtil.getVersion();
    private static Model thisModel = null;
    private static Model_Debug debugModel = null;
    private static String thisModelStr = null;
    private static final List<Model> modelList = new ArrayList<Model>();
    private static final List<MenuItem> toolList = new ArrayList<MenuItem>();
    private static final Map<String, JMenuItem> menuItems = new HashMap<String, JMenuItem>();
    private final JMenu menu_file = new JMenu("File");
    private final JMenu menu_model = new JMenu("Model");
    private final JMenu menu_tool = new JMenu("Tool");
    private final JMenu menu_profile = new JMenu("Profile");
    private final JMenu menu_help = new JMenu("Help");
    private final JMenuItem file_Item_config = new JMenuItem("Config Setting");
    private final JMenuItem file_Item_exit = new JMenuItem("Exit");
    private final JMenuItem profile_readItem = new JMenuItem("Read from PC");
    private final JMenuItem profile_saveItem = new JMenuItem("Save to PC");
    private final JMenuItem profile_factoryItem = new JMenuItem("Factory make");
    private final JMenuItem profile_aesKeyItem = new JMenuItem("Aes key setting");
    private final JMenuItem help_Item_about = new JMenuItem("About");
    private static final BottomStatusPanel bottomStatusPanel = new BottomStatusPanel();
    private final JButton refreshListPort = new JButton();
    private static final JToggleButton openPort = new JToggleButton("Open Port");
    public static final JToggleButton openADB = new JToggleButton("Open EVD");
    private final JButton bluetooth = new JButton("Bluetooth");
    private final JButton readAll = new JButton("Read All");
    private final JButton saveAll = new JButton("Save All");
    private final JButton clearAll = new JButton("Clear All");
    private static final JComboBox<ChannelEnum> cList = new JComboBox();
    public static final JComboBox<String> serialPortList = new JComboBox();
    public static final JComboBox<String> adbList = new JComboBox();
    public static final Protocol protocol = ProtocolAnalysis.INSTANCE;
    private static final CardLayout card = new CardLayout(1, 1);
    private static final JPanel modelPane = new JPanel(card);
    public static final ImageIcon reloadIcon = new ImageIcon(ResourceUtil.getResource((String)"images/reload.png"));
    public static final ImageIcon editIcon = new ImageIcon(ResourceUtil.getResource((String)"images/edit.png"));
    public static final ImageIcon toggle_on = new ImageIcon(ResourceUtil.getResource((String)"images/toggle_on.png"));
    public static final ImageIcon toggle_off = new ImageIcon(ResourceUtil.getResource((String)"images/toggle_off.png"));
    public static final ImageIcon toggle_yes = new ImageIcon(ResourceUtil.getResource((String)"images/toggle_yes.png"));
    public static final ImageIcon toggle_no = new ImageIcon(ResourceUtil.getResource((String)"images/toggle_no.png"));
    public static Map<String, ChannelEnum> selectedItemChannel = new HashMap<String, ChannelEnum>();

    public static Model getThisModel() {
        return thisModel;
    }

    public static Model_Debug getDebugModel() {
        return debugModel;
    }

    public static void setNetwork(String name, int band, int strength) {
        bottomStatusPanel.setNetwork(strength, band, name);
    }

    public static boolean isMTK() {
        return ChannelEnum.SERIAL_MTK.equals(cList.getSelectedItem());
    }

    public static JComboBox<ChannelEnum> getCList() {
        return cList;
    }

    public static String getADBKey() {
        return Convert.toStr((Object)adbList.getSelectedItem(), (String)"");
    }

    public static boolean isShowProperty(String modelName, String key, String defaults) {
        return Boolean.parseBoolean(Constants.configFileUtil.readProperty(modelName, key, defaults));
    }

    private void destroy() {
        String programTitle = Constants.configFileUtil.readProperty("MainPane", "ProgramTitle", null);
        Constants.configFileUtil.writeProperty("MainPane", "Frame_Width", "" + Constants.FRAME_WIDTH);
        Constants.configFileUtil.writeProperty("MainPane", "Frame_Height", "" + Constants.FRAME_HEIGHT);
        Constants.configFileUtil.writeProperty("MainPane", "ThisModel", thisModel.getName());
        System.out.println("programTitle=" + programTitle);
        if (programTitle == null) {
            Constants.configFileUtil.setProperty("MainPane", "ProgramTitle", Constants.programTitle);
            Constants.configFileUtil.setProperty("MainPane", "IsResizable", String.valueOf(Constants.isResizable));
            Constants.configFileUtil.setProperty("MainPane", "IsDebug", String.valueOf(Constants.isDebug));
            Constants.configFileUtil.setProperty("MainPane", "IsNetwork", String.valueOf(Constants.isNetwork));
            Constants.configFileUtil.setProperty("MainPane", "AdbPort", String.valueOf(Constants.adbPort));
            Constants.configFileUtil.setProperty("MainPane", "IsTitleLogo", String.valueOf(Constants.isTitleLogo));
            Constants.configFileUtil.setProperty("MainPane", "TitleLogoPath", Constants.titleLogoPath);
            Constants.configFileUtil.setProperty("MainPane", "isPasswordKeyOld", "true");
            Constants.configFileUtil.setProperty("MainPane", "SmsUrlGPS", Constants.url_gps);
            Constants.configFileUtil.setProperty("MainPane", "SmsUrlWIFI", Constants.url_wifi);
            Constants.configFileUtil.setProperty("MainPane", "isEvdUpgradeVersionCheck", "true");
            for (MenuItem tool_Item : toolList) {
                Constants.configFileUtil.setProperty("Tool", tool_Item.getKey() + "_name", tool_Item.getName());
                Constants.configFileUtil.setProperty("Tool", tool_Item.getKey() + "_isShow", String.valueOf(tool_Item.isShow()));
            }
            for (Model model : modelList) {
                Constants.configFileUtil.setProperty(model.getKey(), "name", model.getName());
                Constants.configFileUtil.setProperty(model.getKey(), "isShow", String.valueOf(model.isShow()));
                model.setConfigFile();
            }
            UsbHidServices.getInstance().setConfigFile();
            Constants.configFileUtil.writeProperty();
        }
    }

    public MainPane(WelcomeWindow welcome) {
        welcome.close();
        this.init(() -> {
            JMenuBar menuBar = this.createMenuBar();
            this.setJMenuBar(menuBar);
            Box mainBox = Box.createVerticalBox();
            JPanel toolBar = this.createToolBar();
            Box statusBar = this.createBottomStatusBar();
            this.initModelPane();
            mainBox.add(toolBar);
            mainBox.add(modelPane);
            mainBox.add(statusBar);
            this.add((Component)mainBox, "Center");
        });
        Constants.threadPool.execute(() -> {
            UsbHidServices.getInstance();
            MainPane.refreshPortList(ChannelEnum.SERIAL);
            MainPane.refreshPortList(ChannelEnum.EVD);
        });
    }

    private void init(Runnable runnable) {
        this.setTitle(Constants.programTitle);
        if (Constants.isTitleLogo) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(Constants.titleLogoPath));
        }
        this.setDefaultCloseOperation(3);
        if (!Constants.isResizable) {
            this.setResizable(false);
        }
        this.setMinimumSize(new Dimension(960, 720));
        this.setPreferredSize(new Dimension(Constants.FRAME_WIDTH, Constants.FRAME_HEIGHT));
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                log.info((Object)"Close Software !");
                SerialPortsService.getInstance().closeSerialPort();
                log.info((Object)("EVD Service Status:" + UsbAdbServices.adbServiceStatus));
                if (UsbAdbServices.adbServiceStatus) {
                    UsbAdbServices.getInstance().killEvd();
                }
                MainPane.this.destroy();
                MainPane.this.dispose();
                System.exit(0);
            }
        });
        int x = this.getX() - (Constants.FRAME_WIDTH - 960) / 2;
        int y = this.getY() - (Constants.FRAME_HEIGHT - 720) / 2;
        this.setLocation(x, y);
        Constants.MAIN_FRAME_LOC_X = this.getX();
        Constants.MAIN_FRAME_LOC_Y = this.getY();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component comp = e.getComponent();
                Constants.FRAME_WIDTH = comp.getWidth();
                Constants.FRAME_HEIGHT = comp.getHeight();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Component comp = e.getComponent();
                Constants.MAIN_FRAME_LOC_X = comp.getX();
                Constants.MAIN_FRAME_LOC_Y = comp.getY();
            }
        });
        if (runnable != null) {
            runnable.run();
        }
        this.validate();
        this.setVisible(true);
        this.pack();
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setVisible(true);
        this.menu_file.setPreferredSize(new Dimension(45, 20));
        this.menu_model.setPreferredSize(new Dimension(60, 20));
        this.menu_tool.setPreferredSize(new Dimension(50, 20));
        this.menu_profile.setPreferredSize(new Dimension(65, 20));
        this.menu_help.setPreferredSize(new Dimension(50, 20));
        this.menu_file.setFont(new Font("Dialog", 1, 15));
        this.menu_model.setFont(new Font("Dialog", 1, 15));
        this.menu_tool.setFont(new Font("Dialog", 1, 15));
        this.menu_profile.setFont(new Font("Dialog", 1, 15));
        this.menu_help.setFont(new Font("Dialog", 1, 15));
        this.menu_file.add(this.file_Item_config);
        this.menu_file.addSeparator();
        this.file_Item_exit.setMnemonic(81);
        this.file_Item_exit.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        this.menu_file.add(this.file_Item_exit);
        int index = 0;
        for (Model model : modelList) {
            if (!model.isShow()) continue;
            this.menu_model.add(menuItems.get("model_Item_" + model.getKey()));
            menuItems.get("model_Item_" + model.getKey()).addActionListener(this);
            if (index < 12) {
                menuItems.get("model_Item_" + model.getKey()).setAccelerator(KeyStroke.getKeyStroke(112 + index, 128));
            } else {
                menuItems.get("model_Item_" + model.getKey()).setAccelerator(KeyStroke.getKeyStroke(49 + index - 12, 128));
            }
            ++index;
        }
        for (MenuItem item : toolList) {
            if (!item.isShow()) continue;
            this.menu_tool.add(item);
            item.addActionListener(this);
        }
        this.menu_profile.add(this.profile_readItem);
        this.menu_profile.add(this.profile_saveItem);
        this.menu_profile.add(this.profile_factoryItem);
        this.menu_profile.add(this.profile_aesKeyItem);
        this.menu_help.add(this.help_Item_about);
        menuBar.add(this.menu_file);
        menuBar.add(this.menu_model);
        menuBar.add(this.menu_tool);
        menuBar.add(this.menu_profile);
        menuBar.add(this.menu_help);
        this.file_Item_config.addActionListener(this);
        this.file_Item_exit.addActionListener(this);
        this.profile_readItem.addActionListener(this);
        this.profile_saveItem.addActionListener(this);
        this.profile_factoryItem.addActionListener(this);
        this.profile_aesKeyItem.addActionListener(this);
        this.help_Item_about.addActionListener(this);
        return menuBar;
    }

    private JPanel createToolBar() {
        JPanel panel = PanelUtil.createPanel(960, 50);
        panel.setBackground(Constants.background);
        BoxLayout layout = new BoxLayout(panel, 0);
        panel.setLayout(layout);
        Box hBox = Box.createHorizontalBox();
        panel.add((Component)hBox, "Center");
        hBox.add(Box.createHorizontalStrut(5));
        cList.setPreferredSize(new Dimension(170, 33));
        cList.setMaximumSize(new Dimension(170, 33));
        hBox.add(cList);
        hBox.add(Box.createHorizontalStrut(10));
        openPort.setUI((ButtonUI)Constants.btnUI);
        openPort.setPreferredSize(new Dimension(105, 33));
        openPort.setMaximumSize(new Dimension(105, 33));
        hBox.add(openPort);
        openADB.setUI((ButtonUI)Constants.btnUI);
        openADB.setPreferredSize(new Dimension(105, 33));
        openADB.setMaximumSize(new Dimension(105, 33));
        hBox.add(openADB);
        this.refreshListPort.setBounds(new Rectangle(300, 6, 30, 33));
        this.refreshListPort.setIcon(reloadIcon);
        this.refreshListPort.setContentAreaFilled(false);
        this.refreshListPort.setHideActionText(true);
        this.refreshListPort.setBorderPainted(false);
        this.refreshListPort.setFocusable(false);
        hBox.add(this.refreshListPort);
        serialPortList.setPreferredSize(new Dimension(120, 33));
        serialPortList.setMaximumSize(new Dimension(120, 33));
        hBox.add(serialPortList);
        adbList.setPreferredSize(new Dimension(190, 33));
        adbList.setMaximumSize(new Dimension(190, 33));
        hBox.add(adbList);
        hBox.add(Box.createHorizontalGlue());
        this.bluetooth.setMaximumSize(new Dimension(90, 33));
        hBox.add(this.bluetooth);
        hBox.add(Box.createHorizontalStrut(15));
        this.readAll.setMaximumSize(new Dimension(95, 33));
        hBox.add(this.readAll);
        hBox.add(Box.createHorizontalStrut(15));
        this.saveAll.setMaximumSize(new Dimension(95, 33));
        this.saveAll.setEnabled(false);
        hBox.add(this.saveAll);
        hBox.add(Box.createHorizontalStrut(15));
        this.clearAll.setMaximumSize(new Dimension(95, 33));
        hBox.add(this.clearAll);
        hBox.add(Box.createHorizontalStrut(15));
        cList.addActionListener(this);
        this.refreshListPort.addActionListener(this);
        openPort.addActionListener(this);
        openADB.addActionListener(this);
        this.bluetooth.addActionListener(this);
        this.readAll.addActionListener(this);
        this.saveAll.addActionListener(this);
        this.clearAll.addActionListener(this);
        return panel;
    }

    private Box createBottomStatusBar() {
        Box hBox = Box.createHorizontalBox();
        hBox.setPreferredSize(new Dimension(960, 35));
        hBox.add(bottomStatusPanel);
        return hBox;
    }

    private void initModelPane() {
        for (Model model : modelList) {
            modelPane.add(model.getKey(), model);
            if (thisModelStr != null && model.getName().equals(thisModelStr)) {
                this.showModel(model);
                continue;
            }
            if (!model.getName().equals(this.menu_model.getItem(0).getText())) continue;
            this.showModel(model);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.file_Item_config)) {
            SwingUtilities.invokeLater(() -> ConfigFileJDialog.getInstance().setVisible(true));
        }
        if (e.getSource().equals(this.file_Item_exit)) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
        for (Model model : modelList) {
            if (e.getSource() != menuItems.get("model_Item_" + model.getKey())) continue;
            this.showModel(model);
        }
        for (MenuItem tool : toolList) {
            int isSimCardUnLuck;
            int isRefactory;
            int isReboot;
            String title;
            int isShutdown;
            if (e.getSource() != menuItems.get("tool_Item_" + tool.getKey())) continue;
            if (tool.getKey().equals("upgrade")) {
                UpgradeJDialog.isSystemUpdate.setVisible(ChannelEnum.EVD.equals(cList.getSelectedItem()));
                UpgradeJDialog.getInstance().setVisible(true);
            }
            if (tool.getKey().equals("shutdown") && (isShutdown = MessageDialog.show(title = "Shutdown", "The device will shut down,continue?", 2)) == 0) {
                MainPane.sendData(CMD_Public.shutdown());
            }
            if (tool.getKey().equals("reboot") && (isReboot = MessageDialog.show(title = "Reboot", "The device will reboot,continue?", 2)) == 0) {
                MainPane.sendData(CMD_Public.reboot());
            }
            if (tool.getKey().equals("refactory") && (isRefactory = MessageDialog.show(title = "Re-factory", "The device will re-factory settings,continue?", 2)) == 0) {
                MainPane.sendData(CMD_Public.reFactory());
            }
            if (!tool.getKey().equals("simCardUnLock") || (isSimCardUnLuck = MessageDialog.show(title = "Sim card unlock", "The device will sim card unlock,continue?", 2)) != 0) continue;
            MainPane.sendData(CMD_Public.isSimCardUnLock());
        }
        if (e.getSource() == this.profile_readItem) {
            thisModel.readProfile();
        }
        if (e.getSource() == this.profile_saveItem) {
            thisModel.writeProfile();
        }
        if (e.getSource().equals(this.profile_factoryItem)) {
            SwingUtilities.invokeLater(() -> FactoryMadeJDialog.getInstance().setVisible(true));
        }
        if (e.getSource().equals(this.profile_aesKeyItem)) {
            SwingUtilities.invokeLater(() -> AesKeyJDialog.getInstance().setVisible(true));
        }
        if (e.getSource() == this.help_Item_about) {
            String title = "About";
            String message = Constants.programTitle + " -- " + programVersion;
            message = message + "                   \n\r\n\r\n\r";
            MessageDialog.show(title, message, 0);
        }
        if (e.getSource() == cList && cList.getItemCount() > 0) {
            if (ChannelEnum.SERIAL_BLUETOOTH.equals(cList.getSelectedItem())) {
                serialPortList.setVisible(true);
                this.refreshListPort.setVisible(true);
                openPort.setVisible(true);
                openADB.setVisible(false);
                adbList.setVisible(false);
                this.bluetooth.setVisible(true);
            } else if (ChannelEnum.HID.equals(cList.getSelectedItem())) {
                serialPortList.setVisible(false);
                this.refreshListPort.setVisible(false);
                openPort.setVisible(false);
                openADB.setVisible(false);
                adbList.setVisible(false);
                this.bluetooth.setVisible(false);
            } else if (ChannelEnum.SERIAL.equals(cList.getSelectedItem()) || ChannelEnum.SERIAL_MTK.equals(cList.getSelectedItem())) {
                serialPortList.setVisible(true);
                this.refreshListPort.setVisible(true);
                openPort.setVisible(true);
                openADB.setVisible(false);
                adbList.setVisible(false);
                this.bluetooth.setVisible(false);
            } else if (ChannelEnum.EVD.equals(cList.getSelectedItem())) {
                serialPortList.setVisible(false);
                this.refreshListPort.setVisible(true);
                openPort.setVisible(false);
                openADB.setVisible(true);
                adbList.setVisible(true);
                this.bluetooth.setVisible(false);
            }
        }
        if (e.getSource() == this.refreshListPort) {
            SwingUtilities.invokeLater(() -> MainPane.refreshPortList());
        }
        if (e.getSource() == openPort) {
            if (openPort.isSelected()) {
                int baudRate = 115200;
                if (ChannelEnum.SERIAL.equals(cList.getSelectedItem()) || ChannelEnum.SERIAL_MTK.equals(cList.getSelectedItem())) {
                    baudRate = 230400;
                }
                boolean isOpened = SerialPortsService.getInstance().openSerialPort(baudRate);
                openPort.setSelected(isOpened);
                if (isOpened) {
                    openPort.setText("Close Port");
                }
            } else {
                openPort.setText("Open Port");
                SerialPortsService.getInstance().closeSerialPort();
            }
        }
        if (e.getSource() == openADB) {
            if (openADB.isSelected()) {
                boolean isOpened = UsbAdbServices.getInstance().openEvd();
                openADB.setSelected(isOpened);
                if (isOpened) {
                    openADB.setText("Close EVD");
                } else {
                    MessageDialog.show("Usb evd is not connected, please check!", 3);
                }
            } else {
                openADB.setText("Open EVD");
                UsbAdbServices.getInstance().closeEvd();
            }
        }
        if (e.getSource() == this.bluetooth) {
            SwingUtilities.invokeLater(() -> BlueSerialJDialog.getInstance().setVisible(true));
            BlueSerialJDialog.getInstance().initBlueJDialog();
        }
        if (e.getSource() == this.readAll) {
            Constants.threadPool.execute(() -> {
                if (!thisModel.getKey().equals("Debug")) {
                    thisModel.clearAll();
                }
                PublicUtil.readConfig(null);
                MainPane.delay(100L);
                PublicUtil.readConfig(new byte[]{22, 74, 98, 115});
                this.saveAll.setEnabled(true);
            });
        }
        if (e.getSource() == this.saveAll) {
            thisModel.saveAll();
        }
        if (e.getSource() == this.clearAll) {
            thisModel.clearAll();
            this.saveAll.setEnabled(false);
        }
    }

    public static void refreshPortList() {
        if (ChannelEnum.SERIAL_BLUETOOTH.equals(cList.getSelectedItem()) || ChannelEnum.SERIAL.equals(cList.getSelectedItem()) || ChannelEnum.SERIAL_MTK.equals(cList.getSelectedItem())) {
            MainPane.refreshPortList(ChannelEnum.SERIAL);
        } else if (ChannelEnum.EVD.equals(cList.getSelectedItem())) {
            MainPane.refreshPortList(ChannelEnum.EVD);
        }
    }

    public static void refreshPortList(ChannelEnum type) {
        block3: {
            block2: {
                if (!type.equals((Object)ChannelEnum.SERIAL)) break block2;
                serialPortList.removeAllItems();
                Vector<String> serialList = SerialPortsService.getInstance().getSerialPortNameList();
                for (String com : serialList) {
                    serialPortList.addItem(com);
                }
                break block3;
            }
            if (!type.equals((Object)ChannelEnum.EVD)) break block3;
            adbList.removeAllItems();
            List<String> adbkeyList = UsbAdbServices.getInstance().getADBList();
            for (String adbkey : adbkeyList) {
                adbList.addItem(adbkey);
            }
        }
    }

    public void showModel(Model model) {
        if (thisModel != null) {
            selectedItemChannel.put(thisModel.getKey(), (ChannelEnum)((Object)cList.getSelectedItem()));
        }
        card.show(modelPane, model.getKey());
        model.initChannelList(cList);
        if (selectedItemChannel.get(model.getKey()) != null) {
            cList.setSelectedItem((Object)selectedItemChannel.get(model.getKey()));
        }
        thisModel = model;
        BottomStatusPanel.setModelInfo(model.getName());
    }

    public static void sendData(byte[] data) {
        Constants.threadPool.execute(() -> {
            if (ChannelEnum.SERIAL_BLUETOOTH.equals(cList.getSelectedItem()) || ChannelEnum.SERIAL.equals(cList.getSelectedItem()) || ChannelEnum.SERIAL_MTK.equals(cList.getSelectedItem())) {
                if (openPort.isSelected()) {
                    SerialPortsService.getInstance().writePort(data);
                }
            } else if (ChannelEnum.HID.equals(cList.getSelectedItem())) {
                UsbHidServices.getInstance().sendMessage(data);
            } else if (ChannelEnum.EVD.equals(cList.getSelectedItem()) && openADB.isSelected()) {
                UsbAdbServices.getInstance().sendMessage(data);
            }
        });
    }

    public static Map<String, Object> receiveData(int sequenceId, long timeOut) {
        if (ChannelEnum.SERIAL_BLUETOOTH.equals(cList.getSelectedItem()) || ChannelEnum.SERIAL.equals(cList.getSelectedItem()) || ChannelEnum.SERIAL_MTK.equals(cList.getSelectedItem())) {
            if (openPort.isSelected()) {
                return SerialPortsService.getInstance().readPortData(sequenceId, timeOut);
            }
        } else {
            if (ChannelEnum.HID.equals(cList.getSelectedItem())) {
                return UsbHidServices.getInstance().receiveMessage(sequenceId, timeOut);
            }
            if (ChannelEnum.EVD.equals(cList.getSelectedItem())) {
                return UsbAdbServices.getInstance().receiveMessage(sequenceId, timeOut);
            }
        }
        return null;
    }

    public static void delay(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        thisModelStr = Constants.configFileUtil.readProperty("MainPane", "ThisModel", null);
        debugModel = new Model_Debug("Debug", "Debug", true);
        modelList.add(new Model_EV07B("EV07B", "EV-07B", true));
        modelList.add(new Model_EV04("EV04", "EV-04", true));
        modelList.add(new Model_EV05("EV05", "EV-05", true));
        modelList.add(new Model_EV06("EV06", "EV-06", true));
        modelList.add(new Model_EV09("EV09", "EV-09", true));
        modelList.add(new Model_EV10("EV10", "EV-10", true));
        modelList.add(new Model_EV12("EV12", "EV-12", true));
        modelList.add(new Model_EV201("EV201", "EV-201", true));
        modelList.add(new Model_EV201G("EV201G", "EV-201G", true));
        modelList.add(new Model_EV202("EV202", "EV-202", true));
        modelList.add(new Model_EV201M("EV201M", "EV-201M", true));
        modelList.add(new Model_EV206M("EV206M", "EV-206M", true));
        modelList.add(new Model_EC01("EC01", "EC-01", true));
        modelList.add(new Model_EC02("EC02", "EC-02", true));
        modelList.add(new Model_EC03("EC03", "EC-03", true));
        modelList.add(new Model_DS02("DS02", "DS02", true));
        modelList.add(new Model_DS3("DS3", "DS3", true));
        modelList.add(new Model_EVHUB("EVHub", "EV-Hub", true));
        modelList.add(debugModel);
        for (Model model : modelList) {
            String modelName = Constants.configFileUtil.readProperty(model.getKey(), "name", model.getName());
            String modelShow = Constants.configFileUtil.readProperty(model.getKey(), "isShow", "" + model.isShow());
            model.setName(modelName);
            model.setShow(Boolean.parseBoolean(modelShow));
            menuItems.put("model_Item_" + model.getKey(), new JMenuItem(model.getName()));
        }
        toolList.add(new MenuItem("upgrade", Constants.tool_upgrade, true));
        toolList.add(new MenuItem("shutdown", Constants.tool_shutdown, true));
        toolList.add(new MenuItem("reboot", Constants.tool_reboot, true));
        toolList.add(new MenuItem("refactory", Constants.tool_refactory, true));
        toolList.add(new MenuItem("simCardUnLock", Constants.tool_simCardUnLock, false));
        for (MenuItem tool_Item : toolList) {
            String toolName = Constants.configFileUtil.readProperty("Tool", tool_Item.getKey() + "_name", tool_Item.getName());
            String toolShow = Constants.configFileUtil.readProperty("Tool", tool_Item.getKey() + "_isShow", "" + tool_Item.isShow());
            tool_Item.setName(toolName);
            tool_Item.setShow(Boolean.parseBoolean(toolShow));
            menuItems.put("tool_Item_" + tool_Item.getKey(), tool_Item);
        }
    }
}

