/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool;

import java.util.function.Consumer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CheckDocument
implements DocumentListener {
    private final Consumer<String> consumer;
    public static String regex_mac = "^([0-9a-fA-F]{2})(([/\\\\s:-][0-9a-fA-F]{2}){5})$";
    public static String regex_lat = "^-?((0|[1-8]?[0-9]?)(([.][0-9]{1,10})?)|90(([.][0]{1,10})?))$";
    public static String regex_lng = "^-?((0|[1-9]?[0-9]?|1?[0-7]?[0-9]?)(([.][0-9]{1,10})?)|180(([.][0]{1,10})?))$";
    public static String regex_time_hm = "^(0\\d{1}|1\\d{1}|2[0-3]):([0-5]\\d{1})$";
    public static String regex_phone = "^(\\+|\\-|\\*|\\#|\\,|\\;|\\d){3,20}$";
    public static String regex_date = "^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$";
    public static String regex_int = "^([0-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5])$";
    public static String regex_time = "^([6-9][0-9]|[0-9][0-9][0-9]|1[0-7][0-9][0-9]|1800)$";
    public static String regex_time2 = "^([1-9][0-9]|[1-9][0-9][0-9]|[1-2][0-9][0-9][0-9]|3[0-5][0-9][0-9]|3600)$";
    public static String regex_time3 = "^[6-9][0-9]|[1-9]\\d{2}|[1-9]\\d{3}||[1-2]\\d{4}|3[1-5]\\d{3}|36000$";
    public static String regex_time4 = "^([6-9][0-9]|[1-9]\\d{2}|[1-9]\\d{3}|[1-7]\\d{4}|8[0-5]\\d{3}|86[0-3]\\d{2}|86400)$";
    public static String regex_time5 = "^([6-9]\\d{2}|[1-9]\\d{3,4}|[1-5]\\d{5}|60[0-3]\\d{3}|604[0-7]\\d{2}|604800)$";
    public static String regex_hex_max_6 = "^[0-9a-fA-F]{1,6}$";
    public static String regex_hex_32 = "^[0-9a-fA-F]{32}$";

    public CheckDocument(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    protected void changeFilter(DocumentEvent event) {
        Document document = event.getDocument();
        try {
            String text = document.getText(0, document.getLength());
            if (this.consumer != null) {
                this.consumer.accept(text);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changeFilter(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changeFilter(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changeFilter(e);
    }
}

