/*
 * Decompiled with CFR 0.152.
 */
package com.eview.tool;

import com.eview.tool.StatusPanelBattery;
import com.eview.util.Constants;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BottomStatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final JLabel labModelInfo = new JLabel("");
    private static final StatusPanelBattery batteryPanel = new StatusPanelBattery();
    private static final JLabel labSignal = new JLabel("Signal:");
    private static final JLabel labBand = new JLabel("Band:");
    private static final JLabel labName = new JLabel("Network:");
    private static final JLabel labHidInfo = new JLabel("HID Status: ");

    public BottomStatusPanel() {
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        this.setBorder(BorderFactory.createLineBorder(Constants.background));
        this.setBackground(Constants.background);
        this.add(Box.createHorizontalStrut(5));
        labModelInfo.setPreferredSize(new Dimension(240, 35));
        this.add(labModelInfo);
        this.add(Box.createHorizontalStrut(10));
        labSignal.setPreferredSize(new Dimension(80, 35));
        labSignal.setVisible(false);
        this.add(labSignal);
        this.add(Box.createHorizontalStrut(5));
        labBand.setPreferredSize(new Dimension(100, 35));
        labBand.setVisible(false);
        this.add(labBand);
        this.add(Box.createHorizontalStrut(5));
        labName.setPreferredSize(new Dimension(160, 35));
        labName.setVisible(false);
        this.add(labName);
        this.add(Box.createHorizontalStrut(10));
        this.add(Box.createHorizontalGlue());
        batteryPanel.setPreferredSize(new Dimension(250, 35));
        this.add(batteryPanel);
        this.add(Box.createHorizontalStrut(10));
        labHidInfo.setPreferredSize(new Dimension(180, 35));
        this.add(labHidInfo);
    }

    public static void setModelInfo(String info) {
        SwingUtilities.invokeLater(() -> labModelInfo.setText("Current Model: " + info));
    }

    public static void setHidStatusInfo(String info) {
        SwingUtilities.invokeLater(() -> labHidInfo.setText("HID Status: " + info));
    }

    public void setNetwork(int signal, int band, String name) {
        if (Constants.isNetwork) {
            labSignal.setVisible(true);
            labBand.setVisible(true);
            labName.setVisible(true);
        }
        labSignal.setText("Signal:" + signal);
        labBand.setText("Band:" + band);
        labName.setText("Network:" + name);
        this.repaint();
    }

    public static void clearNetwork() {
        labSignal.setVisible(false);
        labBand.setVisible(false);
        labName.setVisible(false);
    }

    public static void setBattery(int percent) {
        batteryPanel.setBattery(percent);
    }
}

