/*
 * Decompiled with CFR 0.152.
 */
package com.eview.serial;

import com.alibaba.fastjson.JSON;
import com.eview.tool.ChannelEnum;
import com.eview.tool.MainPane;
import com.eview.tool.MessageDialog;
import com.eview.tool.event.CmdReceiveListener;
import com.eview.tool.event.Condition;
import com.eview.tool.event.EventBusFactory;
import com.eview.tool.model.CMD_Public;
import com.eview.tool.model.Model_Debug;
import com.eview.tool.queue.OutputLog;
import com.eview.tool.queue.OutputLogQueue;
import com.eview.util.Constants;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.LockRingBuffer;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SerialPortsService
implements SerialPortEventListener {
    private static final Logger log = Logger.getLogger(SerialPortsService.class);
    private final String PORT_OWER = "MySerialPorts";
    private boolean isOpenPort = false;
    private CommPortIdentifier portId;
    private SerialPort serialPort;
    private int baudRate = 115200;
    protected volatile InputStream inputStream;
    protected volatile OutputStream outputStream;
    private boolean receiving = false;
    private boolean sentting = false;
    private String receiveData_mtk = "";
    public static final String DATA_KEY = "data_com";
    private final LockRingBuffer ringBuffer = new LockRingBuffer();
    private CmdReceiveListener cmdReceiveListener;
    private static final SerialPortsService instance = new SerialPortsService();

    public static SerialPortsService getInstance() {
        return instance;
    }

    private SerialPortsService() {
    }

    public boolean getIsOpenPort() {
        return this.isOpenPort;
    }

    public Vector<String> getSerialPortNameList() {
        Vector<String> portNameList = new Vector<String>();
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier port = (CommPortIdentifier)portList.nextElement();
            if (port.getPortType() != 1) continue;
            portNameList.add(port.getName());
        }
        if (portNameList.size() == 0) {
            portNameList.add("No COM");
        }
        System.out.println("portList=" + JSON.toJSONString(portNameList));
        return portNameList;
    }

    public synchronized boolean openSerialPort(int baudRate) {
        this.baudRate = baudRate;
        String serialPortName = MainPane.serialPortList.getSelectedItem().toString();
        log.debug((Object)("Open SerialPort -- serialPort:" + serialPortName));
        boolean ok = false;
        try {
            this.portId = CommPortIdentifier.getPortIdentifier((String)serialPortName);
            this.serialPort = (SerialPort)this.portId.open("MySerialPorts", 2000);
            try {
                this.serialPort.setInputBufferSize(1024);
                this.serialPort.enableReceiveTimeout(2000);
                this.serialPort.setOutputBufferSize(8);
                this.inputStream = this.serialPort.getInputStream();
                this.outputStream = this.serialPort.getOutputStream();
            }
            catch (IOException e) {
                log.error((Object)"inputStream or outputStream err ", (Throwable)e);
                return ok;
            }
            catch (UnsupportedCommOperationException e) {
                e.printStackTrace();
                return ok;
            }
        }
        catch (NoSuchPortException ex) {
            MessageDialog.show(serialPortName, "Sorry, we did not find " + serialPortName + " serial port number!", 3);
            return ok;
        }
        catch (PortInUseException ex) {
            MessageDialog.show(serialPortName, "Serial port is occupied, please check!", 3);
            return ok;
        }
        try {
            this.serialPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"SerialPort addEventListener err", (Throwable)e);
            return ok;
        }
        try {
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.setSerialPortParams(baudRate, 8, 1, 0);
            if (ChannelEnum.SERIAL_BLUETOOTH.equals(MainPane.getCList().getSelectedItem())) {
                this.serialPort.setFlowControlMode(2);
            } else {
                this.serialPort.setFlowControlMode(0);
            }
        }
        catch (UnsupportedCommOperationException e) {
            log.error((Object)"Set port params err ", (Throwable)e);
            return ok;
        }
        this.receiving = true;
        this.sentting = true;
        this.isOpenPort = true;
        MainPane.serialPortList.setEnabled(false);
        ok = true;
        this.subscription();
        return ok;
    }

    private void dataProcess_mtk(String data) {
        String regex = "\\+EVTKRSP:{1}[A-Fa-f0-9]+\r\n";
        this.receiveData_mtk = this.receiveData_mtk + data;
        if (this.receiveData_mtk.endsWith("\r\n")) {
            Matcher ma = Pattern.compile(regex).matcher(this.receiveData_mtk);
            Object receiveData_str = null;
            while (ma.find()) {
                receiveData_str = receiveData_str + ma.group(0);
                receiveData_str = ((String)receiveData_str).replaceAll("\\+EVTKRSP:", "").replaceAll("\r\n", "").replaceAll("null", "");
            }
            if (receiveData_str != null) {
                byte[] receiveData = BytesHexStrUtil.hexStringToBytes(receiveData_str);
                this.ringBuffer.add(receiveData);
                CMD_Public.addRingBuffer(this.ringBuffer, DATA_KEY);
            }
            this.receiveData_mtk = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reciveSerialPortsData() {
        block12: {
            try {
                byte[] buf = null;
                int bufLength = this.inputStream.available();
                if (this.receiving) {
                    if (bufLength <= -1) break block12;
                    buf = new byte[bufLength];
                    try {
                        this.inputStream.read(buf);
                    }
                    catch (IOException e) {
                        log.error((Object)"Start read port err ", (Throwable)e);
                        this.notifyAll();
                        return;
                    }
                    if (new String(buf).trim() != " ") {
                        if (MainPane.isMTK()) {
                            this.dataProcess_mtk(new String(buf));
                        } else {
                            this.ringBuffer.add(buf);
                            CMD_Public.addRingBuffer(this.ringBuffer, DATA_KEY);
                        }
                    }
                    break block12;
                }
                this.inputStream.skip(bufLength);
            }
            catch (Exception ex) {
                log.error((Object)"recive Serial Ports Data error!", (Throwable)ex);
                SwingUtilities.invokeLater(() -> {
                    this.closeSerialPort();
                    MessageDialog.show(MainPane.serialPortList.getSelectedItem().toString(), "Serial Ports error,Reboot the serial port!", 4);
                });
            }
            finally {
                this.notifyAll();
            }
        }
    }

    private synchronized boolean write(byte[] bt) {
        boolean ok = false;
        if (!this.isOpenPort) {
            MessageDialog.show("Serial port is not open, open the serial port.", 3);
            return ok;
        }
        if (this.sentting && bt != null) {
            try {
                this.outputStream.write(bt, 0, bt.length);
                this.outputStream.flush();
            }
            catch (NullPointerException e) {
                log.error((Object)"\u627e\u4e0d\u5230\u4e32\u53e3\u3002");
            }
            catch (IOException e) {
                log.error((Object)"\u53d1\u9001\u4fe1\u606f\u5230\u4e32\u53e3\u65f6\u53d1\u751fIO\u5f02\u5e38");
            }
        }
        ok = true;
        this.notifyAll();
        return ok;
    }

    public boolean writePort(byte[] data) {
        if (Constants.isDebug) {
            OutputLog outputLog = new OutputLog().setType("S").setData(BytesHexStrUtil.bytesToHexString(data)).setIsLine(true).setIsShowTime(Model_Debug.log_isShowTime.isSelected()).setTextPane(Model_Debug.log_outputArea);
            OutputLogQueue.getInstance().addDebugLog(outputLog);
            if (MainPane.isMTK()) {
                log.debug((Object)("[S]length:" + data.length + " " + (MainPane.isMTK() ? "mtk:" : "") + BytesHexStrUtil.bytesToHexString(data)));
            } else {
                log.debug((Object)("[S]length:" + data.length + " SerialPort:" + BytesHexStrUtil.bytesToHexString(data)));
            }
        }
        if (MainPane.isMTK()) {
            boolean ok = false;
            while (data != null && data.length > 0) {
                if (data.length > 500) {
                    byte[] atData = Arrays.copyOfRange(data, 0, 500);
                    String dataStr = "AT+EVTKCMD=" + BytesHexStrUtil.bytesToHexString(atData).replaceAll(" ", "") + "\r\n";
                    ok = this.write(dataStr.getBytes());
                    MainPane.delay(50L);
                    data = Arrays.copyOfRange(data, 500, data.length);
                    continue;
                }
                String dataStr = "AT+EVTKCMD=" + BytesHexStrUtil.bytesToHexString(data).replaceAll(" ", "") + "\r\n";
                ok = this.write(dataStr.getBytes());
                data = null;
            }
            return ok;
        }
        return this.write(data);
    }

    public synchronized boolean closeSerialPort() {
        boolean ok = false;
        if (this.isOpenPort) {
            log.debug((Object)(MainPane.serialPortList.getSelectedItem().toString() + " Serial Closed..."));
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            catch (IOException e1) {
                log.error((Object)("Close IO err " + e1.getMessage()));
            }
            if (this.serialPort != null) {
                this.serialPort.notifyOnDataAvailable(false);
                this.serialPort.removeEventListener();
                this.serialPort.close();
                this.serialPort = null;
            }
            this.isOpenPort = false;
            MainPane.serialPortList.setEnabled(true);
            ok = true;
            this.unSubscription();
        }
        return ok;
    }

    public Map<String, Object> readPortData(int sequenceId, long timeOut) {
        Condition condition = new Condition().setSequenceId(sequenceId).setDateType("R");
        return this.cmdReceiveListener.getData(condition, timeOut);
    }

    private void subscription() {
        this.cmdReceiveListener = new CmdReceiveListener(DATA_KEY);
        EventBusFactory.getInstance().register((Object)this.cmdReceiveListener);
    }

    private void unSubscription() {
        EventBusFactory.getInstance().unregister((Object)this.cmdReceiveListener);
    }

    public synchronized void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                this.reciveSerialPortsData();
                break;
            }
        }
    }
}

