/*
 * Decompiled with CFR 0.152.
 */
package com.eview.hid;

import com.eview.tool.BottomStatusPanel;
import com.eview.tool.MainPane;
import com.eview.tool.MessageDialog;
import com.eview.tool.event.CmdReceiveListener;
import com.eview.tool.event.Condition;
import com.eview.tool.event.EventBusFactory;
import com.eview.tool.model.CMD_Public;
import com.eview.tool.model.Model_Debug;
import com.eview.tool.queue.OutputLog;
import com.eview.tool.queue.OutputLogQueue;
import com.eview.util.Constants;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.CheckCRC;
import com.tracker.util.LockRingBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.ScanMode;
import org.hid4java.event.HidServicesEvent;

public class UsbHidServices
implements HidServicesListener {
    private static final Logger log = Logger.getLogger(UsbHidServices.class);
    private static final Integer VENDOR_ID = 6421;
    private static final Integer PRODUCT_ID = 21004;
    private static final int PACKET_LENGTH = 64;
    private static final String SERIAL_NUMBER = null;
    public static final String DATA_KEY = "data_hid";
    private final Map<HidDevice, LockRingBuffer> ringBuffers = new HashMap<HidDevice, LockRingBuffer>();
    private final Map<HidDevice, CmdReceiveListener> receiveListeners = new HashMap<HidDevice, CmdReceiveListener>();
    private static final UsbHidServices instance = new UsbHidServices();
    private static final String ScanInterval = "100";
    private static final String PauseInterval = "100";
    private static final String DataReadInterval = "20";

    public static UsbHidServices getInstance() {
        return instance;
    }

    private UsbHidServices() {
        int scanInterval = Integer.parseInt(Constants.configFileUtil.readProperty("HidService", "ScanInterval", "100"));
        int pauseInterval = Integer.parseInt(Constants.configFileUtil.readProperty("HidService", "PauseInterval", "100"));
        int dataReadInterval = Integer.parseInt(Constants.configFileUtil.readProperty("HidService", "DataReadInterval", DataReadInterval));
        log.debug((Object)String.format("scanInterval=%s pauseInterval=%s dataReadInterval=%s", scanInterval, pauseInterval, dataReadInterval));
        HidServicesSpecification hidServicesSpecification = new HidServicesSpecification();
        hidServicesSpecification.setScanInterval(scanInterval);
        hidServicesSpecification.setPauseInterval(pauseInterval);
        hidServicesSpecification.setDataReadInterval(dataReadInterval);
        hidServicesSpecification.setAutoDataRead(true);
        hidServicesSpecification.setScanMode(ScanMode.SCAN_AT_FIXED_INTERVAL_WITH_PAUSE_AFTER_WRITE);
        hidServicesSpecification.setVendorId(VENDOR_ID.intValue());
        hidServicesSpecification.setProductId(PRODUCT_ID.intValue());
        hidServicesSpecification.setAutoStart(false);
        HidServices hidServices = HidManager.getHidServices((HidServicesSpecification)hidServicesSpecification);
        hidServices.addHidServicesListener((HidServicesListener)this);
        hidServices.start();
        hidServices.getAttachedHidDevices().forEach(hidDevice -> log.debug((Object)("HidDevices:" + String.valueOf(hidDevice))));
    }

    public void hidDeviceAttached(HidServicesEvent event) {
        log.debug((Object)("Device attached: " + event.getHidDevice().hashCode()));
        if (event.getHidDevice().isVidPidSerial(VENDOR_ID.intValue(), PRODUCT_ID.intValue(), SERIAL_NUMBER)) {
            HidDevice hidDevice = event.getHidDevice();
            if (hidDevice.isClosed()) {
                hidDevice.open();
            }
            this.ringBuffers.put(hidDevice, new LockRingBuffer());
            log.debug((Object)("Add hid\uff1a" + event.getHidDevice().hashCode()));
            this.subscription(hidDevice);
            BottomStatusPanel.setHidStatusInfo("Connected");
        }
    }

    public void hidDeviceDetached(HidServicesEvent event) {
        log.debug((Object)("Device detached: " + String.valueOf(event)));
        if (event.getHidDevice().isVidPidSerial(VENDOR_ID.intValue(), PRODUCT_ID.intValue(), SERIAL_NUMBER)) {
            this.ringBuffers.remove(event.getHidDevice());
            this.unSubscription(event.getHidDevice());
            event.getHidDevice().close();
            BottomStatusPanel.setHidStatusInfo("Disconnect");
            MainPane.getThisModel().listenChannelStatus(false);
        }
    }

    public void hidFailure(HidServicesEvent event) {
        log.debug((Object)("HID failure: " + String.valueOf(event)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hidDataReceived(HidServicesEvent event) {
        HidDevice hidDevice = event.getHidDevice();
        synchronized (hidDevice) {
            byte[] dataReceived = event.getDataReceived();
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[R]Length:%s Hid:%s", dataReceived.length, BytesHexStrUtil.bytesToHexString(dataReceived)));
            }
            LockRingBuffer buffer = this.ringBuffers.get(event.getHidDevice());
            int beforeSize = buffer.getSize();
            for (int read = 0; read < dataReceived.length; read += 64) {
                byte[] readData = Arrays.copyOfRange(dataReceived, read, read + 64);
                int crc = readData[1] & 0xFF | (readData[2] & 0xFF) << 8;
                byte length = readData[3];
                byte[] bodyData = Arrays.copyOfRange(readData, 4, 4 + length);
                int checkCRC = CheckCRC.crc16_bit(bodyData);
                if (crc != checkCRC || length != bodyData.length) continue;
                buffer.add(bodyData);
            }
            int afterSize = buffer.getSize();
            if (Constants.isDebug) {
                byte[] cmdData = buffer.read(beforeSize, afterSize);
                log.debug((Object)String.format("[R]HidDevice:%s Length:%s Data:%s", event.getHidDevice().hashCode(), cmdData.length, BytesHexStrUtil.bytesToHexString(cmdData)));
            }
            CMD_Public.addRingBuffer(buffer, DATA_KEY + event.getHidDevice().hashCode());
        }
    }

    public Set<HidDevice> getHidDeviceList() {
        return this.ringBuffers.keySet();
    }

    public void sendMessage(byte[] data) {
        if (!this.ringBuffers.isEmpty()) {
            this.sendMessage((HidDevice)((Map.Entry)this.ringBuffers.entrySet().stream().findFirst().get()).getKey(), data);
        } else {
            this.sendMessage(null, data);
        }
    }

    public void sendMessage(HidDevice hidDevice, byte[] data) {
        int size;
        if (hidDevice == null || hidDevice.isClosed()) {
            MessageDialog.show("Hid port is not connected or occupied, please check!", 3);
            return;
        }
        if (Constants.isDebug) {
            OutputLog outputLog = new OutputLog().setType("S").setData(BytesHexStrUtil.bytesToHexString(data)).setIsLine(true).setIsShowTime(Model_Debug.log_isShowTime.isSelected()).setTextPane(Model_Debug.log_outputArea);
            OutputLogQueue.getInstance().addDebugLog(outputLog);
            log.debug((Object)String.format("[S]HidDevice:%s Length:%s Data:%s", hidDevice.hashCode(), data.length, BytesHexStrUtil.bytesToHexString(data)));
        }
        for (int read = 0; read < data.length; read += size) {
            size = 59;
            if (read + size > data.length) {
                size = data.length - read;
            }
            byte[] bodyData = Arrays.copyOfRange(data, read, read + size);
            int CRC = CheckCRC.crc16_bit(bodyData);
            byte[] headData = new byte[]{1, (byte)(CRC & 0xFF), (byte)(CRC >> 8 & 0xFF), (byte)size};
            byte[] messageData = ArrayUtils.addAll(headData, bodyData);
            int val = hidDevice.write(messageData, 64, (byte)0);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)String.format("[S]Length:%s Hid:%s", val, BytesHexStrUtil.bytesToHexString(messageData)));
        }
    }

    public Map<String, Object> receiveMessage(int sequenceId, long timeOut) {
        HidDevice hidDevice = this.ringBuffers.entrySet().stream().findFirst().map(Map.Entry::getKey).orElse(null);
        return this.receiveMessage(hidDevice, sequenceId, timeOut);
    }

    public Map<String, Object> receiveMessage(HidDevice hidDevice, int sequenceId, long timeOut) {
        if (hidDevice == null) {
            return null;
        }
        CmdReceiveListener cmdReceiveListener = this.receiveListeners.get(hidDevice);
        Condition condition = new Condition().setSequenceId(sequenceId).setDateType("R");
        return cmdReceiveListener.getData(condition, timeOut);
    }

    private void subscription(HidDevice hidDevice) {
        log.debug((Object)("subscription hidDevice=" + hidDevice.hashCode()));
        CmdReceiveListener cmdReceiveListener = new CmdReceiveListener(DATA_KEY + hidDevice.hashCode());
        EventBusFactory.getInstance().register((Object)cmdReceiveListener);
        this.receiveListeners.put(hidDevice, cmdReceiveListener);
    }

    private void unSubscription(HidDevice hidDevice) {
        log.debug((Object)("unSubscription hidDevice=" + hidDevice.hashCode()));
        CmdReceiveListener cmdReceiveListener = this.receiveListeners.get(hidDevice);
        EventBusFactory.getInstance().unregister((Object)cmdReceiveListener);
    }

    public void setConfigFile() {
        Constants.configFileUtil.setProperty("HidService", "ScanInterval", "100");
        Constants.configFileUtil.setProperty("HidService", "PauseInterval", "100");
        Constants.configFileUtil.setProperty("HidService", "DataReadInterval", DataReadInterval);
        Constants.configFileUtil.writeProperty();
    }
}

