/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.ninepatch.common;

import freeseawind.ninepatch.common.NinePatchRegion;
import freeseawind.ninepatch.common.Padding;
import freeseawind.ninepatch.common.Region;
import freeseawind.ninepatch.common.RepeatType;
import freeseawind.ninepatch.common.Row;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractNinePatch<T, E> {
    public static final int PATCH_PIXES = -16777216;
    private int lastWidth;
    private int lastHeight;
    private int patchWidth;
    private int patchHeight;
    private int horizontalPatchNum;
    private int verticalPatchNum;
    private List<List<Row>> columns;
    private Padding padding;
    private T image;
    private RepeatType repeatType;

    public AbstractNinePatch(T image) {
        this(image, null);
    }

    public AbstractNinePatch(T image, RepeatType repeatType) {
        image = this.toCompatibleImage(image);
        this.countPatch(image);
        this.image = image;
        this.repeatType = repeatType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawNinePatch(E g2d, int x, int y, int scaledWidth, int scaledHeight) {
        if (scaledWidth <= 1 || scaledHeight <= 1) {
            return;
        }
        try {
            if (this.lastWidth != scaledWidth || this.lastHeight != scaledHeight) {
                this.lastWidth = scaledWidth;
                this.lastHeight = scaledHeight;
                this.resetData(scaledWidth, scaledHeight);
            }
            if (this.patchWidth == scaledWidth && this.patchHeight == scaledHeight) {
                this.drawImage(g2d, this.image, x, y, scaledWidth, scaledHeight);
                return;
            }
            this.translate(g2d, x, y);
            int startX = 0;
            int startY = 0;
            int minWidth = this.patchWidth;
            int minHeight = this.patchHeight;
            if (this.horizontalPatchNum > 1) {
                minWidth = this.patchWidth / this.horizontalPatchNum;
            }
            if (this.verticalPatchNum > 1) {
                minHeight = this.patchHeight / this.verticalPatchNum;
            }
            int columnCount = 0;
            for (List<Row> rows : this.columns) {
                int rowCount = 0;
                int height = this.patchHeight;
                boolean isFirst = true;
                int preRowHeight = 0;
                if (startY >= scaledHeight) {
                    break;
                }
                for (Row row : rows) {
                    Rectangle rect = row.getRectangle();
                    int width = rect.width;
                    if (startX >= scaledWidth) break;
                    if (Row.Type.HORIZONTALPATCH == row.getType() || Row.Type.TILEPATCH == row.getType()) {
                        width = this.patchWidth - minWidth * (rowCount + 1);
                        width = width < minWidth ? this.patchWidth - minWidth * rowCount : minWidth;
                        ++rowCount;
                    } else if (Row.Type.HORIZONTALPATCH == row.getType() && isFirst) {
                        height = this.patchHeight - minHeight * (columnCount + 1);
                        height = height < minHeight ? this.patchHeight - minHeight * columnCount : minHeight;
                        ++columnCount;
                        isFirst = false;
                    }
                    if (Row.Type.FIX == row.getType()) {
                        this.drawImage(g2d, this.image, rect.x, rect.y, rect.width, rect.height, startX, startY, rect.width, rect.height);
                        startX += rect.width;
                        preRowHeight = rect.height;
                        continue;
                    }
                    if (Row.Type.HORIZONTALPATCH == row.getType()) {
                        this.drawImage(g2d, this.image, rect.x, rect.y, rect.width, rect.height, startX, startY, width, rect.height);
                        startX += width;
                        preRowHeight = rect.height;
                        continue;
                    }
                    if (Row.Type.VERTICALPATCH == row.getType()) {
                        this.drawImage(g2d, this.image, rect.x, rect.y, rect.width, rect.height, startX, startY, rect.width, height);
                        startX += rect.width;
                        preRowHeight = height;
                        continue;
                    }
                    if (Row.Type.TILEPATCH != row.getType()) continue;
                    if (this.repeatType != null) {
                        this.repeatImage(g2d, this.image, rect.x, rect.y, rect.width, rect.height, startX, startY, width, height);
                    } else {
                        this.drawImage(g2d, this.image, rect.x, rect.y, rect.width, rect.height, startX, startY, width, height);
                    }
                    startX += width;
                    preRowHeight = height;
                }
                startX = 0;
                startY += preRowHeight;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.translate(g2d, -x, -y);
        }
    }

    public List<List<Row>> countColumn(NinePatchRegion xRegions, NinePatchRegion yRegions) {
        boolean isPatchY = false;
        int i = 0;
        int j = 0;
        int patchNum = yRegions.getPatchRegions().size();
        int fixNum = yRegions.getFixRegions().size();
        Region yRegion = null;
        LinkedList<List<Row>> columns = new LinkedList<List<Row>>();
        do {
            yRegion = null;
            if (isPatchY && patchNum >= j + 1) {
                yRegion = yRegions.getPatchRegions().get(j++);
            }
            if (!isPatchY && fixNum >= i + 1) {
                yRegion = yRegions.getFixRegions().get(i++);
            }
            if (yRegion != null) {
                columns.add(this.countRow(yRegion, xRegions, isPatchY));
            }
            boolean bl = isPatchY = !isPatchY;
        } while (yRegion != null);
        return columns;
    }

    public List<Row> countRow(Region yRegion, NinePatchRegion xRegions, boolean isPatchY) {
        boolean isPatchX = false;
        int i = 0;
        int j = 0;
        int patchNum = xRegions.getPatchRegions().size();
        int fixNum = xRegions.getFixRegions().size();
        Region xRegion = null;
        LinkedList<Row> column = new LinkedList<Row>();
        do {
            xRegion = null;
            if (isPatchX && patchNum >= j + 1) {
                xRegion = xRegions.getPatchRegions().get(j++);
            }
            if (!isPatchX && fixNum >= i + 1) {
                xRegion = xRegions.getFixRegions().get(i++);
            }
            if (xRegion != null) {
                Row.Type rowType = this.getRowType(isPatchX, isPatchY);
                int height = yRegion.getEnd() - yRegion.getStart();
                int width = xRegion.getEnd() - xRegion.getStart();
                Rectangle rect = new Rectangle(xRegion.getStart() + 1, yRegion.getStart() + 1, width, height);
                Row row = new Row(rect, rowType);
                column.add(row);
            }
            boolean bl = isPatchX = !isPatchX;
        } while (xRegion != null);
        Collections.sort(column);
        return column;
    }

    public Padding getPadding(int w, int h, List<Region> xRegions, List<Region> yRegions) {
        Region xRegion = xRegions.get(0);
        Region yRegion = yRegions.get(0);
        int left = xRegion.getStart();
        int top = yRegion.getStart();
        int right = w - xRegion.getEnd();
        int bottom = h - yRegion.getEnd();
        return new Padding(left, top, right, bottom);
    }

    public NinePatchRegion getPatches(int[] pixels) {
        int start = 0;
        int lastPixel = pixels[0];
        LinkedList<Region> fixArea = new LinkedList<Region>();
        LinkedList<Region> patchArea = new LinkedList<Region>();
        for (int i = 1; i <= pixels.length; ++i) {
            if (i < pixels.length && lastPixel == pixels[i]) continue;
            Region region = new Region(start, i);
            if (-16777216 == lastPixel) {
                patchArea.add(region);
            } else {
                fixArea.add(region);
            }
            start = i;
            if (i >= pixels.length) continue;
            lastPixel = pixels[i];
        }
        if (start == 0) {
            Region region = new Region(start, pixels.length);
            if (-16777216 == lastPixel) {
                patchArea.add(region);
            } else {
                fixArea.add(region);
            }
        }
        return new NinePatchRegion(fixArea, patchArea);
    }

    public void repeatImage(E g2d, T image, int x, int y, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (this.repeatType == null) {
            return;
        }
        if (this.repeatType == RepeatType.HORIZONTAL) {
            int hornaizeW = dw;
            do {
                if (hornaizeW - sw < 0) {
                    sw = hornaizeW;
                }
                this.drawImage(g2d, image, x, y, sw, sh, dx, dy, sw, dh);
                dx += sw;
            } while ((hornaizeW -= sw) > 0);
        } else if (this.repeatType == RepeatType.VERTICAL) {
            int verticalH = dh;
            do {
                if (verticalH - sh < 0) {
                    sh = verticalH;
                }
                this.drawImage(g2d, image, x, y, sw, sh, dx, dy, dw, sh);
                dy += sh;
            } while ((verticalH -= sh) > 0);
        }
    }

    protected void countPatch(T image) {
        int width = this.getImageWidth(image) - 2;
        int height = this.getImageHeight(image) - 2;
        int[] row = null;
        int[] column = null;
        column = this.getPixels(image, 0, 1, 1, height);
        NinePatchRegion left = this.getPatches(column);
        row = this.getPixels(image, 1, 0, width, 1);
        NinePatchRegion top = this.getPatches(row);
        this.horizontalPatchNum = top.getPatchRegions().size();
        this.verticalPatchNum = left.getPatchRegions().size();
        this.columns = this.countColumn(top, left);
        row = this.getPixels(image, 1, height + 1, width, 1);
        column = this.getPixels(image, width + 1, 1, 1, height);
        NinePatchRegion bottom = this.getPatches(row);
        NinePatchRegion right = this.getPatches(column);
        this.padding = this.getPadding(width, height, bottom.getPatchRegions(), right.getPatchRegions());
    }

    protected T toCompatibleImage(T image) {
        return image;
    }

    public abstract int[] getPixels(T var1, int var2, int var3, int var4, int var5);

    public abstract int getImageWidth(T var1);

    public abstract int getImageHeight(T var1);

    public abstract void translate(E var1, int var2, int var3);

    public abstract void drawImage(E var1, T var2, int var3, int var4, int var5, int var6);

    public abstract void drawImage(E var1, T var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private void resetData(int scaleWidth, int scaleHeight) {
        this.patchWidth = scaleWidth;
        this.patchHeight = scaleHeight;
        boolean isFirst = true;
        boolean isNewColumn = true;
        for (List<Row> rows : this.columns) {
            for (Row row : rows) {
                if (Row.Type.FIX == row.getType() && isFirst) {
                    this.patchWidth -= row.getRectangle().width;
                }
                if (Row.Type.FIX != row.getType() || !isNewColumn) continue;
                this.patchHeight -= row.getRectangle().height;
                isNewColumn = false;
            }
            isNewColumn = true;
            isFirst = false;
        }
    }

    private Row.Type getRowType(boolean isPatchX, boolean isPatchY) {
        if (!isPatchX && !isPatchY) {
            return Row.Type.FIX;
        }
        if (!isPatchX && isPatchY) {
            return Row.Type.VERTICALPATCH;
        }
        if (isPatchX && !isPatchY) {
            return Row.Type.HORIZONTALPATCH;
        }
        return Row.Type.TILEPATCH;
    }

    public Padding getPadding() {
        return this.padding;
    }
}

