/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.hid4java.HidDeviceManager;
import org.hid4java.HidServicesSpecification;
import org.hid4java.jna.HidApi;
import org.hid4java.jna.HidDeviceInfoStructure;
import org.hid4java.jna.HidDeviceStructure;

public class HidDevice {
    private final HidDeviceManager hidDeviceManager;
    private HidDeviceStructure hidDeviceStructure;
    private final String path;
    private final int vendorId;
    private final int productId;
    private String serialNumber;
    private final int releaseNumber;
    private String manufacturer;
    private String product;
    private final int usagePage;
    private final int usage;
    private final int interfaceNumber;
    private final boolean autoDataRead;
    private final int dataReadInterval;
    private Thread dataReadThread = null;

    public HidDevice(HidDeviceInfoStructure infoStructure, HidDeviceManager hidDeviceManager, HidServicesSpecification hidServicesSpecification) {
        this.hidDeviceManager = hidDeviceManager;
        this.dataReadInterval = hidServicesSpecification.getDataReadInterval();
        this.autoDataRead = hidServicesSpecification.isAutoDataRead();
        this.hidDeviceStructure = null;
        this.path = infoStructure.path;
        this.vendorId = infoStructure.vendor_id & 0xFFFF;
        this.productId = infoStructure.product_id & 0xFFFF;
        this.releaseNumber = infoStructure.release_number;
        if (infoStructure.serial_number != null) {
            this.serialNumber = infoStructure.serial_number.toString();
        }
        if (infoStructure.manufacturer_string != null) {
            this.manufacturer = infoStructure.manufacturer_string.toString();
        }
        if (infoStructure.product_string != null) {
            this.product = infoStructure.product_string.toString();
        }
        this.usagePage = infoStructure.usage_page;
        this.usage = infoStructure.usage;
        this.interfaceNumber = infoStructure.interface_number;
    }

    private void startDataReadThread() {
        if (this.isDataRead()) {
            return;
        }
        this.dataRead();
        this.configureDataReadThread(this.getDataReadRunnable());
    }

    private synchronized void stopDataReadThread() {
        if (this.isDataRead()) {
            this.dataReadThread.interrupt();
        }
    }

    private synchronized void configureDataReadThread(Runnable dataReadRunnable) {
        if (this.autoDataRead) {
            this.stopDataReadThread();
        }
        this.dataReadThread = new Thread(dataReadRunnable);
        this.dataReadThread.setDaemon(true);
        this.dataReadThread.setName("hid4java data reader");
        this.dataReadThread.start();
    }

    private synchronized Runnable getDataReadRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(HidDevice.this.dataReadInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    HidDevice.this.dataRead();
                }
            }
        };
    }

    private boolean isDataRead() {
        return this.dataReadThread != null && this.dataReadThread.isAlive();
    }

    private synchronized void dataRead() {
        byte[] dataRead = this.readAll(10);
        this.hidDeviceManager.afterDeviceDataRead(this, dataRead);
    }

    public String getId() {
        return this.path;
    }

    public String getPath() {
        return this.path;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public int getProductId() {
        return this.productId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public int getReleaseNumber() {
        return this.releaseNumber;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getProduct() {
        return this.product;
    }

    public int getUsagePage() {
        return this.usagePage;
    }

    public int getUsage() {
        return this.usage;
    }

    public int getInterfaceNumber() {
        return this.interfaceNumber;
    }

    public boolean open() {
        this.hidDeviceStructure = HidApi.open(this.path);
        if (this.autoDataRead) {
            this.startDataReadThread();
        }
        return this.hidDeviceStructure != null;
    }

    @Deprecated
    public boolean isOpen() {
        return !this.isClosed();
    }

    public boolean isClosed() {
        return this.hidDeviceStructure == null;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.stopDataReadThread();
        HidApi.close(this.hidDeviceStructure);
        this.hidDeviceStructure = null;
    }

    public void setNonBlocking(boolean nonBlocking) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        HidApi.setNonBlocking(this.hidDeviceStructure, nonBlocking);
    }

    public int read(byte[] data) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.read(this.hidDeviceStructure, data);
    }

    public Byte[] read(int amountToRead, int timeoutMillis) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        byte[] bytes = new byte[amountToRead];
        int read = HidApi.read(this.hidDeviceStructure, bytes, timeoutMillis);
        Byte[] retData = new Byte[read];
        for (int i = 0; i < read; ++i) {
            retData[i] = bytes[i];
        }
        return retData;
    }

    public Byte[] read(int amountToRead) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        byte[] bytes = new byte[amountToRead];
        int read = HidApi.read(this.hidDeviceStructure, bytes);
        Byte[] retData = new Byte[read];
        for (int i = 0; i < read; ++i) {
            retData[i] = bytes[i];
        }
        return retData;
    }

    public Byte[] read() {
        return this.read(64, 1000);
    }

    public int read(byte[] bytes, int timeoutMillis) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.read(this.hidDeviceStructure, bytes, timeoutMillis);
    }

    public byte[] readAll(int timeoutMillis) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        boolean morePackets = true;
        while (morePackets) {
            byte[] packet = new byte[64];
            int bytesRead = this.read(packet, timeoutMillis);
            if (bytesRead > 0) {
                try {
                    output.write(packet);
                }
                catch (IOException e) {
                    morePackets = false;
                }
                continue;
            }
            morePackets = false;
        }
        return output.toByteArray();
    }

    public int getFeatureReport(byte[] data, byte reportId) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.getFeatureReport(this.hidDeviceStructure, data, reportId);
    }

    public int sendFeatureReport(byte[] data, byte reportId) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.sendFeatureReport(this.hidDeviceStructure, data, reportId);
    }

    public String getIndexedString(int index) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.getIndexedString(this.hidDeviceStructure, index);
    }

    public int getReportDescriptor(byte[] buffer) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.getReportDescriptor(this.hidDeviceStructure, buffer, buffer.length);
    }

    public int write(byte[] message, int packetLength, byte reportId) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return this.write(message, packetLength, reportId, false);
    }

    public int write(byte[] message, int packetLength, byte reportId, boolean applyPadding) {
        if (this.isClosed()) {
            throw new IllegalStateException("Device has not been opened");
        }
        if (applyPadding) {
            message = Arrays.copyOf(message, packetLength + 1);
        }
        int result = HidApi.write(this.hidDeviceStructure, message, packetLength, reportId);
        this.hidDeviceManager.afterDeviceWrite();
        return result;
    }

    public String getLastErrorMessage() {
        return HidApi.getLastErrorMessage(this.hidDeviceStructure);
    }

    public boolean isVidPidSerial(int vendorId, int productId, String serialNumber) {
        if (serialNumber == null) {
            return !(vendorId != 0 && this.vendorId != vendorId || productId != 0 && this.productId != productId);
        }
        return !(vendorId != 0 && this.vendorId != vendorId || productId != 0 && this.productId != productId || !this.serialNumber.equals(serialNumber));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HidDevice hidDevice = (HidDevice)o;
        return this.path.equals(hidDevice.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "HidDevice [path=" + this.path + ", vendorId=0x" + Integer.toHexString(this.vendorId) + ", productId=0x" + Integer.toHexString(this.productId) + ", serialNumber=" + this.serialNumber + ", releaseNumber=0x" + Integer.toHexString(this.releaseNumber) + ", manufacturer=" + this.manufacturer + ", product=" + this.product + ", usagePage=0x" + Integer.toHexString(this.usagePage) + ", usage=0x" + Integer.toHexString(this.usage) + ", interfaceNumber=" + this.interfaceNumber + "]";
    }
}

